/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import com.sun.java.swing.plaf.gtk.GTKConstants;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.util.concurrent.TimeUnit;
import sun.awt.SunToolkit;
import sun.java2d.opengl.OGLRenderQueue;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public abstract class UNIXToolkit
extends SunToolkit {
    public static final Object GTK_LOCK = new Object();
    private static final int[] BAND_OFFSETS = new int[]{0, 1, 2};
    private static final int[] BAND_OFFSETS_ALPHA = new int[]{0, 1, 2, 3};
    private static final int DEFAULT_DATATRANSFER_TIMEOUT = 10000;
    private Boolean nativeGTKAvailable;
    private Boolean nativeGTKLoaded;
    private BufferedImage tmpImage = null;
    private static volatile Boolean shouldDisableSystemTray = null;
    public static final String FONTCONFIGAAHINT = "fontconfig/Antialias";

    public static int getDatatransferTimeout() {
        Integer n = AccessController.doPrivileged(new GetIntegerAction("sun.awt.datatransfer.timeout"));
        if (n == null || n <= 0) {
            return 10000;
        }
        return n;
    }

    public String getDesktop() {
        String string = "gnome";
        String string2 = AccessController.doPrivileged(() -> System.getenv("GNOME_DESKTOP_SESSION_ID"));
        if (string2 != null) {
            return string;
        }
        String string3 = AccessController.doPrivileged(() -> System.getenv("XDG_CURRENT_DESKTOP"));
        return string3 != null && string3.toLowerCase().contains(string) ? string : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNativeGTKAvailable() {
        Object object = GTK_LOCK;
        synchronized (object) {
            if (this.nativeGTKLoaded != null) {
                return this.nativeGTKLoaded;
            }
            if (this.nativeGTKAvailable != null) {
                return this.nativeGTKAvailable;
            }
            boolean bl = UNIXToolkit.check_gtk(UNIXToolkit.getEnabledGtkVersion().getNumber());
            this.nativeGTKAvailable = bl;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadGTK() {
        Object object = GTK_LOCK;
        synchronized (object) {
            if (this.nativeGTKLoaded == null) {
                this.nativeGTKLoaded = UNIXToolkit.load_gtk(UNIXToolkit.getEnabledGtkVersion().getNumber(), UNIXToolkit.isGtkVerbose());
            }
        }
        return this.nativeGTKLoaded;
    }

    @Override
    protected Object lazilyLoadDesktopProperty(String string) {
        if (string.startsWith("gtk.icon.")) {
            return this.lazilyLoadGTKIcon(string);
        }
        return super.lazilyLoadDesktopProperty(string);
    }

    protected Object lazilyLoadGTKIcon(String string) {
        Object v = this.desktopProperties.get(string);
        if (v != null) {
            return v;
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 5) {
            return null;
        }
        int n = 0;
        try {
            n = Integer.parseInt(stringArray[3]);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        GTKConstants.TextDirection textDirection = "ltr".equals(stringArray[4]) ? GTKConstants.TextDirection.LTR : GTKConstants.TextDirection.RTL;
        BufferedImage bufferedImage = this.getStockIcon(-1, stringArray[2], n, textDirection.ordinal(), null);
        if (bufferedImage != null) {
            this.setDesktopProperty(string, bufferedImage);
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldDisableSystemTray() {
        Boolean bl = shouldDisableSystemTray;
        if (bl == null) {
            Object object = GTK_LOCK;
            synchronized (object) {
                bl = shouldDisableSystemTray;
                if (bl == null) {
                    Integer n;
                    if ("gnome".equals(this.getDesktop()) && ((n = AccessController.doPrivileged(this::getGnomeShellMajorVersion)) == null || n < 45)) {
                        shouldDisableSystemTray = true;
                        return shouldDisableSystemTray;
                    }
                    shouldDisableSystemTray = bl = Boolean.valueOf(false);
                }
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Integer getGnomeShellMajorVersion() {
        try {
            Process process = new ProcessBuilder("/usr/bin/gnome-shell", "--version").start();
            try (InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                if (!process.waitFor(2L, TimeUnit.SECONDS)) return null;
                if (process.exitValue() != 0) return null;
                String string = bufferedReader.readLine();
                if (string == null) return null;
                String[] stringArray = string.replaceAll("[^\\d.]", "").split("\\.");
                if (stringArray.length < 1) return null;
                Integer n = Integer.parseInt(stringArray[0]);
                return n;
            }
        }
        catch (IOException | IllegalThreadStateException | InterruptedException | NumberFormatException exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getGTKIcon(String string) {
        if (!this.loadGTK()) {
            return null;
        }
        Object object = GTK_LOCK;
        synchronized (object) {
            if (!this.load_gtk_icon(string)) {
                this.tmpImage = null;
            }
        }
        return this.tmpImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getStockIcon(int n, String string, int n2, int n3, String string2) {
        if (!this.loadGTK()) {
            return null;
        }
        Object object = GTK_LOCK;
        synchronized (object) {
            if (!this.load_stock_icon(n, string, n2, n3, string2)) {
                this.tmpImage = null;
            }
        }
        return this.tmpImage;
    }

    public void loadIconCallback(byte[] byArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.tmpImage = null;
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n3 * n2);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n3, n5, bl ? BAND_OFFSETS_ALPHA : BAND_OFFSETS, null);
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), bl, false, 3, 0);
        this.tmpImage = new BufferedImage(componentColorModel, writableRaster, false, null);
    }

    private static native boolean check_gtk(int var0);

    private static native boolean load_gtk(int var0, boolean var1);

    private static native boolean unload_gtk();

    private native boolean load_gtk_icon(String var1);

    private native boolean load_stock_icon(int var1, String var2, int var3, int var4, String var5);

    private native void nativeSync();

    private static native int get_gtk_version();

    @Override
    public void sync() {
        this.nativeSync();
        OGLRenderQueue.sync();
    }

    @Override
    protected RenderingHints getDesktopAAHints() {
        String string;
        boolean bl;
        Object object = this.getDesktopProperty("gnome.Xft/Antialias");
        if (object == null) {
            object = this.getDesktopProperty(FONTCONFIGAAHINT);
            if (object != null) {
                return new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            }
            return null;
        }
        boolean bl2 = bl = object instanceof Number && ((Number)object).intValue() != 0;
        Object object2 = bl ? ((string = (String)this.getDesktopProperty("gnome.Xft/RGBA")) == null || string.equals("none") ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : (string.equals("rgb") ? RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB : (string.equals("bgr") ? RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR : (string.equals("vrgb") ? RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB : (string.equals("vbgr") ? RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR : RenderingHints.VALUE_TEXT_ANTIALIAS_ON))))) : RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
        return new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, object2);
    }

    private native boolean gtkCheckVersionImpl(int var1, int var2, int var3);

    public boolean checkGtkVersion(int n, int n2, int n3) {
        if (this.loadGTK()) {
            return this.gtkCheckVersionImpl(n, n2, n3);
        }
        return false;
    }

    public static GtkVersions getEnabledGtkVersion() {
        String string = AccessController.doPrivileged(new GetPropertyAction("jdk.gtk.version"));
        if (string == null) {
            return GtkVersions.ANY;
        }
        if (string.startsWith("2")) {
            return GtkVersions.GTK2;
        }
        if ("3".equals(string)) {
            return GtkVersions.GTK3;
        }
        return GtkVersions.ANY;
    }

    public static GtkVersions getGtkVersion() {
        return GtkVersions.getVersion(UNIXToolkit.get_gtk_version());
    }

    public static boolean isGtkVerbose() {
        return AccessController.doPrivileged(() -> Boolean.getBoolean("jdk.gtk.verbose"));
    }

    public static enum GtkVersions {
        ANY(0),
        GTK2(2),
        GTK3(3);

        final int number;

        private GtkVersions(int n2) {
            this.number = n2;
        }

        public static GtkVersions getVersion(int n) {
            switch (n) {
                case 2: {
                    return GTK2;
                }
                case 3: {
                    return GTK3;
                }
            }
            return ANY;
        }

        public int getNumber() {
            return this.number;
        }

        static class Constants {
            static final int GTK2_MAJOR_NUMBER = 2;
            static final int GTK3_MAJOR_NUMBER = 3;

            Constants() {
            }
        }
    }
}

