/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.workers;

import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.metadb.util.MetaDbUtil;
import agorum.roi.scripting.EngineContext;
import agorum.roi.statistic.workers.ScriptWorkerAction;
import agorum.roi.statistic.workers.WorkersStatistic;
import agorum.roi.workers.ContextCache;
import agorum.roi.workers.Job;
import agorum.roi.workers.Worker;
import agorum.roi.workers.Workers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ScriptWorker
extends Worker {
    private static final String METADB_BASE = "MAIN_MODULE_MANAGEMENT/workers/ScriptWorker";
    private String producer;
    private String consumer;
    private EngineContext.CompiledScript compiledProducer;
    private EngineContext.CompiledScript compiledConsumer;
    private final ContextCache contexts = new ContextCache();

    public ScriptWorker(String name, int concurrency, String producer, String consumer) {
        super(name, concurrency);
        try (Transaction t = new Transaction();){
            this.setScripts(producer, consumer);
            t.commit();
        }
    }

    private void save() {
        try {
            Transaction.afterCommit(ScriptWorker.class.getName() + "_" + this.getName(), () -> {
                try (Transaction t = new Transaction();
                     MetaDbUtil mdu = new MetaDbUtil(SessionControllerAdmin.getService(ScriptWorker.class), "MAIN_MODULE_MANAGEMENT/workers/ScriptWorker/" + this.getName());){
                    mdu.delete("");
                    mdu.setInt("Concurrency", this.getConcurrency());
                    mdu.setString("Producer", this.producer);
                    mdu.setString("Consumer", this.consumer);
                    mdu.commit();
                    t.commit();
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static Map<String, Object> exp(String name) {
        ScriptWorker worker = (ScriptWorker)Workers.get(name);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", name);
        data.put("concurrency", worker.getConcurrency());
        data.put("producer", worker.getProducer());
        data.put("consumer", worker.getConsumer());
        return data;
    }

    public static void imp(Map<String, Object> data) throws Exception {
        String name = (String)data.get("name");
        if (name == null) {
            throw new IllegalArgumentException("Missing name property");
        }
        Transaction.afterCommit(ScriptWorker.class.getName() + "_" + name, () -> {
            Worker other = Workers.get(name);
            Number concurrencyNum = (Number)data.get("concurrency");
            String producer = (String)data.get("producer");
            String consumer = (String)data.get("consumer");
            int concurrency = concurrencyNum.intValue();
            if (other == null) {
                ScriptWorkerAction.create(name, concurrency, producer, consumer);
            } else if (other instanceof ScriptWorker) {
                ScriptWorker worker = (ScriptWorker)other;
                worker.setConcurrency(concurrency);
                worker.setScripts(producer, consumer);
                worker.reset();
            } else {
                throw new IllegalArgumentException("A worker with this name already exists: " + name);
            }
        });
    }

    @Override
    public void remove() {
        super.remove();
        try (MetaDbUtil mdu = new MetaDbUtil(SessionControllerAdmin.getService(ScriptWorker.class), METADB_BASE);){
            mdu.delete(this.getName());
            mdu.commit();
        }
    }

    public final void setScripts(String producer, String consumer) {
        EngineContext ec = new EngineContext(false, null);
        this.compiledProducer = ec.compile(producer, this.getName());
        this.compiledConsumer = ec.compile(consumer, this.getName());
        this.producer = producer;
        this.consumer = consumer;
        this.reset();
        this.save();
    }

    public final String getProducer() {
        return this.producer;
    }

    public final String getConsumer() {
        return this.consumer;
    }

    @Override
    protected Collection<Job> collect(int limit, boolean idle) {
        ArrayList<Job> work = new ArrayList<Job>(limit);
        try {
            EngineContext ec = this.contexts.get();
            SessionController sc = SessionControllerAdmin.getService(ScriptWorker.class);
            ec.put("sc", sc);
            ec.put("sessionController", sc);
            ec.put("sca", sc);
            ec.put("sessionControllerAdmin", sc);
            ec.put("limit", limit);
            ec.put("idle", idle);
            Object result = ec.exec(this.compiledProducer);
            if (result instanceof Iterable) {
                for (Object data : (Iterable)result) {
                    Object id;
                    if (data instanceof Map) {
                        Map map = (Map)data;
                        id = map.get("id");
                        if (id == null) {
                            this.stat.error("Missing job id: " + data);
                            continue;
                        }
                    } else if (data != null) {
                        id = data;
                    } else {
                        this.stat.error("Empty job data");
                        continue;
                    }
                    work.add(new Job(id.toString(), () -> {
                        long time = System.currentTimeMillis();
                        this.work(data);
                        this.stat.measure("Job duration", "ms", System.currentTimeMillis() - time);
                    }));
                }
            } else if (result != null) {
                this.stat.error("Unsupported producer result type: " + result.getClass().getName());
            }
        }
        catch (Exception e) {
            this.contexts.remove();
            this.stat.error((Throwable)e, "Error while collecting work");
        }
        return work;
    }

    protected void work(Object data) {
        EngineContext ec = this.contexts.get();
        SessionController sc = SessionControllerAdmin.getService(ScriptWorker.class);
        ec.put("sc", sc);
        ec.put("sessionController", sc);
        ec.put("sca", sc);
        ec.put("sessionControllerAdmin", sc);
        ec.put("data", data);
        try {
            ec.exec(this.compiledConsumer);
        }
        catch (Exception e) {
            this.contexts.remove();
            this.stat.error((Throwable)e, "Error while executing script");
        }
    }

    @Override
    public void reset() {
        this.contexts.reset();
        super.reset();
    }

    static {
        try (MetaDbUtil mdu = new MetaDbUtil(SessionControllerAdmin.getService(ScriptWorker.class), METADB_BASE, true);){
            for (String worker : mdu.listBundles("")) {
                try {
                    ScriptWorkerAction.create(worker, mdu.getInt(worker + "/Concurrency", 4), mdu.getString(worker + "/Producer"), mdu.getString(worker + "/Consumer"));
                }
                catch (Exception e) {
                    WorkersStatistic.getInstance().error().exception((Throwable)e).send("Could not start script worker " + worker);
                }
            }
        }
    }
}

