/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.workers;

import agorum.roi.ejb.common.AttributeInfo;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.metadb.util.MetaDbUtil;
import agorum.roi.scripting.EngineContext;
import agorum.roi.searchengine.IndexHelper;
import agorum.roi.statistic.workers.QueryScriptAction;
import agorum.roi.statistic.workers.WorkersStatistic;
import agorum.roi.workers.ContextCache;
import agorum.roi.workers.QueryWorker;
import agorum.roi.workers.Worker;
import agorum.roi.workers.Workers;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryScript
extends QueryWorker {
    private static final String METADB_BASE = "MAIN_MODULE_MANAGEMENT/workers/QueryScript";
    private String script;
    private EngineContext.CompiledScript compiled;
    private boolean includeHidden;
    private String query;
    private String[] properties;
    private final ContextCache contexts = new ContextCache();

    public QueryScript(String name, int concurrency, String script, boolean includeHidden, String query, String ... properties) {
        super(name, concurrency);
        try (Transaction t = new Transaction();){
            this.setScript(script);
            this.includeHidden(includeHidden);
            this.setProperties(properties);
            this.setQuery(query);
            t.commit();
        }
    }

    private void save() {
        try {
            Transaction.afterCommit(QueryScript.class.getName() + "_" + this.getName(), () -> {
                try (Transaction t = new Transaction();
                     MetaDbUtil mdu = new MetaDbUtil(SessionControllerAdmin.getService(QueryScript.class), "MAIN_MODULE_MANAGEMENT/workers/QueryScript/" + this.getName());){
                    mdu.delete("");
                    mdu.setInt("Concurrency", this.getConcurrency());
                    mdu.setString("Script", this.script);
                    mdu.setBoolean("IncludeHidden", this.includeHidden);
                    mdu.setString("Query", this.query);
                    mdu.setStringArray("Properties", this.properties);
                    mdu.commit();
                    t.commit();
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static Map<String, Object> exp(String name) {
        QueryScript worker = (QueryScript)Workers.get(name);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", name);
        data.put("concurrency", worker.getConcurrency());
        data.put("includeHidden", worker.includeHidden());
        data.put("query", worker.getQuery());
        data.put("properties", Arrays.asList(worker.getProperties()));
        data.put("script", worker.getScript());
        return data;
    }

    public static void imp(Map<String, Object> data) throws Exception {
        String name = (String)data.get("name");
        if (name == null) {
            throw new IllegalArgumentException("Missing name property");
        }
        Transaction.afterCommit(QueryScript.class.getName() + "_" + name, () -> {
            String[] properties;
            Worker other = Workers.get(name);
            Number concurrencyNum = (Number)data.get("concurrency");
            String script = (String)data.get("script");
            Boolean includeHiddenBool = (Boolean)data.get("includeHidden");
            String query = (String)data.get("query");
            List propertiesList = (List)data.get("properties");
            int concurrency = concurrencyNum.intValue();
            boolean includeHidden = includeHiddenBool == null ? false : includeHiddenBool;
            String[] stringArray = properties = propertiesList == null ? null : (String[])propertiesList.stream().map(x -> x.toString()).toArray(String[]::new);
            if (other == null) {
                QueryScriptAction.create(name, concurrency, script, includeHidden, query, properties);
            } else if (other instanceof QueryScript) {
                QueryScript worker = (QueryScript)other;
                worker.setConcurrency(concurrency);
                worker.includeHidden(includeHidden);
                worker.setQuery(query);
                worker.setProperties(properties);
                worker.setScript(script);
            } else {
                throw new IllegalArgumentException("A worker with this name already exists: " + name);
            }
        });
    }

    @Override
    public void remove() {
        super.remove();
        try (MetaDbUtil mdu = new MetaDbUtil(SessionControllerAdmin.getService(QueryScript.class), METADB_BASE);){
            mdu.delete(this.getName());
            mdu.commit();
        }
    }

    public final void setScript(String script) {
        EngineContext ec = new EngineContext(false, null);
        this.compiled = ec.compile(script, this.getName());
        this.script = script;
        this.reset();
        this.save();
    }

    public String getScript() {
        return this.script;
    }

    public void includeHidden(boolean includeHidden) {
        this.includeHidden = includeHidden;
        this.save();
    }

    @Override
    public boolean includeHidden() {
        return this.includeHidden;
    }

    public void setQuery(String query) {
        this.query = query;
        this.save();
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    public void setProperties(String[] properties) {
        if (properties == null) {
            this.properties = new String[]{"uuid"};
        } else if (Arrays.asList(properties).contains("uuid")) {
            this.properties = properties;
        } else {
            this.properties = new String[properties.length + 1];
            this.properties[0] = "uuid";
            System.arraycopy(properties, 0, this.properties, 1, properties.length);
        }
        this.save();
    }

    @Override
    public String[] getProperties() {
        return this.properties;
    }

    @Override
    protected String getId(Map<String, AttributeInfo> item) {
        return (String)item.get((Object)"uuid").value;
    }

    @Override
    protected void work(Map<String, AttributeInfo> item) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (Map.Entry<String, AttributeInfo> entry : item.entrySet()) {
            data.put(entry.getKey(), entry.getValue().value);
        }
        EngineContext ec = this.contexts.get();
        SessionController sc = SessionControllerAdmin.getService(QueryScript.class);
        ec.put("sc", sc);
        ec.put("sessionController", sc);
        ec.put("sca", sc);
        ec.put("sessionControllerAdmin", sc);
        ec.put("data", data);
        try (Transaction t = new Transaction();){
            IndexHelper.disableAutoCommit();
            ec.exec(this.compiled);
            t.commit();
            this.stat.clearStickyLogEntry(this.getName());
        }
        catch (Exception e) {
            this.contexts.remove();
            this.stat.error().sticky(this.getName()).exception((Throwable)e).send("Error while executing script");
        }
    }

    @Override
    public void reset() {
        this.contexts.reset();
        super.reset();
    }

    static {
        try (MetaDbUtil mdu = new MetaDbUtil(SessionControllerAdmin.getService(QueryScript.class), METADB_BASE, true);){
            for (String worker : mdu.listBundles("")) {
                try {
                    QueryScriptAction.create(worker, mdu.getInt(worker + "/Concurrency", 4), mdu.getString(worker + "/Script"), mdu.getBoolean(worker + "/IncludeHidden", false), mdu.getString(worker + "/Query"), mdu.getStringArray(worker + "/Properties"));
                }
                catch (Exception e) {
                    WorkersStatistic.getInstance().error().exception((Throwable)e).send("Could not start QueryScript worker " + worker);
                }
            }
        }
    }
}

