/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.workers;

import agorum.commons.statistic.Statistic;
import agorum.roi.common.Startup;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.workers.Job;
import agorum.roi.workers.Queue;
import agorum.roi.workers.Worker;
import java.util.Collection;

public class AclInheritor
extends Worker {
    private static final String METADB_CONCURRENCY = "MAIN_MODULE_MANAGEMENT/workers/AclInheritor/Concurrency";
    private static final String ME = AclInheritor.class.getName();
    private static final AclInheritor instance = new AclInheritor();
    private final Queue queue;

    protected AclInheritor() {
        super("AclInheritor", SessionControllerAdmin.getService(AclInheritor.class).getMetaDbInstance().getInt(METADB_CONCURRENCY, 2));
        this.queue = new Queue((Statistic)this.stat, "AclInherit", item -> {
            try (Transaction t = new Transaction();){
                Transaction.put(ME, this);
                this.inherit(item.getObject());
                item.done();
                t.commit();
            }
        });
        Startup.whenReady(this::start);
    }

    @Override
    protected Collection<Job> collect(int limit, boolean idle) {
        return this.queue.collect(limit);
    }

    public static void queue(GlobalObjectClientBean object) throws Exception {
        if (Transaction.get(ME) == null) {
            AclInheritor.instance.queue.queue(object.getId(), null, instance::wake);
        }
    }

    public static boolean mayInherit() {
        return Transaction.get(ME) != null;
    }

    private void inherit(GlobalObjectClientBean object) throws Exception {
        SessionController sc = SessionControllerAdmin.getService(AclInheritor.class);
        if (!object.getSessionController().isMainAdmin()) {
            object = sc.getGlobalObjectById(object.getId());
        }
        GlobalObjectClientBeanDefinition def = (GlobalObjectClientBeanDefinition)object.getNewDefinition(sc);
        def.setSystemOption("doNotEA", "");
        def.setSystemOption("skipAcls", object.getId());
        def.setAttribute(GlobalObjectClientBean.ACL_ATTRIBUTE, object.getAttribute(GlobalObjectClientBean.ACL_ATTRIBUTE));
        def.deleteAllScopeAcls();
        def.setScopeAcls(object.getScopeAcls());
        object.update(def);
        this.stat.count("Objects updated", 1L);
    }
}

