/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.tools;

import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.tools.PerformanceInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class PerformanceTester {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PerformanceInfo> testFileSystem(String baseDir) throws Exception {
        ArrayList<PerformanceInfo> info = new ArrayList<PerformanceInfo>();
        File dir = new File(baseDir + "/test_" + System.currentTimeMillis());
        dir.mkdirs();
        try {
            long i;
            long i2;
            if (dir.getFreeSpace() < 0x140000000L) {
                throw new Exception("Not enough space on: " + dir.getAbsolutePath() + ", you need at least 5 GB");
            }
            Random rand = new Random(System.currentTimeMillis());
            long time = System.currentTimeMillis();
            for (i2 = 0L; i2 <= 3000L; ++i2) {
                FileOutputStream fos = new FileOutputStream(new File(dir, "test_" + i2));
                fos.write((byte)rand.nextInt());
                fos.close();
            }
            for (i2 = 3000L; i2 >= 0L; --i2) {
                File f = new File(dir, "test_" + i2);
                FileInputStream fis = new FileInputStream(f);
                fis.read();
                fis.close();
                f.delete();
            }
            time = System.currentTimeMillis() - time;
            PerformanceInfo pInfo = new PerformanceInfo();
            pInfo.info = "Filesystem: Small files";
            pInfo.score = time;
            pInfo.referenceScore = 1200.0;
            info.add(pInfo);
            time = System.currentTimeMillis();
            int amnt = 10000;
            byte[] buffer = new byte[amnt];
            for (int i3 = 0; i3 < amnt; ++i3) {
                buffer[i3] = (byte)rand.nextInt(255);
            }
            for (i = 0L; i <= 300L; ++i) {
                FileOutputStream fos = new FileOutputStream(new File(dir, "testbig_" + i));
                for (int b = 0; b < 1000; ++b) {
                    fos.write(buffer, 0, amnt);
                }
                fos.close();
            }
            for (i = 300L; i >= 0L; --i) {
                File f = new File(dir, "testbig_" + i);
                FileInputStream fis = new FileInputStream(f);
                fis.read();
                fis.close();
                f.delete();
            }
            time = System.currentTimeMillis() - time;
            pInfo = new PerformanceInfo();
            pInfo.info = "Filesystem: Big files";
            pInfo.score = time;
            pInfo.referenceScore = 22000.0;
            info.add(pInfo);
        }
        finally {
            dir.delete();
        }
        return info;
    }

    public List<PerformanceInfo> testCPU() throws Exception {
        ArrayList<PerformanceInfo> info = new ArrayList<PerformanceInfo>();
        long time = System.currentTimeMillis();
        for (long i = 0L; i < 10000000L; ++i) {
            double a = 1550.0;
            a = Math.sqrt(a);
            a = Math.sin(a);
        }
        time = System.currentTimeMillis() - time;
        PerformanceInfo pInfo = new PerformanceInfo();
        pInfo.info = "CPU: Calculation";
        pInfo.score = time;
        pInfo.referenceScore = 460.0;
        info.add(pInfo);
        time = System.currentTimeMillis();
        String s = new String();
        for (long i = 0L; i < 3000000L; ++i) {
            s = s + "Test";
            if (i % 100L != 0L) continue;
            s = "";
        }
        time = System.currentTimeMillis() - time;
        pInfo = new PerformanceInfo();
        pInfo.info = "CPU: Stringperformance";
        pInfo.score = time;
        pInfo.referenceScore = 800.0;
        info.add(pInfo);
        time = System.currentTimeMillis();
        int amnt = 100000;
        byte[] buffer1 = new byte[100000];
        byte[] buffer2 = new byte[100000];
        for (long i = 0L; i < 200000L; ++i) {
            for (int j = 0; j < amnt; ++j) {
                buffer1[j] = buffer2[j];
            }
        }
        time = System.currentTimeMillis() - time;
        pInfo = new PerformanceInfo();
        pInfo.info = "CPU: Memory performance";
        pInfo.score = time;
        pInfo.referenceScore = 1700.0;
        info.add(pInfo);
        return info;
    }

    public List<PerformanceInfo> testAgorumCore(SessionController sessionController, String basePath) throws Exception {
        long i;
        byte[] buffer2;
        ArrayList<PerformanceInfo> info = new ArrayList<PerformanceInfo>();
        RoiFileSystem rfs = new RoiFileSystem(sessionController);
        FolderObjectClientBean testFolder = rfs.createFullpath(basePath + "/test_" + System.currentTimeMillis());
        long time = System.currentTimeMillis();
        try (RoiTransactionHandler rth = new RoiTransactionHandler(0);){
            rth.begin();
            for (long i2 = 0L; i2 < 1000L; ++i2) {
                rfs.createFullpath("test_" + i2, testFolder, testFolder.getAcl());
            }
            rth.end();
        }
        time = System.currentTimeMillis() - time;
        PerformanceInfo pInfo = new PerformanceInfo();
        pInfo.info = "agorum core: Create many folders";
        pInfo.score = time;
        pInfo.referenceScore = 12000.0;
        System.out.println(pInfo.info + ": " + pInfo.score);
        info.add(pInfo);
        time = System.currentTimeMillis();
        try (RoiTransactionHandler rth = new RoiTransactionHandler(0);){
            rth.begin();
            for (long i3 = 0L; i3 < 100L; ++i3) {
                testFolder.getItems();
            }
            rth.end();
        }
        time = System.currentTimeMillis() - time;
        pInfo = new PerformanceInfo();
        pInfo.info = "agorum core: Get items from folder";
        pInfo.score = time;
        pInfo.referenceScore = 7000.0;
        info.add(pInfo);
        time = System.currentTimeMillis();
        rth = new RoiTransactionHandler(0);
        var10_12 = null;
        try {
            GlobalObjectClientBean[] items;
            rth.begin();
            for (GlobalObjectClientBean item : items = testFolder.getItems()) {
                item.delete();
            }
            rth.end();
        }
        catch (Throwable items) {
            var10_12 = items;
            throw items;
        }
        finally {
            if (rth != null) {
                if (var10_12 != null) {
                    try {
                        rth.close();
                    }
                    catch (Throwable items) {
                        var10_12.addSuppressed(items);
                    }
                } else {
                    rth.close();
                }
            }
        }
        time = System.currentTimeMillis() - time;
        pInfo = new PerformanceInfo();
        pInfo.info = "agorum core: Delete folders from folder";
        pInfo.score = time;
        pInfo.referenceScore = 13000.0;
        info.add(pInfo);
        time = System.currentTimeMillis();
        rth = new RoiTransactionHandler(0);
        var10_12 = null;
        try {
            rth.begin();
            buffer2 = new byte[100];
            for (i = 0L; i < 300L; ++i) {
                ByteArrayInputStream content = new ByteArrayInputStream(buffer2);
                rfs.putDocument("testfile_" + i, content, testFolder.getAnyFolderPath(), testFolder.getAcl(), false);
                content = null;
            }
            rth.end();
        }
        catch (Throwable buffer2) {
            var10_12 = buffer2;
            throw buffer2;
        }
        finally {
            if (rth != null) {
                if (var10_12 != null) {
                    try {
                        rth.close();
                    }
                    catch (Throwable buffer2) {
                        var10_12.addSuppressed(buffer2);
                    }
                } else {
                    rth.close();
                }
            }
        }
        time = System.currentTimeMillis() - time;
        pInfo = new PerformanceInfo();
        pInfo.info = "agorum core: Write small files";
        pInfo.score = time;
        pInfo.referenceScore = 9400.0;
        info.add(pInfo);
        time = System.currentTimeMillis();
        rth = new RoiTransactionHandler(0);
        var10_12 = null;
        try {
            rth.begin();
            buffer2 = new byte[0xA00000];
            for (i = 0L; i < 30L; ++i) {
                ByteArrayInputStream content = new ByteArrayInputStream(buffer2);
                rfs.putDocument("testfilebig_" + i, content, testFolder.getAnyFolderPath(), testFolder.getAcl(), false);
                content = null;
            }
            rth.end();
        }
        catch (Throwable buffer3) {
            var10_12 = buffer3;
            throw buffer3;
        }
        finally {
            if (rth != null) {
                if (var10_12 != null) {
                    try {
                        rth.close();
                    }
                    catch (Throwable buffer3) {
                        var10_12.addSuppressed(buffer3);
                    }
                } else {
                    rth.close();
                }
            }
        }
        time = System.currentTimeMillis() - time;
        pInfo = new PerformanceInfo();
        pInfo.info = "agorum core: Write large files";
        pInfo.score = time;
        pInfo.referenceScore = 14500.0;
        info.add(pInfo);
        time = System.currentTimeMillis();
        rth = new RoiTransactionHandler(0);
        var10_12 = null;
        try {
            rth.begin();
            for (GlobalObjectClientBean item : items = testFolder.getItems()) {
                item.delete();
            }
            rth.end();
        }
        catch (Throwable throwable) {
            var10_12 = throwable;
            throw throwable;
        }
        finally {
            if (rth != null) {
                if (var10_12 != null) {
                    try {
                        rth.close();
                    }
                    catch (Throwable throwable) {
                        var10_12.addSuppressed(throwable);
                    }
                } else {
                    rth.close();
                }
            }
        }
        time = System.currentTimeMillis() - time;
        pInfo = new PerformanceInfo();
        pInfo.info = "agorum core: Delete files from folder";
        pInfo.score = time;
        pInfo.referenceScore = 5300.0;
        info.add(pInfo);
        testFolder.delete();
        return info;
    }

    public void printPerfInfo(List<PerformanceInfo> info) {
        for (PerformanceInfo pInfo : info) {
            System.out.println(pInfo.info + ": " + pInfo.getPersentScoreFormatted() + "% (" + pInfo.score + ")");
        }
    }

    public static void main(String[] args) {
        try {
            PerformanceTester tester = new PerformanceTester();
            List<PerformanceInfo> info = tester.testFileSystem("c:\\temp\\testperformance");
            tester.printPerfInfo(info);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

