/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.tools;

import agorum.roi.interfaces.webservices.client.beans.common.BaseItemsRequestBean;
import agorum.roi.interfaces.webservices.client.beans.common.BaseItemsResponseBean;
import agorum.roi.interfaces.webservices.client.beans.common.BaseRequestBean;
import agorum.roi.interfaces.webservices.client.beans.common.BaseResponseBean;
import agorum.roi.interfaces.webservices.client.beans.common.ItemBean;
import agorum.roi.interfaces.webservices.client.beans.login.LoginRequestBean;
import agorum.roi.interfaces.webservices.client.beans.login.LoginResponseBean;
import agorum.roi.interfaces.webservices.client.beans.search.SearchRequestBean;
import agorum.roi.interfaces.webservices.client.beans.search.SearchResponseBean;
import agorum.webcomponents.webservices.beans.GenericRequestBean;
import agorum.webcomponents.webservices.common.WebServiceUtils;
import java.io.FileOutputStream;
import java.util.StringTokenizer;

public class NgFSFind {
    private String userName = null;
    private String passWord = null;
    private String query = null;
    private String webServiceUrl = null;
    private String startPath = null;
    private String attributes = null;
    private int numberOfItems = 100;
    private String sessionIdOutFile = null;
    private String wsSessionId = null;

    public NgFSFind(String[] args) {
        this.wsSessionId = args[0];
        this.userName = args[1];
        this.passWord = args[2];
        this.webServiceUrl = args[3];
        this.query = args[4];
        this.startPath = args[5];
        this.attributes = args[6];
        this.numberOfItems = Integer.parseInt(args[7]);
        this.sessionIdOutFile = args[8];
    }

    public void find() {
        WebServiceUtils wsu = new WebServiceUtils();
        LoginRequestBean loginRequestBean = new LoginRequestBean();
        loginRequestBean.setUserName(this.userName);
        loginRequestBean.setPassWord(this.passWord);
        Class[] classes = new Class[]{LoginRequestBean.class, LoginResponseBean.class, BaseRequestBean.class, BaseResponseBean.class};
        LoginResponseBean loginResponseBean = (LoginResponseBean)wsu.callWebService(this.wsSessionId, this.webServiceUrl, (GenericRequestBean)loginRequestBean, "NgFSWebService", "login", classes);
        try {
            FileOutputStream fos = new FileOutputStream(this.sessionIdOutFile);
            fos.write(loginResponseBean.getWsSessionId().getBytes());
            fos.close();
        }
        catch (Exception fos) {
            // empty catch block
        }
        SearchRequestBean searchRequestBean = new SearchRequestBean();
        searchRequestBean.setQuery(this.query);
        searchRequestBean.setStartItem(0);
        searchRequestBean.setItemsPerRequest(this.numberOfItems);
        searchRequestBean.setStartPath(this.startPath);
        StringTokenizer st = new StringTokenizer(this.attributes, ",");
        int number = st.countTokens();
        String[] reqAttributes = new String[number];
        for (int i = 0; i < number; ++i) {
            reqAttributes[i] = st.nextElement().toString().toUpperCase();
        }
        searchRequestBean.setRequestAttributes(reqAttributes);
        classes = new Class[]{SearchRequestBean.class, SearchResponseBean.class, BaseItemsRequestBean.class, BaseItemsResponseBean.class, ItemBean.class, BaseRequestBean.class, BaseResponseBean.class};
        SearchResponseBean searchResponseBean = (SearchResponseBean)wsu.callWebService(loginResponseBean.getWsSessionId(), this.webServiceUrl, (GenericRequestBean)searchRequestBean, "NgFSWebService", "search", classes);
        ItemBean[] items = searchResponseBean.getItems();
        if (items != null) {
            int len = items.length;
            for (int i = 0; i < len; ++i) {
                String[] attributeValues = items[i].getAttributes();
                int attrLen = attributeValues.length;
                for (int j = 0; j < attrLen; ++j) {
                    System.out.print(attributeValues[j] + "   ");
                }
                System.out.print("\n");
            }
        }
        System.err.println("Totally found: " + searchResponseBean.getResultCount());
    }

    public static void main(String[] args) {
        if (args.length < 9) {
            System.err.println("Usage: NgFSFind <SessionId> <UserName> <PassWord> <WebServiceUrl> <Query> <Start-Path> <Attributes> <NumberOfItems> <OutFile for SessionId>");
        } else {
            NgFSFind find = new NgFSFind(args);
            find.find();
        }
    }
}

