/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.tools;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.string.StringUtils;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.parser.common.CreateRoiObjectsFromParseObject;
import agorum.roi.parser.common.ParserObject;
import agorum.roi.parser.common.RoiXMLParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Vector;

public class CreateXmlFromFolder {
    private SessionController sessionController = null;
    private String sourceBasePath = null;
    private String sourcePath = null;
    private String destinationBasePath = null;
    private String destinationPath = null;
    private String diskPath = null;

    public CreateXmlFromFolder(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public StringBuffer createXml(String sourceBasePath, String sourcePath, String destinationBasePath, String destinationPath, String diskPath) throws Exception {
        FolderObjectClientBean folderSourcePath;
        this.sourceBasePath = sourceBasePath;
        this.sourcePath = sourcePath;
        this.destinationBasePath = destinationBasePath;
        this.destinationPath = destinationPath;
        this.diskPath = diskPath;
        StringBuffer sa = new StringBuffer();
        FolderObjectClientBean folderSourceBasePath = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(sourceBasePath);
        if (folderSourceBasePath != null && (folderSourcePath = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(sourcePath)) != null) {
            File f = new File(diskPath);
            f.mkdirs();
            sa.append("<?xml version = \"1.0\" encoding=\"ISO-8859-15\"?>\n");
            sa.append("<ObjectList>\n");
            this.getItemsRec(folderSourceBasePath, folderSourcePath, "  ", sa, destinationPath, diskPath);
            sa.append("</ObjectList>\n");
        }
        return sa;
    }

    private void getItemsRec(FolderObjectClientBean folderSourceBasePath, FolderObjectClientBean folder, String depth, StringBuffer sa, String path, String actDiskPath) throws Exception {
        GlobalObjectClientBean[] items = this.getSMBItems(folder);
        if (items != null) {
            int len = items.length;
            for (int i = 0; i < len; ++i) {
                int read;
                String basePath = this.getBasePath(folderSourceBasePath, items[i]);
                if (basePath != null) {
                    System.err.println("" + depth + items[i].getName() + " --> Link (" + basePath + ")");
                    sa.append(depth + "<FolderPathRelationObject>\n");
                    sa.append(depth + "  <LeftObject RefType=\"Path\">" + path + "</LeftObject>\n");
                    sa.append(depth + "  <RightObject RefType=\"Path\">" + this.destinationBasePath + basePath + "</RightObject>\n");
                    sa.append(depth + "</FolderPathRelationObject>\n\n");
                    continue;
                }
                System.err.println("" + depth + items[i].getName());
                String myDiskPath = actDiskPath + File.separator + items[i].getName();
                if (this.sessionController.isFolder(items[i])) {
                    sa.append(depth + "<FolderObject>\n");
                    sa.append(depth + "  <Update>" + path + "/" + items[i].getName() + "</Update>\n");
                    sa.append(depth + "  <Acl RefType=\"Name\"  ClassName=\"AccessControlListObject\" DoNotSetIfNotExists=\"true\">" + items[i].getAcl().getName() + "</Acl>\n");
                    sa.append(depth + "</FolderObject>\n");
                    File f = new File(myDiskPath);
                    f.mkdirs();
                    this.getItemsRec(folderSourceBasePath, (FolderObjectClientBean)items[i], depth + "  ", sa, path + "/" + items[i].getName(), actDiskPath + File.separator + items[i].getName());
                    continue;
                }
                sa.append(depth + "<FileObject>\n");
                sa.append(depth + "  <Update>" + path + "/" + items[i].getName() + "</Update>\n");
                sa.append(depth + "  <Acl RefType=\"Name\"  ClassName=\"AccessControlListObject\" DoNotSetIfNotExists=\"true\">" + items[i].getAcl().getName() + "</Acl>\n");
                sa.append(depth + "</FileObject>\n");
                FileObjectClientBean file = (FileObjectClientBean)items[i];
                InputStream is = file.getContentStream();
                File f = new File(myDiskPath);
                f.createNewFile();
                if (is == null) continue;
                FileOutputStream fos = new FileOutputStream(f);
                byte[] buffer = new byte[1024];
                while ((read = is.read(buffer)) >= 0) {
                    fos.write(buffer, 0, read);
                }
                try {
                    fos.close();
                    is.close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private String getBasePath(FolderObjectClientBean folderSourceBasePath, GlobalObjectClientBean gocb) throws Exception {
        String basePath = null;
        String[] paths = gocb.getAllFolderPath(folderSourceBasePath.getId());
        if (paths != null) {
            basePath = paths[0];
        }
        return basePath;
    }

    private GlobalObjectClientBean[] getSMBItems(FolderObjectClientBean folder) throws Exception {
        String[] sArray = null;
        try {
            MetaDb metaDb = this.sessionController.getMetaDbInstance();
            sArray = metaDb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/roiprotocols/smb/control/AllowedObjects");
        }
        catch (Throwable metaDb) {
            // empty catch block
        }
        GlobalObjectClientBean[] subItemsArr = folder.getItemsObjectsOnly(sArray);
        return subItemsArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ImportXMLToRoi(String xml) {
        RoiTransactionHandler rth = null;
        try {
            long time1 = System.currentTimeMillis();
            rth = new RoiTransactionHandler();
            rth.begin();
            RoiXMLParser roiXMLParser = new RoiXMLParser(this.sessionController);
            roiXMLParser.setDocument(xml);
            ParserObject po = roiXMLParser.parse();
            CreateRoiObjectsFromParseObject createRoiObjectsFromParseObject = new CreateRoiObjectsFromParseObject(this.sessionController);
            Vector v = createRoiObjectsFromParseObject.create(po);
            rth.end();
            System.err.println("Ben\u00f6tigte Zeit : " + (System.currentTimeMillis() - time1));
            if (v != null && v.size() > 0) {
                System.err.println("XML - Liefertb Returnwerte ");
                int len = v.size();
                for (int i = 0; i < len; ++i) {
                    AttributeValue av = (AttributeValue)v.elementAt(i);
                    System.err.println("DataType = " + av.getDataType() + ", Value = " + av.toString(this.sessionController));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Exception: " + e.getMessage());
        }
        finally {
            if (rth != null) {
                try {
                    rth.abort();
                }
                catch (Exception exception) {}
                rth = null;
            }
        }
    }

    public static void main(String[] args) {
        block7: {
            try {
                if (args == null || args != null && args.length < 7) {
                    System.err.println("Aufruf:\nCreateXmlFromFolder UserName UserPassword sourceBasePath sourcePath destinationBasePath destinationPath diskPath\n");
                    break block7;
                }
                String userName = args[0];
                String password = args[1];
                String sourceBasePath = args[2];
                String sourcePath = args[3];
                String destinationBasePath = args[4];
                String destinationPath = args[5];
                String diskPath = args[6];
                System.setProperty("org.jboss.mq.il.oil.localAddr", "1.1.1.1");
                System.setProperty("org.jboss.mq.il.oil.localPort", "9876");
                System.err.println("userName            " + userName);
                System.err.println("password            " + password);
                System.err.println("sourceBasePath      " + sourceBasePath);
                System.err.println("sourcePath          " + sourcePath);
                System.err.println("destinationBasePath " + destinationBasePath);
                System.err.println("destinationPath     " + destinationPath);
                System.err.println("diskPath            " + diskPath);
                RoiProperties rp = new RoiProperties();
                CredentialObject credential = new CredentialObject();
                credential.setUserName(userName);
                credential.setPassWord(password);
                credential.setModulInfo("CreateXmlFromFolder");
                SessionController sessionController = SessionController.connect(credential);
                CreateXmlFromFolder createXmlFromFolder = new CreateXmlFromFolder(sessionController);
                StringBuffer sbXml = createXmlFromFolder.createXml(sourceBasePath, sourcePath, destinationBasePath, destinationPath, diskPath);
                File f = new File(diskPath + File.separator + "Import.xml");
                f.createNewFile();
                StringUtils su = new StringUtils();
                ByteArrayInputStream is = su.stringToStream(sbXml.toString());
                if (is != null) {
                    int read;
                    FileOutputStream fos = new FileOutputStream(f);
                    byte[] buffer = new byte[1024];
                    while ((read = is.read(buffer)) >= 0) {
                        fos.write(buffer, 0, read);
                    }
                    try {
                        fos.close();
                        ((InputStream)is).close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                System.err.println("xml : \n" + sbXml.toString());
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        System.err.println("Programm ende");
    }
}

