/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.timephasedaction.actions;

import agorum.commons.statistic.SystemObjectReference;
import agorum.commons.statistic.SystemStatistic;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.MailObjectClientBean;
import agorum.roi.ejb.client.beans.NoteObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AccessLevel;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.sessionfacade.beans.FileObjectSessionFacade;
import agorum.roi.sessionfacade.beans.NoteObjectSessionFacade;
import agorum.roi.timephasedaction.actions.BaseAction;

public class DismantleMailAction
extends BaseAction {
    public static Object syncObj = new Object();
    public static boolean isRunning = false;

    @Override
    public boolean hasAccess(SystemStatistic stat, SessionController sessionController, GlobalObjectClientBean clientBean, String action) throws Exception {
        if (!(clientBean instanceof MailObjectClientBean)) {
            return false;
        }
        String accessLevelSource = this.getMethodParameter(sessionController, "AccessLevelSource", action);
        return clientBean.checkEffectiveAccess(AccessLevel.getAccessLevel(accessLevelSource));
    }

    @Override
    public boolean hasAccess(SystemStatistic stat, SessionController sessionController, String className, String action) throws Exception {
        return className.equals(MailObjectClientBean.CLASS_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning(SystemStatistic stat) {
        Object object = syncObj;
        synchronized (object) {
            if (!isRunning) {
                isRunning = true;
                return false;
            }
            return true;
        }
    }

    @Override
    public void invokeFast(SystemStatistic stat, SessionController sessionController, GlobalObjectClientBean clientBean, String action) throws Exception {
        this.dismantleMail(stat, sessionController, (MailObjectClientBean)clientBean, Boolean.parseBoolean(this.getMethodParameter(sessionController, "DeleteMail", action)), Boolean.parseBoolean(this.getMethodParameter(sessionController, "AttachAsNote", action)));
    }

    @Override
    public void invoke(SystemStatistic stat, SessionController sessionController, GlobalObjectClientBean clientBean, String action) throws Exception {
        isRunning = false;
    }

    private void dismantleMail(SystemStatistic stat, SessionController sessionController, MailObjectClientBean mail, boolean deleteMail, boolean attachAsNote) throws Exception {
        FolderObjectClientBean[] parents = mail.getParents();
        if (parents == null || parents.length <= 0) {
            stat.warning().object((SystemObjectReference)mail).send("Got no parent folder, aborting");
            return;
        }
        FolderObjectClientBean parent = parents[0];
        GlobalObjectClientBean[] attachments = mail.getMailAttachments();
        if (attachments == null || attachments.length <= 0) {
            stat.info().object((SystemObjectReference)mail).send("has no attachments, skipping");
            return;
        }
        ContentInterface mailBody = null;
        if (attachAsNote) {
            mailBody = (ContentInterface)((Object)mail.getBestBodyPart());
        }
        for (GlobalObjectClientBean attachment : attachments) {
            if (attachAsNote) {
                stat.debug().object((SystemObjectReference)mail).send("attach as note");
                ContentInterface attachmentCi = (ContentInterface)((Object)attachment);
                FileObjectSessionFacade fosf = new FileObjectSessionFacade(sessionController);
                fosf.setWithTransaction(true);
                fosf.setDestinationFolder(parent);
                fosf.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, DismantleMailAction.uncollideName(parent, attachment.getName()));
                fosf.setContentStream(attachmentCi.getContentStream());
                GlobalObjectClientBean attachmentCopy = fosf.create();
                attachmentCopy.setAcl(mail.getAcl());
                attachmentCopy.setCreator(attachment.getCreator());
                attachmentCopy.setOwner(attachment.getOwner());
                attachmentCopy.setCreateDate(attachment.getCreateDate());
                NoteObjectSessionFacade noteSessionFacade = new NoteObjectSessionFacade(sessionController);
                noteSessionFacade.setWithTransaction(true);
                noteSessionFacade.setNameWithId(true);
                noteSessionFacade.setParentObject(attachmentCopy);
                noteSessionFacade.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, NoteObjectClientBean.CLASS_NAME + "_$$ID$$.txt");
                noteSessionFacade.setContentStream(mailBody.getContentStream());
                noteSessionFacade.create();
                stat.debug().object((SystemObjectReference)mail).send("note created");
                continue;
            }
            String name = DismantleMailAction.uncollideName(parent, attachment.getName());
            stat.debug().object((SystemObjectReference)mail).send("attach no note");
            stat.debug().object((SystemObjectReference)mail).send("new name: " + name);
            attachment.setName(name);
            parent.add(attachment);
            stat.debug().object((SystemObjectReference)mail).send("added to: " + parent.getID());
        }
        if (deleteMail) {
            stat.debug().object((SystemObjectReference)mail).send("delete mail ...");
            if (attachAsNote) {
                SuperObjectClientBeanDefinition def = mail.getNewDefinition(sessionController);
                def.setSystemOption("SetExpirationDateInsteadOfDelete", "");
                def.setSystemOption("parentFolderOfDeleteObject", parent);
                mail.delete(def);
            } else {
                parent.removeItem(mail);
            }
        }
    }

    private static String uncollideName(FolderObjectClientBean parent, String name) throws Exception {
        String newName;
        if (!parent.hasItem(name)) {
            return name;
        }
        String extension = "";
        int i = name.lastIndexOf(46);
        if (i >= 0) {
            extension = name.substring(i);
            name = name.substring(0, i);
        }
        i = 0;
        while (parent.hasItem(newName = name + " (" + ++i + ")" + extension)) {
        }
        return newName;
    }
}

