/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.workers;

import agorum.commons.forms.FormItem;
import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemConfig;
import agorum.commons.tuple.Pair;
import agorum.roi.metadb.common.MetaDbAccessor;
import agorum.roi.metadb.util.MetaDbUtil;
import agorum.roi.workers.MailCompressor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MailCompressorConfig
extends SystemConfig {
    private static final String METADB_BASE = "MAIN_MODULE_MANAGEMENT/workers/MailCompressor/";
    private static final Pattern pattern = Pattern.compile("inpath:\\((([0-9]+ OR )*[0-9]+)\\) updatedate(_date_range)?:\\[\\* TO NOW-([0-9]+)DAYS]");
    private static final MailCompressorConfig instance = new MailCompressorConfig(CoreStatistic.getInstance().getGroup("Configurations"));

    protected MailCompressorConfig(Statistic parent) {
        super(parent);
        MailCompressor.ifNotCompatible(() -> ((MailCompressorConfig)this).removeFromParent());
    }

    public static MailCompressorConfig getInstance() {
        return instance;
    }

    public String getDescription() {
        return "Mail compression configuration";
    }

    public String getShortDescription() {
        return "Mail compression";
    }

    public void formButton(Map<String, Object> args) {
        block16: {
            try {
                if (!MailCompressorConfig.isButton((String)"save", args)) break block16;
                try (MetaDbUtil mdbu = new MetaDbAccessor(this.getName()).getWriteUtil(METADB_BASE);){
                    String query;
                    mdbu.setString("Concurrency", args.get("concurrency").toString());
                    Object queryObj = args.get("query");
                    String string = query = queryObj == null ? "" : queryObj.toString().trim();
                    if (query.isEmpty()) {
                        mdbu.setString("Query", MailCompressorConfig.buildQuery((String[])args.get("folders"), (Integer)args.get("retentionDays")));
                    } else {
                        mdbu.setString("Query", query);
                    }
                    mdbu.commit();
                }
                MailCompressor.reconfigure();
            }
            catch (Exception e) {
                throw new RuntimeException("Error saving configuration", e);
            }
        }
    }

    public Collection<FormItem> formCreate(Map<String, Object> formData) {
        FormItem.Collection fields = new FormItem.Collection();
        try (MetaDbUtil mdbu = new MetaDbAccessor(this.getName()).getReadUtil(METADB_BASE);){
            fields.intField("concurrency").title("Concurrency").description("Worker concurrency level").value((Object)mdbu.getInt("Concurrency", 0)).allowBlank(false).add();
            String[] folders = new String[]{};
            int retentionDays = 30;
            String query = mdbu.getString("Query");
            Pair<String[], Integer> pair = MailCompressorConfig.splitQuery(query);
            if (pair != null) {
                folders = (String[])pair.getFirst();
                retentionDays = (Integer)pair.getSecond();
                query = "";
            }
            fields.stringArrayField("folders").title("Folder IDs").description("List of folders in which mails should be compressed recursively, separated by ;").value((Object)folders).allowBlank(true).validationJs("!v.trim() || /^( *[0-9]+ *;)* *[0-9]+ *$/.test(v)").add();
            fields.intField("retentionDays").title("Retention days").description("Number of days that uncompressed mail content should be retained").value((Object)retentionDays).allowBlank(true).add();
            fields.stringField("query").title("Query").description("Query for finding compression candidates (Folder IDs and Retention days are ignored, if you enter a query)").value((Object)query).allowBlank(true).add();
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading configuration", e);
        }
        return fields.getCollection();
    }

    private static String buildQuery(String[] folders, int retentionDays) {
        String inpath = Arrays.stream(folders).map(String::trim).collect(Collectors.joining(" OR "));
        return "inpath:(" + inpath + ") updatedate_date_range:[* TO NOW-" + retentionDays + "DAYS]";
    }

    private static Pair<String[], Integer> splitQuery(String query) {
        if (query == null) {
            return null;
        }
        Matcher m = pattern.matcher(query);
        if (m.matches()) {
            return new Pair((Object)m.group(1).split(" OR "), (Object)Integer.valueOf(m.group(4)));
        }
        return null;
    }
}

