/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.workers;

import agorum.commons.forms.FormItem;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemConfig;
import agorum.roi.metadb.common.MetaDbAccessor;
import agorum.roi.metadb.util.MetaDbUtil;
import agorum.roi.statistic.searchengine.ContentIndexStatistic;
import agorum.roi.statistic.searchengine.SearchEngineStatistic;
import agorum.roi.workers.ContentExtractor;
import java.util.Collection;
import java.util.Map;

public class ContentExtractorConfig
extends SystemConfig {
    private static final String METADB_BASE = "MAIN_MODULE_MANAGEMENT/workers/ContentExtractor/";
    private static final ContentExtractorConfig instance = new ContentExtractorConfig(SearchEngineStatistic.getInstance().getGroup("Configurations"));

    protected ContentExtractorConfig(Statistic parent) {
        super(parent);
    }

    public static ContentExtractorConfig getInstance() {
        return instance;
    }

    public String getDescription() {
        return "Content extraction configuration";
    }

    public String getShortDescription() {
        return "Content extraction";
    }

    public void formButton(Map<String, Object> args) {
        block18: {
            try {
                if (!ContentExtractorConfig.isButton((String)"save", args)) break block18;
                try (MetaDbUtil mdbu = new MetaDbAccessor(this.getName()).getWriteUtil(METADB_BASE);){
                    if (!((Boolean)args.get("licensed")).booleanValue()) {
                        this.setPromptAfterAction("You have to accept the license terms before changing this configuration.");
                        return;
                    }
                    mdbu.setString("ConcurrencyStandard", args.get("concurrencyStandard").toString());
                    mdbu.setString("ConcurrencyFast", args.get("concurrencyFast").toString());
                    mdbu.commit();
                }
                ContentExtractor.reconfigure();
            }
            catch (Exception e) {
                ContentIndexStatistic.getInstance().error(e, "Error saving configuration");
            }
        }
    }

    public Collection<FormItem> formCreate(Map<String, Object> formData) {
        FormItem.Collection fields = new FormItem.Collection();
        try (MetaDbUtil mdbu = new MetaDbAccessor(this.getName()).getReadUtil(METADB_BASE);){
            fields.boolField("licensed").title("Licensed").description("By checking this field I confirm that my license covers the number of OCR-enabled extractor threads entered below.").add();
            fields.intField("concurrencyStandard").title("Concurrency (Standard)").description("Worker concurrency level for standard extraction (with OCR)").value((Object)mdbu.getInt("ConcurrencyStandard", 1)).allowBlank(false).add();
            fields.intField("concurrencyFast").title("Concurrency (Fast)").description("Worker concurrency level for fast extraction (without OCR)").value((Object)mdbu.getInt("ConcurrencyFast", 1)).allowBlank(false).add();
        }
        catch (Exception e) {
            ContentIndexStatistic.getInstance().error(e, "Error loading configuration");
        }
        return fields.getCollection();
    }
}

