/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.measurement;

import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.measurement.Histogram;
import agorum.commons.statistic.measurement.WatchableMeasurement;
import java.io.File;

public class ServerDiskSpaceRoot
extends Histogram {
    private static final long MEGABYTE = 0x100000L;
    private static final long FREE_MEMORY_CRITICAL = 1024L;

    public ServerDiskSpaceRoot() {
        super(false, "Server Free Disk Space (" + new File("/").getAbsolutePath() + ")", "MB");
    }

    public long getValue() {
        return new File("/").getUsableSpace() / 0x100000L;
    }

    public long getMaximum() {
        return new File("/").getTotalSpace() / 0x100000L;
    }

    public void onTick(Statistic parent) {
        super.onTick(parent);
        this.set(this.getValue());
    }

    public void loadDefaults() {
        this.addCondition(new WatchableMeasurement.Condition("value", WatchableMeasurement.Operator.LESS, 1024L));
    }
}

