/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.config;

import agorum.commons.forms.FormItem;
import agorum.commons.server.ServiceUtils;
import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemConfig;
import agorum.commons.statistic.SystemStatistic;
import agorum.roi.common.utils.InstallUtil;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.metadb.util.MetaDbUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SmartFolderConfig
extends SystemConfig {
    private static final SystemStatistic stat = CoreStatistic.getInstance();
    private static final SmartFolderConfig instance = new SmartFolderConfig(stat.getGroup("Configurations"));
    private static final String BASE_KEY = "MAIN_MODULE_MANAGEMENT/asf";
    private final SessionController sessionController = SessionControllerAdmin.getSessionControllerAdmin(((Object)((Object)this)).getClass().getName());

    protected SmartFolderConfig(Statistic parent) {
        super(parent);
        ServiceUtils.whenStarted(() -> {
            if (!InstallUtil.isModuleActive("SmartFolder")) {
                this.removeFromParent();
            }
        });
    }

    public static SmartFolderConfig getInstance() {
        return instance;
    }

    public String getDescription() {
        return "agorum smart folder";
    }

    public String getShortDescription() {
        return "smart folder";
    }

    public Map<String, Object> formLoad() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        MetaDbUtil mdbUtils = new MetaDbUtil(this.sessionController, BASE_KEY);
        settings.put("cacheLifetime", mdbUtils.getInt("cache_lifetime", 30));
        settings.put("maxRow", mdbUtils.getInt("max_row", 500));
        settings.put("translation", mdbUtils.getString("translation/PathOrId"));
        settings.put("configurationMaxItems", mdbUtils.getInt("maxCacheConfigurationEntries", 1000));
        settings.put("configurationPurgeTime", mdbUtils.getInt("maxCacheConfigurationPurgeTime", 5000));
        settings.put("configurationCacheLifetime", mdbUtils.getInt("maxCacheConfigurationLifeTime", 36000000));
        settings.put("metaDatesMaxItems", mdbUtils.getInt("maxCacheMetaDatesEntries", 1000));
        settings.put("metaDatesPurgeTime", mdbUtils.getInt("maxCacheMetaDatesPurgeTime", 5000));
        settings.put("metaDatesCacheLifetime", mdbUtils.getInt("maxCacheMetaDatesLifeTime", 36000000));
        mdbUtils.close();
        return settings;
    }

    public Collection<FormItem> formCreate(Map<String, Object> formData) {
        FormItem.Collection fields = new FormItem.Collection(formData);
        fields.intField("configurationMaxItems").description("Max items of folder configurations held in the cache").title("Max FolderDescription items").allowBlank(false).add();
        fields.intField("configurationPurgeTime").description("Max time of purging folder configurations from the cache in milliseconds").title("Max FolderDescription purge time").allowBlank(false).add();
        fields.intField("configurationCacheLifetime").description("Max life time of folder configuration cache entries in milliseconds").title("Max FolderDescription cache entry life time").allowBlank(false).add();
        fields.intField("metaDatesMaxItems").description("Max items of meta date definitions held in the cache").title("Max meta date definitions").allowBlank(false).add();
        fields.intField("metaDatesPurgeTime").description("Max time of purging meta date definitions from the cache in milliseconds").title("Max meta date definition purge time").allowBlank(false).add();
        fields.intField("metaDatesCacheLifetime").description("Max life time of meta date definition cache entries in milliseconds").title("Max meta date definition cache entry life time").allowBlank(false).add();
        fields.intField("cacheLifetime").description("Cache lifetime of the different caches in seconds").title("Cache lifetime").allowBlank(false).add();
        fields.intField("maxRow").description("Maximum of rows/records retrieved from a query within a smart folder").title("Max rows").allowBlank(false).add();
        fields.stringField("translation").description("Global translation file for virtual folder").title("Translation").allowBlank(true).add();
        return fields.getCollection();
    }

    public void formButton(Map<String, Object> formData) {
        if (SmartFolderConfig.isButton((String)"save", formData)) {
            MetaDbUtil mdbUtils = new MetaDbUtil(this.sessionController, BASE_KEY);
            mdbUtils.setInt("cache_lifetime", (Integer)formData.get("cacheLifetime"));
            mdbUtils.setInt("max_row", (Integer)formData.get("maxRow"));
            mdbUtils.setInt("maxCacheConfigurationEntries", (Integer)formData.get("configurationMaxItems"));
            mdbUtils.setInt("maxCacheConfigurationPurgeTime", (Integer)formData.get("configurationPurgeTime"));
            mdbUtils.setInt("maxCacheConfigurationLifeTime", (Integer)formData.get("configurationCacheLifetime"));
            mdbUtils.setInt("maxCacheMetaDatesEntries", (Integer)formData.get("configurationMaxItems"));
            mdbUtils.setInt("maxCacheMetaDatesPurgeTime", (Integer)formData.get("configurationPurgeTime"));
            mdbUtils.setInt("maxCacheMetaDatesLifeTime", (Integer)formData.get("configurationCacheLifetime"));
            String csvFile = (String)formData.get("translation");
            if (csvFile != null && !csvFile.isEmpty()) {
                mdbUtils.setString("translation/CaseSensitive", "false");
                mdbUtils.setString("translation/Class", "agorum.api.object.data.CsvDataHandler");
                mdbUtils.setString("translation/Delimiter", ";");
                mdbUtils.setString("translation/Encoding", "UTF-8");
                mdbUtils.setString("translation/Exact", "false");
                mdbUtils.setString("translation/PathOrId", csvFile);
                mdbUtils.setString("translation/QueryColumn", "value");
                mdbUtils.setString("translation/Quote", "\"");
                mdbUtils.setString("translation/WithHeader", "true");
            } else {
                mdbUtils.delete("translation");
            }
            mdbUtils.commit();
            mdbUtils.close();
        }
    }
}

