/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.config;

import agorum.commons.forms.FormItem;
import agorum.commons.server.ServiceUtils;
import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemConfig;
import agorum.commons.statistic.SystemStatistic;
import agorum.commons.system.ExternalApplication;
import agorum.commons.system.ModuleManagement;
import agorum.roi.common.VersionInfo;
import agorum.roi.common.utils.InstallUtil;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.metadb.util.MetaDbUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ModuleActivationConfig
extends SystemConfig {
    private static final SystemStatistic stat = CoreStatistic.getInstance();
    private static final ModuleActivationConfig instance = new ModuleActivationConfig(stat.getGroup("Configurations"));
    private static final String BASE_KEY = "MAIN_MODULE_MANAGEMENT/roi/control/modules";
    private static final String FULL_LICENSE = "isFullLicense";
    private static final String TEST_LICENSE = "isTestLicense";
    private final SessionController sessionController = SessionControllerAdmin.getSessionControllerAdmin(((Object)((Object)this)).getClass().getName());
    private boolean haveGS;
    private boolean haveIM;

    public static ModuleActivationConfig getInstance() {
        return instance;
    }

    protected ModuleActivationConfig(Statistic parent) {
        super(parent);
        ServiceUtils.whenStarted(() -> {
            if (!VersionInfo.isAgorumCoreProInstalled()) {
                this.removeFromParent();
            }
        });
    }

    public String getDescription() {
        return "Manage active modules";
    }

    public String getShortDescription() {
        return "Active modules";
    }

    private void connect() throws Exception {
        this.sessionController.reconnectIfNeeded();
    }

    private void check(String module, Map<String, Object> formData) {
        Set dependencies = ModuleManagement.getDependencies((String)module);
        if (dependencies != null) {
            for (String dependency : dependencies) {
                this.check(dependency, formData);
            }
        }
        formData.put(module, true);
    }

    private void uncheck(String module, Map<String, Object> formData) {
        Set reverseDependencies = ModuleManagement.getReverseDependencies((String)module);
        if (reverseDependencies != null) {
            for (String dependsOn : reverseDependencies) {
                this.uncheck(dependsOn, formData);
            }
        }
        formData.put(module, false);
    }

    private String getDependencies(String module) {
        Set dependencies = ModuleManagement.getDependencies((String)module);
        if (dependencies == null) {
            return "";
        }
        return dependencies.stream().map(key -> ModuleManagement.getDisplayName((String)key)).collect(Collectors.joining(", "));
    }

    private boolean allowUncheck(String module) {
        if ("Storage".equals(module)) {
            String[] bundle = MetaDbSuperCache.listSimplePropertyBundles(this.sessionController, "MAIN_MODULE_MANAGEMENT/backend/configurations");
            return bundle == null || bundle.length == 0;
        }
        if ("StorageContainerBackend".equals(module)) {
            boolean active = false;
            String base = "MAIN_MODULE_MANAGEMENT/backend/configurations";
            String[] bundle = MetaDbSuperCache.listSimplePropertyBundles(this.sessionController, base);
            if (bundle != null) {
                for (String entry : bundle) {
                    String driverClass = MetaDbSuperCache.getSimplePropertyValue(this.sessionController, base + "/" + entry + "/DriverClass");
                    if (driverClass == null || !driverClass.equals("agorum.backendcontainer.drivers.SolrBackendDriver")) continue;
                    active = true;
                    break;
                }
            }
            return !active;
        }
        if ("Preview".equals(module)) {
            return this.haveGS && this.haveIM;
        }
        return true;
    }

    public Map<String, Object> formLoad() {
        HashMap<String, Object> formData = new HashMap<String, Object>();
        formData.put(FULL_LICENSE, false);
        formData.put(TEST_LICENSE, false);
        try {
            this.connect();
            for (String module : ModuleManagement.getMetaDbNames()) {
                formData.put(module, InstallUtil.isModuleActive(module, false));
            }
            stat.info("Analysed active modules");
        }
        catch (Exception e) {
            stat.error((Throwable)e);
        }
        try {
            this.haveGS = ExternalApplication.getToolPath((String)"GHOSTSCRIPT") != null;
            this.haveIM = ExternalApplication.getToolPath((String)"IMAGEMAGICK") != null;
        }
        catch (Exception e) {
            this.haveGS = false;
            this.haveIM = false;
        }
        return formData;
    }

    public Collection<FormItem> formCreate(Map<String, Object> formData) {
        ArrayList sortedNames = new ArrayList(ModuleManagement.getMetaDbNames());
        sortedNames.sort((l, r) -> ModuleManagement.getDisplayName((String)l).compareTo(ModuleManagement.getDisplayName((String)r)));
        FormItem.Collection fields = new FormItem.Collection(formData);
        fields.boolField(FULL_LICENSE).title("Licensed").description("By checking this field I confirm that I own a valid license for all activated modules.").add();
        fields.boolField(TEST_LICENSE).title("Test License").description("By checking this field I confirm that this server is used only for testing or development, not in a production environment and that I have accepted the testing license terms which can be found using the link below.").add();
        fields.staticField("static1").title("Testing License Terms").value((Object)"These are the license terms for testing agorum core").link(ModuleActivationConfig.getSupportLink((String)"testlicense"), "Testing license terms").add();
        if (!this.haveGS) {
            fields.staticField("noGS").title("GhostScript not installed").value((Object)"<span style='color:red'>GhostScript is not installed on this server. GhostScript is required for module 'Preview'. Option 'Preview' will not be available.</span>").add();
        }
        if (!this.haveIM) {
            fields.staticField("noIM").title("ImageMagick not installed").value((Object)"<span style='color:red'>ImageMagick is not installed on this server. ImageMagick is required for module 'Preview'. Option 'Preview' will not be available.</span>").add();
        }
        for (String module : sortedNames) {
            String friendlyName = ModuleManagement.getDisplayName((String)module);
            String desc = "Activate module " + friendlyName;
            String dep = this.getDependencies(module);
            fields.boolField(module).title(friendlyName).description(desc).longDescription(dep.isEmpty() ? null : "Depends on " + dep).readOnly(!this.allowUncheck(module)).add();
        }
        return fields.getCollection();
    }

    public boolean formUpdate(String key, Object value, Map<String, Object> formData) {
        boolean isActive = (Boolean)value;
        if (key.equals(FULL_LICENSE)) {
            if (isActive) {
                formData.put(TEST_LICENSE, false);
            }
        } else if (key.equals(TEST_LICENSE)) {
            if (isActive) {
                formData.put(FULL_LICENSE, false);
            }
        } else if (isActive) {
            this.check(key, formData);
        } else {
            this.uncheck(key, formData);
        }
        return true;
    }

    public void formButton(Map<String, Object> args) {
        block16: {
            try {
                if (!ModuleActivationConfig.isButton((String)"save", args)) break block16;
                boolean fullLicense = (Boolean)args.get(FULL_LICENSE);
                boolean testLicense = (Boolean)args.get(TEST_LICENSE);
                if (!fullLicense && !testLicense) {
                    this.setPromptAfterAction("You have to accept the license terms before changing this configuration.");
                    return;
                }
                this.connect();
                try (MetaDbUtil mdbUtils = new MetaDbUtil(this.sessionController, BASE_KEY);){
                    List names = ModuleManagement.getMetaDbNames();
                    for (Map.Entry<String, Object> entry : args.entrySet()) {
                        if (!names.contains(entry.getKey())) continue;
                        mdbUtils.setBoolean(entry.getKey() + "/Active", (Boolean)entry.getValue());
                    }
                    mdbUtils.commit();
                }
                InstallUtil.applyPreviewStandardSettings(this.sessionController);
                this.setPromptAfterAction("The server must be restarted for the changes to take effect!");
            }
            catch (Exception e) {
                this.error(e);
            }
        }
    }
}

