/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.check;

import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.StatisticDetail;
import agorum.commons.statistic.SystemCheck;
import agorum.commons.statistic.SystemLink;
import agorum.commons.statistic.SystemStatistic;
import agorum.commons.statistic.SystemTaskException;
import agorum.roi.statistic.JavaUtils;
import java.text.DecimalFormat;
import java.util.Map;

public class MemoryCheck
extends SystemCheck {
    private static final MemoryCheck instance = new MemoryCheck(CoreStatistic.getInstance().getGroup("Checks"));
    private static final int MEM_MID = 4096;
    private static final int MEM_GOOD = 8192;

    protected MemoryCheck(Statistic parent) {
        super(parent);
    }

    public static MemoryCheck getInstance() {
        return instance;
    }

    public void performCheck(Map<String, Object> args) throws SystemTaskException {
        StatisticDetail detail = new StatisticDetail();
        this.details.add(detail);
        detail.unit = "MB";
        try {
            Runtime runtime = Runtime.getRuntime();
            long maxMemory = JavaUtils.getMemory("-xmx");
            long initMemory = JavaUtils.getMemory("-xms");
            long freeMemory = runtime.freeMemory();
            DecimalFormat df = new DecimalFormat("0.00");
            detail.title = "Result";
            if ((double)maxMemory / 1024.0 / 1024.0 < 4096.0) {
                this.performanceStatus = Statistic.PerformanceStatus.CRITICAL;
                this.info().detail((Object)("Your max JVM memory is too low you need at least 4GB RAM, at the moment you have: " + df.format((double)maxMemory / 1024.0 / 1024.0) + " MB")).send("JVM memory too low");
                detail.detail = "JVM memory too low";
            } else if ((double)maxMemory / 1024.0 / 1024.0 < 8192.0) {
                this.performanceStatus = Statistic.PerformanceStatus.WARN;
                this.info().detail((Object)("Your JVM memory could be higher, 8GB is optimal, at the moment you have: " + df.format((double)maxMemory / 1024.0 / 1024.0) + " MB")).send("JVM Memory could be higher");
                detail.detail = "Too few JVM Memory";
            } else if ((double)maxMemory / 1024.0 / 1024.0 > 16384.0) {
                this.performanceStatus = Statistic.PerformanceStatus.WARN;
                this.info().detail((Object)("Your JVM memory is probably too high, more than 16 GB can lead to JVM freezes, when garbage collection is running, at the moment you have: " + df.format((double)maxMemory / 1024.0 / 1024.0) + " MB")).send("JVM memory is probably too high");
                detail.detail = "JVM Memory probably too high";
            } else {
                this.performanceStatus = Statistic.PerformanceStatus.OK;
                this.info().detail((Object)("Your JVM memory is optimal: " + df.format((double)maxMemory / 1024.0 / 1024.0))).send("JVM memory is optimal");
                detail.detail = "JVM memory optimal";
            }
            detail.performanceStatus = this.performanceStatus;
            detail.actualValue = new Double((double)maxMemory / 1024.0 / 1024.0);
            detail.referenceValue = new Double(8192.0);
            detail.link = new SystemLink();
            detail.link.setLink(SystemStatistic.getSupportLink((String)"jvmram"));
            detail.link.setDescription("More info");
            detail = new StatisticDetail();
            this.details.add(detail);
            detail.title = "Info";
            detail.unit = "MB";
            if (maxMemory - initMemory > 512L) {
                detail.performanceStatus = Statistic.PerformanceStatus.WARN;
                detail.detail = "JVM XMS Memory settings: it is better to set -Xms to the same value as -Xmx";
            } else {
                detail.performanceStatus = Statistic.PerformanceStatus.OK;
                detail.detail = "JVM XMS Memory settings";
            }
            detail.actualValue = new Double((double)initMemory / 1024.0 / 1024.0);
            detail.referenceValue = new Double((double)maxMemory / 1024.0 / 1024.0);
            detail = new StatisticDetail();
            this.details.add(detail);
            detail.detail = "Free JVM Memory";
            detail.title = "Info";
            detail.unit = "MB";
            detail.performanceStatus = Statistic.PerformanceStatus.INFO;
            detail.actualValue = new Double((double)freeMemory / 1024.0 / 1024.0);
            detail.referenceValue = new Double(4096.0);
        }
        catch (Exception e) {
            throw new SystemTaskException("Error getting memory info", (Throwable)e);
        }
    }

    public String getDescription() {
        return "Checking JVM Memory of the agorum core server";
    }

    public String getShortDescription() {
        return "JVM Memory";
    }
}

