/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.action;

import agorum.commons.forms.FormItem;
import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemAction;
import agorum.commons.statistic.SystemTaskException;
import agorum.roi.common.utils.Packager;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class PackageInstallAction
extends SystemAction
implements Packager.Logger {
    private static final PackageInstallAction instance = new PackageInstallAction(CoreStatistic.getInstance().getGroup("Actions"));

    protected PackageInstallAction(Statistic parent) {
        super(parent);
    }

    public static PackageInstallAction getInstance() {
        return instance;
    }

    public String getDescription() {
        return "Install agorum configuration package";
    }

    public String getShortDescription() {
        return "Install Package";
    }

    public Collection<FormItem> formCreate(Map<String, Object> formData) {
        FormItem.Collection fields = new FormItem.Collection();
        fields.attachment("zipFile").title("ZIP File").description("Choose configuration ZIP file to install").add();
        fields.button("upload").title("Install ZIP Package").description("Install").add();
        return fields.getCollection();
    }

    public boolean runActionSync(Map<String, Object> args) throws SystemTaskException {
        return true;
    }

    public void runActionAsync(Map<String, Object> args) throws SystemTaskException {
        try {
            String button = (String)args.get("buttonId");
            if (button.equals("upload")) {
                Map attachments = (Map)args.get("attachments");
                SessionController sessionController = SessionControllerAdmin.getSessionControllerAdmin(this.getName());
                if (attachments.size() > 0) {
                    this.info("Starting package installer");
                    for (Map.Entry entry : attachments.entrySet()) {
                        Packager.unpack(this, sessionController, ((Statistic.Attachment)entry.getValue()).getStream(), null);
                    }
                    this.info("Package successfully installed");
                } else {
                    this.info("No package file selected");
                }
            }
        }
        catch (Exception e) {
            this.error(e, "Error installing package file");
        }
    }

    @Override
    public void println(String str) throws IOException {
        this.info().indirection(2).send(str);
    }
}

