/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.sessionfacade.beans;

import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FileObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.FormatObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.sessionfacade.beans.GlobalObjectSessionFacade;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class FileObjectSessionFacade
extends GlobalObjectSessionFacade {
    public FileObjectSessionFacade(SessionController sessionController) throws Exception {
        super(sessionController);
        this.setGlobalObjectClientBeanDefinition(new FileObjectClientBeanDefinition(sessionController));
    }

    public GlobalObjectClientBean createTemporaryDocument(String fileName, InputStream contentStream) throws Exception {
        this.setAttributeInternal(GlobalObjectClientBean.NAME_ATTRIBUTE, fileName);
        this.setAttributeInternal(GlobalObjectClientBean.EXPIRATIONDATE_ATTRIBUTE, new Date(new Date().getTime() + 600000L));
        try {
            this.setContentStream(contentStream);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        GlobalObjectClientBean po = this.create();
        return po;
    }

    public void setContentStream(InputStream contentStream) throws Exception {
        try {
            this.gosfc.setContentStream(contentStream);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            ExceptionUtils.handleException(e);
        }
    }

    public void setFormat(FormatObjectClientBean format) throws Exception {
        try {
            FileObjectClientBeanDefinition dDef = (FileObjectClientBeanDefinition)this.gosfc.getGlobalObjectDefinition();
            dDef.setFormat(format);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    @Override
    public void setGlobalObject(GlobalObjectClientBean gocb) throws Exception {
        try {
            this.gosfc.setGlobalObject(gocb);
            this.gosfc.setGlobalObjectClientBeanDefinition((GlobalObjectClientBeanDefinition)gocb.getNewDefinition(this.sessionController));
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlobalObjectClientBean create() throws Exception {
        FileObjectClientBean focb = null;
        RoiTransactionHandler rth = null;
        try {
            rth = this.getRoiTransactionHandler();
            this.beginTransaction(rth);
            focb = (FileObjectClientBean)super.create();
            if (this.gosfc.getContentStream() != null) {
                focb.setContent(this.gosfc.getContentStream(), this.getGlobalObjectClientBeanDefinition());
            }
            rth = this.completeTransaction(rth);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            rth = this.abortTransaction(rth);
        }
        return focb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlobalObjectClientBean update() throws Exception {
        FileObjectClientBean focb = null;
        RoiTransactionHandler rth = null;
        try {
            rth = this.getRoiTransactionHandler();
            this.beginTransaction(rth);
            focb = (FileObjectClientBean)super.update();
            if (this.gosfc.getContentStream() != null) {
                if (this.getAllSystemOption().get("forceMakeHistory") != null) {
                    this.setSystemOption("forceMakeHistory", null);
                }
                focb.setContent(this.gosfc.getContentStream(), this.getGlobalObjectClientBeanDefinition());
            }
            rth = this.completeTransaction(rth);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            rth = this.abortTransaction(rth);
        }
        return focb;
    }

    @Override
    protected void setDefinitionFromFolder() throws Exception {
        GlobalObjectClientBeanDefinition newDef;
        if (this.gosfc.getDestinationFolder() != null && (newDef = (GlobalObjectClientBeanDefinition)this.gosfc.getDestinationFolder().getFileObjectCreateDefinition(this.gosfc.getDestinationFolder().getSessionController())) != null) {
            GlobalObjectClientBeanDefinition oldDef = this.gosfc.getGlobalObjectDefinition();
            newDef.setAllSystemOption(oldDef.getAllSystemOption());
            Hashtable attributes = oldDef.getAttributes();
            this.setGlobalObjectClientBeanDefinition(newDef);
            Enumeration enumer = attributes.elements();
            while (enumer.hasMoreElements()) {
                Hashtable singleAttr = (Hashtable)enumer.nextElement();
                Enumeration enumer2 = singleAttr.keys();
                while (enumer2.hasMoreElements()) {
                    String attrName = (String)enumer2.nextElement();
                    if (attrName.equalsIgnoreCase(GlobalObjectClientBean.CLASSID_ATTRIBUTE)) continue;
                    AttributeValue av = (AttributeValue)singleAttr.get(attrName);
                    newDef.setAttribute(attrName, av);
                }
            }
        }
    }
}

