/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.selector;

import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.BaseObject;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.selector.Selector;
import agorum.roi.selector.SelectorSetEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class SelectorSet<T> {
    private final SortedSet<SelectorSetEntry<T>> selectors = new TreeSet<SelectorSetEntry<T>>();
    private int order;

    public void add(T id, Selector selector) {
        this.selectors.add(new SelectorSetEntry<T>(id, selector, this.order++));
    }

    public T selecting(GlobalObjectClientBean object) {
        for (SelectorSetEntry selectorSetEntry : this.selectors) {
            if (!selectorSetEntry.selector.selects(object)) continue;
            return selectorSetEntry.id;
        }
        return null;
    }

    public T selecting(SessionController sessionController, BaseObject object) {
        for (SelectorSetEntry selectorSetEntry : this.selectors) {
            if (!selectorSetEntry.selector.selects(sessionController, object)) continue;
            return selectorSetEntry.id;
        }
        return null;
    }

    public List<T> allSelecting(GlobalObjectClientBean object) {
        ArrayList ids = new ArrayList();
        for (SelectorSetEntry selectorSetEntry : this.selectors) {
            if (ids.contains(selectorSetEntry.id) || !selectorSetEntry.selector.selects(object)) continue;
            ids.add(selectorSetEntry.id);
        }
        return ids;
    }

    public List<T> allSelecting(SessionController sessionController, BaseObject object) {
        ArrayList ids = new ArrayList();
        for (SelectorSetEntry selectorSetEntry : this.selectors) {
            if (ids.contains(selectorSetEntry.id) || !selectorSetEntry.selector.selects(sessionController, object)) continue;
            ids.add(selectorSetEntry.id);
        }
        return ids;
    }
}

