/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.selector;

import agorum.commons.statistic.CoreStatistic;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.selector.Phrase;

public class PhraseLower
extends Phrase {
    private static final CoreStatistic LOG = CoreStatistic.getInstance();

    public PhraseLower(String phrase) {
        super(phrase);
    }

    @Override
    protected boolean checkAttributeValue(Object checkObject, Phrase.TYPE type, String value) {
        Object objectAttributeValue = checkObject;
        if (objectAttributeValue instanceof AttributeValue) {
            objectAttributeValue = ((AttributeValue)checkObject).getObject();
        }
        try {
            if (objectAttributeValue instanceof Integer) {
                return this.compareTo((Integer)objectAttributeValue, Integer.parseInt(value));
            }
            if (objectAttributeValue instanceof Long) {
                return this.compareTo((Long)objectAttributeValue, Long.parseLong(value));
            }
            if (objectAttributeValue instanceof Double) {
                return this.compareTo((Double)objectAttributeValue, Double.parseDouble(value));
            }
            if (objectAttributeValue instanceof Float) {
                return this.compareTo((Float)objectAttributeValue, Float.valueOf(Float.parseFloat(value)));
            }
            LOG.error("Object attribute data type: " + objectAttributeValue.getClass().getName() + " is not supported for phrase \"PhraseLower>\"");
        }
        catch (NumberFormatException numberFormatException) {
            LOG.error("Numberformatexception for input string " + value + " in phrase \"PhraseLower\"");
        }
        return false;
    }

    @Override
    protected String determineComparator(boolean specialTreatment) {
        return specialTreatment ? "<=" : "<";
    }

    @Override
    protected boolean determineSpecialTreatment(String phrase) {
        return phrase.contains("<=");
    }

    private <T extends Comparable<T>> boolean compareTo(T attributeValue, T phraseValue) {
        int compareResult = attributeValue.compareTo(phraseValue);
        return this.getSpecialTreatment() ? compareResult <= 0 : compareResult < 0;
    }
}

