/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.selector;

import agorum.commons.statistic.CoreStatistic;
import agorum.roi.common.utils.Beans;
import agorum.roi.ejb.common.BaseObject;
import agorum.roi.ejb.common.SessionController;
import java.util.regex.Pattern;
import org.apache.poi.ss.formula.eval.NotImplementedException;

public class Phrase {
    private static final CoreStatistic LOG = CoreStatistic.getInstance();
    private String attribute = null;
    private String value = null;
    private String phrase = "";
    private TYPE type = null;
    private Pattern regexPattern = null;
    private boolean specialTreatment = false;

    public Phrase() {
    }

    public Phrase(String phrase) {
        this.phrase = this.preparePhrase(this.checkPhrase(phrase));
        this.specialTreatment = this.determineSpecialTreatment(phrase);
        this.determineAttributeAndValue();
    }

    public Phrase(String phrase, TYPE type) {
        this.phrase = this.preparePhrase(this.checkPhrase(phrase));
        this.type = this.checkType(type);
        this.specialTreatment = this.determineSpecialTreatment(phrase);
        this.determineAttributeAndValue();
    }

    public boolean match(SessionController sc, BaseObject baseObject) {
        Object attributeValueObject = Beans.get(sc, baseObject, this.attribute);
        if (attributeValueObject == null) {
            return false;
        }
        if (attributeValueObject instanceof Object[]) {
            for (Object current : (Object[])attributeValueObject) {
                if (!this.checkAttributeValue(current, this.type, this.value)) continue;
                return true;
            }
        } else if (attributeValueObject instanceof Iterable) {
            for (Object current : (Iterable)attributeValueObject) {
                if (!this.checkAttributeValue(current, this.type, this.value)) continue;
                return true;
            }
        } else {
            return this.checkAttributeValue(attributeValueObject, this.type, this.value);
        }
        return false;
    }

    protected String getPhrase() {
        return this.phrase;
    }

    protected boolean getSpecialTreatment() {
        return this.specialTreatment;
    }

    protected boolean checkAttributeValue(Object checkObject, TYPE type, String value) {
        throw new NotImplementedException("Please implement the method \"checkAttributeValue\" within your phrase implementation!");
    }

    protected String additionalPhrasePreparation(String phrase) {
        return phrase;
    }

    protected String determineComparator(boolean specialTreatment) {
        return null;
    }

    protected boolean determineSpecialTreatment(String phrase) {
        return false;
    }

    protected Pattern prepareRegexPattern() {
        if (this.regexPattern == null) {
            String regexString = this.value;
            int options = 0;
            if (regexString.endsWith("/")) {
                regexString = regexString.substring(1, regexString.length() - 1);
            } else if (regexString.endsWith("/i")) {
                regexString = regexString.substring(1, regexString.length() - 2);
                options = 2;
            } else {
                regexString = regexString.substring(1, regexString.length() - 2);
            }
            this.regexPattern = Pattern.compile(regexString, options);
        }
        return this.regexPattern;
    }

    private void determineAttributeAndValue() {
        if (this.attribute == null || this.value == null) {
            if (this.phrase != null && !this.phrase.isEmpty()) {
                this.attribute = this.phrase;
                String comparator = this.determineComparator(this.specialTreatment);
                if (comparator != null && !comparator.isEmpty()) {
                    int comparerIndex = this.phrase.indexOf(comparator);
                    this.attribute = this.phrase.substring(0, comparerIndex);
                    this.value = this.phrase.substring(comparerIndex + comparator.length());
                }
            } else {
                LOG.warning("Attribute and value can't be determined. Phrase not set on phrase \"PhraseAttributeEqual\"");
            }
        }
    }

    private String checkPhrase(String phrase) {
        if (phrase != null && !phrase.isEmpty()) {
            return phrase;
        }
        LOG.error("Null/empty phrase value set");
        return "";
    }

    private TYPE checkType(TYPE type) {
        if (type != null) {
            return type;
        }
        LOG.error("Null type set for phrase");
        return TYPE.STRING;
    }

    private String preparePhrase(String phrase) {
        int indexOfOpeningBracket = phrase.indexOf(91);
        int indexOfClosingBracket = phrase.lastIndexOf(93);
        if (indexOfOpeningBracket == -1 || indexOfClosingBracket == -1) {
            LOG.error("Selector malformed for phrase");
            return "";
        }
        return this.additionalPhrasePreparation(phrase.substring(indexOfOpeningBracket + 1, indexOfClosingBracket));
    }

    public static enum TYPE {
        REGEX,
        STRING;

    }
}

