/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.searchengine;

import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.SystemStatistic;
import agorum.documentservice.client.common.DefaultDocumentServiceStatisticHolder;
import agorum.documentservice.client.common.DocumentServiceStatisticHolder;
import agorum.roi.common.Startup;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.scripting.EngineContext;
import agorum.roi.searchengine.IndexHandlerInterface;
import agorum.roi.selector.Selector;
import agorum.roi.statistic.searchengine.DocumentServiceSearchEngineIndexSystemStatistic;
import agorum.roi.statistic.searchengine.IndexStatistic;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class IndexHelper {
    private static final SystemStatistic stat = IndexStatistic.getInstance();
    private static final String NO_AUTO_COMMIT = "NoAutoCommit";
    private static final String NO_REALTIME_INDEX = "NoRealtimeIndex";
    private static final String AUTHORITATIVE = "Authoritative";
    private static boolean maintenanceMode;
    private static final boolean AUTO_COMMIT_ENABLED_DEFAULT = true;
    public static boolean autoCommitEnabled;
    private static Class<?> cls;

    public static void reset() {
        cls = null;
    }

    public static void maintenanceMode(SessionController sc, boolean activate) throws Exception {
        if (!sc.isAdminEnabled()) {
            throw new Exception("This can only be done by admin");
        }
        maintenanceMode = activate;
    }

    public static boolean isInMaintenanceMode() {
        return maintenanceMode;
    }

    public static Modifier noAutoCommit() {
        return new Modifier(NO_AUTO_COMMIT);
    }

    public static Modifier noRealtimeIndex() {
        return new Modifier(NO_REALTIME_INDEX);
    }

    public static Modifier authoritative() {
        return new Modifier(AUTHORITATIVE);
    }

    public static JavaScriptHandler javaScriptHandler(SessionController sc) throws Exception {
        return new JavaScriptHandler(sc);
    }

    public static JSHandler getJSHandler() {
        return JavaScriptHandler.getHandler();
    }

    public static void disableAutoCommit() {
        Transaction.put(NO_AUTO_COMMIT, "");
    }

    public static void disableRealtimeIndex() {
        Transaction.put(NO_REALTIME_INDEX, "");
    }

    public static boolean doAutoCommit() {
        return Transaction.get(NO_AUTO_COMMIT) == null && !Modifier.active(NO_AUTO_COMMIT);
    }

    public static boolean doRealtimeIndex() {
        return Transaction.get(NO_REALTIME_INDEX) == null && !Modifier.active(NO_REALTIME_INDEX);
    }

    public static boolean isAuthoritative() {
        return Modifier.active(AUTHORITATIVE);
    }

    @Deprecated
    public static IndexHandlerInterface getIndexHandler() {
        return IndexHelper.getIndexHandler((DocumentServiceStatisticHolder)new DefaultDocumentServiceStatisticHolder());
    }

    public static IndexHandlerInterface getIndexHandlerDefault() {
        return IndexHelper.getIndexHandler((DocumentServiceStatisticHolder)new DefaultDocumentServiceStatisticHolder());
    }

    public static IndexHandlerInterface getIndexHandler(SystemStatistic stat) {
        return IndexHelper.getIndexHandler(new DocumentServiceStatisticHolder(stat));
    }

    public static IndexHandlerInterface getIndexHandler(DocumentServiceStatisticHolder statisticHolder) {
        try {
            if (statisticHolder == null) {
                statisticHolder = new DocumentServiceSearchEngineIndexSystemStatistic();
            }
            if (cls == null) {
                SessionController sc = SessionControllerAdmin.getSessionControllerAdmin("IndexHelper");
                String handler = sc.getMetaDbInstance().getString("MAIN_MODULE_MANAGEMENT/textindexservice/control/IndexHandler");
                if (handler == null) {
                    handler = "agorum.searchengine.common.IndexHandler";
                }
                cls = Class.forName(handler);
            }
            IndexHandlerInterface ihi = (IndexHandlerInterface)cls.newInstance();
            ihi.setSystemStatistic(statisticHolder);
            return ihi;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean supportsAdvancedSearch() {
        try (IndexHandlerInterface ih = IndexHelper.getIndexHandlerDefault();){
            boolean bl = ih.supportsAdvancedSearch();
            return bl;
        }
        catch (Exception e) {
            CoreStatistic.getInstance().error((Throwable)e);
            return false;
        }
    }

    public static void commit() throws IOException {
        try (IndexHandlerInterface i = IndexHelper.getIndexHandler(stat);){
            i.commit();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    static {
        autoCommitEnabled = true;
        Startup.whenUpdatesFinished(() -> {
            try {
                autoCommitEnabled = SessionControllerAdmin.get(IndexHelper.class).getMetaDbInstance().getBoolean("MAIN_MODULE_MANAGEMENT/textindexservice/control/AutoCommit", true);
            }
            catch (Exception e) {
                stat.error((Throwable)e);
            }
        });
    }

    public static class JavaScriptHandler
    implements AutoCloseable {
        private static final ThreadLocal<JSHandler> jsHandler = new ThreadLocal();

        private JavaScriptHandler(SessionController sc) throws Exception {
            JSHandler current = jsHandler.get();
            if (current == null) {
                current = new JSHandler(new EngineContext(false, sc));
                jsHandler.set(current);
                String prefix = "MAIN_MODULE_MANAGEMENT/textindexservice/control/jshandler";
                String[] handlerList = MetaDbSuperCache.listSimplePropertyBundles(sc, prefix);
                if (handlerList != null) {
                    for (String key : handlerList) {
                        ContentInterface ci;
                        Selector selector;
                        if (key.startsWith("#")) continue;
                        String handler = MetaDbSuperCache.getSimplePropertyValue(sc, prefix + "/" + key + "/Script");
                        String selectorString = MetaDbSuperCache.getSimplePropertyValue(sc, prefix + "/" + key + "/Selector");
                        Selector selector2 = selector = selectorString == null ? null : Selector.compile(selectorString);
                        if (handler == null) continue;
                        try {
                            ci = (ContentInterface)((Object)sc.findGlobalObjectByPathOrId(handler));
                        }
                        catch (Exception e) {
                            throw new Exception("Error loading script: " + handler + " (" + key + ")", e);
                        }
                        if (ci == null) {
                            throw new Exception("Script not found: " + handler + " (" + key + ")");
                        }
                        current.scripts.add(new SelectorScript(ci, selector));
                    }
                }
            }
        }

        private static JSHandler getHandler() {
            return jsHandler.get();
        }

        @Override
        public void close() {
            jsHandler.remove();
        }
    }

    public static class JSHandler {
        public final EngineContext context;
        public final List<SelectorScript> scripts = new ArrayList<SelectorScript>();

        public JSHandler(EngineContext context) {
            this.context = context;
        }
    }

    public static class SelectorScript {
        public final ContentInterface script;
        public final Selector selector;

        public SelectorScript(ContentInterface script, Selector selector) {
            this.script = script;
            this.selector = selector;
        }
    }

    public static class Modifier
    implements AutoCloseable {
        private static final ThreadLocal<List<String>> modifiers = new ThreadLocal();
        private final String key;

        private Modifier(String key) {
            this.key = key;
            List<String> current = modifiers.get();
            if (current == null) {
                current = new ArrayList<String>();
                modifiers.set(current);
            }
            current.add(key);
        }

        @Override
        public void close() {
            List<String> current = modifiers.get();
            current.remove(this.key);
            if (current.isEmpty()) {
                modifiers.remove();
            }
        }

        private static boolean active(String key) {
            List<String> current = modifiers.get();
            return current != null && current.contains(key);
        }
    }
}

