/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.searchengine;

import agorum.commons.statistic.Statistic;
import agorum.roi.common.Storage;
import agorum.roi.common.utils.InstallUtil;
import agorum.roi.ejb.common.AttributeInfo;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.exception.RoiException;
import agorum.roi.metadb.util.MetaDbUtil;
import agorum.roi.searchengine.IndexHandlerInterface;
import agorum.roi.searchengine.IndexHelper;
import agorum.roi.statistic.searchengine.IndexStatistic;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class IndexGeneration {
    private static int current;
    private static List<Runnable> callbacks;
    private static final int MAX = 1;
    private static final long STEP_SIZE = 50000L;
    private static final String GATE_QUERY = "ancestors:globalobject NOT allfields:storagebackend";
    private static final int GATE_LIMIT = 500;
    private static final String METADB_BASE = "MAIN_MODULE_MANAGEMENT/textindexservice/control/";
    private static final String METADB_GENERATION = "Generation";
    private static final String UPGRADE = "upgrade";
    private static final Statistic stat;

    public static int get() {
        return current;
    }

    public static boolean isAtLeast(int min) {
        return current >= min;
    }

    public static synchronized void whenAtLeast(int min, Runnable callback) {
        if (current < min) {
            callbacks.add(callback);
        } else {
            callback.run();
        }
    }

    private static void upgrade(SessionController sca) {
        try {
            String[] upgradeInfo = Storage.get(IndexGeneration.class).get(UPGRADE, "0").split(":");
            if (Integer.parseInt(upgradeInfo[0]) != 1) {
                IndexGeneration.upgradePhase1(sca, -1L);
                return;
            }
            switch (upgradeInfo[1]) {
                case "1": {
                    IndexGeneration.upgradePhase1(sca, Long.parseLong(upgradeInfo[2]));
                    break;
                }
                case "2": {
                    IndexGeneration.upgradePhase2(sca);
                }
            }
        }
        catch (Exception e) {
            stat.error().sticky(IndexGeneration.class.getName()).exception((Throwable)e).send("Index generation upgrade (" + current + " -> " + 1 + ") failed");
        }
    }

    private static void upgradePhase1(SessionController sca, long firstId) throws Exception {
        Storage s = Storage.get(IndexGeneration.class);
        stat.info("Starting upgrade phase 1");
        try (Connection conn = new ConnectionUtils().getConnection();){
            if (firstId < 0L) {
                try (PreparedStatement ps = conn.prepareStatement("select max(id) from globalobject");
                     ResultSet rSet = ps.executeQuery();){
                    if (rSet.next()) {
                        firstId = rSet.getLong(1);
                    }
                }
            }
            long nextSnapshot = 0L;
            block49: for (long startId = firstId; startId > 0L; startId -= 50000L) {
                if (System.currentTimeMillis() > nextSnapshot) {
                    try (Transaction t = new Transaction();){
                        IndexHelper.disableRealtimeIndex();
                        s.put(UPGRADE, "1:1:" + startId);
                        t.commit();
                    }
                    nextSnapshot = System.currentTimeMillis() + 10000L;
                }
                long endId = Math.max(0L, startId - 50000L);
                while (true) {
                    try (PreparedStatement ps = conn.prepareStatement("insert into totextindex2 (id) select id from globalobject where id > ? and id <= ?");){
                        stat.info("Re-indexing IDs " + startId + " to " + endId);
                        ps.setLong(1, endId);
                        ps.setLong(2, startId);
                        ps.execute();
                        stat.clearStickyLogEntry(IndexGeneration.class.getName() + "_ON_HOLD");
                        continue block49;
                    }
                    catch (Exception e) {
                        stat.warning((Throwable)e);
                        stat.warning().sticky(IndexGeneration.class.getName() + "_ON_HOLD").exception((Throwable)e).send("Index generation upgrade (" + current + " -> " + 1 + ") on hold");
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (Exception e2) {
                            stat.warning((Throwable)e2);
                        }
                        continue;
                    }
                    break;
                }
            }
        }
        s.put(UPGRADE, "1:2");
        IndexGeneration.upgradePhase2(sca);
    }

    private static void upgradePhase2(SessionController sca) throws InterruptedException {
        stat.info("Starting upgrade phase 2");
        while (true) {
            block15: {
                try {
                    sca.reconnectIfNeeded();
                    if (!IndexGeneration.isPhase2Done(sca)) break block15;
                    current = 1;
                    try (MetaDbUtil mdu = new MetaDbUtil(sca, METADB_BASE);){
                        mdu.setInt(METADB_GENERATION, current);
                        mdu.commit();
                    }
                    Storage.get(IndexGeneration.class).clear();
                    stat.info("Index upgraded to generation " + current + ", running " + callbacks.size() + " callbacks");
                    callbacks.stream().forEach(c -> c.run());
                    return;
                }
                catch (Exception e) {
                    stat.warning((Throwable)e);
                }
            }
            Thread.sleep(3600000L);
        }
    }

    private static boolean isPhase2Done(SessionController sca) throws Exception {
        try (IndexHandlerInterface ih = IndexHelper.getIndexHandlerDefault();){
            List<Object> leftOver;
            if (ih.supportsAdvancedSearch()) {
                leftOver = sca.prepareAdvancedSearch((String)GATE_QUERY).rows((int)500).search((String[])new String[]{"id", "uuid"}).rows;
                if (leftOver.isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
                List<String> toRemove = leftOver.stream().map(row -> (String)((AttributeInfo)row.get((Object)"uuid")).value).filter(uuid -> {
                    try {
                        if (sca.getGlobalObjectByUUID((String)uuid) == null) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        stat.warning((Throwable)e);
                    }
                    return false;
                }).collect(Collectors.toList());
                if (!toRemove.isEmpty()) {
                    ih.openForIndexing(null);
                    ih.deleteByUuid(toRemove);
                    ih.commit();
                    stat.info("Removed " + toRemove.size() + " stale objects from the index");
                }
            } else {
                leftOver = sca.search(GATE_QUERY, 500);
                if (leftOver.isEmpty()) {
                    boolean toRemove = true;
                    return toRemove;
                }
                long removedCount = leftOver.stream().map(Long::valueOf).filter(id -> {
                    try {
                        sca.getGlobalObjectById((Long)id);
                    }
                    catch (Exception e) {
                        if (e instanceof RoiException && ((RoiException)e).getErrorCode() == 101) {
                            return true;
                        }
                        stat.warning((Throwable)e);
                    }
                    return false;
                }).peek(id -> {
                    try {
                        ih.preIndex("deleteObjectListener", (Long)id, null);
                    }
                    catch (Exception e) {
                        stat.error((Throwable)e);
                    }
                }).count();
                if (removedCount > 0L) {
                    stat.info("Removed " + removedCount + " stale objects from the index");
                }
            }
        }
        return false;
    }

    static {
        callbacks = new ArrayList<Runnable>();
        stat = IndexStatistic.getInstance();
        SessionController sca = SessionControllerAdmin.getService(IndexGeneration.class);
        current = sca.getMetaDbInstance().getInt("MAIN_MODULE_MANAGEMENT/textindexservice/control/Generation", -1);
        if (current < 0) {
            current = InstallUtil.isFirstRun() ? 1 : 0;
            stat.info("Detected index generation " + current);
            try (MetaDbUtil mdu = new MetaDbUtil(sca, METADB_BASE);){
                mdu.setInt(METADB_GENERATION, current);
                mdu.commit();
            }
        }
        if (current < 1) {
            stat.info("Upgrading index from generation " + current + " to " + 1);
            new Thread(() -> IndexGeneration.upgrade(sca)).start();
        }
    }
}

