/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.scripting;

import agorum.commons.utils.TimestampedHolder;
import agorum.roi.ejb.common.ContentInterface;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Cache<T>
implements Iterable<T> {
    private final Map<Long, TimestampedHolder<T>> cache = new ConcurrentHashMap<Long, TimestampedHolder<T>>();
    private final ThreadLocal<Set<Long>> accessSet = new ThreadLocal<Set<Long>>(){

        @Override
        protected Set<Long> initialValue() {
            return new HashSet<Long>();
        }
    };

    public T get(ContentInterface ci) throws Exception {
        Long id = ci.getId();
        TimestampedHolder<T> cacheEntry = this.cache.get(id);
        if (cacheEntry != null && cacheEntry.timestamp.equals(ci.getLastContentModifyDate())) {
            this.accessSet.get().add(id);
            return (T)cacheEntry.value;
        }
        return null;
    }

    public T put(ContentInterface ci, Producer<T> producer) throws Exception {
        Long id = ci.getId();
        Date timestamp = ci.getLastContentModifyDate();
        T value = producer.produce();
        this.cache.put(id, new TimestampedHolder(timestamp, value));
        this.accessSet.get().add(id);
        return value;
    }

    public void preparePurge() {
        this.accessSet.get().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Set<Long> myAccessSet = this.accessSet.get();
        Map<Long, TimestampedHolder<T>> map = this.cache;
        synchronized (map) {
            Iterator<Long> iter = this.cache.keySet().iterator();
            while (iter.hasNext()) {
                Long id = iter.next();
                if (myAccessSet.contains(id)) continue;
                iter.remove();
            }
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new CacheIterator();
    }

    private class CacheIterator
    implements Iterator<T> {
        private final Iterator<TimestampedHolder<T>> innerIterator;

        protected CacheIterator() {
            this.innerIterator = Cache.this.cache.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.innerIterator.hasNext();
        }

        @Override
        public T next() {
            return this.innerIterator.next().value;
        }

        @Override
        public void remove() {
            this.innerIterator.remove();
        }
    }

    public static interface Producer<T> {
        public T produce() throws Exception;
    }
}

