/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.pdf;

import agorum.commons.RewindableInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.varia.NullAppender;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessBuffer;
import org.apache.pdfbox.pdfparser.NonSequentialPDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;

public class PdfLoader {
    private static final ThreadLocal<String> lastError = new ThreadLocal();

    public static PDDocument load(InputStream is) throws IOException {
        RewindableInputStream rs = new RewindableInputStream(is);
        IOException suppressed = null;
        try {
            lastError.remove();
            try {
                PDDocument doc = PDDocument.loadNonSeq((InputStream)rs, (RandomAccess)new RandomAccessBuffer());
                if (lastError.get() == null) {
                    PDDocument pDDocument = doc;
                    return pDDocument;
                }
            }
            catch (IOException e) {
                suppressed = e;
            }
            rs.rewind();
            PDDocument e = PDDocument.load((InputStream)rs);
            return e;
        }
        catch (IOException e) {
            e.addSuppressed(suppressed);
            throw e;
        }
        finally {
            lastError.remove();
            rs.doClose();
        }
    }

    static {
        Logger.getLogger(NonSequentialPDFParser.class).addAppender((Appender)new NullAppender(){

            public void doAppend(LoggingEvent e) {
                if (e.getLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
                    lastError.set(e.getMessage() == null ? "null" : e.getMessage().toString());
                }
            }
        });
    }
}

