/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.parser.mail;

import agorum.commons.string.ByteBuffer;
import agorum.commons.string.Encoding;
import agorum.commons.string.StringConverterUtils;
import agorum.commons.utils.MapBuilder;
import agorum.roi.parser.mail.internet.MsgMimeMessage;
import agorum.roi.parser.mail.rtf.Rtf2Html;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.poi.hsmf.MAPIMessage;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.RecipientChunks;
import org.apache.poi.hsmf.datatypes.StringChunk;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.EntryUtils;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.StringUtil;

public class MsgParser {
    private final Vector<File> tmpFilePool = new Vector();
    private static long globalCounter = 0L;
    public static boolean debug = false;
    private static final String COMPRESSED_RTF_HEADER = "{\\rtf1\\ansi\\mac\\deff0\\deftab720{\\fonttbl;}{\\f0\\fnil \\froman \\fswiss \\fmodern \\fscript \\fdecor MS Sans SerifSymbolArialTimes New RomanCourier{\\colortbl\\red0\\green0\\blue0\n\r\\par \\pard\\plain\\f0\\fs20\\b\\i\\u\\tab\\tx";
    private static final byte[] RTF_LINE = new byte[]{92, 108, 105, 110, 101};
    private static final byte[] RTF_PAR = new byte[]{92, 112, 97, 114};
    private static final byte[] RTF_FROMHTML = new byte[]{92, 102, 114, 111, 109, 104, 116, 109, 108};
    private static final byte[] RTF_ANSICPG = new byte[]{92, 97, 110, 115, 105, 99, 112, 103};
    private static final Map<String, Integer> FROM_ADDRESS_FIELD = new MapBuilder().add((Object)"0C1F", (Object)0).add((Object)"5D01", (Object)1).add((Object)"5D02", (Object)2).add((Object)"5D0A", (Object)3).add((Object)"0042", (Object)4).add((Object)"5D0B", (Object)5).build();
    private static final int[] CRC32_TABLE = new int[256];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String parse(InputStream is) {
        MsgMimeMessage mimeMessage = null;
        String mimeString = null;
        ByteArrayOutputStream contentOutput = null;
        try {
            Properties props = System.getProperties();
            Session session = Session.getInstance((Properties)props, null);
            session.setDebug(false);
            POIFSFileSystem fs = new POIFSFileSystem(is);
            mimeMessage = this.parseMsgRecursive(fs, (DirectoryEntry)fs.getRoot(), session, false);
            mimeMessage.saveChanges();
            contentOutput = new ByteArrayOutputStream();
            mimeMessage.writeTo(contentOutput);
            contentOutput.close();
            mimeString = new String(contentOutput.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            int len = this.tmpFilePool.size();
            for (int i = 0; i < len; ++i) {
                try {
                    File f = this.tmpFilePool.elementAt(i);
                    f.delete();
                    continue;
                }
                catch (Exception exception) {}
            }
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return mimeString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File parseAsTmpFile(InputStream is) {
        File tmpFile = null;
        FileOutputStream fos = null;
        try {
            Properties props = System.getProperties();
            Session session = Session.getInstance((Properties)props, null);
            session.setDebug(false);
            POIFSFileSystem fs = new POIFSFileSystem(is);
            MsgMimeMessage mimeMessage = this.parseMsgRecursive(fs, (DirectoryEntry)fs.getRoot(), session, false);
            mimeMessage.saveChanges();
            tmpFile = new File("tmpmail_" + System.currentTimeMillis() + "_" + MsgParser.getCounter());
            fos = new FileOutputStream(tmpFile);
            mimeMessage.writeTo(fos);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            int len = this.tmpFilePool.size();
            for (int i = 0; i < len; ++i) {
                try {
                    File f = this.tmpFilePool.elementAt(i);
                    f.delete();
                    continue;
                }
                catch (Exception exception) {}
            }
            try {
                fos.close();
            }
            catch (Exception exception) {}
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return tmpFile;
    }

    private MsgMimeMessage parseMsgRecursive(POIFSFileSystem fs, DirectoryEntry dir, Session session, boolean requireContent) throws Exception {
        ArrayList<InternetAddress> correctBccAddresses;
        ArrayList<InternetAddress> correctCcAddresses;
        RecipientChunks[] recps;
        String subject = null;
        String header = null;
        String messageId = null;
        String fromAddress = null;
        int fromAddressPriority = Integer.MAX_VALUE;
        String toAddress = null;
        String ccAddress = null;
        String bccAddress = null;
        String inReplyTo = null;
        Hashtable<String, String> addressContainer = new Hashtable<String, String>();
        MimeMultipart multiPart = null;
        MAPIMessage mapiMsg = new MAPIMessage(fs);
        mapiMsg.setReturnNullOnMissingChunk(true);
        Date date = null;
        if (mapiMsg.getMessageDate() != null) {
            date = mapiMsg.getMessageDate().getTime();
        }
        ArrayList<MimeBodyPart> bodyPartsHtml = new ArrayList<MimeBodyPart>();
        ArrayList<MimeBodyPart> bodyPartsText = new ArrayList<MimeBodyPart>();
        ArrayList<MimeBodyPart> bodyPartsRTF = new ArrayList<MimeBodyPart>();
        Iterator iter = dir.getEntries();
        while (iter.hasNext()) {
            DocumentEntry docEntry;
            Entry entry = (Entry)iter.next();
            if (entry.isDirectoryEntry()) {
                MimeBodyPart attaBodyPart;
                if (entry.getName().startsWith("__recip_version1.0_")) {
                    this.parseRecipients((DirectoryEntry)entry, addressContainer);
                    continue;
                }
                if (!entry.getName().startsWith("__attach_version1.0_") || (attaBodyPart = this.parseAttachmentFolder((DirectoryEntry)entry, session)) == null) continue;
                if (multiPart == null) {
                    multiPart = new MimeMultipart();
                }
                multiPart.addBodyPart((BodyPart)attaBodyPart);
                continue;
            }
            if (!entry.isDocumentEntry() || (docEntry = (DocumentEntry)entry).getName().length() < 8) continue;
            String info = docEntry.getName().substring(docEntry.getName().length() - 8).toUpperCase();
            String docProperty = info.substring(0, 4);
            String docEncoding = info.substring(4);
            if (docProperty.equals("0037")) {
                subject = mapiMsg.getSubject();
                subject = subject.trim();
                if (!debug) continue;
                MsgParser.debug("subject: " + subject);
                continue;
            }
            if (FROM_ADDRESS_FIELD.containsKey(docProperty)) {
                String string;
                int priority = FROM_ADDRESS_FIELD.get(docProperty);
                if (priority >= fromAddressPriority || !(string = (String)this.parseValue(docEntry, docEncoding)).contains("@")) continue;
                fromAddress = string.trim();
                fromAddressPriority = priority;
                if (!debug) continue;
                MsgParser.debug("fromAddress: " + fromAddress + " (" + docProperty + ")");
                continue;
            }
            if (docProperty.equals("1042")) {
                try {
                    inReplyTo = (String)this.parseValue(docEntry, docEncoding);
                }
                catch (Exception priority) {}
                continue;
            }
            if (docProperty.equals("007D")) {
                header = (String)this.parseValue(docEntry, docEncoding);
                continue;
            }
            if (docProperty.equals("0E02")) {
                bccAddress = (String)this.parseValue(docEntry, docEncoding);
                bccAddress = bccAddress.trim();
                continue;
            }
            if (docProperty.equals("0E03")) {
                ccAddress = (String)this.parseValue(docEntry, docEncoding);
                ccAddress = ccAddress.trim();
                continue;
            }
            if (docProperty.equals("0E04")) {
                toAddress = (String)this.parseValue(docEntry, docEncoding);
                toAddress = toAddress.trim();
                if (!debug) continue;
                MsgParser.debug("toAddress: " + toAddress);
                continue;
            }
            if (docProperty.equals("1000")) {
                String body = (String)this.parseValue(docEntry, docEncoding);
                if (body == null || body.length() <= 0) continue;
                if (debug) {
                    MsgParser.debug("PART: body text");
                }
                if (multiPart == null) {
                    multiPart = new MimeMultipart();
                }
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setText(body, "UTF-8");
                bodyPartsText.add(mimeBodyPart);
                if (!debug) continue;
                MsgParser.debug("body: " + body);
                continue;
            }
            if (docProperty.equals("1009")) {
                Charset sourceEncoding;
                byte[] rtf = (byte[])this.parseValue(docEntry, docEncoding);
                RtfInfo rtfInfo = this.parseRTF(rtf);
                Charset charset = sourceEncoding = rtfInfo.codePage < 0 ? StandardCharsets.UTF_8 : Encoding.codePageToEncoding((int)rtfInfo.codePage);
                String body = Encoding.getHtmlWithEncoding((byte[])rtfInfo.data, (Charset)sourceEncoding, null);
                if (body.length() <= 0) continue;
                if (multiPart == null) {
                    multiPart = new MimeMultipart();
                }
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setContent((Object)body, "text/html; charset=" + Encoding.DEFAULT_CHARSET.name());
                bodyPartsRTF.add(bodyPart);
                continue;
            }
            if (docProperty.equals("1013")) {
                byte[] bytes = StringConverterUtils.toByteArray((InputStream)new DocumentInputStream(docEntry));
                if (bytes.length <= 0) continue;
                String string = Encoding.getHtmlWithEncoding((byte[])bytes, null, null);
                if (multiPart == null) {
                    multiPart = new MimeMultipart();
                }
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setContent((Object)string, "text/html; charset=" + Encoding.DEFAULT_CHARSET.name());
                bodyPartsHtml.add(bodyPart);
                continue;
            }
            if (docProperty.equals("1035")) {
                messageId = (String)this.parseValue(docEntry, docEncoding);
                messageId = messageId.trim();
                continue;
            }
            if (!debug) continue;
            MsgParser.debug("unsupported: " + docProperty + "/" + docEncoding + ": " + this.parseValue(docEntry, docEncoding));
        }
        MsgMimeMessage message = new MsgMimeMessage(session);
        if (header != null) {
            InternetHeaders ih = new InternetHeaders(StringConverterUtils.toStream((String)(header + "\r\n"), (Charset)StandardCharsets.ISO_8859_1));
            Enumeration headerEnum = ih.getAllHeaderLines();
            while (headerEnum.hasMoreElements()) {
                String headerLine = (String)headerEnum.nextElement();
                String hl = headerLine.toLowerCase();
                if (hl.startsWith("to: ") || hl.startsWith("cc: ") || hl.startsWith("bcc: ") || hl.startsWith("from: ")) continue;
                message.addHeaderLine(headerLine);
            }
        }
        if (messageId != null) {
            message.setMessageID(messageId);
        }
        if (subject != null) {
            message.setSubject(subject);
        }
        if (inReplyTo != null) {
            message.setHeader("In-Reply-To", inReplyTo);
        }
        InternetAddress addr = null;
        if (fromAddress != null && fromAddress.indexOf("@") != -1) {
            addr = new InternetAddress(fromAddress, mapiMsg.getDisplayFrom());
        } else {
            String dFrom = mapiMsg.getDisplayFrom();
            if (debug) {
                MsgParser.debug("Fromaddress (mapi): " + dFrom);
            }
            addr = new InternetAddress("", dFrom);
        }
        if (debug) {
            MsgParser.debug("Fromaddress: " + fromAddress + " -> " + addr + ", " + addr.getPersonal());
        }
        message.setFrom((Address)addr);
        String[] repList = null;
        try {
            repList = mapiMsg.getRecipientEmailAddressList();
        }
        catch (Exception headerLine) {
            // empty catch block
        }
        String[] nameList = null;
        try {
            nameList = mapiMsg.getRecipientNamesList();
        }
        catch (Exception hl) {
            // empty catch block
        }
        String toName = mapiMsg.getDisplayTo();
        HashMap<String, String> mailAdrMapping = new HashMap<String, String>();
        for (RecipientChunks chunks : recps = mapiMsg.getRecipientDetailsChunks()) {
            Chunk[] allChunks = chunks.getAll();
            String mailAddress = null;
            String cnName = null;
            for (Chunk chunk : allChunks) {
                if (!(chunk instanceof StringChunk)) continue;
                StringChunk stringChunk = (StringChunk)chunk;
                String ls = stringChunk.getValue().toLowerCase();
                if (ls.indexOf("/cn=") != -1) {
                    cnName = ls;
                    continue;
                }
                if (ls.indexOf("@") == -1) continue;
                mailAddress = ls;
            }
            if (cnName == null || mailAddress == null) continue;
            mailAdrMapping.put(cnName, mailAddress);
            if (!debug) continue;
            MsgParser.debug("adr mapping: " + cnName + " = " + mailAddress);
        }
        ArrayList<InternetAddress> arrayList = this.getToAddresses(mailAdrMapping, repList, nameList, toName);
        if (arrayList != null) {
            int len = arrayList.size();
            InternetAddress[] addrs = new InternetAddress[len];
            for (int i = 0; i < len; ++i) {
                addrs[i] = arrayList.get(i);
            }
            message.addRecipients(Message.RecipientType.TO, (Address[])addrs);
        }
        if ((correctCcAddresses = this.getToAddresses(mailAdrMapping, repList, nameList, mapiMsg.getDisplayCC())) != null) {
            int len = correctCcAddresses.size();
            InternetAddress[] addrs = new InternetAddress[len];
            for (int i = 0; i < len; ++i) {
                addrs[i] = correctCcAddresses.get(i);
            }
            message.addRecipients(Message.RecipientType.CC, (Address[])addrs);
        }
        if ((correctBccAddresses = this.getToAddresses(mailAdrMapping, repList, nameList, mapiMsg.getDisplayBCC())) != null) {
            int len = correctBccAddresses.size();
            InternetAddress[] addrs = new InternetAddress[len];
            for (int i = 0; i < len; ++i) {
                addrs[i] = correctBccAddresses.get(i);
            }
            message.addRecipients(Message.RecipientType.BCC, (Address[])addrs);
        }
        if (date != null) {
            message.setSentDate(date);
        }
        if (multiPart == null) {
            if (requireContent) {
                return null;
            }
            message.setText("");
        } else {
            if (bodyPartsHtml.size() == 0) {
                for (MimeBodyPart bodyPart : bodyPartsRTF) {
                    multiPart.addBodyPart((BodyPart)bodyPart);
                }
            }
            for (MimeBodyPart bodyPart : bodyPartsHtml) {
                multiPart.addBodyPart((BodyPart)bodyPart);
            }
            for (MimeBodyPart bodyPart : bodyPartsText) {
                multiPart.addBodyPart((BodyPart)bodyPart);
            }
            message.setContent((Multipart)multiPart);
        }
        return message;
    }

    private String replaceColons(String name) {
        if (name.startsWith("'") && name.endsWith("'") || name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1);
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    protected ArrayList<InternetAddress> getToAddresses(Map<String, String> adrMapping, String[] repList, String[] nameList, String names) throws Exception {
        String before;
        int i;
        if (names == null || names.length() == 0) {
            return null;
        }
        ArrayList<InternetAddress> ret = new ArrayList<InternetAddress>();
        String[] nameArr = names.split(";\\s*");
        for (i = 0; i < nameArr.length; ++i) {
            before = nameArr[i];
            nameArr[i] = this.replaceColons(nameArr[i]);
            if (!debug) continue;
            MsgParser.debug("adr-name: " + before + " -> " + nameArr[i]);
        }
        for (i = 0; i < nameList.length; ++i) {
            before = nameList[i];
            nameList[i] = this.replaceColons(nameList[i]);
            if (!debug) continue;
            MsgParser.debug("adr-list: " + before + " -> " + nameList[i]);
        }
        for (String name : nameArr) {
            boolean found = false;
            if (nameList != null && repList != null && nameList.length == repList.length) {
                for (int i2 = 0; i2 < nameList.length; ++i2) {
                    String nameCmp = nameList[i2];
                    String adr = repList[i2];
                    if (adr != null && adr.indexOf("@") == -1 && adrMapping != null) {
                        adr = adr.toLowerCase();
                        for (Map.Entry<String, String> adrEntry : adrMapping.entrySet()) {
                            if (adrEntry.getKey().indexOf(adr) == -1) continue;
                            if (debug) {
                                MsgParser.debug("mapping: " + adr + " -> " + adrEntry.getKey() + "/" + adrEntry.getValue());
                            }
                            adr = adrEntry.getValue();
                            break;
                        }
                    }
                    if (!nameCmp.equals(name) || adr == null) continue;
                    found = true;
                    if (nameCmp.indexOf("@") != -1) {
                        nameCmp = "";
                    }
                    if (debug) {
                        MsgParser.debug("found: " + adr + ", " + nameCmp);
                    }
                    ret.add(new InternetAddress(adr, nameCmp));
                    break;
                }
            }
            if (found) continue;
            if (debug) {
                MsgParser.debug("!found: " + name);
            }
            ret.add(new InternetAddress("", this.replaceColons(name)));
        }
        return ret;
    }

    protected void handleEmails(StringBuffer s, String type, String displayText, StringUtil.StringsIterator emails) {
        if (displayText == null || displayText.length() == 0) {
            return;
        }
        String[] names = displayText.split(";\\s*");
        boolean first = true;
        s.append(type + ": ");
        for (String name : names) {
            String email;
            if (first) {
                first = false;
            } else {
                s.append("; ");
            }
            s.append(name);
            if (!emails.hasNext() || (email = emails.next()).equals(name)) continue;
            s.append(" <" + email + ">");
        }
        s.append("\n");
    }

    private void parseRecipients(DirectoryEntry dir, Hashtable<String, String> addressContainer) throws Exception {
        String name = null;
        String address = null;
        Iterator iter = dir.getEntries();
        while (iter.hasNext()) {
            Entry entry = (Entry)iter.next();
            String info = entry.getName().substring(entry.getName().length() - 8).toUpperCase();
            String docProperty = info.substring(0, 4);
            String docEncoding = info.substring(4);
            if (docProperty.equals("3001")) {
                name = (String)this.parseValue((DocumentEntry)entry, docEncoding);
                if (name.indexOf("@") != -1 && address == null) {
                    address = name;
                }
                name = name.trim();
                continue;
            }
            if (docProperty.equals("3002") || docProperty.equals("403D") || !docProperty.equals("3003") && !docProperty.equals("403E")) continue;
            address = (String)this.parseValue((DocumentEntry)entry, docEncoding);
            address = address.trim();
        }
        if (name == null) {
            name = address;
        }
        if (address != null) {
            addressContainer.put(name, address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimeBodyPart parseAttachmentFolder(DirectoryEntry dir, Session session) throws Exception {
        MimeBodyPart attaBodyPart;
        block20: {
            attaBodyPart = null;
            String fileName = null;
            String extension = null;
            String contentType = null;
            String contentId = null;
            try (InputStream contentStream = null;){
                Iterator iter = dir.getEntries();
                while (iter.hasNext()) {
                    Entry entry = (Entry)iter.next();
                    String info = entry.getName().substring(entry.getName().length() - 8).toUpperCase();
                    String docProperty = info.substring(0, 4);
                    String docEncoding = info.substring(4);
                    if (docProperty.equals("3703")) {
                        extension = (String)this.parseValue((DocumentEntry)entry, docEncoding);
                        extension = extension.trim();
                        continue;
                    }
                    if (docProperty.equals("3704")) {
                        if (fileName != null) continue;
                        fileName = (String)this.parseValue((DocumentEntry)entry, docEncoding);
                        fileName = fileName.trim();
                        continue;
                    }
                    if (docProperty.equals("3707")) {
                        fileName = (String)this.parseValue((DocumentEntry)entry, docEncoding);
                        fileName = fileName.trim();
                        continue;
                    }
                    if (docProperty.equals("370E")) {
                        contentType = (String)this.parseValue((DocumentEntry)entry, docEncoding);
                        contentType = contentType.trim();
                        continue;
                    }
                    if (docProperty.equals("3712")) {
                        contentId = (String)this.parseValue((DocumentEntry)entry, docEncoding);
                        contentId = contentId.trim();
                        continue;
                    }
                    if (!docProperty.equals("3701")) continue;
                    if (entry instanceof DirectoryEntry) {
                        POIFSFileSystem newDoc = new POIFSFileSystem();
                        EntryUtils.copyNodes((DirectoryEntry)((DirectoryEntry)entry), (DirectoryEntry)newDoc.getRoot());
                        MsgMimeMessage mailMessage = this.parseMsgRecursive(newDoc, (DirectoryEntry)entry, session, true);
                        if (mailMessage == null) {
                            MimeBodyPart mimeBodyPart = null;
                            return mimeBodyPart;
                        }
                        attaBodyPart = new MimeBodyPart();
                        mailMessage.saveChanges();
                        attaBodyPart.setContent((Object)mailMessage, "message/rfc822");
                        break;
                    }
                    contentStream = new DocumentInputStream((DocumentEntry)entry);
                }
                if (fileName == null && contentType != null && contentType.toLowerCase().indexOf("signed") != -1) {
                    fileName = "unknown_signed";
                }
                if (attaBodyPart != null || fileName == null) break block20;
                if (debug) {
                    MsgParser.debug("attachment: " + fileName + ", " + contentType);
                }
                File tmpAtta = null;
                try (FileOutputStream fos = null;){
                    int read;
                    tmpAtta = new File("tmp_mail_atta_" + System.currentTimeMillis() + "_" + MsgParser.getCounter());
                    fos = new FileOutputStream(tmpAtta);
                    byte[] buffer = new byte[1024];
                    while ((read = contentStream.read(buffer)) >= 0) {
                        fos.write(buffer, 0, read);
                    }
                }
                if (tmpAtta != null) {
                    attaBodyPart = new MimeBodyPart();
                    FileDataSource fds = new FileDataSource(tmpAtta.getAbsolutePath());
                    attaBodyPart.setDataHandler(new DataHandler((DataSource)fds));
                    attaBodyPart.setFileName(MimeUtility.encodeWord((String)fileName, (String)"UTF-8", null));
                    attaBodyPart.setHeader("Content-Type", contentType);
                    attaBodyPart.setContentID(contentId);
                    this.tmpFilePool.addElement(tmpAtta);
                }
            }
        }
        return attaBodyPart;
    }

    private RtfInfo parseRTF(byte[] in) throws Exception {
        if (debug) {
            MsgParser.debug("parseRTF");
        }
        RtfInfo result = new RtfInfo();
        int posIn = 0;
        int posOut = 0;
        if (in != null && in.length > 15) {
            int size = (int)this.convertByteArrayToInt32(in, posIn);
            int rawSize = (int)this.convertByteArrayToInt32(in, posIn += 4);
            int magic = (int)this.convertByteArrayToInt32(in, posIn += 4);
            int crc = (int)this.convertByteArrayToInt32(in, posIn += 4);
            posIn += 4;
            if (size != in.length - 4) {
                return null;
            }
            if (crc != MsgParser.calculateCRC32(in, 16, in.length - 16)) {
                return null;
            }
            if (magic == 1095517517) {
                RtfInfo.access$102(result, new byte[rawSize]);
                System.arraycopy(in, posIn, result.data, posOut, rawSize);
            } else if (magic == 1967544908) {
                RtfInfo.access$102(result, new byte[COMPRESSED_RTF_HEADER.length() + rawSize]);
                System.arraycopy(COMPRESSED_RTF_HEADER.getBytes("US-ASCII"), 0, result.data, 0, COMPRESSED_RTF_HEADER.length());
                posOut = COMPRESSED_RTF_HEADER.length();
                int flagCount = 0;
                int flags = 0;
                while (posOut < result.data.length) {
                    flags = flagCount++ % 8 == 0 ? this.convertByteArrayToInt8(in, posIn++) : (flags >>= 1);
                    if ((flags & 1) == 1) {
                        int offset = this.convertByteArrayToInt8(in, posIn++);
                        int length = this.convertByteArrayToInt8(in, posIn++);
                        offset = offset << 4 | length >>> 4;
                        length = (length & 0xF) + 2;
                        if ((offset = posOut / 4096 * 4096 + offset) >= posOut) {
                            offset -= 4096;
                        }
                        int end = offset + length;
                        while (offset < end) {
                            ((RtfInfo)result).data[posOut++] = result.data[offset++];
                        }
                        continue;
                    }
                    ((RtfInfo)result).data[posOut++] = in[posIn++];
                }
                in = result.data;
                RtfInfo.access$102(result, new byte[rawSize]);
                System.arraycopy(in, COMPRESSED_RTF_HEADER.length(), result.data, 0, rawSize);
            }
            if (result.data != null && result.data.length > 0) {
                ByteBuffer byteBuffer = new ByteBuffer(result.data);
                if (this.isRtfHtml(byteBuffer)) {
                    result.codePage = -1;
                    RtfInfo.access$102(result, Rtf2Html.rtf2html(new String(result.data, StandardCharsets.US_ASCII)).getBytes(StandardCharsets.UTF_8));
                } else {
                    result.codePage = this.getRtfEncoding(byteBuffer);
                    byteBuffer = byteBuffer.replace(RTF_LINE, RTF_PAR);
                    try {
                        RTFEditorKit rtfKit = new RTFEditorKit();
                        Document doc = rtfKit.createDefaultDocument();
                        rtfKit.read(new ByteArrayInputStream(byteBuffer.toByteArray()), doc, 0);
                        ByteArrayOutputStream writer = new ByteArrayOutputStream();
                        HTMLEditorKit htmlKit = new HTMLEditorKit();
                        htmlKit.write(writer, doc, 0, doc.getLength());
                        RtfInfo.access$102(result, writer.toByteArray());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object parseValue(DocumentEntry docEntry, String encoding) throws Exception {
        Object value = null;
        if (encoding != null && encoding.length() == 4) {
            DocumentInputStream docIs = null;
            try {
                docIs = new DocumentInputStream(docEntry);
                if (encoding.equals("001E")) {
                    value = StringConverterUtils.toString((InputStream)docIs, (String)"cp1252");
                } else if (encoding.equals("001F")) {
                    value = StringConverterUtils.toString((InputStream)docIs, (String)"UTF-16LE");
                } else if (encoding.equals("0102")) {
                    value = StringConverterUtils.toByteArray((InputStream)docIs);
                }
            }
            finally {
                try {
                    docIs.close();
                }
                catch (Exception exception) {}
            }
        }
        return value;
    }

    private int convertByteArrayToInt8(byte[] bytes, int pos) {
        return bytes[pos] & 0xFF;
    }

    private long convertByteArrayToInt32(byte[] bytes, int pos) {
        return (long)(bytes[pos] & 0xFF | (bytes[pos + 1] & 0xFF) << 8 | (bytes[pos + 2] & 0xFF) << 16 | (bytes[pos + 3] & 0xFF) << 24) & 0xFFFFFFFFL;
    }

    private boolean isRtfHtml(ByteBuffer body) {
        return body.indexOf(0, RTF_FROMHTML) != -1;
    }

    private int getRtfEncoding(ByteBuffer rtf) {
        int codepage = 1252;
        int pos = rtf.indexOf(0, RTF_ANSICPG);
        if (pos >= 0) {
            codepage = rtf.readNumber(pos + 8);
        }
        return codepage;
    }

    private static int calculateCRC32(byte[] buffer, int offset, int len) {
        int crc = 0;
        int end = offset + len;
        for (int i = offset; i < end; ++i) {
            crc = CRC32_TABLE[(crc ^ buffer[i]) & 0xFF] ^ crc >>> 8;
        }
        return crc;
    }

    private static synchronized long getCounter() {
        return ++globalCounter;
    }

    private static void debug(String msg) {
        System.out.println("\n" + msg);
    }

    public static void main(String[] args) {
        debug = true;
        try {
            File[] mails;
            File dir = new File("c:\\temp\\mails\\msg3");
            File outDir = new File("c:\\temp\\mails\\msg3");
            for (File mail : mails = dir.listFiles()) {
                if (!mail.getName().toLowerCase().endsWith(".msg")) continue;
                System.out.println("Parsing: " + mail.getAbsolutePath());
                MsgParser msgParser = new MsgParser();
                try (FileInputStream fis = new FileInputStream(mail);){
                    String mimeMessage = msgParser.parse(fis);
                    try (FileOutputStream fos = new FileOutputStream(outDir.getAbsolutePath() + "/" + mail.getName() + ".eml");){
                        fos.write(mimeMessage.getBytes());
                    }
                }
            }
            System.out.println("Finished parsing");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int c = i;
            for (int j = 0; j < 8; ++j) {
                c = (c & 1) == 1 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
            }
            MsgParser.CRC32_TABLE[i] = c;
        }
    }

    private static class RtfInfo {
        private int codePage;
        private byte[] data;

        private RtfInfo() {
        }

        static /* synthetic */ byte[] access$102(RtfInfo x0, byte[] x1) {
            x0.data = x1;
            return x1;
        }
    }
}

