/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.parser.common;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.string.StringConverterUtils;
import agorum.commons.string.StringUtils;
import agorum.roi.ejb.client.beans.AccessControlEntryObjectClientBean;
import agorum.roi.ejb.client.beans.AccessControlEntryObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.AttributeObjectClientBean;
import agorum.roi.ejb.client.beans.ClassObjectClientBean;
import agorum.roi.ejb.client.beans.DataBaseObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryGroupObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.FormatObjectClientBean;
import agorum.roi.ejb.client.beans.FormatObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.InternalObjectClientBean;
import agorum.roi.ejb.client.beans.PropertyBundleObjectClientBean;
import agorum.roi.ejb.client.beans.PropertyObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.parser.common.RoiXMLObject;
import agorum.roi.parser.common.RoiXMLObjectAttribute;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CreateOrUpdateRoiObjectInstance {
    private static final int ATTRIBUTEVALUE_TYPENORMAL = 0;
    private static final int ATTRIBUTEVALUE_TYPADDARRAYELEMENT = 1;
    private static final int ATTRIBUTEVALUE_TYPINSERTARRAYELEMENTAT = 2;
    private static final int ATTRIBUTEVALUE_TYPEREMOVEARRAYELEMENT = 3;
    private static final int ATTRIBUTEVALUE_TYPEREMOVEARRAYELEMENTAT = 4;
    private static final String SAVEPOINT_ATTRIBUTE = "SAVEPOINT";
    private static final String UPDATE_ATTRIBUTE = "UPDATE";
    private static final String XMLRETURN_ATTRIBUTE = "XMLRETURN";
    private static final String XMLRETURNVALUE_ATTRIBUTE = "XMLRETURNVALUE";
    private static final String DELETE_ATTRIBUTE = "DELETE";
    private static final String DELETEIFEXIST_ATTRIBUTE = "DELETEIFEXIST";
    private static final String DELETEALLREFERENCESFROMTHISOBJECT_ATTRIBUTE = "DELETEALLREFERENCESFROMTHISOBJECT";
    private static final String DELETEALLREFERENCES_ATTRIBUTE = "DELETEALLREFERENCES";
    private static final String PARENTFOLDEROFDELETEOBJECT_ATTRIBUTE = "PARENTFOLDEROFDELETEOBJECT";
    private static final String SETEXPIRATIONDATEINSTEADOFDELETE_ATTRIBUTE = "SETEXPIRATIONDATEINSTEADOFDELETE";
    private static final String INTERNALVARIABLES_ATTRIBUTE = "INTERNALVARIABLES";
    private static final String INTERNALVARIABLE_ATTRIBUTE = "INTERNALVARIABLE";
    private static final String VARIABLENAME_ATTRIBUTETYPE = "VARIABLENAME";
    private static final String ADDTOFOLDER_ATTRIBUTE = "ADDTOFOLDER";
    private static final String LINKTOFOLDER_ATTRIBUTE = "LINKTOFOLDER";
    private static final String NOERRORIFEXIST_ATTRIBUTE = "NOERRORIFEXIST";
    private static final String EXITIFEXIST_ATTRIBUTE = "EXITIFEXIST";
    private static final String CONTENT_ATTRIBUTE = "CONTENT";
    private static final String ARRAYELEMENT_ATTRIBUTE = "ARRAYELEMENT";
    private static final String INVOKEMETHOD_ATTRIBUTE = "INVOKEMETHOD";
    private static final String SCOPEACLS_ATTRIBUTE = "SCOPEACLS";
    private static final String ADDSCOPEACL_ATTRIBUTE = "ADDSCOPEACL";
    private static final String DELETESCOPEACL_ATTRIBUTE = "DELETESCOPEACL";
    private static final String ADDARRAYELEMENT_ATTRIBUTE = "ADDARRAYELEMENT";
    private static final String INSERTARRAYELEMENTAT_ATTRIBUTE = "INSERTARRAYELEMENTAT";
    private static final String REMOVEARRAYELEMENT_ATTRIBUTE = "REMOVEARRAYELEMENT";
    private static final String REMOVEARRAYELEMENTAT_ATTRIBUTE = "REMOVEARRAYELEMENTAT";
    private static final String EXTENDEDATTRIBUTESXML_ATTRIBUTE = "EXTENDEDATTRIBUTESXML";
    private static final String UPDATEEXTENDEDATTRIBUTES_ATTRIBUTE = "UPDATEEXTENDEDATTRIBUTES";
    private static final String CLASSID_ATTRIBUTE = "CLASSID";
    private static final String REFTYPE_ATTRIBUTETYPE = "REFTYPE";
    private static final String FORMAT_ATTRIBUTETYPE = "FORMAT";
    private static final String DATATYPE_ATTRIBUTETYPE = "DATATYPE";
    private static final String METHODDATATYPE_ATTRIBUTETYPE = "METHODDATATYPE";
    private static final String POSITION_ATTRIBUTETYPE = "POSITION";
    private static final String WITHID_ATTRIBUTETYPE = "WITHID";
    private static final String PATH_REFTYPE = "PATH";
    private static final String ID_REFTYPE = "ID";
    private static final String SAVEPOINT_REFTYPE = "SAVEPOINT";
    private static final String INHERITED_ATTRIBUTE = "INHERITABLE";
    private static final String NAME_REFTYPE = "NAME";
    private static final String INTERNALVARIABLE_REFTYPE = "InternalVariable";
    private static final String TMPPATH_REFTYPE = "TmpPath";
    private static final String CLASSNAME_ATTRIBUTETYPE = "CLASSNAME";
    private static final String PROPERTYBUNDLE_ATTRIBUTETYPE = "PROPERTYBUNDLE";
    private static final String METADBPROPERTYENTRY_ATTRIBUTETYPE = "METADBPROPERTYENTRY";
    private static final String DONOTSETIFNOTEXISTS_ATTRIBUTETYPE = "DONOTSETIFNOTEXISTS";
    private static final String USEINTERNALVARIABLES_ATTRIBUTETYPE = "USEINTERNALVARIABLES";
    private static final String REPLACE_ATTRIBUTETYPE = "REPLACE";
    private static final String ENCODING_ATTRIBUTE = "ENCODING";
    private static final String ENCODING_BASE64 = "BASE64";
    private static final String DEFAULT_FORMAT = "dd.MM.yyyy HH:mm:ss";
    private static final String DELETEACES_ATTRIBUTE = "DELETEACES";
    private static final String DELETEGRANTEE_ATTRIBUTE = "DELETEGRANTEE";
    private static final String ACES_ATTRIBUTE = "ACES";
    private static final String MEMBERS_ATTRIBUTE = "MEMBERS";
    private static final String REF_ATTRIBUTE = "REF";
    private static final String DELETEREF_ATTRIBUTE = "DELETEREF";
    private SessionController sessionController = null;
    private Hashtable savepoint = null;
    private Hashtable internalVariables = null;
    private StringUtils su = new StringUtils();
    private Vector toDoAttribute = new Vector();
    private boolean isUpdate = false;
    private FolderObjectClientBean actFolder = null;
    private Vector returnVector = null;
    private boolean noErrorIfExist = false;
    private boolean exitIfExist = false;

    public CreateOrUpdateRoiObjectInstance(SessionController sessionController, FolderObjectClientBean actFolder) {
        this.sessionController = sessionController;
        this.actFolder = actFolder;
    }

    public boolean createOrUpdate(RoiXMLObject rxo, Hashtable savepoint, Vector returnVector, Hashtable internalVariables) throws Exception {
        this.savepoint = savepoint;
        this.returnVector = returnVector;
        this.internalVariables = internalVariables;
        if (rxo != null) {
            Vector roiXMLObjectAttribute = rxo.getRoiXMLObjectAttribute();
            if (this.getAttribute(roiXMLObjectAttribute, UPDATE_ATTRIBUTE) != null) {
                this.update(rxo);
            } else if (this.getAttribute(roiXMLObjectAttribute, DELETE_ATTRIBUTE) != null) {
                this.delete(rxo);
            } else if (this.getAttribute(roiXMLObjectAttribute, XMLRETURN_ATTRIBUTE) != null) {
                this.returnAttribute(rxo);
            } else if (this.getAttribute(roiXMLObjectAttribute, INTERNALVARIABLES_ATTRIBUTE) != null) {
                this.setInternalVarianles(rxo);
            } else {
                return this.createOrUpdateObject(rxo, null);
            }
        }
        return true;
    }

    private RoiXMLObjectAttribute getAttribute(Vector v, String attributeName) throws Exception {
        RoiXMLObjectAttribute att = null;
        if (v != null) {
            int len = v.size();
            for (int i = 0; i < len; ++i) {
                RoiXMLObjectAttribute rxoa = (RoiXMLObjectAttribute)v.elementAt(i);
                if (!rxoa.getName().equalsIgnoreCase(attributeName)) continue;
                att = rxoa;
                break;
            }
        }
        return att;
    }

    private void setInternalVarianles(RoiXMLObject rxo) throws Exception {
        Vector roiXMLObjectAttribute = rxo.getRoiXMLObjectAttribute();
        RoiXMLObjectAttribute att = this.getAttribute(roiXMLObjectAttribute, INTERNALVARIABLES_ATTRIBUTE);
        SuperObjectClientBean socb = this.getSuperObjectClientBean(rxo, att);
        if (socb != null) {
            Enumeration attrEnum = roiXMLObjectAttribute.elements();
            while (attrEnum.hasMoreElements()) {
                Object o = attrEnum.nextElement();
                RoiXMLObjectAttribute rxoa = (RoiXMLObjectAttribute)o;
                if (rxoa.getName().equalsIgnoreCase(INTERNALVARIABLE_ATTRIBUTE)) {
                    String value = rxoa.getValue();
                    String variableName = this.getVariableName(rxo, rxoa);
                    if (variableName != null) {
                        if (value.equalsIgnoreCase(ID_REFTYPE)) {
                            this.putInternalVariable(this.internalVariables, variableName, "" + socb.getId());
                            continue;
                        }
                        if (value.equalsIgnoreCase("Content")) {
                            StringUtils su = new StringUtils();
                            this.returnVector.addElement(AttributeValue.newAttributeValueObject(su.encodeToBase64(((ContentInterface)((Object)socb)).getContentStream())));
                            this.putInternalVariable(this.internalVariables, variableName, su.encodeToBase64(((ContentInterface)((Object)socb)).getContentStream()));
                            continue;
                        }
                        if (value.equalsIgnoreCase("AnyPath")) {
                            this.putInternalVariable(this.internalVariables, variableName, ((GlobalObjectClientBean)socb).getAnyFolderPath());
                            continue;
                        }
                        AttributeValue av = socb.getAttribute(value.toUpperCase());
                        String myVar = av.toString(this.sessionController);
                        if (myVar.startsWith("\"")) {
                            myVar = myVar.substring(1);
                        }
                        if (myVar.endsWith("\"")) {
                            myVar = myVar.substring(0, myVar.length() - 1);
                        }
                        this.putInternalVariable(this.internalVariables, variableName, myVar);
                        continue;
                    }
                    throw new Exception("Attribute VariableName=... not found in Tag InternalVariable");
                }
                if (rxoa.getName().equalsIgnoreCase(INTERNALVARIABLES_ATTRIBUTE)) continue;
                throw new Exception("Attribute " + rxoa.getName() + " not allowed in XMLReturn-Tag");
            }
        }
    }

    private void returnAttribute(RoiXMLObject rxo) throws Exception {
        Vector roiXMLObjectAttribute = rxo.getRoiXMLObjectAttribute();
        RoiXMLObjectAttribute att = this.getAttribute(roiXMLObjectAttribute, XMLRETURN_ATTRIBUTE);
        SuperObjectClientBean socb = this.getSuperObjectClientBean(rxo, att);
        if (socb != null) {
            Enumeration attrEnum = roiXMLObjectAttribute.elements();
            while (attrEnum.hasMoreElements()) {
                Object o = attrEnum.nextElement();
                RoiXMLObjectAttribute rxoa = (RoiXMLObjectAttribute)o;
                if (rxoa.getName().equalsIgnoreCase(XMLRETURNVALUE_ATTRIBUTE)) {
                    String value = rxoa.getValue();
                    if (value.equalsIgnoreCase(ID_REFTYPE)) {
                        this.returnVector.addElement(AttributeValue.newAttributeValueObject(socb.getId()));
                        continue;
                    }
                    if (value.equalsIgnoreCase("SuperObjectClientBean")) {
                        this.returnVector.addElement(AttributeValue.newAttributeValueObject(socb));
                        continue;
                    }
                    if (value.equalsIgnoreCase("Content")) {
                        StringUtils su = new StringUtils();
                        this.returnVector.addElement(AttributeValue.newAttributeValueObject(su.encodeToBase64(((ContentInterface)((Object)socb)).getContentStream())));
                        continue;
                    }
                    AttributeValue av = socb.getAttribute(value.toUpperCase());
                    this.returnVector.addElement(av);
                    continue;
                }
                if (rxoa.getName().equalsIgnoreCase(XMLRETURN_ATTRIBUTE)) continue;
                throw new Exception("Attribute " + rxoa.getName() + " not allowed in XMLReturn-Tag");
            }
        }
    }

    private void update(RoiXMLObject rxo) throws Exception {
        Vector roiXMLObjectAttribute = rxo.getRoiXMLObjectAttribute();
        RoiXMLObjectAttribute att = this.getAttribute(roiXMLObjectAttribute, UPDATE_ATTRIBUTE);
        SuperObjectClientBean socb = this.getSuperObjectClientBean(rxo, att);
        if (socb != null) {
            this.createOrUpdateObject(rxo, socb);
        }
    }

    private void delete(RoiXMLObject rxo) throws Exception {
        SuperObjectClientBean socb;
        RoiXMLObjectAttribute attSetExpirationDateInsteadOfDelete;
        RoiXMLObjectAttribute attDeleteAllReferences;
        RoiXMLObjectAttribute attDeleteAllReferencesFromThisObject;
        RoiXMLObjectAttribute attParentFolderDeleteObject;
        Vector roiXMLObjectAttribute;
        block8: {
            roiXMLObjectAttribute = rxo.getRoiXMLObjectAttribute();
            RoiXMLObjectAttribute attDeleteObject = this.getAttribute(roiXMLObjectAttribute, DELETE_ATTRIBUTE);
            attParentFolderDeleteObject = this.getAttribute(roiXMLObjectAttribute, PARENTFOLDEROFDELETEOBJECT_ATTRIBUTE);
            RoiXMLObjectAttribute attDeleteIfExist = this.getAttribute(roiXMLObjectAttribute, DELETEIFEXIST_ATTRIBUTE);
            attDeleteAllReferencesFromThisObject = this.getAttribute(roiXMLObjectAttribute, DELETEALLREFERENCESFROMTHISOBJECT_ATTRIBUTE);
            attDeleteAllReferences = this.getAttribute(roiXMLObjectAttribute, DELETEALLREFERENCES_ATTRIBUTE);
            attSetExpirationDateInsteadOfDelete = this.getAttribute(roiXMLObjectAttribute, SETEXPIRATIONDATEINSTEADOFDELETE_ATTRIBUTE);
            socb = null;
            try {
                socb = this.getSuperObjectClientBean(rxo, attDeleteObject);
            }
            catch (Exception e) {
                if (attDeleteIfExist != null) break block8;
                throw e;
            }
        }
        if (socb != null) {
            SuperObjectClientBeanDefinition def = socb.getNewDefinition(this.sessionController);
            if (attParentFolderDeleteObject != null) {
                def.setSystemOption("parentFolderOfDeleteObject", this.getSuperObjectClientBean(rxo, attParentFolderDeleteObject));
            }
            if (attDeleteAllReferences != null) {
                def.setSystemOption("deleteAllReferences", " ");
            }
            if (attDeleteAllReferencesFromThisObject != null) {
                def.setSystemOption("deleteAllReferencesFromThisObject", " ");
            }
            if (attSetExpirationDateInsteadOfDelete != null) {
                def.setSystemOption("SetExpirationDateInsteadOfDelete", " ");
            }
            Enumeration attrEnum = roiXMLObjectAttribute.elements();
            while (attrEnum.hasMoreElements()) {
                Object o = attrEnum.nextElement();
                RoiXMLObjectAttribute rxoa = (RoiXMLObjectAttribute)o;
                if (!rxoa.getName().equalsIgnoreCase(INVOKEMETHOD_ATTRIBUTE)) continue;
                this.invokeMethod(rxo, rxoa, def);
            }
            socb.delete(def);
        }
    }

    private boolean createOrUpdateObject(RoiXMLObject rxo, SuperObjectClientBean socb) throws Exception {
        SuperObjectClientBeanDefinition def = this.getDefinition(rxo, socb);
        boolean noToDoAttributeIfExist = false;
        if (def != null) {
            if (!this.isUpdate) {
                SuperObjectClientBean existing;
                boolean doCreate = true;
                if (this.exitIfExist) {
                    SuperObjectClientBean existing2 = this.getExisting(def);
                    if (existing2 != null) {
                        return false;
                    }
                } else if (this.noErrorIfExist && (existing = this.getExisting(def)) != null) {
                    socb = existing;
                    doCreate = false;
                    noToDoAttributeIfExist = true;
                }
                if (doCreate) {
                    socb = this.sessionController.createSuperObject(def);
                }
            } else {
                if (socb instanceof GlobalObjectClientBean) {
                    System.err.println("XML: update Object : " + ((GlobalObjectClientBean)socb).getName());
                }
                socb.update(def);
            }
            String savePoint = rxo.getAttribute("SAVEPOINT");
            if (savePoint != null) {
                this.setSavePoint(savePoint, "" + socb.getId());
            }
            if (!noToDoAttributeIfExist) {
                this.createToDoAttribute(rxo, socb, this.toDoAttribute);
            }
        } else {
            System.err.println("Kein entsprechendes Object gefunden (" + rxo.getName() + ")");
        }
        return true;
    }

    private SuperObjectClientBean getExisting(SuperObjectClientBeanDefinition def) throws Exception {
        GlobalObjectClientBean result = null;
        if (def instanceof FormatObjectClientBeanDefinition) {
            SuperObjectClientBean[] testArr = null;
            try {
                testArr = this.sessionController.getSuperObjectByAttributes(this.sessionController, this.sessionController.getClassObject(FormatObjectClientBean.CLASS_NAME), new String[]{FormatObjectClientBean.NAME_ATTRIBUTE, FormatObjectClientBean.EXTENSION_ATTRIBUTE}, new Object[]{def.getAttribute(FormatObjectClientBean.NAME_ATTRIBUTE).getString(), def.getAttribute(FormatObjectClientBean.EXTENSION_ATTRIBUTE).getString()}, new int[]{0, 0}, new boolean[]{true, true}, new int[]{3, 2, 1}, null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (testArr != null && testArr.length > 0) {
                result = testArr[0];
            }
        } else {
            FolderObjectClientBean f = (FolderObjectClientBean)def.getSystemOption("addToFolder");
            if (f != null && (result = f.getItem(def.getAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE).getString())) != null && !result.getClassName().equalsIgnoreCase(def.getClassName())) {
                result = null;
            }
        }
        return result;
    }

    private SuperObjectClientBeanDefinition getDefinition(RoiXMLObject rxo, SuperObjectClientBean socb) throws Exception {
        ClassObjectClientBean co = null;
        this.isUpdate = false;
        if (socb != null) {
            co = this.sessionController.getClassObject(socb.getClassId());
            this.isUpdate = true;
        } else {
            co = this.sessionController.getClassObject(rxo.getName().toUpperCase());
        }
        Vector roiXMLObjectAttribute = rxo.getRoiXMLObjectAttribute();
        return this.getDefinitionIntern(rxo, socb, roiXMLObjectAttribute, co);
    }

    private SuperObjectClientBeanDefinition getDefinition(RoiXMLObject rxo, SuperObjectClientBean socb, RoiXMLObjectAttribute rxoa) throws Exception {
        ClassObjectClientBean co = null;
        this.isUpdate = false;
        if (socb != null) {
            co = this.sessionController.getClassObject(socb.getClassId());
            this.isUpdate = true;
        } else {
            co = this.sessionController.getClassObject(rxoa.getName().toUpperCase());
        }
        Vector roiXMLObjectAttribute = rxoa.getRoiXMLObjectAttribute();
        return this.getDefinitionIntern(rxo, socb, roiXMLObjectAttribute, co);
    }

    private SuperObjectClientBeanDefinition getDefinitionIntern(RoiXMLObject rxo, SuperObjectClientBean socb, Vector roiXMLObjectAttribute, ClassObjectClientBean co) throws Exception {
        SuperObjectClientBeanDefinition def = null;
        if (co != null) {
            Hashtable allAtt = (Hashtable)this.sessionController.getAllAttributes().get(this.sessionController, co.getId());
            if (!this.isUpdate) {
                Object objSysOptDef = Class.forName(co.getClientBeanClass()).newInstance();
                SuperObjectClientBeanDefinition sysOptDef = ((SuperObjectClientBean)objSysOptDef).getNewDefinition(this.sessionController);
                Enumeration enumB = roiXMLObjectAttribute.elements();
                this.toDoAttribute = new Vector();
                while (enumB.hasMoreElements()) {
                    Object o = enumB.nextElement();
                    RoiXMLObjectAttribute rxoa = (RoiXMLObjectAttribute)o;
                    if (!rxoa.getName().equalsIgnoreCase(INVOKEMETHOD_ATTRIBUTE)) continue;
                    this.invokeMethod(rxo, rxoa, sysOptDef);
                }
                def = this.getDefinitionFromDestinationFolder(rxo, roiXMLObjectAttribute, co, sysOptDef);
                if (def == null) {
                    Object obj = Class.forName(co.getClientBeanClass()).newInstance();
                    def = ((SuperObjectClientBean)obj).getNewDefinition(this.sessionController);
                }
                if (def.getId() == null) {
                    def.setId(this.sessionController.getSequenceId());
                }
            } else {
                def = socb.getNewDefinition(this.sessionController);
            }
            Enumeration enumA = roiXMLObjectAttribute.elements();
            this.toDoAttribute = new Vector();
            while (enumA.hasMoreElements()) {
                Object o = enumA.nextElement();
                RoiXMLObjectAttribute rxoa = (RoiXMLObjectAttribute)o;
                if (rxoa.getName().equalsIgnoreCase(LINKTOFOLDER_ATTRIBUTE) || rxoa.getName().equalsIgnoreCase(CONTENT_ATTRIBUTE) || rxoa.getName().equalsIgnoreCase(ACES_ATTRIBUTE) || rxoa.getName().equalsIgnoreCase(DELETEACES_ATTRIBUTE) || rxoa.getName().equalsIgnoreCase(SCOPEACLS_ATTRIBUTE) || rxoa.getName().equalsIgnoreCase(MEMBERS_ATTRIBUTE)) {
                    this.toDoAttribute.addElement(rxoa);
                    continue;
                }
                if (rxoa.getName().equalsIgnoreCase(NOERRORIFEXIST_ATTRIBUTE)) {
                    this.noErrorIfExist = true;
                    continue;
                }
                if (rxoa.getName().equalsIgnoreCase(EXITIFEXIST_ATTRIBUTE)) {
                    this.exitIfExist = true;
                    continue;
                }
                if (rxoa.getName().equalsIgnoreCase(ADDTOFOLDER_ATTRIBUTE)) {
                    this.setAddToFolderOption(rxo, (GlobalObjectClientBeanDefinition)def, rxoa);
                    continue;
                }
                if (rxoa.getName().equalsIgnoreCase(EXTENDEDATTRIBUTESXML_ATTRIBUTE)) {
                    String inheritedS;
                    boolean inherited = false;
                    if (rxoa.getAttribute() != null && (inheritedS = (String)rxoa.getAttribute().get(INHERITED_ATTRIBUTE)) != null) {
                        inherited = Boolean.parseBoolean(inheritedS);
                    }
                    this.setExtendedAttributesXML(rxo, (GlobalObjectClientBeanDefinition)def, rxoa, inherited);
                    continue;
                }
                if (rxoa.getName().equalsIgnoreCase(UPDATEEXTENDEDATTRIBUTES_ATTRIBUTE)) {
                    String inheritedS;
                    boolean inherited = false;
                    if (rxoa.getAttribute() != null && (inheritedS = (String)rxoa.getAttribute().get(INHERITED_ATTRIBUTE)) != null) {
                        inherited = Boolean.parseBoolean(inheritedS);
                    }
                    this.updateExtendedAttributes(rxo, (GlobalObjectClientBeanDefinition)def, rxoa, inherited);
                    continue;
                }
                if (rxoa.getName().equalsIgnoreCase(INVOKEMETHOD_ATTRIBUTE)) {
                    this.invokeMethod(rxo, rxoa, def);
                    continue;
                }
                if (rxoa.getName().equalsIgnoreCase(UPDATE_ATTRIBUTE) || rxoa.getName().equalsIgnoreCase(CLASSID_ATTRIBUTE)) continue;
                AttributeValueBean avb = this.getAttributeValue(rxo, rxoa, co, allAtt, def.getId());
                if (avb.getAttributeValueType() == 0) {
                    def.setAttribute(rxoa.getName().toUpperCase(), avb.getAttributeValue());
                    continue;
                }
                if (avb.getAttributeValueType() == 1) {
                    def.addArrayElement(rxoa.getName().toUpperCase(), avb.getAttributeValue());
                    continue;
                }
                if (avb.getAttributeValueType() == 2) {
                    long pos = this.getPosition(rxo, rxoa);
                    def.insertArrayElementAt(rxoa.getName().toUpperCase(), avb.getAttributeValue(), pos);
                    continue;
                }
                if (avb.getAttributeValueType() == 3) {
                    def.removeArrayElement(rxoa.getName().toUpperCase(), avb.getAttributeValue());
                    continue;
                }
                if (avb.getAttributeValueType() != 4) continue;
                long[] pos = avb.getAttributePos();
                int len = pos.length;
                for (int i = 0; i < len; ++i) {
                    def.removeArrayElementAt(rxoa.getName().toUpperCase(), pos[i]);
                    for (int k = i + 1; k < len; ++k) {
                        if (pos[k] <= pos[i]) continue;
                        int n = k;
                        pos[n] = pos[n] - 1L;
                    }
                }
            }
        }
        return def;
    }

    private SuperObjectClientBeanDefinition getDefinitionFromDestinationFolder(RoiXMLObject rxo, Vector roiXMLObjectAttribute, ClassObjectClientBean co, SuperObjectClientBeanDefinition sysOpDef) throws Exception {
        SuperObjectClientBeanDefinition def = null;
        Enumeration attrEnum = roiXMLObjectAttribute.elements();
        this.toDoAttribute = new Vector();
        while (attrEnum.hasMoreElements()) {
            Object o = attrEnum.nextElement();
            RoiXMLObjectAttribute rxoa = (RoiXMLObjectAttribute)o;
            if (!rxoa.getName().equalsIgnoreCase(ADDTOFOLDER_ATTRIBUTE)) continue;
            FolderObjectClientBean focb = null;
            focb = (FolderObjectClientBean)this.getSuperObjectClientBean(rxo, rxoa);
            if (focb == null) {
                throw new Exception("AddToFolder: Object not found" + this.getValue(rxo, rxoa, rxoa));
            }
            if (!(sysOpDef instanceof GlobalObjectClientBeanDefinition)) continue;
            def = focb.getCreateDefinition(this.sessionController, co, (GlobalObjectClientBeanDefinition)sysOpDef);
        }
        return def;
    }

    private void createToDoAttribute(RoiXMLObject rxo, SuperObjectClientBean socb, Vector toDoAttribute) throws Exception {
        if (toDoAttribute != null && toDoAttribute.size() > 0) {
            Enumeration attrEnum = toDoAttribute.elements();
            while (attrEnum.hasMoreElements()) {
                RoiXMLObjectAttribute rxoa = (RoiXMLObjectAttribute)attrEnum.nextElement();
                if (rxoa.getName().equalsIgnoreCase(LINKTOFOLDER_ATTRIBUTE)) {
                    this.linkToFolder(rxo, socb, rxoa);
                    continue;
                }
                if (rxoa.getName().equalsIgnoreCase(CONTENT_ATTRIBUTE)) {
                    this.setContent(rxo, socb, rxoa);
                    continue;
                }
                if (rxoa.getName().equalsIgnoreCase(ACES_ATTRIBUTE)) {
                    this.setAccessControlEntrys(rxo, socb, rxoa);
                    continue;
                }
                if (rxoa.getName().equalsIgnoreCase(DELETEACES_ATTRIBUTE)) {
                    this.deleteAccessControlEntrys(rxo, socb, rxoa);
                    continue;
                }
                if (rxoa.getName().equalsIgnoreCase(MEMBERS_ATTRIBUTE)) {
                    this.setMembers(rxo, socb, rxoa);
                    continue;
                }
                if (!rxoa.getName().equalsIgnoreCase(SCOPEACLS_ATTRIBUTE)) continue;
                this.setScopeAcls(rxo, socb, rxoa);
            }
        }
    }

    public void deleteAccessControlEntrys(RoiXMLObject rxo, SuperObjectClientBean socb, RoiXMLObjectAttribute rxoa) throws Exception {
        AccessControlListObjectClientBean acl = (AccessControlListObjectClientBean)socb;
        Hashtable<Long, AccessControlEntryObjectClientBean> delAces = new Hashtable<Long, AccessControlEntryObjectClientBean>();
        Vector elements = rxoa.getRoiXMLObjectAttribute();
        int len = elements.size();
        for (int i = 0; i < len; ++i) {
            SuperObjectClientBean so;
            AccessControlEntryObjectClientBean[] aces;
            RoiXMLObjectAttribute ro = (RoiXMLObjectAttribute)elements.elementAt(i);
            if (!ro.getName().equalsIgnoreCase(DELETEGRANTEE_ATTRIBUTE) || (aces = acl.getAccessControlEntries((DirectoryObjectClientBean)(so = this.getSuperObjectClientBean(rxo, ro)))) == null) continue;
            int lenE = aces.length;
            for (int e = 0; e < lenE; ++e) {
                if (delAces.containsKey(aces[e].getId())) continue;
                delAces.put(aces[e].getId(), aces[e]);
            }
        }
        len = delAces.size();
        if (len > 0) {
            AccessControlEntryObjectClientBean[] aces = new AccessControlEntryObjectClientBean[len];
            Enumeration enumE = delAces.keys();
            int i = 0;
            while (enumE.hasMoreElements()) {
                AccessControlEntryObjectClientBean ace;
                Long key = (Long)enumE.nextElement();
                aces[i] = ace = (AccessControlEntryObjectClientBean)delAces.get(key);
                ++i;
            }
            acl.removeAccessControlEntryObject(aces);
        }
    }

    public void setAccessControlEntrys(RoiXMLObject rxo, SuperObjectClientBean socb, RoiXMLObjectAttribute rxoa) throws Exception {
        int i;
        AccessControlEntryObjectClientBeanDefinition[] acesDef = null;
        AccessControlListObjectClientBean acl = (AccessControlListObjectClientBean)socb;
        Vector<SuperObjectClientBeanDefinition> v = new Vector<SuperObjectClientBeanDefinition>();
        Vector elements = rxoa.getRoiXMLObjectAttribute();
        int len = elements.size();
        for (i = 0; i < len; ++i) {
            SuperObjectClientBeanDefinition def = this.getDefinition(rxo, null, (RoiXMLObjectAttribute)elements.elementAt(i));
            if (def == null) continue;
            v.addElement(def);
        }
        len = v.size();
        if (len > 0) {
            acesDef = new AccessControlEntryObjectClientBeanDefinition[len];
            for (i = 0; i < len; ++i) {
                acesDef[i] = (AccessControlEntryObjectClientBeanDefinition)v.elementAt(i);
                if (acesDef[i].getAttribute(AccessControlEntryObjectClientBean.GRANTED_ATTRIBUTE) != null) continue;
                acesDef[i].setGranted(true);
            }
            acl.grantOrRevokeAccess(acesDef);
        }
    }

    public void invokeMethod(RoiXMLObject rxo, RoiXMLObjectAttribute rxoa, SuperObjectClientBeanDefinition def) throws Exception {
        Vector elements = rxoa.getRoiXMLObjectAttribute();
        String method = null;
        Hashtable<String, InvokeMethodAttribueBean> parameter = new Hashtable<String, InvokeMethodAttribueBean>();
        int len = elements.size();
        for (int i = 0; i < len; ++i) {
            RoiXMLObjectAttribute ro = (RoiXMLObjectAttribute)elements.elementAt(i);
            if (ro.getName().equalsIgnoreCase("METHOD")) {
                method = ro.getValue();
                continue;
            }
            if (ro.getName().toUpperCase().startsWith("PARAMETER_")) {
                InvokeMethodAttribueBean imab = new InvokeMethodAttribueBean();
                if (this.getDataType(rxo, ro).equalsIgnoreCase("STRING")) {
                    imab.setValue(ro.getValue());
                    parameter.put(ro.getName().toUpperCase(), imab);
                } else if (this.getDataType(rxo, ro).equalsIgnoreCase("CISTRING")) {
                    imab.setValue(ro.getValue());
                    parameter.put(ro.getName().toUpperCase(), imab);
                } else if (this.getDataType(rxo, ro).equalsIgnoreCase("STRING_ARRAY")) {
                    String[] array = this.getInvokeMethodStringArray(rxo, ro);
                    imab.setValue(array);
                    parameter.put(ro.getName().toUpperCase(), imab);
                } else {
                    throw new Exception("DataType not supported in <InvokeMethod> '" + this.getDataType(rxo, ro) + "', value = " + ro.getValue());
                }
                if (this.getMethodDataType(rxo, ro).equalsIgnoreCase("STRING")) {
                    imab.setMethodDataType(new String(""));
                    continue;
                }
                if (this.getMethodDataType(rxo, ro).equalsIgnoreCase("OBJECT")) {
                    imab.setMethodDataType(new Object());
                    continue;
                }
                throw new Exception("MethodDataType not supported in <InvokeMethod> '" + this.getMethodDataType(rxo, ro) + "', value = " + ro.getValue());
            }
            throw new Exception("Tag not supported in <InvokeMethod> '" + ro.getName() + "'");
        }
        if (method != null) {
            Class[] paramTypes = null;
            Object[] pObj = null;
            int anz = parameter.size();
            if (anz > 0) {
                pObj = new Object[anz];
                paramTypes = new Class[anz];
                for (int i = 0; i < anz; ++i) {
                    if (!parameter.containsKey("PARAMETER_" + (i + 1))) {
                        throw new Exception("Paramter not match by Method " + rxoa.getName() + "." + method + "(PARAMETER_" + (i + 1) + " not define)");
                    }
                    InvokeMethodAttribueBean imab = (InvokeMethodAttribueBean)parameter.get("PARAMETER_" + (i + 1));
                    paramTypes[i] = imab.getMethodDataType().getClass();
                    pObj[i] = imab.getValue();
                }
            }
            try {
                Class<?> c = def.getClass();
                Method m = c.getMethod(method, paramTypes);
                m.invoke((Object)def, pObj);
            }
            catch (Exception e) {
                throw new Exception("InvokeMethod - Error " + method + " (" + e.getMessage() + ")");
            }
        } else {
            throw new Exception("Tag <Method> not found in <InvokeMethod> ");
        }
    }

    private String[] getInvokeMethodStringArray(RoiXMLObject rxo, RoiXMLObjectAttribute rxoa) throws Exception {
        int i;
        String[] array = null;
        Vector elements = rxoa.getRoiXMLObjectAttribute();
        Vector<String> arrayVector = new Vector<String>();
        int len = elements.size();
        for (i = 0; i < len; ++i) {
            RoiXMLObjectAttribute ro = (RoiXMLObjectAttribute)elements.elementAt(i);
            if (!ro.getName().equalsIgnoreCase(ARRAYELEMENT_ATTRIBUTE)) continue;
            arrayVector.addElement(ro.getValue());
        }
        len = arrayVector.size();
        if (len > 0) {
            array = new String[len];
            for (i = 0; i < len; ++i) {
                array[i] = (String)arrayVector.elementAt(i);
            }
        }
        return array;
    }

    public void setMembers(RoiXMLObject rxo, SuperObjectClientBean socb, RoiXMLObjectAttribute rxoa) throws Exception {
        int i;
        DirectoryObjectClientBean[] docb = null;
        DirectoryGroupObjectClientBean group = (DirectoryGroupObjectClientBean)socb;
        Vector<SuperObjectClientBean> v = new Vector<SuperObjectClientBean>();
        Vector<SuperObjectClientBean> vDel = new Vector<SuperObjectClientBean>();
        Vector elements = rxoa.getRoiXMLObjectAttribute();
        int len = elements.size();
        for (i = 0; i < len; ++i) {
            SuperObjectClientBean so;
            RoiXMLObjectAttribute ro = (RoiXMLObjectAttribute)elements.elementAt(i);
            if (ro.getName().equalsIgnoreCase(REF_ATTRIBUTE)) {
                so = this.getSuperObjectClientBean(rxo, ro);
                if (so == null) continue;
                v.addElement(so);
                continue;
            }
            if (!ro.getName().equalsIgnoreCase(DELETEREF_ATTRIBUTE) || (so = this.getSuperObjectClientBean(rxo, ro)) == null) continue;
            vDel.addElement(so);
        }
        len = v.size();
        if (len > 0) {
            docb = new DirectoryObjectClientBean[len];
            for (i = 0; i < len; ++i) {
                docb[i] = (DirectoryObjectClientBean)v.elementAt(i);
            }
            group.addMembers(docb);
        }
        if ((len = vDel.size()) > 0) {
            docb = new DirectoryObjectClientBean[len];
            for (i = 0; i < len; ++i) {
                docb[i] = (DirectoryObjectClientBean)vDel.elementAt(i);
            }
            group.removeMembers(docb);
        }
    }

    public void setScopeAcls(RoiXMLObject rxo, SuperObjectClientBean socb, RoiXMLObjectAttribute rxoa) throws Exception {
        GlobalObjectClientBean clientBean = (GlobalObjectClientBean)socb;
        Vector elements = rxoa.getRoiXMLObjectAttribute();
        int len = elements.size();
        for (int i = 0; i < len; ++i) {
            AccessControlListObjectClientBean acl;
            SuperObjectClientBean so;
            RoiXMLObjectAttribute ro = (RoiXMLObjectAttribute)elements.elementAt(i);
            if (ro.getName().equalsIgnoreCase(ADDSCOPEACL_ATTRIBUTE)) {
                so = this.getSuperObjectClientBean(rxo, ro);
                if (so == null) continue;
                acl = (AccessControlListObjectClientBean)so;
                clientBean.setScopeAcl(acl);
                continue;
            }
            if (!ro.getName().equalsIgnoreCase(DELETESCOPEACL_ATTRIBUTE) || (so = this.getSuperObjectClientBean(rxo, ro)) == null) continue;
            acl = (AccessControlListObjectClientBean)so;
            clientBean.deleteScopeAcl(acl);
        }
    }

    private void setContent(RoiXMLObject rxo, SuperObjectClientBean socb, RoiXMLObjectAttribute rxoa) throws Exception {
        String value = rxoa.getValue();
        String encoding = this.getEncoding(rxo, rxoa);
        InputStream is = null;
        if (encoding.equals(ENCODING_BASE64)) {
            if (value == null) {
                value = "";
            }
            is = this.su.decodeFromBase64ToStream(value);
        } else {
            String reftype = this.getRefType(rxo, rxoa);
            if (reftype.equalsIgnoreCase(TMPPATH_REFTYPE)) {
                throw new Exception("The option TmpPath has been removed, due to security issues");
            }
            is = rxoa.getValue() != null ? StringConverterUtils.toStream((String)rxoa.getValue()) : StringConverterUtils.toStream((String)"");
        }
        ((ContentInterface)((Object)socb)).setContent(is);
    }

    private void setAddToFolderOption(RoiXMLObject rxo, GlobalObjectClientBeanDefinition def, RoiXMLObjectAttribute rxoa) throws Exception {
        FolderObjectClientBean focb = null;
        focb = (FolderObjectClientBean)this.getSuperObjectClientBean(rxo, rxoa);
        if (focb == null) {
            throw new Exception("AddToFolder: Object not found" + this.getValue(rxo, rxoa, rxoa));
        }
        def.setAddToFolderOption(focb);
    }

    private void setExtendedAttributesXML(RoiXMLObject rxo, GlobalObjectClientBeanDefinition def, RoiXMLObjectAttribute rxoa, boolean inherited) throws Exception {
        String value = this.getValue(rxo, rxoa, rxoa);
        def.setExtendedAttributesXML(value, inherited);
    }

    private void updateExtendedAttributes(RoiXMLObject rxo, GlobalObjectClientBeanDefinition def, RoiXMLObjectAttribute rxoa, boolean inherited) throws Exception {
        String value = this.getValue(rxo, rxoa, rxoa);
        if (value != null) {
            try {
                Hashtable<String, String> removedAttributes = null;
                Hashtable<String, Object> extendedAttributes = new Hashtable<String, Object>();
                GlobalObjectClientBean.parseExtendedAttributesXml(value, this.sessionController, false, extendedAttributes, null, null);
                Enumeration<String> keyEnum = extendedAttributes.keys();
                while (keyEnum.hasMoreElements()) {
                    String key = keyEnum.nextElement();
                    AttributeValue attributeValue = (AttributeValue)extendedAttributes.get(key);
                    if (attributeValue.getAttributeValue() != null) continue;
                    if (removedAttributes == null) {
                        removedAttributes = new Hashtable<String, String>();
                    }
                    removedAttributes.put(key, "");
                    extendedAttributes.remove(key);
                }
                def.updateExtendedAttributes(extendedAttributes, removedAttributes, inherited);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private void linkToFolder(RoiXMLObject rxo, SuperObjectClientBean socb, RoiXMLObjectAttribute rxoa) throws Exception {
        block3: {
            try {
                FolderObjectClientBean focb = null;
                focb = (FolderObjectClientBean)this.getSuperObjectClientBean(rxo, rxoa);
                if (focb != null) {
                    focb.addItem((GlobalObjectClientBean)socb);
                }
            }
            catch (Exception e) {
                if (this.noErrorIfExist) break block3;
                throw e;
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SuperObjectClientBean getSuperObjectClientBean(RoiXMLObject rxo, RoiXMLObjectAttribute rxoa) throws Exception {
        void var3_17;
        Object var3_3 = null;
        try {
            void var3_15;
            String value = this.getValue(rxo, rxoa, rxoa);
            if (value == null || value != null && value.length() < 1) {
                throw new Exception("RefType=\"" + this.getRefType(rxo, rxoa) + "\" : no value define");
            }
            if (this.getRefType(rxo, rxoa).equalsIgnoreCase(PATH_REFTYPE) || this.getRefType(rxo, rxoa).equalsIgnoreCase(INTERNALVARIABLE_REFTYPE)) {
                String path = value;
                if (path.startsWith("/")) {
                    GlobalObjectClientBean globalObjectClientBean = this.sessionController.findGlobalObjectByPath(path);
                } else {
                    if (this.actFolder == null) throw new Exception("no rootfolder define");
                    GlobalObjectClientBean globalObjectClientBean = this.sessionController.findGlobalObjectByPath(this.actFolder, path);
                }
            } else if (this.getRefType(rxo, rxoa).equalsIgnoreCase("SAVEPOINT")) {
                String savePoint = this.getSavePoint(rxoa.getValue());
                GlobalObjectClientBean globalObjectClientBean = this.sessionController.getGlobalObjectById(new Long(savePoint));
            } else if (this.getRefType(rxo, rxoa).equalsIgnoreCase(ID_REFTYPE)) {
                String className = this.getClassName(rxo, rxoa);
                if (className == null) throw new Exception("We need the ClassName from this RefType=\"ID\"");
                ClassObjectClientBean co = this.sessionController.getClassObject(className);
                if (co == null) throw new Exception("ClassName " + className + " not found");
                ClassObjectClientBean coRoot = this.sessionController.getRootClassObjectFromClassId(co.getId());
                Long id = new Long(value);
                if (coRoot.getName().equalsIgnoreCase(GlobalObjectClientBean.CLASS_NAME)) {
                    GlobalObjectClientBean globalObjectClientBean = this.sessionController.getGlobalObjectById(id);
                } else if (coRoot.getName().equalsIgnoreCase(InternalObjectClientBean.CLASS_NAME)) {
                    InternalObjectClientBean internalObjectClientBean = this.sessionController.getInternalObjectById(id);
                } else if (coRoot.getName().equalsIgnoreCase(DataBaseObjectClientBean.CLASS_NAME)) {
                    DataBaseObjectClientBean dataBaseObjectClientBean = this.sessionController.getDataBaseObjectById(id);
                }
            } else if (this.getRefType(rxo, rxoa).equalsIgnoreCase(NAME_REFTYPE)) {
                String className = this.getClassName(rxo, rxoa);
                if (className == null) throw new Exception("We need the ClassName from this RefType=\"NAME\"");
                ClassObjectClientBean co = this.sessionController.getClassObject(className);
                if (co == null) throw new Exception("ClassName " + className + " not found");
                SuperObjectClientBean[] socbArr = this.sessionController.getSuperObjectByAttribute(this.sessionController, GlobalObjectClientBean.NAME_ATTRIBUTE, rxoa.getValue(), false, co);
                if (socbArr != null && socbArr.length == 1) {
                    SuperObjectClientBean superObjectClientBean = socbArr[0];
                } else {
                    Object var3_13 = null;
                }
            }
            if (var3_15 != null || !this.getDoNotSetIfNotExists(rxo, rxoa).equalsIgnoreCase("false")) return var3_17;
            throw new Exception("Object not found (RefType=" + this.getRefType(rxo, rxoa) + "): " + rxoa.getValue());
        }
        catch (Exception e) {
            if (!this.getDoNotSetIfNotExists(rxo, rxoa).equalsIgnoreCase("false")) return var3_17;
            throw e;
        }
    }

    private String getUseInternalVariables(RoiXMLObject rxo, RoiXMLObjectAttribute rxoa) throws Exception {
        String use = "false";
        Hashtable att = rxoa.getAttribute();
        if (att != null && att.containsKey(USEINTERNALVARIABLES_ATTRIBUTETYPE)) {
            use = att.get(USEINTERNALVARIABLES_ATTRIBUTETYPE).toString();
        }
        return use;
    }

    private String getReplace(RoiXMLObject rxo, RoiXMLObjectAttribute rxoa) throws Exception {
        String replace = "false";
        Hashtable att = rxoa.getAttribute();
        if (att != null && att.containsKey(REPLACE_ATTRIBUTETYPE)) {
            replace = att.get(REPLACE_ATTRIBUTETYPE).toString();
        }
        return replace;
    }

    private String getDoNotSetIfNotExists(RoiXMLObject rxo, RoiXMLObjectAttribute rxoa) throws Exception {
        String refType = "FALSE";
        Hashtable att = rxoa.getAttribute();
        if (att != null && att.containsKey(DONOTSETIFNOTEXISTS_ATTRIBUTETYPE)) {
            refType = att.get(DONOTSETIFNOTEXISTS_ATTRIBUTETYPE).toString().toUpperCase();
        }
        return refType;
    }

    private String getRefType(RoiXMLObject rxo, RoiXMLObjectAttribute rxoa) throws Exception {
        String refType = PATH_REFTYPE;
        Hashtable att = rxoa.getAttribute();
        if (att != null && att.containsKey(REFTYPE_ATTRIBUTETYPE)) {
            refType = att.get(REFTYPE_ATTRIBUTETYPE).toString().toUpperCase();
        }
        return refType;
    }

    private void putInternalVariable(Hashtable h, String key, String value) throws Exception {
        if (h.containsKey(key)) {
            h.remove(key);
        }
        h.put(key, value);
    }

    private String getVariableName(RoiXMLObject rxo, RoiXMLObjectAttribute rxoa) throws Exception {
        String variableName = null;
        Hashtable att = rxoa.getAttribute();
        if (att != null && att.containsKey(VARIABLENAME_ATTRIBUTETYPE)) {
            variableName = att.get(VARIABLENAME_ATTRIBUTETYPE).toString();
        }
        return variableName;
    }

    private void getArray(RoiXMLObject rxo, RoiXMLObjectAttribute rxoa, String datatype, ClassObjectClientBean co, AttributeValueBean avb) throws Exception {
        Object[] o = null;
        boolean buildAttribute = true;
        Vector roiXMLObjectAttribute = rxoa.getRoiXMLObjectAttribute();
        if (roiXMLObjectAttribute != null) {
            Object[] arr;
            int len = roiXMLObjectAttribute.size();
            long[] possArray = new long[len];
            avb.setAttributePos(possArray);
            if (datatype.equals("BOOLEAN_ARRAY")) {
                arr = new Boolean[len];
                o = arr;
            } else if (datatype.equals("DATE_ARRAY")) {
                arr = new Date[len];
                o = arr;
            } else if (datatype.equals("INTEGER_ARRAY")) {
                arr = new Integer[len];
                o = arr;
            } else if (datatype.equals("LONG_ARRAY")) {
                arr = new Long[len];
                o = arr;
            } else if (datatype.equals("DOUBLE_ARRAY")) {
                arr = new Double[len];
                o = arr;
            } else if (datatype.equals("STRING_ARRAY")) {
                arr = new String[len];
                o = arr;
            } else if (datatype.equals("GLOBALOBJECT_ARRAY")) {
                arr = new GlobalObjectClientBean[len];
                o = arr;
            } else if (datatype.equals("INTERNALOBJECT_ARRAY")) {
                arr = new InternalObjectClientBean[len];
                o = arr;
            } else if (datatype.equals("DATABASEOBJECT_ARRAY")) {
                arr = new DataBaseObjectClientBean[len];
                o = arr;
            } else if (datatype.equals("DIRECTORYOBJECT_ARRAY")) {
                arr = new DirectoryObjectClientBean[len];
                o = arr;
            }
            Enumeration attrEnum = roiXMLObjectAttribute.elements();
            int i = 0;
            String attributeValueType = null;
            while (attrEnum.hasMoreElements()) {
                RoiXMLObjectAttribute rxObjAtt = (RoiXMLObjectAttribute)attrEnum.nextElement();
                String value = this.getValue(rxo, rxObjAtt, rxObjAtt);
                if (i == 0) {
                    attributeValueType = rxObjAtt.getName();
                    if (rxObjAtt.getName().equalsIgnoreCase(ARRAYELEMENT_ATTRIBUTE)) {
                        avb.setAttributeValueType(0);
                    } else if (rxObjAtt.getName().equalsIgnoreCase(ADDARRAYELEMENT_ATTRIBUTE)) {
                        avb.setAttributeValueType(1);
                    } else if (rxObjAtt.getName().equalsIgnoreCase(INSERTARRAYELEMENTAT_ATTRIBUTE)) {
                        avb.setAttributeValueType(2);
                    } else if (rxObjAtt.getName().equalsIgnoreCase(REMOVEARRAYELEMENT_ATTRIBUTE)) {
                        avb.setAttributeValueType(3);
                    } else if (rxObjAtt.getName().equalsIgnoreCase(REMOVEARRAYELEMENTAT_ATTRIBUTE)) {
                        avb.setAttributeValueType(4);
                    }
                }
                if (!rxObjAtt.getName().equalsIgnoreCase(attributeValueType)) {
                    throw new Exception("mix from ArrayElements not allowd (" + attributeValueType + " and " + rxObjAtt.getName() + ")");
                }
                possArray[i] = this.getPosition(rxo, rxObjAtt);
                if (rxObjAtt.getName().equalsIgnoreCase(REMOVEARRAYELEMENTAT_ATTRIBUTE)) {
                    buildAttribute = false;
                } else if (rxObjAtt.getName().equalsIgnoreCase(ARRAYELEMENT_ATTRIBUTE) || rxObjAtt.getName().equalsIgnoreCase(ADDARRAYELEMENT_ATTRIBUTE) || rxObjAtt.getName().equalsIgnoreCase(INSERTARRAYELEMENTAT_ATTRIBUTE) || rxObjAtt.getName().equalsIgnoreCase(REMOVEARRAYELEMENT_ATTRIBUTE)) {
                    if (datatype.equals("BOOLEAN_ARRAY")) {
                        ((Boolean[])o)[i] = Boolean.valueOf(value);
                    } else if (datatype.equals("DATE_ARRAY")) {
                        ((Date[])o)[i] = this.getDate(rxo, rxObjAtt);
                    } else if (datatype.equals("INTEGER_ARRAY")) {
                        ((Integer[])o)[i] = new Integer(value);
                    } else if (datatype.equals("LONG_ARRAY")) {
                        ((Long[])o)[i] = new Long(value);
                    } else if (datatype.equals("DOUBLE_ARRAY")) {
                        ((Double[])o)[i] = new Double(value);
                    } else if (datatype.equals("STRING_ARRAY")) {
                        ((String[])o)[i] = value;
                    } else if (datatype.equals("GLOBALOBJECT_ARRAY")) {
                        ((GlobalObjectClientBean[])o)[i] = (GlobalObjectClientBean)this.getSuperObjectClientBean(rxo, rxObjAtt);
                    } else if (datatype.equals("INTERNALOBJECT_ARRAY")) {
                        ((InternalObjectClientBean[])o)[i] = (InternalObjectClientBean)this.getSuperObjectClientBean(rxo, rxObjAtt);
                    } else if (datatype.equals("DATABASEOBJECT_ARRAY")) {
                        ((DataBaseObjectClientBean[])o)[i] = (DataBaseObjectClientBean)this.getSuperObjectClientBean(rxo, rxObjAtt);
                    } else if (datatype.equals("DIRECTORYOBJECT_ARRAY")) {
                        ((DirectoryObjectClientBean[])o)[i] = (DirectoryObjectClientBean)this.getSuperObjectClientBean(rxo, rxObjAtt);
                    }
                }
                ++i;
            }
        }
        if (buildAttribute) {
            avb.setAttributeValue(AttributeValue.newAttributeValueObject(o));
        }
    }

    private String getEncoding(RoiXMLObject rxo, RoiXMLObjectAttribute rxoa) throws Exception {
        String encoding = "";
        Hashtable att = rxoa.getAttribute();
        if (att != null && att.containsKey(ENCODING_ATTRIBUTE)) {
            encoding = att.get(ENCODING_ATTRIBUTE).toString().toUpperCase();
        }
        return encoding;
    }

    private String getFormat(RoiXMLObject rxo, RoiXMLObjectAttribute rxoa) throws Exception {
        String format = DEFAULT_FORMAT;
        Hashtable att = rxoa.getAttribute();
        if (att != null && att.containsKey(FORMAT_ATTRIBUTETYPE)) {
            format = att.get(FORMAT_ATTRIBUTETYPE).toString();
        }
        return format;
    }

    private String getDataType(RoiXMLObject rxo, RoiXMLObjectAttribute rxoa) throws Exception {
        String datatype = "STRING";
        Hashtable att = rxoa.getAttribute();
        if (att != null && att.containsKey(DATATYPE_ATTRIBUTETYPE)) {
            datatype = att.get(DATATYPE_ATTRIBUTETYPE).toString();
        }
        return datatype;
    }

    private String getMethodDataType(RoiXMLObject rxo, RoiXMLObjectAttribute rxoa) throws Exception {
        String datatype = "STRING";
        Hashtable att = rxoa.getAttribute();
        if (att != null && att.containsKey(METHODDATATYPE_ATTRIBUTETYPE)) {
            datatype = att.get(METHODDATATYPE_ATTRIBUTETYPE).toString();
        }
        return datatype;
    }

    private long getPosition(RoiXMLObject rxo, RoiXMLObjectAttribute rxoa) throws Exception {
        long position = -1L;
        Hashtable att = rxoa.getAttribute();
        if (att != null && att.containsKey(POSITION_ATTRIBUTETYPE)) {
            position = Long.parseLong(att.get(POSITION_ATTRIBUTETYPE).toString());
        }
        return position;
    }

    private boolean getWithId(RoiXMLObject rxo, RoiXMLObjectAttribute rxoa) throws Exception {
        boolean withId = false;
        Hashtable att = rxoa.getAttribute();
        if (att != null && att.containsKey(WITHID_ATTRIBUTETYPE)) {
            withId = att.get(WITHID_ATTRIBUTETYPE).toString().equalsIgnoreCase("true");
        }
        return withId;
    }

    private String getClassName(RoiXMLObject rxo, RoiXMLObjectAttribute rxoa) throws Exception {
        String className = null;
        Hashtable att = rxoa.getAttribute();
        if (att != null && att.containsKey(CLASSNAME_ATTRIBUTETYPE)) {
            className = att.get(CLASSNAME_ATTRIBUTETYPE).toString().toUpperCase();
        }
        return className;
    }

    private String getPropertyBundle(RoiXMLObject rxo, RoiXMLObjectAttribute rxoa) throws Exception {
        String bundle = null;
        Hashtable att = rxoa.getAttribute();
        if (att != null && att.containsKey(PROPERTYBUNDLE_ATTRIBUTETYPE)) {
            bundle = att.get(PROPERTYBUNDLE_ATTRIBUTETYPE).toString();
            att.remove(PROPERTYBUNDLE_ATTRIBUTETYPE);
        }
        return bundle;
    }

    private String getMetaDbPropertyEntry(RoiXMLObject rxo, RoiXMLObjectAttribute rxoa) throws Exception {
        String bundle = null;
        Hashtable att = rxoa.getAttribute();
        if (att != null && att.containsKey(METADBPROPERTYENTRY_ATTRIBUTETYPE)) {
            bundle = att.get(METADBPROPERTYENTRY_ATTRIBUTETYPE).toString();
        }
        return bundle;
    }

    private String getValue(RoiXMLObject rxo, RoiXMLObjectAttribute rxoa, RoiXMLObjectAttribute rxoaValue) throws Exception {
        String metaDbPropertyEntry;
        String valueRet = rxoaValue.getValue();
        String bundleName = this.getPropertyBundle(rxo, rxoa);
        if (bundleName != null) {
            PropertyBundleObjectClientBean bundle = this.sessionController.getPropertyBundleByName(bundleName);
            if (bundle != null) {
                String propertyName = valueRet;
                PropertyObjectClientBean property = bundle.getProperty(propertyName);
                if (property == null) {
                    throw new Exception("Property " + propertyName + " from PropertyBundle " + bundleName + " not Found");
                }
                valueRet = property.getPropertyValue();
                rxoaValue.setValue(valueRet);
            } else {
                throw new Exception("PropertyBundle " + bundleName + " not Found");
            }
        }
        if ((metaDbPropertyEntry = this.getMetaDbPropertyEntry(rxo, rxoa)) != null) {
            String pos = "0";
            String propValueKey = metaDbPropertyEntry;
            try {
                int p1 = metaDbPropertyEntry.lastIndexOf("[");
                int p2 = metaDbPropertyEntry.lastIndexOf("]");
                if (p1 < p2) {
                    pos = metaDbPropertyEntry.substring(p1 + 1, p2);
                    propValueKey = metaDbPropertyEntry.substring(0, p1);
                }
            }
            catch (Exception p1) {
                // empty catch block
            }
            int p = -1;
            try {
                p = new Integer(pos);
            }
            catch (Exception e) {
                throw new Exception("MetaDbPropertyArray " + pos + " must by a int - Value");
            }
            if (p >= 0) {
                try {
                    MetaDb mdb = this.sessionController.getMetaDbInstance();
                    valueRet = mdb.getSimplePropertyValue(propValueKey)[p];
                }
                catch (Throwable e) {
                    throw new Exception("MetaDbPropertyEntry " + metaDbPropertyEntry + " not found (internal array : [" + p + "])");
                }
            } else {
                throw new Exception("MetaDbPropertyArray " + pos + " must by >= 0");
            }
        }
        if (this.getRefType(rxo, rxoa).equalsIgnoreCase(INTERNALVARIABLE_REFTYPE) || this.getUseInternalVariables(rxo, rxoa).equalsIgnoreCase("true")) {
            if (!this.getReplace(rxo, rxoa).equalsIgnoreCase("true")) {
                valueRet = this.internalVariables.containsKey(valueRet) ? (String)this.internalVariables.get(valueRet) : valueRet;
            } else {
                Enumeration en = this.internalVariables.keys();
                if (en != null) {
                    StringUtils su = new StringUtils();
                    while (en.hasMoreElements()) {
                        String key = (String)en.nextElement();
                        String value = (String)this.internalVariables.get(key);
                        valueRet = su.strReplace(valueRet, key, value);
                    }
                }
            }
        }
        return valueRet;
    }

    private Date getDate(RoiXMLObject rxo, RoiXMLObjectAttribute rxoa) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat(this.getFormat(rxo, rxoa));
        return sdf.parse(rxoa.getValue());
    }

    private AttributeValueBean getAttributeValue(RoiXMLObject rxo, RoiXMLObjectAttribute rxoa, ClassObjectClientBean co, Hashtable allAtt, Long id) throws Exception {
        AttributeValueBean avb = new AttributeValueBean();
        String attributeName = rxoa.getName().toUpperCase();
        AttributeObjectClientBean att = (AttributeObjectClientBean)allAtt.get(attributeName);
        if (att != null) {
            String datatype = att.getDataType();
            String value = this.getValue(rxo, rxoa, rxoa);
            if (datatype.equals("STRING")) {
                if (id != null && this.getWithId(rxo, rxoa)) {
                    value = this.su.strReplace(value, "$$ID$$", "" + id);
                }
                avb.setAttributeValue(AttributeValue.newAttributeValueObject(value));
            } else if (datatype.equals("CISTRING")) {
                if (id != null && this.getWithId(rxo, rxoa)) {
                    value = this.su.strReplace(value, "$$ID$$", "" + id);
                }
                avb.setAttributeValue(AttributeValue.newAttributeValueCIObject(value));
            } else if (datatype.equals("LONGTEXT")) {
                avb.setAttributeValue(AttributeValue.newAttributeValueObject(value));
            } else if (datatype.equals("LONG")) {
                avb.setAttributeValue(AttributeValue.newAttributeValueObject(new Long(value)));
            } else if (datatype.equals("BOOLEAN")) {
                avb.setAttributeValue(AttributeValue.newAttributeValueObject(Boolean.valueOf(value)));
            } else if (datatype.equals("INTEGER")) {
                avb.setAttributeValue(AttributeValue.newAttributeValueObject(new Integer(value)));
            } else if (datatype.equals("DOUBLE")) {
                avb.setAttributeValue(AttributeValue.newAttributeValueObject(new Double(value)));
            } else if (datatype.equals("DATE")) {
                avb.setAttributeValue(AttributeValue.newAttributeValueObject(this.getDate(rxo, rxoa)));
            } else if (datatype.equals("DATABASEOBJECT")) {
                DataBaseObjectClientBean o = (DataBaseObjectClientBean)this.getSuperObjectClientBean(rxo, rxoa);
                if (o != null) {
                    avb.setAttributeValue(AttributeValue.newAttributeValueObject(o));
                }
            } else if (datatype.equals("GLOBALOBJECT")) {
                GlobalObjectClientBean o = (GlobalObjectClientBean)this.getSuperObjectClientBean(rxo, rxoa);
                if (o != null) {
                    avb.setAttributeValue(AttributeValue.newAttributeValueObject(o));
                }
            } else if (datatype.equals("INTERNALOBJECT")) {
                InternalObjectClientBean o = (InternalObjectClientBean)this.getSuperObjectClientBean(rxo, rxoa);
                if (o != null) {
                    avb.setAttributeValue(AttributeValue.newAttributeValueObject(o));
                }
            } else if (datatype.equals("DIRECTORYOBJECT")) {
                DirectoryObjectClientBean o = (DirectoryObjectClientBean)this.getSuperObjectClientBean(rxo, rxoa);
                if (o != null) {
                    avb.setAttributeValue(AttributeValue.newAttributeValueObject(o));
                }
            } else if (datatype.equals("BOOLEAN_ARRAY")) {
                this.getArray(rxo, rxoa, datatype, co, avb);
            } else if (datatype.equals("DATE_ARRAY")) {
                this.getArray(rxo, rxoa, datatype, co, avb);
            } else if (datatype.equals("INTEGER_ARRAY")) {
                this.getArray(rxo, rxoa, datatype, co, avb);
            } else if (datatype.equals("LONG_ARRAY")) {
                this.getArray(rxo, rxoa, datatype, co, avb);
            } else if (datatype.equals("DOUBLE_ARRAY")) {
                this.getArray(rxo, rxoa, datatype, co, avb);
            } else if (datatype.equals("STRING_ARRAY")) {
                this.getArray(rxo, rxoa, datatype, co, avb);
            } else if (datatype.equals("GLOBALOBJECT_ARRAY")) {
                this.getArray(rxo, rxoa, datatype, co, avb);
            } else if (datatype.equals("INTERNALOBJECT_ARRAY")) {
                this.getArray(rxo, rxoa, datatype, co, avb);
            } else if (datatype.equals("DATABASEOBJECT_ARRAY")) {
                this.getArray(rxo, rxoa, datatype, co, avb);
            } else if (datatype.equals("DIRECTORYOBJECT_ARRAY")) {
                this.getArray(rxo, rxoa, datatype, co, avb);
            }
        } else {
            throw new Exception("Attribute " + attributeName + " not Found in  Object " + co.getUniqueName());
        }
        return avb;
    }

    public void setSavePoint(String key, String value) {
        if (this.savepoint.containsKey(key)) {
            this.savepoint.remove(key);
        }
        this.savepoint.put(key, value);
    }

    public String getSavePoint(String key) throws Exception {
        String save = null;
        if (this.savepoint.containsKey(key)) {
            save = this.savepoint.get(key).toString();
        }
        if (save == null) {
            throw new Exception("SavePoint=\"" + key + "\" not define");
        }
        return save;
    }

    private class InvokeMethodAttribueBean {
        private Object value = null;
        private Object methodDataType = null;

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Object getMethodDataType() {
            return this.methodDataType;
        }

        public void setMethodDataType(Object methodDataType) {
            this.methodDataType = methodDataType;
        }
    }

    private class AttributeValueBean {
        private AttributeValue attributeValue = null;
        private int attributeValueType = 0;
        private long[] attributePos = null;

        public AttributeValue getAttributeValue() {
            return this.attributeValue;
        }

        public void setAttributeValue(AttributeValue attributeValue) {
            this.attributeValue = attributeValue;
        }

        public int getAttributeValueType() {
            return this.attributeValueType;
        }

        public void setAttributeValueType(int attributeValueType) {
            this.attributeValueType = attributeValueType;
        }

        public long[] getAttributePos() {
            return this.attributePos;
        }

        public void setAttributePos(long[] attributePos) {
            this.attributePos = attributePos;
        }
    }
}

