/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.metadb.util.cache;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.agceptit.metadb.client.common.MetaDbException;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyBundleObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyEntryObjectClientBean;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.metadb.common.MetaDbUtils;
import agorum.roi.metadb.util.cache.Bundle;
import agorum.roi.metadb.util.cache.Node;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Entry
extends Node {
    private static final int CONTENT_LENGTH_THRESHOLD = 2048;
    protected String[] value;
    protected boolean encrypted;

    public Entry(String path, Bundle parent, SessionController sessionController, MetaDb metaDb, MetaDbUtils metaDbUtils, Map<String, Node> cache, boolean initialize) {
        super(path, parent, sessionController, metaDb, metaDbUtils, cache);
        if (initialize) {
            this.initialize();
        }
    }

    private void initialize() {
        try {
            this.value = this.metaDb.getSimplePropertyValue(this.path);
        }
        catch (Exception e) {
            throw new MetaDbException("Could not initialize MetaDb entry at " + this.path, (Throwable)e);
        }
    }

    protected void setEncrypted(boolean encrypted) {
        this.setChanged(true);
        this.encrypted = encrypted;
    }

    @Override
    protected void commitImpl() {
        try {
            GlobalObjectClientBean existing = this.parent.clientBean.getItem(this.name);
            if (existing != null && !(existing instanceof MetaDbPropertyEntryObjectClientBean)) {
                existing.delete();
                existing = null;
            }
            if (this.encrypted) {
                this.createOrUpdate(this.parent.clientBean, existing, this.name, 8192L, this.value[0]);
            } else if (this.value.length == 1) {
                String saveValue = this.value[0];
                if (saveValue != null && (saveValue.length() > 2048 || saveValue.contains("\n") || saveValue.contains("\r") || saveValue.contains("||") || saveValue.contains("&&"))) {
                    this.createOrUpdate(this.parent.clientBean, existing, this.name, 4096L, saveValue);
                } else {
                    this.createOrUpdate(this.parent.clientBean, existing, this.name, 1L, saveValue);
                }
            } else {
                this.createOrUpdate(this.parent.clientBean, existing, this.name, 64L, this.value);
            }
        }
        catch (Exception e) {
            throw new MetaDbException("Could not create MetaDb entry " + this.path, (Throwable)e);
        }
    }

    @Override
    protected void deleteImpl() {
    }

    @Override
    protected List<String> listImpl(boolean bundles) {
        throw new IllegalArgumentException("Cannot list MetaDb entry " + this.path);
    }

    @Override
    protected String[] getImpl() {
        return this.value;
    }

    @Override
    protected boolean setImpl(String[] value) {
        if (value == null || value.length <= 0) {
            value = new String[]{""};
        }
        if (Arrays.equals(this.value, value)) {
            return false;
        }
        this.value = value;
        return true;
    }

    private MetaDbPropertyEntryObjectClientBean createOrUpdate(MetaDbPropertyBundleObjectClientBean bundle, GlobalObjectClientBean existing, String entryName, long entryDataType, Object data) throws Exception {
        if (existing != null) {
            return this.metaDbUtils.updateMetaDbPropertyEntryObjectClientBean(bundle, (MetaDbPropertyEntryObjectClientBean)existing, entryName, entryDataType, data, true);
        }
        return this.metaDbUtils.createMetaDbPropertyEntryObjectClientBean(bundle, null, entryName, entryDataType, data, true);
    }
}

