/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.metadb.interfaces;

import agorum.agceptit.metadb.client.beans.DeploymentDescriptorBean;
import agorum.agceptit.metadb.client.beans.GetPropertyBean;
import agorum.agceptit.metadb.client.beans.ListPropertyBean;
import agorum.agceptit.metadb.client.beans.PropertyBundleBean;
import agorum.agceptit.metadb.client.beans.PropertyElementBean;
import agorum.agceptit.metadb.client.beans.PropertyEntryBean;
import agorum.agceptit.metadb.client.beans.PropertyIdentifierBean;
import agorum.agceptit.metadb.client.beans.TypeMappingBean;
import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.agceptit.metadb.client.common.MetaDbEnvironment;
import agorum.agceptit.metadb.client.common.MetaDbException;
import agorum.agceptit.metadb.client.interfaces.MetaDbAccessorInterface;
import agorum.agceptit.metadb.client.statistic.MetaDbStatistic;
import agorum.commons.statistic.SystemStatistic;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.metadb.cache.MetaDbCache;
import agorum.roi.metadb.cache.beans.BundleBean;
import agorum.roi.metadb.cache.beans.EntryBean;
import agorum.roi.metadb.cache.beans.NodeBean;
import agorum.roi.metadb.common.MetaDbEntryUtils;
import agorum.roi.metadb.common.MetaDbUtils;
import java.util.ArrayList;
import java.util.List;

public class MetaDbRoiAccessorImpl
implements MetaDbAccessorInterface {
    private static final SystemStatistic stat = MetaDbStatistic.getInstance();
    private static final MetaDbCache cache = MetaDbCache.getInstance();
    private static final String[] changes = new String[]{"all"};

    public PropertyElementBean getElement(PropertyIdentifierBean identifier, MetaDbEnvironment mdbEnv) throws MetaDbException {
        NodeBean nodeBean;
        if (cache == null) {
            return null;
        }
        String key = identifier.getPropertyKey();
        try {
            nodeBean = cache.get(key);
        }
        catch (Exception e) {
            throw new MetaDbException((Throwable)e);
        }
        if (nodeBean instanceof BundleBean) {
            BundleBean bundleBean = (BundleBean)nodeBean;
            PropertyBundleBean bundle = new PropertyBundleBean();
            bundle.setId(bundleBean.getId().toString());
            bundle.setName(bundleBean.getName());
            bundle.setKey(key);
            return bundle;
        }
        if (nodeBean instanceof EntryBean) {
            MetaDbEntryUtils mdbeu = new MetaDbEntryUtils((SessionController)mdbEnv.getParameter("sessionController"));
            EntryBean entryBean = (EntryBean)nodeBean;
            PropertyEntryBean entry = new PropertyEntryBean();
            entry.setId(entryBean.getId().toString());
            entry.setName(entryBean.getName());
            entry.setKey(key);
            entry.setValue(this.replace(mdbeu, entryBean.getValue()));
            return entry;
        }
        return null;
    }

    public GetPropertyBean getProperty(PropertyIdentifierBean identifier, MetaDbEnvironment mdbEnv) throws MetaDbException {
        EntryBean entryBean;
        if (cache == null) {
            return null;
        }
        String key = identifier.getPropertyKey();
        try {
            entryBean = (EntryBean)cache.get(key);
        }
        catch (Exception e) {
            System.err.println("Error reading key: " + key);
            try {
                if (cache.get(key) instanceof BundleBean) {
                    System.out.println("[BUNDLE] ID: " + ((BundleBean)cache.get(key)).getId() + ", name: " + ((BundleBean)cache.get(key)).getName());
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            throw new MetaDbException((Throwable)e);
        }
        if (entryBean == null) {
            return null;
        }
        MetaDbEntryUtils mdbeu = new MetaDbEntryUtils((SessionController)mdbEnv.getParameter("sessionController"));
        PropertyEntryBean entry = new PropertyEntryBean();
        entry.setId(entryBean.getId().toString());
        entry.setName(entryBean.getName());
        entry.setKey(key);
        entry.setValue(this.replace(mdbeu, entryBean.getValue()));
        GetPropertyBean result = new GetPropertyBean();
        result.setId(key);
        result.setEntry(entry);
        return result;
    }

    public ListPropertyBean listPropertyBundle(PropertyIdentifierBean identifier, MetaDbEnvironment mdbEnv) throws MetaDbException {
        List<NodeBean> beans;
        BundleBean bundleBean;
        if (cache == null) {
            return null;
        }
        String key = identifier.getPropertyKey();
        try {
            bundleBean = (BundleBean)cache.get(key);
        }
        catch (Exception e) {
            throw new MetaDbException((Throwable)e);
        }
        if (bundleBean == null) {
            return null;
        }
        try {
            beans = cache.list(key, null);
        }
        catch (Exception e) {
            throw new MetaDbException((Throwable)e);
        }
        if (beans == null) {
            return null;
        }
        ArrayList<Object> elements = new ArrayList<Object>(beans.size());
        MetaDbEntryUtils mdbeu = new MetaDbEntryUtils((SessionController)mdbEnv.getParameter("sessionController"));
        for (NodeBean bean : beans) {
            if (bean instanceof BundleBean) {
                PropertyBundleBean bundle = new PropertyBundleBean();
                bundle.setId(bean.getId().toString());
                bundle.setKey(key + "/" + bean.getName());
                bundle.setName(bean.getName());
                elements.add(bundle);
                continue;
            }
            if (!(bean instanceof EntryBean)) continue;
            EntryBean entryBean = (EntryBean)bean;
            PropertyEntryBean entry = new PropertyEntryBean();
            entry.setId(bean.getId().toString());
            entry.setKey(key + "/" + bean.getName());
            entry.setName(bean.getName());
            entry.setValue(this.replace(mdbeu, entryBean.getValue()));
            elements.add(entry);
        }
        ListPropertyBean result = new ListPropertyBean();
        result.setId(bundleBean.getId().toString());
        result.setElements(elements.toArray(new PropertyElementBean[elements.size()]));
        return result;
    }

    public String connect(MetaDbEnvironment mdbEnv) throws MetaDbException {
        try {
            SessionController sessionController = (SessionController)mdbEnv.getParameter("sessionController");
            if (sessionController == null) {
                String userName = (String)mdbEnv.getParameter("userName");
                String passWord = (String)mdbEnv.getParameter("passWord");
                CredentialObject credentialObject = new CredentialObject();
                credentialObject.setUserName(userName);
                credentialObject.setPassWord(passWord);
                credentialObject.setModulInfo("MetaDbRoiAccessorImpl");
                sessionController = SessionController.connect(credentialObject);
                mdbEnv.setParameter("sessionController", (Object)sessionController);
            } else {
                sessionController.reconnectIfNeeded();
            }
            try {
                sessionController.isConnected();
            }
            catch (Exception e) {
                throw new MetaDbException("MetaDb authentification failed", "agorum.agceptit.metadb.remote.exception.AuthentificationFailed", 4003);
            }
            return "" + sessionController.getSessionId();
        }
        catch (Throwable t) {
            stat.debug(t);
            if (t instanceof MetaDbException) {
                throw (MetaDbException)t;
            }
            throw new MetaDbException(t.getMessage(), "agorum.agceptit.metadb.remote.exception.Unknown", 4000);
        }
    }

    public boolean isConnected(MetaDbEnvironment mdbEnv) throws MetaDbException {
        SessionController sessionController = (SessionController)mdbEnv.getParameter("sessionController");
        boolean bRet = true;
        try {
            sessionController.isConnected();
        }
        catch (Exception e) {
            bRet = false;
        }
        return bRet;
    }

    public DeploymentDescriptorBean getDeploymentDescriptor(String serviceName, MetaDbEnvironment mdbEnv) throws MetaDbException {
        DeploymentDescriptorBean dd;
        block12: {
            SessionController sessionController = (SessionController)mdbEnv.getParameter("sessionController");
            dd = new DeploymentDescriptorBean();
            try {
                MetaDb mdb = sessionController.getMetaDbInstance();
                String testKey = "MAIN_MODULE_MANAGEMENT/dynawebservices/providers/" + serviceName;
                String[] test = mdb.listSimplePropertyBundle(testKey);
                if (test == null) {
                    String msg = "Provider not found: " + serviceName + "\nlook for key: " + testKey;
                    stat.debug(msg);
                    throw new MetaDbException(msg, "agorum.agceptit.metadb.remote.exception.PropertyNotFound", 4001);
                }
                String key = "MAIN_MODULE_MANAGEMENT/dynawebservices/providers/" + serviceName + "/beans";
                String[] beanNames = mdb.listSimplePropertyBundle(key);
                TypeMappingBean[] tms = null;
                if (beanNames != null) {
                    int len = beanNames.length;
                    tms = new TypeMappingBean[len];
                    for (int i = 0; i < len; ++i) {
                        String beanClass = null;
                        key = "MAIN_MODULE_MANAGEMENT/dynawebservices/providers/" + serviceName + "/beans/" + beanNames[i] + "/class";
                        try {
                            beanClass = mdb.getSimplePropertyValue(key)[0];
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (beanClass == null) {
                            String msg = "Class for bean " + beanNames[i] + " not defined\nlook for key: \"" + key + "\"";
                            stat.debug(msg);
                            throw new MetaDbException(msg, "agorum.agceptit.metadb.remote.exception.PropertyNotFound", 4001);
                        }
                        tms[i] = new TypeMappingBean();
                        tms[i].setBeanName(beanNames[i]);
                        tms[i].setBeanClass(beanClass);
                    }
                }
                dd.setTypeMappings(tms);
                key = "MAIN_MODULE_MANAGEMENT/dynawebservices/providers/" + serviceName + "/methods";
                String[] methods = mdb.listSimplePropertyBundle(key);
                if (methods == null) {
                    String msg = "Provider " + serviceName + " has no methods defined\nlook for key: \"" + key + "\"";
                    stat.debug(msg);
                    throw new MetaDbException(msg, "agorum.agceptit.metadb.remote.exception.PropertyNotFound", 4001);
                }
                dd.setMethods(methods);
                String providerClass = null;
                key = "MAIN_MODULE_MANAGEMENT/dynawebservices/providers/" + serviceName + "/class";
                try {
                    providerClass = mdb.getSimplePropertyValue(key)[0];
                }
                catch (Exception beanClass) {
                    // empty catch block
                }
                if (providerClass == null) {
                    String msg = "Class definition for Provider " + serviceName + " is not defined\nlook for key: \"" + key + "\"";
                    stat.debug(msg);
                    throw new MetaDbException(msg, "agorum.agceptit.metadb.remote.exception.PropertyNotFound", 4001);
                }
                dd.setProviderClass(providerClass);
            }
            catch (Throwable e) {
                stat.debug(e);
                if (!(e instanceof MetaDbException)) break block12;
                throw (MetaDbException)e;
            }
        }
        return dd;
    }

    public String[] getPropertyChanges(MetaDbEnvironment mdbEnv) throws MetaDbException {
        return changes;
    }

    private String[] replace(MetaDbEntryUtils mdbeu, String[] values) {
        if (values != null) {
            values = (String[])values.clone();
        }
        values = mdbeu.replaceBasicKeywords(values);
        MetaDbUtils.replaceAdvanced(values);
        return values;
    }
}

