/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.metadb.common;

import agorum.agceptit.metadb.client.beans.PropertyElementBean;
import agorum.agceptit.metadb.client.beans.PropertyIdentifierBean;
import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.cache.GenericCache;
import agorum.commons.string.StringUtils;
import agorum.commons.system.SystemProperties;
import agorum.commons.system.SystemTools;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyBundleObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyBundleObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.MetaDbPropertyEntryObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyGroupObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyGroupObjectClientBeanDefinition;
import agorum.roi.ejb.common.AssociatedGroupOfDirectoryObject;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.metadb.beans.MetaDbPropertyBean;
import agorum.roi.metadb.beans.MetaDbPropertyBundleBean;
import agorum.roi.metadb.beans.MetaDbPropertyEntryBean;
import agorum.roi.metadb.beans.MetaDbPropertyGroupBean;
import agorum.roi.metadb.beans.MetaDbReturnBean;
import agorum.roi.metadb.common.MetaDbEntryUtils;
import agorum.roi.sessionfacade.beans.MetaDbPropertyEntryObjectSessionFacade;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MetaDbUtils {
    private SessionController sessionController = null;
    private FolderObjectClientBean globalMetaDbBasePath = null;
    public static final String METADB_BASE_PATH = "/agorum/ngos/MetaDb";
    private String lastFoundId = null;
    private GenericCache gc = null;

    public MetaDbUtils(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public void setMetaDbBasePath(FolderObjectClientBean metaDbBasePath) {
        this.globalMetaDbBasePath = metaDbBasePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FolderObjectClientBean getMetaDbBasePath() throws Exception {
        String output = "";
        try {
            if (this.globalMetaDbBasePath != null) {
                output = output + "is set, use it: " + this.globalMetaDbBasePath + "\n";
                FolderObjectClientBean folderObjectClientBean = this.globalMetaDbBasePath;
                return folderObjectClientBean;
            }
            this.gc = MetaDbUtils.getCache();
            String key = "" + this.sessionController.getSessionId();
            output = output + "get out of cache: " + key + "\n";
            if (this.gc.contains((Object)key)) {
                output = output + "is in cache\n";
                FolderObjectClientBean folderObjectClientBean = this.globalMetaDbBasePath = (FolderObjectClientBean)this.gc.get((Object)key);
                return folderObjectClientBean;
            }
            this.globalMetaDbBasePath = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPathFromRoot(METADB_BASE_PATH);
            output = output + "find by path: /agorum/ngos/MetaDb\n";
            if (this.gc.contains((Object)key)) {
                this.gc.remove((Object)key);
            }
            output = output + "put to cache: key, " + this.globalMetaDbBasePath + "\n";
            this.gc.put((Object)key, (Object)this.globalMetaDbBasePath);
            FolderObjectClientBean folderObjectClientBean = this.globalMetaDbBasePath;
            return folderObjectClientBean;
        }
        finally {
            if (this.globalMetaDbBasePath == null) {
                System.err.println("Something wrong in getMetaDbBasePath: " + output);
            }
        }
    }

    public static FolderObjectClientBean getMetaDbBasePath(SessionController sessionController) throws Exception {
        FolderObjectClientBean metaDbBasePath = (FolderObjectClientBean)sessionController.findGlobalObjectByPath(METADB_BASE_PATH);
        return metaDbBasePath;
    }

    public MetaDbPropertyBean[] getItems(String path, FolderObjectClientBean fromFolder) throws Exception {
        return this.getItems(path, fromFolder, false);
    }

    public MetaDbPropertyBean[] getItems(String path, FolderObjectClientBean fromFolder, boolean notCached) throws Exception {
        return this.getItems(this.sessionController, path, fromFolder, notCached);
    }

    public MetaDbPropertyBean[] getItems(String path, MetaDbPropertyBundleBean bundle) throws Exception {
        return this.getItems(path, bundle, false);
    }

    public MetaDbPropertyBean[] getItems(String path, MetaDbPropertyBundleBean bundle, boolean notCached) throws Exception {
        return this.getItems(this.sessionController, path, bundle, notCached);
    }

    public MetaDbPropertyBean findByPath(String path) throws Exception {
        return this.findByPath(path, false);
    }

    public MetaDbPropertyBean findByPath(String path, boolean notCached) throws Exception {
        return this.findByPath(path, this.getMetaDbBasePath(), false, notCached);
    }

    public MetaDbPropertyBean findByPath(String path, GlobalObjectClientBean metaDbBasePath) throws Exception {
        return this.findByPath(path, metaDbBasePath, false, false);
    }

    public MetaDbPropertyBean findByPath(String path, GlobalObjectClientBean metaDbBasePath, boolean notCached) throws Exception {
        return this.findByPath(path, metaDbBasePath, false, notCached);
    }

    public MetaDbPropertyBean findByPath(String path, GlobalObjectClientBean metaDbBasePath, boolean withId, boolean notCached) throws Exception {
        if (path != null) {
            MetaDbReturnBean mrb = this.findByPathInternal(this.sessionController, metaDbBasePath, path, withId, notCached);
            this.lastFoundId = mrb.getLastFolderId();
            return mrb.getMetaDbPropertyBean();
        }
        return null;
    }

    public void printMetaDbStructur() throws Exception {
        this.printMetaDbStructur(this.getMetaDbBasePath());
    }

    public void printMetaDbStructur(FolderObjectClientBean startPath) throws Exception {
        this.printMetaDbStructurIntern("", this.getItems(null, startPath));
    }

    private void printMetaDbStructurIntern(String offset, MetaDbPropertyBean[] items) throws Exception {
        if (items != null) {
            int len = items.length;
            for (int i = 0; i < len; ++i) {
                if (items[i] instanceof MetaDbPropertyBundleBean) {
                    System.err.println(offset + items[i].getName());
                    FolderObjectClientBean folder = (FolderObjectClientBean)this.sessionController.getGlobalObjectById(items[i].getId());
                    this.printMetaDbStructurIntern(offset + "  ", this.getItems(null, folder));
                    continue;
                }
                if (!(items[i] instanceof MetaDbPropertyEntryBean)) continue;
                System.err.println(offset + items[i].getName() + "=" + ((MetaDbPropertyEntryBean)items[i]).getStringValue());
            }
        }
    }

    public void hasDuplicatEntry(GlobalObjectClientBean lo, GlobalObjectClientBean ro) throws Exception {
        MetaDbPropertyBundleBean[] loPB = this.getFirstBundles(lo);
        MetaDbPropertyBean[] roItems = null;
        if (ro instanceof MetaDbPropertyEntryObjectClientBean || ro instanceof MetaDbPropertyBundleObjectClientBean) {
            roItems = new MetaDbPropertyBean[]{this.getMetaDbPropertyBean(ro)};
        } else if (ro instanceof MetaDbPropertyGroupObjectClientBean) {
            roItems = this.getItems(null, (FolderObjectClientBean)ro);
        }
        if (roItems != null && loPB != null) {
            int lenPB = loPB.length;
            for (int y = 0; y < lenPB; ++y) {
                FolderObjectClientBean folder = (FolderObjectClientBean)this.sessionController.getGlobalObjectById(loPB[y].getId());
                MetaDbPropertyBean[] myItems = this.getItems(null, folder);
                if (myItems == null) continue;
                int lenB = myItems.length;
                int lenG = roItems.length;
                for (int i = 0; i < lenB; ++i) {
                    for (int k = 0; k < lenG; ++k) {
                        if (!myItems[i].getName().equalsIgnoreCase(roItems[k].getName())) continue;
                        String loString = lo.getName();
                        String roString = ro.getName();
                        String itemsPath = myItems[i].getName();
                        String roItemsPath = roItems[k].getName();
                        ExceptionUtils.handleException("Duplicate entry by MetaDb (lo.Name = " + loString + ", ro.Name = " + roString + "\nItemPath = " + itemsPath + "\nroItemPath = " + roItemsPath + ")", "agorum.roi.remote.exception.DuplicteEntry", 70);
                    }
                }
            }
        }
    }

    public MetaDbPropertyBundleBean[] getFirstBundles(GlobalObjectClientBean source) throws Exception {
        return this.getFirstBundles(this.sessionController, source, false);
    }

    public String[] replaceStringValue(MetaDbPropertyEntryBean openEntry, long entryDataType) throws Exception {
        String[] valueArray = null;
        Object o = openEntry.getValueObject(entryDataType);
        if (o instanceof String) {
            valueArray = new String[]{(String)o};
        } else if (o instanceof String[]) {
            valueArray = (String[])o;
        }
        if (valueArray != null) {
            MetaDbEntryUtils metaDbEntryUtils = new MetaDbEntryUtils(this.sessionController);
            valueArray = metaDbEntryUtils.replaceBasicKeywords(valueArray);
            valueArray = this.replaceAdvancedKeywords(valueArray);
        }
        return valueArray;
    }

    public String getLastFoundId() {
        return this.lastFoundId;
    }

    @Deprecated
    private String[] replaceAdvancedKeywords(String[] sArr) {
        MetaDbUtils.replaceAdvanced(sArr);
        return sArr;
    }

    public static void replaceAdvanced(String[] sArr) {
        if (sArr == null) {
            return;
        }
        SystemTools systemTools = new SystemTools();
        int len = sArr.length;
        for (int i = 0; i < len; ++i) {
            sArr[i] = systemTools.replaceIp(sArr[i]);
        }
    }

    public GlobalObjectClientBean createMetaDbPath(String[] names, String[] classNames) throws Exception {
        return this.createMetaDbPath(this.getMetaDbBasePath(), names, classNames);
    }

    /*
     * Enabled aggressive block sorting
     */
    public GlobalObjectClientBean createMetaDbPath(FolderObjectClientBean startFolder, String[] names, String[] classNames) throws Exception {
        FolderObjectClientBean cbRet;
        block8: {
            cbRet = null;
            if (names == null || classNames == null || names.length != classNames.length || startFolder == null) break block8;
            FolderObjectClientBean myRoot = startFolder;
            int len = names.length;
            for (int i = 0; i < len; ++i) {
                GlobalObjectClientBean myCb;
                block7: {
                    block9: {
                        FolderObjectClientBeanDefinition def;
                        myCb = myRoot.getItem(names[i]);
                        if (myCb != null) break block9;
                        if (classNames[i].equalsIgnoreCase(MetaDbPropertyGroupObjectClientBean.CLASS_NAME)) {
                            def = new MetaDbPropertyGroupObjectClientBeanDefinition(this.sessionController);
                            def.setName(names[i]);
                            myCb = this.sessionController.createGlobalObject(def);
                            myRoot.addItem(myCb);
                            break block7;
                        } else if (classNames[i].equalsIgnoreCase(MetaDbPropertyBundleObjectClientBean.CLASS_NAME)) {
                            def = new MetaDbPropertyBundleObjectClientBeanDefinition(this.sessionController);
                            def.setName(names[i]);
                            myCb = this.sessionController.createGlobalObject(def);
                            myRoot.addItem(myCb);
                            break block7;
                        } else {
                            cbRet = null;
                            break;
                        }
                    }
                    if (!myCb.getClassName().equalsIgnoreCase(classNames[i])) {
                        cbRet = null;
                        break;
                    }
                }
                cbRet = myRoot = (FolderObjectClientBean)myCb;
            }
        }
        if (cbRet != null) {
            return cbRet;
        }
        System.err.println("createMetaDbPath path : null");
        return cbRet;
    }

    public MetaDbPropertyEntryObjectClientBean createMetaDbPropertyEntryObjectClientBean(FolderObjectClientBean bundle, String entryName, long entryDataType, Object data) throws Exception {
        return this.createMetaDbPropertyEntryObjectClientBean(bundle, entryName, entryDataType, data, false);
    }

    public MetaDbPropertyEntryObjectClientBean createMetaDbPropertyEntryObjectClientBean(FolderObjectClientBean bundle, String entryName, long entryDataType, Object data, boolean notCached) throws Exception {
        MetaDbPropertyEntryBean entry = (MetaDbPropertyEntryBean)this.findByPath(entryName, bundle, notCached);
        return this.createMetaDbPropertyEntryObjectClientBean(bundle, entry, entryName, entryDataType, data, notCached);
    }

    public MetaDbPropertyEntryObjectClientBean createMetaDbPropertyEntryObjectClientBean(FolderObjectClientBean bundle, MetaDbPropertyEntryBean entry, String entryName, long entryDataType, Object data, boolean notCached) throws Exception {
        MetaDbPropertyEntryObjectClientBean entryRet = null;
        if (entry == null) {
            MetaDbPropertyEntryObjectSessionFacade facadeEntry = new MetaDbPropertyEntryObjectSessionFacade(this.sessionController);
            facadeEntry.setWithTransaction(true);
            facadeEntry.setDestinationFolder(bundle);
            if (data != null) {
                if (entryDataType == 2L) {
                    facadeEntry.setAttribute("BOOLEANVALUE", data);
                } else if (entryDataType == 1L) {
                    facadeEntry.setAttribute("STRINGVALUE", data);
                } else if (entryDataType == 4L) {
                    facadeEntry.setAttribute("INTVALUE", data);
                } else if (entryDataType == 8L) {
                    facadeEntry.setAttribute("LONGVALUE", data);
                } else if (entryDataType == 16L) {
                    facadeEntry.setAttribute("DATEVALUE", data);
                } else if (entryDataType == 32L) {
                    facadeEntry.setAttribute("DOUBLEVALUE", data);
                } else if (entryDataType == 64L) {
                    facadeEntry.setAttribute("STRINGARRAYVALUE", data);
                } else if (entryDataType == 128L) {
                    facadeEntry.setAttribute("BOOLEANARRAYVALUE", data);
                } else if (entryDataType == 256L) {
                    facadeEntry.setAttribute("INTARRAYVALUE", data);
                } else if (entryDataType == 512L) {
                    facadeEntry.setAttribute("LONGARRAYVALUE", data);
                } else if (entryDataType == 1024L) {
                    facadeEntry.setAttribute("DATEARRAYVALUE", data);
                } else if (entryDataType == 2048L) {
                    facadeEntry.setAttribute("DOUBLEARRAYVALUE", data);
                } else if (entryDataType == 4096L) {
                    if (data instanceof InputStream) {
                        facadeEntry.setContentStream((InputStream)data);
                    } else if (data instanceof String) {
                        StringUtils su = new StringUtils();
                        ByteArrayInputStream is = su.stringToStream((String)data, SystemProperties.getCharsetName());
                        facadeEntry.setContentStream(is);
                    } else {
                        ExceptionUtils.handleException("Content not supported for object" + data.getClass().getName(), "agorum.roi.remote.exception.NoAttributeValue", 72);
                    }
                } else if (entryDataType == 8192L) {
                    facadeEntry.setAttribute("STRINGVALUE", data);
                } else {
                    ExceptionUtils.handleException("EntryDataType not supported: " + entryDataType, "agorum.roi.remote.exception.NoAttributeValue", 72);
                }
                facadeEntry.setAttribute("ENTRYDATATYPE", new Long(entryDataType));
                if (entryName != null) {
                    facadeEntry.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, entryName);
                } else {
                    ExceptionUtils.handleException("EntryName must be defined ", "agorum.roi.remote.exception.NoAttributeValue", 72);
                }
            } else {
                ExceptionUtils.handleException("Data is null: " + entryDataType, "agorum.roi.remote.exception.NoAttributeValue", 72);
            }
            entryRet = (MetaDbPropertyEntryObjectClientBean)facadeEntry.create();
        } else {
            entryRet = (MetaDbPropertyEntryObjectClientBean)this.sessionController.getGlobalObjectById(entry.getId());
        }
        return entryRet;
    }

    public MetaDbPropertyEntryObjectClientBean updateMetaDbPropertyEntryObjectClientBean(FolderObjectClientBean bundle, String entryName, long entryDataType, Object data) throws Exception {
        return this.updateMetaDbPropertyEntryObjectClientBean(bundle, entryName, entryDataType, data, false);
    }

    public MetaDbPropertyEntryObjectClientBean updateMetaDbPropertyEntryObjectClientBean(FolderObjectClientBean bundle, String entryName, long entryDataType, Object data, boolean notCached) throws Exception {
        MetaDbPropertyEntryObjectClientBean entryObject = (MetaDbPropertyEntryObjectClientBean)this.sessionController.getGlobalObjectById(this.findByPath(entryName, bundle, notCached).getId());
        return this.updateMetaDbPropertyEntryObjectClientBean(bundle, entryObject, entryName, entryDataType, data, notCached);
    }

    public MetaDbPropertyEntryObjectClientBean updateMetaDbPropertyEntryObjectClientBean(FolderObjectClientBean bundle, MetaDbPropertyEntryObjectClientBean entryObject, String entryName, long entryDataType, Object data, boolean notCached) throws Exception {
        if (entryObject != null) {
            MetaDbPropertyEntryObjectSessionFacade facadeEntry = new MetaDbPropertyEntryObjectSessionFacade(this.sessionController);
            facadeEntry.setWithTransaction(true);
            facadeEntry.setGlobalObject(entryObject);
            if (data != null) {
                if (entryDataType == 2L) {
                    facadeEntry.setAttribute("BOOLEANVALUE", data);
                } else if (entryDataType == 1L) {
                    facadeEntry.setAttribute("STRINGVALUE", data);
                } else if (entryDataType == 4L) {
                    facadeEntry.setAttribute("INTVALUE", data);
                } else if (entryDataType == 8L) {
                    facadeEntry.setAttribute("LONGVALUE", data);
                } else if (entryDataType == 16L) {
                    facadeEntry.setAttribute("DATEVALUE", data);
                } else if (entryDataType == 32L) {
                    facadeEntry.setAttribute("DOUBLEVALUE", data);
                } else if (entryDataType == 64L) {
                    facadeEntry.setAttribute("STRINGARRAYVALUE", data);
                } else if (entryDataType == 128L) {
                    facadeEntry.setAttribute("BOOLEANARRAYVALUE", data);
                } else if (entryDataType == 256L) {
                    facadeEntry.setAttribute("INTARRAYVALUE", data);
                } else if (entryDataType == 512L) {
                    facadeEntry.setAttribute("LONGARRAYVALUE", data);
                } else if (entryDataType == 1024L) {
                    facadeEntry.setAttribute("DATEARRAYVALUE", data);
                } else if (entryDataType == 2048L) {
                    facadeEntry.setAttribute("DOUBLEARRAYVALUE", data);
                } else if (entryDataType == 4096L) {
                    if (data instanceof InputStream) {
                        facadeEntry.setContentStream((InputStream)data);
                    } else if (data instanceof String) {
                        StringUtils su = new StringUtils();
                        ByteArrayInputStream is = su.stringToStream((String)data, SystemProperties.getCharsetName());
                        facadeEntry.setContentStream(is);
                    } else {
                        ExceptionUtils.handleException("Content not supported for object" + data.getClass().getName(), "agorum.roi.remote.exception.NoAttributeValue", 72);
                    }
                } else if (entryDataType == 8192L) {
                    facadeEntry.setAttribute("STRINGVALUE", data);
                } else {
                    ExceptionUtils.handleException("EntryDataType not supported: " + entryDataType, "agorum.roi.remote.exception.NoAttributeValue", 72);
                }
                facadeEntry.setAttribute("ENTRYDATATYPE", new Long(entryDataType));
            } else {
                ExceptionUtils.handleException("Data is null: " + entryDataType, "agorum.roi.remote.exception.NoAttributeValue", 72);
            }
            entryObject = (MetaDbPropertyEntryObjectClientBean)facadeEntry.update();
        }
        return entryObject;
    }

    public MetaDbPropertyEntryObjectClientBean createOrUpdateMetaDbPropertyEntryObjectClientBean(FolderObjectClientBean bundle, String entryName, long entryDataType, Object data) throws Exception {
        return this.createOrUpdateMetaDbPropertyEntryObjectClientBean(bundle, entryName, entryDataType, data, false);
    }

    public MetaDbPropertyEntryObjectClientBean createOrUpdateMetaDbPropertyEntryObjectClientBean(FolderObjectClientBean bundle, String entryName, long entryDataType, Object data, boolean notCached) throws Exception {
        MetaDbPropertyEntryBean entry = (MetaDbPropertyEntryBean)this.findByPath(entryName, bundle, notCached);
        if (entry != null) {
            return this.updateMetaDbPropertyEntryObjectClientBean(bundle, entryName, entryDataType, data, notCached);
        }
        return this.createMetaDbPropertyEntryObjectClientBean(bundle, entryName, entryDataType, data, notCached);
    }

    private MetaDbPropertyBean getMetaDbPropertyBean(GlobalObjectClientBean globalObject) throws Exception {
        MetaDbPropertyBean mdb = null;
        if (globalObject instanceof MetaDbPropertyBundleObjectClientBean) {
            mdb = new MetaDbPropertyBundleBean();
        } else if (globalObject instanceof MetaDbPropertyEntryObjectClientBean) {
            mdb = new MetaDbPropertyEntryBean();
        } else if (globalObject instanceof MetaDbPropertyGroupObjectClientBean) {
            mdb = new MetaDbPropertyGroupBean();
        }
        ((MetaDbPropertyBean)mdb).fillBeanFromGlobalObject(globalObject);
        return mdb;
    }

    private static GenericCache getCache() throws Exception {
        GenericCache gc = GenericCache.getInstance((Object)"MetaDbUtilsBasePathCache", (int)Integer.MAX_VALUE, (int)10000, (int)600000);
        return gc;
    }

    public AssociatedGroupOfDirectoryObject[] getAllGroupsOfActualUser() throws Exception {
        AssociatedGroupOfDirectoryObject[] asso = this.sessionController.getAssociatedGroupOfDirectoryObject(this.sessionController.getLoginUser(), 0, true);
        return asso;
    }

    public Vector getAllDriveLocations(String uniqueId) throws Throwable {
        MetaDb metaDb = this.sessionController.getMetaDbInstance();
        Vector<PropertyElementBean[]> allLists = new Vector<PropertyElementBean[]>();
        PropertyIdentifierBean identifierMachine = new PropertyIdentifierBean();
        identifierMachine.setPropertyKey("MAIN_MACHINE_MANAGEMENT/" + uniqueId + "/LOCATIONS");
        PropertyElementBean[] machineList = metaDb.listPropertyBundle(identifierMachine, 1);
        allLists.add(machineList);
        AssociatedGroupOfDirectoryObject[] asso = this.sessionController.getAssociatedGroupOfDirectoryObject(this.sessionController.getLoginUser(), 0, true);
        if (asso != null) {
            int len = asso.length;
            for (int i = 0; i < len; ++i) {
                PropertyIdentifierBean identifierGroup = new PropertyIdentifierBean();
                identifierGroup.setPropertyKey("MAIN_GROUP_MANAGEMENT/" + asso[i].getDirectoryObjectClientBean().getName() + "/LOCATIONS");
                PropertyElementBean[] groupList = metaDb.listPropertyBundle(identifierGroup, 1);
                allLists.add(groupList);
            }
        }
        PropertyIdentifierBean identifierUser = new PropertyIdentifierBean();
        identifierUser.setPropertyKey("MAIN_USER_MANAGEMENT/" + this.sessionController.getLoginUser().getName() + "/LOCATIONS");
        PropertyElementBean[] userList = metaDb.listPropertyBundle(identifierUser, 1);
        allLists.add(userList);
        int size = allLists.size();
        Vector<String> resultList = new Vector<String>();
        for (int i = 0; i < size; ++i) {
            PropertyElementBean[] propElArr = (PropertyElementBean[])allLists.elementAt(i);
            if (propElArr == null) continue;
            int len = propElArr.length;
            for (int j = 0; j < len; ++j) {
                String key = propElArr[j].getKey();
                resultList.addElement(key);
            }
        }
        return resultList;
    }

    public void setParameterHash(Hashtable parameters, String path) throws Exception {
        String names = "";
        String values = "";
        String sep = "";
        Enumeration keyEnum = parameters.keys();
        while (keyEnum.hasMoreElements()) {
            String key = (String)keyEnum.nextElement();
            names = names + sep + key;
            values = values + sep + (String)parameters.get(key);
            if (sep.length() != 0) continue;
            sep = "||";
        }
        StringUtils su = new StringUtils();
        String[] parameterNames = su.getStringArrayFromString(names, "||");
        String[] parameterValues = su.getStringArrayFromString(values, "||");
        this.setParameterHash(parameterNames, parameterValues, path);
    }

    public void setParameterHash(String[] parameterNames, String[] parameterValues, String path) throws Exception {
        MetaDbPropertyBean bundle = this.findByPath(path);
        MetaDbPropertyBundleObjectClientBean folder = (MetaDbPropertyBundleObjectClientBean)this.sessionController.getGlobalObjectById(bundle.getId());
        this.setParameterHash(parameterNames, parameterValues, folder);
    }

    public void setParameterHash(String[] parameterNames, String[] parameterValues, MetaDbPropertyBundleObjectClientBean folder) throws Exception {
        String folderPath = folder.getAnyFolderPath();
        GlobalObjectClientBean pnEntry = this.sessionController.findGlobalObjectByPath(folderPath + "/ParameterNames");
        MetaDbPropertyEntryObjectSessionFacade pnFacadeEntry = new MetaDbPropertyEntryObjectSessionFacade(this.sessionController);
        if (pnEntry == null) {
            pnFacadeEntry.setDestinationFolder(folder);
        } else {
            pnFacadeEntry.setGlobalObject(pnEntry);
        }
        pnFacadeEntry.setWithTransaction(true);
        pnFacadeEntry.setAttribute("STRINGARRAYVALUE", parameterNames);
        pnFacadeEntry.setAttribute("ENTRYDATATYPE", new Long(64L));
        pnFacadeEntry.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, "ParameterNames");
        if (pnEntry == null) {
            pnFacadeEntry.create();
        } else {
            pnFacadeEntry.update();
        }
        GlobalObjectClientBean pvEntry = this.sessionController.findGlobalObjectByPath(folderPath + "/ParameterValues");
        MetaDbPropertyEntryObjectSessionFacade pvFacadeEntry = new MetaDbPropertyEntryObjectSessionFacade(this.sessionController);
        if (pvEntry == null) {
            pvFacadeEntry.setDestinationFolder(folder);
        } else {
            pvFacadeEntry.setGlobalObject(pvEntry);
        }
        pvFacadeEntry.setWithTransaction(true);
        pvFacadeEntry.setAttribute("STRINGARRAYVALUE", parameterValues);
        pvFacadeEntry.setAttribute("ENTRYDATATYPE", new Long(64L));
        pvFacadeEntry.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, "ParameterValues");
        if (pvEntry == null) {
            pvFacadeEntry.create();
        } else {
            pvFacadeEntry.update();
        }
    }

    public ArrayList getObjectsFromPathEntries(String[] pathEntries, boolean createPath) throws Exception {
        return this.getObjectsFromPathEntries(pathEntries, createPath, null, null, null);
    }

    public ArrayList getObjectsFromPathEntries(String[] pathEntries, boolean createPath, Date date) throws Exception {
        return this.getObjectsFromPathEntries(pathEntries, createPath, null, null, date);
    }

    public ArrayList getObjectsFromPathEntries(String[] pathEntries, boolean createPath, FolderObjectClientBean startFolder, AccessControlListObjectClientBean acl, Date date) throws Exception {
        ArrayList<GlobalObjectClientBean> objects = new ArrayList<GlobalObjectClientBean>();
        RoiFileSystem rfs = new RoiFileSystem(this.sessionController);
        if (pathEntries != null) {
            int entriesLen = pathEntries.length;
            for (int i = 0; i < entriesLen; ++i) {
                String datePath;
                GlobalObjectClientBean object = null;
                String path = pathEntries[i].trim();
                if (path.matches("^\\s*\\d+\\s*;\\s*[^/\\\\].*$")) {
                    String[] idAndPath = path.split(";", 2);
                    FolderObjectClientBean sFolder = null;
                    try {
                        sFolder = (FolderObjectClientBean)this.sessionController.getGlobalObjectById(Long.valueOf(idAndPath[0].trim()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (sFolder != null) {
                        String datePath2 = idAndPath[1].trim();
                        if (datePath2.startsWith(".\\") || datePath2.startsWith("./")) {
                            datePath2 = datePath2.substring(2);
                        }
                        if ((object = this.sessionController.findGlobalObjectByPath(sFolder, datePath2 = this.handleDatePath(datePath2, date))) == null && createPath) {
                            object = rfs.createFullpath(datePath2, sFolder, acl);
                        }
                    }
                } else if (path.matches("^\\s*\\d+\\s*$")) {
                    object = this.sessionController.getGlobalObjectById(Long.valueOf(path.trim()));
                } else if (path.matches("^\\s*[/\\\\].*$")) {
                    datePath = this.handleDatePath(path.trim(), date);
                    object = this.sessionController.findGlobalObjectByPath(datePath);
                    if (object == null && createPath) {
                        object = rfs.createFullpath(datePath, null, acl);
                    }
                } else if (path.matches("^\\s*[^/\\\\].*$") && startFolder != null) {
                    datePath = path.trim();
                    if (datePath.startsWith(".\\") || datePath.startsWith("./")) {
                        datePath = datePath.substring(2);
                    }
                    if ((object = this.sessionController.findGlobalObjectByPath(startFolder, datePath = this.handleDatePath(datePath, date))) == null && createPath) {
                        object = rfs.createFullpath(datePath, startFolder, acl);
                    }
                }
                if (object == null) continue;
                objects.add(object);
            }
        }
        return objects;
    }

    private String handleDatePath(String path, Date date) {
        StringBuffer newPath;
        block3: {
            int startIdx;
            newPath = new StringBuffer("");
            if (date == null) {
                date = new Date();
            }
            while ((startIdx = path.indexOf("${SDF:")) != -1) {
                int endIdx = path.indexOf("}", startIdx);
                if (endIdx != -1) {
                    newPath.append(path.substring(0, startIdx));
                    String sdfPattern = path.substring(startIdx + 6, endIdx);
                    SimpleDateFormat sdf = new SimpleDateFormat(sdfPattern);
                    newPath.append(sdf.format(date));
                    path = path.substring(endIdx + 1);
                    continue;
                }
                newPath.append(path);
                break block3;
            }
            newPath.append(path);
        }
        return newPath.toString();
    }

    public MetaDbPropertyBean[] getItems(SessionController sessionController, String path, FolderObjectClientBean fromFolder, boolean notCached) throws RemoteException, Exception {
        String key = null;
        key = path == null ? "" + fromFolder.getId() : path;
        MetaDbPropertyBean[] pb = this.getItems1(sessionController, fromFolder, null, notCached);
        if (pb == null) {
            pb = new MetaDbPropertyBean[]{};
        }
        return pb;
    }

    public MetaDbPropertyBean[] getItems(SessionController sessionController, String path, MetaDbPropertyBundleBean fromFolder, boolean notCached) throws RemoteException, Exception {
        String key = null;
        key = path == null ? "" + fromFolder.getId() : path;
        MetaDbPropertyBean[] pb = this.getItems2(sessionController, fromFolder, null, notCached);
        if (pb == null) {
            pb = new MetaDbPropertyBean[]{};
        }
        return pb;
    }

    public MetaDbReturnBean findByPathInternal(SessionController sessionController, GlobalObjectClientBean fromFolder, String path, boolean notCached) throws RemoteException, Exception {
        return this.findByPathInternal(sessionController, fromFolder, path, false, notCached);
    }

    public MetaDbReturnBean findByPathInternal(SessionController sessionController, GlobalObjectClientBean fromFolder, String path, boolean withId, boolean notCached) throws RemoteException, Exception {
        MetaDbPropertyBean lastClient = new MetaDbPropertyBean();
        lastClient.fillBeanFromGlobalObject(fromFolder);
        MetaDbReturnBean mdbr = new MetaDbReturnBean();
        mdbr = this.findByPathInternal(sessionController, fromFolder, path, 1, lastClient, mdbr, notCached);
        return mdbr;
    }

    public MetaDbPropertyBundleBean[] getFirstBundles(SessionController sessionController, GlobalObjectClientBean source, boolean notCached) throws RemoteException, Exception {
        return this.getFirstBundles(sessionController, source, new Vector(), true, notCached);
    }

    private MetaDbPropertyBundleBean[] getFirstBundles(SessionController sessionController, GlobalObjectClientBean source, Vector v, boolean retOk, boolean notCached) throws Exception {
        MetaDbPropertyBundleBean[] pRet = null;
        if (source instanceof MetaDbPropertyBundleObjectClientBean) {
            v.addElement(source);
        } else {
            FolderObjectClientBean[] parents = source.getParents();
            if (parents != null) {
                int len = parents.length;
                for (int i = 0; i < len; ++i) {
                    if (parents[i] instanceof MetaDbPropertyBundleObjectClientBean) {
                        v.addElement(parents[i]);
                        continue;
                    }
                    if (!(parents[i] instanceof MetaDbPropertyGroupObjectClientBean)) continue;
                    this.getFirstBundles(sessionController, parents[i], v, false, notCached);
                }
            }
        }
        if (retOk) {
            int len = v.size();
            pRet = new MetaDbPropertyBundleBean[len];
            for (int i = 0; i < len; ++i) {
                MetaDbPropertyBundleBean mpbb = new MetaDbPropertyBundleBean();
                MetaDbPropertyBundleObjectClientBean bundle = (MetaDbPropertyBundleObjectClientBean)v.elementAt(i);
                mpbb.fillBeanFromGlobalObject(bundle);
                pRet[i] = mpbb;
            }
        }
        return pRet;
    }

    private MetaDbPropertyBean[] getItems1(SessionController sessionController, FolderObjectClientBean fromFolder, String name, boolean notCached) throws Exception {
        MetaDbPropertyBean[] items = null;
        Vector v = new Vector();
        this.getItemsInternal(sessionController, fromFolder, fromFolder.getItems(), v, name, notCached);
        int len = v.size();
        if (len > 0) {
            items = new MetaDbPropertyBean[len];
            for (int i = 0; i < len; ++i) {
                GlobalObjectClientBean globalObject = (GlobalObjectClientBean)v.elementAt(i);
                items[i] = this.getMetaDbPropertyBeanEJB(globalObject);
            }
        }
        return items;
    }

    private MetaDbPropertyBean[] getItems2(SessionController sessionController, MetaDbPropertyBundleBean bundle, String name, boolean notCached) throws Exception {
        FolderObjectClientBean fromFolder = (FolderObjectClientBean)sessionController.getGlobalObjectById(bundle.getId());
        MetaDbPropertyBean[] items = null;
        Vector v = new Vector();
        this.getItemsInternal(sessionController, fromFolder, fromFolder.getItems(), v, name, notCached);
        int len = v.size();
        if (len > 0) {
            items = new MetaDbPropertyBean[len];
            for (int i = 0; i < len; ++i) {
                GlobalObjectClientBean globalObject = (GlobalObjectClientBean)v.elementAt(i);
                items[i] = this.getMetaDbPropertyBeanEJB(globalObject);
            }
        }
        return items;
    }

    private void getItemsInternal(SessionController sessionController, GlobalObjectClientBean parent, GlobalObjectClientBean[] items, Vector v, String name, boolean notCached) throws Exception {
        if (items != null) {
            for (GlobalObjectClientBean gocb : items) {
                if (parent instanceof MetaDbPropertyGroupObjectClientBean) {
                    // empty if block
                }
                if (gocb instanceof MetaDbPropertyGroupObjectClientBean) {
                    if (gocb instanceof MetaDbPropertyGroupObjectClientBean) {
                        // empty if block
                    }
                    this.getItemsInternal(sessionController, gocb, ((MetaDbPropertyGroupObjectClientBean)gocb).getItems(), v, name, notCached);
                    continue;
                }
                if (!(gocb instanceof MetaDbPropertyBundleObjectClientBean) && !(gocb instanceof MetaDbPropertyEntryObjectClientBean) || name != null && !name.equalsIgnoreCase(gocb.getName())) continue;
                v.addElement(gocb);
            }
        }
    }

    private MetaDbPropertyBean getItem1(SessionController sessionController, FolderObjectClientBean fromFolder, String name, String thePath, boolean notCached) throws Exception {
        MetaDbPropertyBean[] items;
        MetaDbPropertyBean item = null;
        if (name != null && (items = this.getItems1(sessionController, fromFolder, name, notCached)) != null && items.length == 1) {
            item = items[0];
        }
        return item;
    }

    private FolderObjectClientBean[] getParents(GlobalObjectClientBean fromObject) throws Exception {
        FolderObjectClientBean[] parents = fromObject.getParents();
        return parents;
    }

    private MetaDbReturnBean findByPathInternal(SessionController sessionController, GlobalObjectClientBean fromFolder, String path, int pathPos, MetaDbPropertyBean lastClientBean, MetaDbReturnBean mrb, boolean notCached) throws Exception {
        String lastFoundId = "" + fromFolder.getId();
        mrb.setLastFolderId(lastFoundId);
        Object clientBean = null;
        StringUtils su = new StringUtils();
        String name = su.getStringFromPos(path, "/", pathPos);
        String thePath = "";
        String sep = "";
        for (int i = 1; i <= pathPos; ++i) {
            String n = su.getStringFromPos(path, "/", i);
            thePath = thePath + sep + n;
            sep = "/";
        }
        ++pathPos;
        if (name != null) {
            if (name.equals("..")) {
                FolderObjectClientBean[] parents = this.getParents(fromFolder);
                if (parents != null) {
                    lastClientBean = this.getMetaDbPropertyBeanEJB(parents[0]);
                    mrb.setMetaDbPropertyBean(lastClientBean);
                }
            } else {
                ArrayList relIdGroups = new ArrayList();
                lastClientBean = this.getItem1(sessionController, (FolderObjectClientBean)fromFolder, name, thePath, notCached);
                mrb.setMetaDbPropertyBean(lastClientBean);
            }
            if (lastClientBean != null && lastClientBean.isFolder()) {
                GlobalObjectClientBean gocb = sessionController.getGlobalObjectById(lastClientBean.getId());
                mrb = this.findByPathInternal(sessionController, gocb, path, pathPos, lastClientBean, mrb, notCached);
            } else if (su.getStringFromPos(path, "/", pathPos) != null) {
                lastClientBean = null;
                mrb.setMetaDbPropertyBean(null);
            }
        }
        return mrb;
    }

    private MetaDbPropertyBean getMetaDbPropertyBeanEJB(GlobalObjectClientBean globalObject) throws Exception {
        MetaDbPropertyBean mdb = null;
        if (globalObject instanceof MetaDbPropertyBundleObjectClientBean) {
            mdb = new MetaDbPropertyBundleBean();
        } else if (globalObject instanceof MetaDbPropertyEntryObjectClientBean) {
            mdb = new MetaDbPropertyEntryBean();
        } else if (globalObject instanceof MetaDbPropertyGroupObjectClientBean) {
            mdb = new MetaDbPropertyGroupBean();
        }
        ((MetaDbPropertyBean)mdb).fillBeanFromGlobalObject(globalObject);
        if (mdb instanceof MetaDbPropertyEntryBean) {
            MetaDbPropertyEntryBean entry = (MetaDbPropertyEntryBean)mdb;
            String[] sArr = this.replaceValue(globalObject.getSessionController(), entry);
            entry.setValue(sArr);
        }
        return mdb;
    }

    private String[] replaceValue(SessionController sessionController, MetaDbPropertyEntryBean mdb) throws Exception {
        String[] valueArray = mdb.getValue();
        StringUtils su = new StringUtils();
        if (valueArray != null) {
            int len = valueArray.length;
            for (int i = 0; i < len; ++i) {
                String value = valueArray[i];
                while (true) {
                    String prop;
                    int propPos = 0;
                    String propExt = "";
                    if (value == null) {
                        System.err.println("The element: " + i + " is null in key: " + mdb.getName() + ", id: " + mdb.getId());
                    }
                    if (value.indexOf("${prop[") != -1) {
                        String propPosS = su.getStringFrommTrenner(value, "${prop[", "]:", 1);
                        propPos = Integer.parseInt(propPosS);
                        propExt = "[" + propPosS + "]";
                    }
                    if ((prop = su.getStringFrommTrenner(value, "${prop" + propExt + ":", "}", 1)) == null) break;
                    GlobalObjectClientBean offset = null;
                    offset = prop.startsWith("../") ? sessionController.getGlobalObjectById(mdb.getId()) : MetaDbUtils.getMetaDbBasePath(sessionController);
                    MetaDbPropertyEntryBean nextEntry = null;
                    MetaDbReturnBean findByPathInternal = this.findByPathInternal(sessionController, offset, prop, true);
                    if (findByPathInternal != null) {
                        nextEntry = (MetaDbPropertyEntryBean)findByPathInternal.getMetaDbPropertyBean();
                    }
                    if (nextEntry == null) break;
                    String[] valueNext = nextEntry.getValue();
                    if (valueNext == null) continue;
                    value = su.strReplaceFirst(value, "${prop" + propExt + ":" + prop + "}", valueNext[propPos]);
                }
                valueArray[i] = value;
            }
        }
        return valueArray;
    }

    @Deprecated
    public int warmupMetaDbStructur(MetaDbUtils mdbu) throws Exception {
        return 1;
    }

    public void setMetaDbEntry(String metaDbBundle, String metaDbPropertyName, long dataType, Object value) throws Exception {
        Long mpId = this.findByPath(metaDbBundle).getId();
        MetaDbPropertyBundleObjectClientBean bundle = (MetaDbPropertyBundleObjectClientBean)this.sessionController.getGlobalObjectById(mpId);
        this.createOrUpdateMetaDbPropertyEntryObjectClientBean(bundle, metaDbPropertyName, dataType, value);
    }

    public boolean isPropertyGroup(String pathToCheck) throws Exception {
        GlobalObjectClientBean gocb = this.sessionController.findGlobalObjectByPath("/agorum/ngos/MetaDb/" + pathToCheck);
        return gocb instanceof MetaDbPropertyGroupObjectClientBean;
    }

    public boolean isPropertyEntry(String pathToCheck) throws Exception {
        GlobalObjectClientBean gocb = this.sessionController.findGlobalObjectByPath("/agorum/ngos/MetaDb/" + pathToCheck);
        return gocb instanceof MetaDbPropertyEntryObjectClientBean;
    }

    public boolean isPropertyBundle(String pathToCheck) throws Exception {
        GlobalObjectClientBean gocb = this.sessionController.findGlobalObjectByPath("/agorum/ngos/MetaDb/" + pathToCheck);
        return gocb instanceof MetaDbPropertyBundleObjectClientBean;
    }
}

