/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.metadb.cache;

import agorum.agceptit.metadb.client.statistic.MetaDbStatistic;
import agorum.commons.logging.Log;
import agorum.commons.logging.TimeSpanLogger;
import agorum.commons.statistic.Statistic;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyBundleObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyEntryObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyGroupObjectClientBean;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.metadb.cache.Context;
import agorum.roi.metadb.cache.NoCache;
import agorum.roi.metadb.cache.beans.NodeBean;
import agorum.roi.metadb.cache.transaction.AddItem;
import agorum.roi.metadb.cache.transaction.Modification;
import agorum.roi.metadb.cache.transaction.RemoveItem;
import agorum.roi.metadb.cache.transaction.Transaction;
import agorum.roi.metadb.cache.transaction.Update;
import agorum.roi.metadb.cache.tree.Bundle;
import agorum.roi.metadb.cache.tree.Node;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class MetaDbCache {
    static final Statistic stat = MetaDbStatistic.getInstance();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private Context context;
    private Bundle root;
    private Long rootId;

    public static MetaDbCache getInstance() {
        return SingletonHolder.instance;
    }

    protected MetaDbCache() {
        this.rebuild();
    }

    public final void rebuild() {
        try (TimeSpanLogger.Auto tsl = new TimeSpanLogger(stat).name("MetaDb cache rebuild").logAs("INFO").measurement().auto();){
            this.context = new Context();
            SessionController sessionController = this.getSessionController();
            GlobalObjectClientBean rootObj = null;
            try {
                rootObj = sessionController.findGlobalObjectByPath("/agorum/ngos/MetaDb");
                this.rootId = rootObj.getId();
            }
            catch (Exception e) {
                stat.error().exception((Throwable)e).send("Could not look up MetaDb root");
                throw new RuntimeException("Could not look up MetaDb root", e);
            }
            try {
                this.root = new Bundle(this.context, rootObj);
            }
            catch (Exception e) {
                stat.error().exception((Throwable)e).send("Could not initialize cache");
                throw new RuntimeException("Could not initialize cache", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeBean get(String path) throws Exception {
        if (this.invalidGet(path)) {
            return NoCache.get(this.getSessionController(), path);
        }
        this.lock.readLock().lock();
        try {
            StringTokenizer tokenizer = new StringTokenizer(path.toLowerCase(), "/");
            NodeBean nodeBean = this.root.get(tokenizer);
            return nodeBean;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeBean> list(String path, Node.Type type) throws Exception {
        if (this.invalidList(path)) {
            return NoCache.list(SessionControllerAdmin.getSessionControllerAdmin("MetaDbCache"), path, type);
        }
        this.lock.readLock().lock();
        try {
            StringTokenizer tokenizer = new StringTokenizer(path.toLowerCase(), "/");
            List<NodeBean> list = this.root.list(tokenizer, type);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void update(GlobalObjectClientBean obj) throws Exception {
        this.modify(new Update(this.context, this.acquire(obj)));
    }

    public void addItem(GlobalObjectClientBean folder, GlobalObjectClientBean item) throws Exception {
        if (item instanceof MetaDbPropertyBundleObjectClientBean || item instanceof MetaDbPropertyGroupObjectClientBean || item instanceof MetaDbPropertyEntryObjectClientBean) {
            this.modify(new AddItem(this.context, this.acquire(folder), this.acquire(item)));
        }
    }

    public void removeItem(GlobalObjectClientBean folder, GlobalObjectClientBean item) throws Exception {
        if (item instanceof MetaDbPropertyBundleObjectClientBean || item instanceof MetaDbPropertyGroupObjectClientBean || item instanceof MetaDbPropertyEntryObjectClientBean) {
            this.modify(new RemoveItem(this.context, this.acquire(folder), item.getName()));
        }
    }

    public Long getRootId() {
        return this.rootId;
    }

    private SessionController getSessionController() {
        try {
            return SessionControllerAdmin.getSessionControllerAdmin("MetaDbCache");
        }
        catch (Exception e) {
            stat.warning().exception((Throwable)e).send("Could not connect admin session");
            throw new RuntimeException("Could not connect admin session", e);
        }
    }

    private GlobalObjectClientBean acquire(GlobalObjectClientBean obj) throws Exception {
        return this.getSessionController().getGlobalObjectById(obj.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modify(Modification modification) {
        block19: {
            try (TimeSpanLogger.Auto tsl = new TimeSpanLogger(stat).name("MetaDb cache commit").logAs("INFO").measurement().auto();){
                RoiTransactionHandler rth = RoiTransactionHandler.getThreadTransaction();
                if (rth != null) {
                    Transaction threadTransaction = Transaction.getInstance();
                    threadTransaction.add(modification);
                    rth.whileCommit("MetaDbCache", () -> {
                        this.lock.writeLock().lock();
                        try {
                            threadTransaction.commit();
                        }
                        catch (Exception e) {
                            Log.error((String)"Could not run cache update", (Throwable)e);
                        }
                        finally {
                            this.lock.writeLock().unlock();
                            threadTransaction.clear();
                        }
                    });
                    rth.whileRollback("MetaDbCache", () -> threadTransaction.clear());
                    break block19;
                }
                this.lock.writeLock().lock();
                try {
                    if (!modification.gone()) {
                        modification.commit();
                    }
                }
                catch (Exception e) {
                    stat.error().exception((Throwable)e).send("Could not run cache update");
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
        }
    }

    private boolean invalidGet(String path) throws Exception {
        boolean invalid = false;
        if (RoiTransactionHandler.getThreadTransaction() != null) {
            invalid = Transaction.getInstance().invalidGet(path);
        }
        if (invalid) {
            stat.count("MetaDb cache misses", 1L);
        } else {
            stat.count("MetaDb cache hits", 1L);
        }
        return invalid;
    }

    private boolean invalidList(String path) throws Exception {
        boolean invalid = false;
        if (RoiTransactionHandler.getThreadTransaction() != null) {
            invalid = Transaction.getInstance().invalidList(path);
        }
        if (invalid) {
            stat.count("MetaDb cache misses", 1L);
        } else {
            stat.count("MetaDb cache hits", 1L);
        }
        return invalid;
    }

    private static class SingletonHolder {
        public static final MetaDbCache instance = new MetaDbCache();

        private SingletonHolder() {
        }
    }
}

