/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.interfaces.webservices.server;

import agorum.roi.ejb.client.beans.AccessControlEntryObjectClientBean;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryGroupObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.common.AssociatedGroupOfDirectoryObject;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.TransactionProperties;
import agorum.roi.exception.RoiException;
import agorum.roi.interfaces.webservices.client.beans.administration.AccessControlEntryBean;
import agorum.roi.interfaces.webservices.client.beans.administration.AddToAclRequestBean;
import agorum.roi.interfaces.webservices.client.beans.administration.AddToGroupRequestBean;
import agorum.roi.interfaces.webservices.client.beans.administration.AdministrationResponseBean;
import agorum.roi.interfaces.webservices.client.beans.administration.DeleteUserRequestBean;
import agorum.roi.interfaces.webservices.client.beans.administration.GetAclEntriesRequestBean;
import agorum.roi.interfaces.webservices.client.beans.administration.GetAclEntriesResponseBean;
import agorum.roi.interfaces.webservices.client.beans.administration.GetAssociatedAclsOfDirectoryGroupRequestBean;
import agorum.roi.interfaces.webservices.client.beans.administration.GetAssociatedAclsOfDirectoryUserRequestBean;
import agorum.roi.interfaces.webservices.client.beans.administration.GetAssociatedGroupsOfDirectoryObjectRequestBean;
import agorum.roi.interfaces.webservices.client.beans.administration.GetFreeDBSizeResponseBean;
import agorum.roi.interfaces.webservices.client.beans.administration.GetGroupMembersRequestBean;
import agorum.roi.interfaces.webservices.client.beans.administration.ModifyUserRequestBean;
import agorum.roi.interfaces.webservices.client.beans.administration.RemoveFromAclRequestBean;
import agorum.roi.interfaces.webservices.client.beans.administration.RemoveFromGroupRequestBean;
import agorum.roi.interfaces.webservices.client.beans.common.BaseRequestBean;
import agorum.roi.interfaces.webservices.client.beans.common.ItemBean;
import agorum.roi.interfaces.webservices.client.beans.common.ObjectLookupBean;
import agorum.roi.interfaces.webservices.client.beans.items.ItemsResponseBean;
import agorum.roi.interfaces.webservices.client.common.WebServiceErrorKeys;
import agorum.roi.interfaces.webservices.server.BaseItemService;
import agorum.roi.sessionfacade.beans.AccessControlListObjectSessionFacade;
import agorum.roi.sessionfacade.beans.DirectoryGroupObjectSessionFacade;
import agorum.roi.sessionfacade.beans.DirectoryUserObjectSessionFacade;
import agorum.webcomponents.webservices.beans.WebServiceSessionBean;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class AdministrationService
extends BaseItemService {
    public AdministrationService(WebServiceSessionBean wsSessionBean) {
        super(wsSessionBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AdministrationResponseBean addToGroup(AddToGroupRequestBean requestBean) {
        AdministrationResponseBean responseBean = new AdministrationResponseBean();
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            DirectoryGroupObjectSessionFacade groupSessionFacade = new DirectoryGroupObjectSessionFacade(sessionController);
            DirectoryGroupObjectClientBean group = (DirectoryGroupObjectClientBean)this.lookupObject(sessionController, requestBean.getGroup());
            if (group == null) {
                responseBean.setErrorKey(WebServiceErrorKeys.ADMINISTRATION_GROUP_NOT_FOUND);
                responseBean.setLogError("given group was not found: " + requestBean.getGroup());
                AdministrationResponseBean administrationResponseBean = responseBean;
                return administrationResponseBean;
            }
            groupSessionFacade.setWithTransaction(true);
            groupSessionFacade.setGlobalObject(group);
            int len = requestBean.getMembers().length;
            if (len > 0) {
                String[] members = new String[len];
                for (int i = 0; i < len; ++i) {
                    try {
                        members[i] = "" + this.lookupObject(sessionController, requestBean.getMembers()[i]).getId();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (members[i] != null) continue;
                    responseBean.setErrorKey(WebServiceErrorKeys.ADMINISTRATION_MEMBER_NOT_FOUND);
                    responseBean.setLogError("given member was not found: " + requestBean.getMembers()[i]);
                    AdministrationResponseBean administrationResponseBean = responseBean;
                    return administrationResponseBean;
                }
                groupSessionFacade.setAddMembers(members);
                groupSessionFacade.update();
            }
            rth.end();
            rth = null;
            return responseBean;
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
            return responseBean;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
            return responseBean;
        }
        finally {
            if (rth != null) {
                try {
                    rth.abort();
                    rth = null;
                }
                catch (Exception re) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AdministrationResponseBean removeFromGroup(RemoveFromGroupRequestBean requestBean) {
        AdministrationResponseBean responseBean = new AdministrationResponseBean();
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            DirectoryGroupObjectSessionFacade groupSessionFacade = new DirectoryGroupObjectSessionFacade(sessionController);
            DirectoryGroupObjectClientBean group = (DirectoryGroupObjectClientBean)this.lookupObject(sessionController, requestBean.getGroup());
            if (group == null) {
                responseBean.setErrorKey(WebServiceErrorKeys.ADMINISTRATION_GROUP_NOT_FOUND);
                responseBean.setLogError("given group was not found: " + requestBean.getGroup());
                AdministrationResponseBean administrationResponseBean = responseBean;
                return administrationResponseBean;
            }
            groupSessionFacade.setWithTransaction(true);
            groupSessionFacade.setGlobalObject(group);
            int len = requestBean.getMembers().length;
            if (len > 0) {
                String[] members = new String[len];
                for (int i = 0; i < len; ++i) {
                    try {
                        members[i] = "" + this.lookupObject(sessionController, requestBean.getMembers()[i]).getId();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (members[i] != null) continue;
                    responseBean.setErrorKey(WebServiceErrorKeys.ADMINISTRATION_MEMBER_NOT_FOUND);
                    responseBean.setLogError("given member was not found: " + requestBean.getMembers()[i]);
                    AdministrationResponseBean administrationResponseBean = responseBean;
                    return administrationResponseBean;
                }
                groupSessionFacade.setRemoveMembers(members);
                groupSessionFacade.update();
            }
            rth.end();
            rth = null;
            return responseBean;
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
            return responseBean;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
            return responseBean;
        }
        finally {
            if (rth != null) {
                try {
                    rth.abort();
                    rth = null;
                }
                catch (Exception re) {}
            }
        }
    }

    public ItemsResponseBean getGroupMembers(GetGroupMembersRequestBean requestBean) {
        ItemsResponseBean responseBean = new ItemsResponseBean();
        try {
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            Vector<ItemBean> itemList = new Vector<ItemBean>();
            int resultCount = 0;
            DirectoryGroupObjectClientBean group = (DirectoryGroupObjectClientBean)this.lookupObject(sessionController, requestBean.getGroup());
            if (group == null) {
                responseBean.setErrorKey(WebServiceErrorKeys.ADMINISTRATION_GROUP_NOT_FOUND);
                responseBean.setLogError("given group was not found: " + requestBean.getGroup());
                return responseBean;
            }
            DirectoryObjectClientBean[] members = group.getDirectMembers();
            try {
                if (members != null) {
                    int len = members.length;
                    for (int i = 0; i < len; ++i) {
                        ItemBean itemBean = this.fillItemBean(members[i], requestBean.getRequestAttributes(), null);
                        itemList.addElement(itemBean);
                        ++resultCount;
                    }
                }
            }
            catch (Exception e) {
                responseBean.setLogError("Error getting members");
                return responseBean;
            }
            ItemBean[] itemBeans = this.getItemBeans(itemList);
            responseBean.setResultCount(resultCount);
            responseBean.setItems(itemBeans);
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
        }
        return responseBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AdministrationResponseBean addToAcl(AddToAclRequestBean requestBean) {
        AdministrationResponseBean responseBean = new AdministrationResponseBean();
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            AccessControlListObjectClientBean acl = (AccessControlListObjectClientBean)this.lookupObject(sessionController, requestBean.getAcl());
            if (acl == null) {
                responseBean.setErrorKey(WebServiceErrorKeys.ADMINISTRATION_ACL_NOT_FOUND);
                responseBean.setLogError("given acl was not found: " + requestBean.getAcl());
                AdministrationResponseBean administrationResponseBean = responseBean;
                return administrationResponseBean;
            }
            int len = requestBean.getAccessControlEntries().length;
            if (len > 0) {
                AccessControlListObjectSessionFacade aclSessionFacade = new AccessControlListObjectSessionFacade(sessionController);
                aclSessionFacade.setWithTransaction(true);
                aclSessionFacade.setGlobalObject(acl);
                for (int i = 0; i < len; ++i) {
                    AccessControlEntryBean aceb = requestBean.getAccessControlEntries()[i];
                    DirectoryObjectClientBean directoryObject = (DirectoryObjectClientBean)this.lookupObject(sessionController, aceb.getMember());
                    if (directoryObject == null) {
                        responseBean.setErrorKey(WebServiceErrorKeys.ADMINISTRATION_MEMBER_NOT_FOUND);
                        responseBean.setLogError("given member was not found: " + aceb.getMember());
                        AdministrationResponseBean administrationResponseBean = responseBean;
                        return administrationResponseBean;
                    }
                    acl.removeAccessControlEntryObject(acl.getAccessControlEntries(directoryObject));
                    if (aceb.getMode().equalsIgnoreCase("grant")) {
                        aclSessionFacade.addGranteeOrRevokee(directoryObject.getId(), aceb.getPermissionBundle(), true);
                        continue;
                    }
                    aclSessionFacade.addGranteeOrRevokee(directoryObject.getId(), aceb.getPermissionBundle(), false);
                }
                aclSessionFacade.update();
            }
            rth.end();
            rth = null;
            return responseBean;
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
            return responseBean;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
            return responseBean;
        }
        finally {
            if (rth != null) {
                try {
                    rth.abort();
                    rth = null;
                }
                catch (Exception re) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AdministrationResponseBean removeFromAcl(RemoveFromAclRequestBean requestBean) {
        AdministrationResponseBean responseBean = new AdministrationResponseBean();
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            AccessControlListObjectClientBean acl = (AccessControlListObjectClientBean)this.lookupObject(sessionController, requestBean.getAcl());
            if (acl == null) {
                responseBean.setErrorKey(WebServiceErrorKeys.ADMINISTRATION_ACL_NOT_FOUND);
                responseBean.setLogError("given acl was not found: " + requestBean.getAcl());
                AdministrationResponseBean administrationResponseBean = responseBean;
                return administrationResponseBean;
            }
            int len = requestBean.getMembers().length;
            Hashtable<String, String> removeMembers = new Hashtable<String, String>();
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    DirectoryObjectClientBean member = (DirectoryObjectClientBean)this.lookupObject(sessionController, requestBean.getMembers()[i]);
                    if (member == null) {
                        responseBean.setErrorKey(WebServiceErrorKeys.ADMINISTRATION_MEMBER_NOT_FOUND);
                        responseBean.setLogError("given member was not found: " + requestBean.getMembers()[i]);
                        AdministrationResponseBean administrationResponseBean = responseBean;
                        return administrationResponseBean;
                    }
                    removeMembers.put("" + member.getId(), "");
                }
                AccessControlEntryObjectClientBean[] aces = acl.getAccessControlEntries();
                len = aces.length;
                for (int i = 0; i < len; ++i) {
                    if (!removeMembers.containsKey("" + aces[i].getGrantee().getId())) continue;
                    acl.removeAccessControlEntryObject(aces[i]);
                }
            }
            rth.end();
            rth = null;
            return responseBean;
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
            return responseBean;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
            return responseBean;
        }
        finally {
            if (rth != null) {
                try {
                    rth.abort();
                    rth = null;
                }
                catch (Exception re) {}
            }
        }
    }

    public GetAclEntriesResponseBean getAclEntries(GetAclEntriesRequestBean requestBean) {
        GetAclEntriesResponseBean responseBean = new GetAclEntriesResponseBean();
        try {
            int i;
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            Vector<AccessControlEntryBean> itemList = new Vector<AccessControlEntryBean>();
            int resultCount = 0;
            AccessControlListObjectClientBean acl = (AccessControlListObjectClientBean)this.lookupObject(sessionController, requestBean.getAcl());
            if (acl == null) {
                responseBean.setErrorKey(WebServiceErrorKeys.ADMINISTRATION_ACL_NOT_FOUND);
                responseBean.setLogError("given acl was not found: " + requestBean.getAcl());
                return responseBean;
            }
            AccessControlEntryObjectClientBean[] aces = acl.getAccessControlEntries();
            if (aces != null) {
                int len = aces.length;
                for (i = 0; i < len; ++i) {
                    AccessControlEntryBean aceBean = new AccessControlEntryBean();
                    String pb = aces[i].getPermissionBundleObjects()[0].getName();
                    ObjectLookupBean member = new ObjectLookupBean();
                    DirectoryObjectClientBean membObject = aces[i].getGrantee();
                    member.setObjectId(membObject.getId());
                    member.setName(membObject.getName());
                    member.setClassName(membObject.getClassName());
                    aceBean.setMember(member);
                    aceBean.setMode(aces[i].getGranted() ? "grant" : "revoke");
                    aceBean.setPermissionBundle(pb);
                    itemList.addElement(aceBean);
                    ++resultCount;
                }
            }
            AccessControlEntryBean[] aceBeans = new AccessControlEntryBean[resultCount];
            for (i = 0; i < resultCount; ++i) {
                aceBeans[i] = (AccessControlEntryBean)itemList.get(i);
            }
            responseBean.setAccessControlEntries(aceBeans);
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
        }
        return responseBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdministrationResponseBean modifyUser(ModifyUserRequestBean requestBean) {
        AdministrationResponseBean responseBean = new AdministrationResponseBean();
        RoiTransactionHandler rth = null;
        try {
            String passWord;
            rth = new RoiTransactionHandler();
            rth.begin();
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            DirectoryUserObjectSessionFacade userSessionFacade = new DirectoryUserObjectSessionFacade(sessionController);
            GlobalObjectClientBean user = this.lookupObject(sessionController, requestBean.getUser());
            if (user == null) {
                responseBean.setErrorKey(WebServiceErrorKeys.ADMINISTRATION_USER_NOT_FOUND);
                responseBean.setLogError("given user was not found: " + requestBean.getUser());
                AdministrationResponseBean administrationResponseBean = responseBean;
                return administrationResponseBean;
            }
            userSessionFacade.setGlobalObject(user);
            String[] emailAddresses = null;
            if (!this.isEmpty(requestBean.getEMailAddresses())) {
                StringTokenizer st = new StringTokenizer(requestBean.getEMailAddresses(), ";,");
                int len = st.countTokens();
                emailAddresses = new String[len];
                for (int i = 0; i < len; ++i) {
                    emailAddresses[i] = st.nextToken().toString();
                }
            }
            if (!this.isEmpty(passWord = requestBean.getPassWord())) {
                userSessionFacade.setPassWord(passWord);
            }
            if (emailAddresses != null) {
                userSessionFacade.setEmailAddresses(emailAddresses);
            }
            if (requestBean.getAdminEnabled() != null && requestBean.getAdminEnabled().length() > 0) {
                userSessionFacade.setAdminEnabled(Boolean.valueOf(requestBean.getAdminEnabled()));
            }
            if (!this.isEmpty(requestBean.getUserName())) {
                userSessionFacade.setUserName(requestBean.getUserName());
            }
            if (!this.isEmpty(requestBean.getDescription())) {
                userSessionFacade.setDescription(requestBean.getDescription());
            }
            if (!this.isEmpty(requestBean.getFamilyName())) {
                userSessionFacade.setFamilyName(requestBean.getFamilyName());
            }
            if (!this.isEmpty(requestBean.getGivenName())) {
                userSessionFacade.setGivenName(requestBean.getGivenName());
            }
            if (!this.isEmpty(requestBean.getLanguage())) {
                userSessionFacade.setLanguage(requestBean.getLanguage());
            }
            if (!this.isEmpty(requestBean.getMandatorIdent())) {
                userSessionFacade.setMandatorIdentifier(requestBean.getMandatorIdent());
            }
            userSessionFacade.update();
            rth.end();
            rth = null;
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
        }
        finally {
            if (rth != null) {
                try {
                    rth.abort();
                    rth = null;
                }
                catch (Exception re) {}
            }
        }
        return responseBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdministrationResponseBean deleteUser(DeleteUserRequestBean requestBean) {
        AdministrationResponseBean responseBean = new AdministrationResponseBean();
        RoiTransactionHandler rth = null;
        try {
            if (requestBean.getOwningUser() == null) {
                responseBean.setLogError("no user defined, that owns the objects of the user, that is deleted");
            } else if (requestBean.getUser() == null) {
                responseBean.setLogError("no user defined for deleting");
            }
            rth = new RoiTransactionHandler(TransactionProperties.getDeleteTransactionTimeout());
            rth.begin();
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            GlobalObjectClientBean user = this.lookupObject(sessionController, requestBean.getUser());
            if (user == null) {
                responseBean.setErrorKey(WebServiceErrorKeys.ADMINISTRATION_USER_NOT_FOUND);
                responseBean.setLogError("given user was not found: " + requestBean.getUser());
                AdministrationResponseBean administrationResponseBean = responseBean;
                return administrationResponseBean;
            }
            GlobalObjectClientBeanDefinition userDef = (GlobalObjectClientBeanDefinition)user.getNewDefinition(sessionController);
            if (requestBean.isDeleteHomeFolder()) {
                userDef.setSystemOption("deleteUserHome", "");
            }
            userDef.setSystemOption("childUser", this.lookupObject(sessionController, requestBean.getOwningUser()));
            userDef.setSystemOption("deleteFoldersRecursive", "true");
            user.delete(userDef);
            rth.end();
            rth = null;
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
        }
        finally {
            if (rth != null) {
                try {
                    rth.abort();
                    rth = null;
                }
                catch (Exception re) {}
            }
        }
        return responseBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetFreeDBSizeResponseBean getFreeDBSize(BaseRequestBean requestBean) {
        GetFreeDBSizeResponseBean responseBean = new GetFreeDBSizeResponseBean();
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            responseBean.setFreeDBSize(sessionController.getFreeDBSize());
            rth.end();
            rth = null;
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
        }
        finally {
            if (rth != null) {
                try {
                    rth.abort();
                    rth = null;
                }
                catch (Exception re) {}
            }
        }
        return responseBean;
    }

    public ItemsResponseBean getAssociatedGroupsOfDirectoryObject(GetAssociatedGroupsOfDirectoryObjectRequestBean requestBean) {
        ItemsResponseBean responseBean = new ItemsResponseBean();
        try {
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            DirectoryObjectClientBean directoryObject = (DirectoryObjectClientBean)this.lookupObject(sessionController, requestBean.getDirectoryObject());
            if (directoryObject == null) {
                responseBean.setErrorKey(WebServiceErrorKeys.ADMINISTRATION_MEMBER_NOT_FOUND);
                responseBean.setLogError("given member was not found: " + requestBean.getDirectoryObject());
                return responseBean;
            }
            Vector<ItemBean> itemList = new Vector<ItemBean>();
            int resultCount = 0;
            AssociatedGroupOfDirectoryObject[] allObjects = sessionController.getAssociatedGroupOfDirectoryObject(directoryObject, requestBean.getDepth(), requestBean.getUnique());
            try {
                if (allObjects != null) {
                    int len = allObjects.length;
                    for (int i = 0; i < len; ++i) {
                        ItemBean itemBean = this.fillItemBean(allObjects[i].getDirectoryObjectClientBean(), requestBean.getRequestAttributes(), null, allObjects[i].getDepth());
                        itemList.addElement(itemBean);
                        ++resultCount;
                    }
                }
            }
            catch (Exception e) {
                responseBean.setLogError("Error getting members");
                return responseBean;
            }
            ItemBean[] itemBeans = this.getItemBeans(itemList);
            responseBean.setResultCount(resultCount);
            responseBean.setItems(itemBeans);
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
        }
        return responseBean;
    }

    public ItemsResponseBean getAssociatedAclsOfDirectoryUser(GetAssociatedAclsOfDirectoryUserRequestBean requestBean) {
        ItemsResponseBean responseBean = new ItemsResponseBean();
        try {
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            DirectoryUserObjectClientBean directoryUserObject = (DirectoryUserObjectClientBean)this.lookupObject(sessionController, requestBean.getDirectoryUser());
            if (directoryUserObject == null) {
                responseBean.setErrorKey(WebServiceErrorKeys.ADMINISTRATION_USER_NOT_FOUND);
                responseBean.setLogError("given user was not found: " + requestBean.getDirectoryUser());
                return responseBean;
            }
            Vector<ItemBean> itemList = new Vector<ItemBean>();
            int resultCount = 0;
            AccessControlListObjectClientBean[] allObjects = sessionController.getAssociatedAclsOfDirectoryUser(directoryUserObject);
            try {
                if (allObjects != null) {
                    int len = allObjects.length;
                    for (int i = 0; i < len; ++i) {
                        ItemBean itemBean = this.fillItemBean(allObjects[i], requestBean.getRequestAttributes(), null);
                        itemList.addElement(itemBean);
                        ++resultCount;
                    }
                }
            }
            catch (Exception e) {
                responseBean.setLogError("Error getting members");
                return responseBean;
            }
            ItemBean[] itemBeans = this.getItemBeans(itemList);
            responseBean.setResultCount(resultCount);
            responseBean.setItems(itemBeans);
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
        }
        return responseBean;
    }

    public ItemsResponseBean getAssociatedAclsOfDirectoryGroup(GetAssociatedAclsOfDirectoryGroupRequestBean requestBean) {
        ItemsResponseBean responseBean = new ItemsResponseBean();
        try {
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            DirectoryGroupObjectClientBean directoryGroupObject = (DirectoryGroupObjectClientBean)this.lookupObject(sessionController, requestBean.getDirectoryGroup());
            if (directoryGroupObject == null) {
                responseBean.setErrorKey(WebServiceErrorKeys.ADMINISTRATION_GROUP_NOT_FOUND);
                responseBean.setLogError("given group was not found: " + requestBean.getDirectoryGroup());
                return responseBean;
            }
            Vector<ItemBean> itemList = new Vector<ItemBean>();
            int resultCount = 0;
            AccessControlListObjectClientBean[] allObjects = sessionController.getAssociatedAclsOfDirectoryGroup(directoryGroupObject, requestBean.getDirectOnly());
            try {
                if (allObjects != null) {
                    int len = allObjects.length;
                    for (int i = 0; i < len; ++i) {
                        ItemBean itemBean = this.fillItemBean(allObjects[i], requestBean.getRequestAttributes(), null);
                        itemList.addElement(itemBean);
                        ++resultCount;
                    }
                }
            }
            catch (Exception e) {
                responseBean.setLogError("Error getting members");
                return responseBean;
            }
            ItemBean[] itemBeans = this.getItemBeans(itemList);
            responseBean.setResultCount(resultCount);
            responseBean.setItems(itemBeans);
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
        }
        return responseBean;
    }
}

