/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.interfaces.webservices.client.utils.test;

import agorum.roi.interfaces.webservices.client.beans.login.LoginResponseBean;
import agorum.roi.interfaces.webservices.client.beans.system.TransactionResponseBean;
import agorum.roi.interfaces.webservices.client.utils.common.WsProperties;
import agorum.roi.interfaces.webservices.client.utils.system.WsBeginTransaction;
import agorum.roi.interfaces.webservices.client.utils.system.WsEndTransaction;
import agorum.roi.interfaces.webservices.client.utils.test.TestBaseClass;

public class TestTransactions
extends TestBaseClass {
    public TestTransactions(String[] args) {
        this.setUserName(args[0]);
        this.setPassWord(args[1]);
        WsProperties prop = new WsProperties();
        this.setUrl(prop.getWebServiceUrl());
    }

    public void testTransactions(LoginResponseBean loginResponseBean) throws Exception {
        String transactionId = null;
        try {
            for (int i = 0; i < 300; ++i) {
                WsBeginTransaction wsBeginTransaction = new WsBeginTransaction(loginResponseBean, this.getUrl());
                int transactionTimeout = 30;
                wsBeginTransaction.setTransactionTimeout(transactionTimeout);
                TransactionResponseBean beginResponse = wsBeginTransaction.doWs();
                this.checkResponseError(beginResponse);
                transactionId = beginResponse.getTransactionId();
                System.err.println("began transaction: " + i);
                WsEndTransaction wsEndTransaction = new WsEndTransaction(loginResponseBean, this.getUrl(), transactionId);
                TransactionResponseBean responseEnd = wsEndTransaction.doWs();
                this.checkResponseError(beginResponse);
                transactionId = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: TestTransactions <UserName> <PassWord>");
        } else {
            try {
                TestTransactions test = new TestTransactions(args);
                LoginResponseBean loginResponseBean = test.runLogin(test.getUserName(), test.getPassWord(), test.getUrl());
                if (loginResponseBean.getConnected()) {
                    test.testTransactions(loginResponseBean);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            System.err.println("ende test");
        }
    }
}

