/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.interfaces.webservices.client.utils.test;

import agorum.commons.string.StringUtils;
import agorum.roi.interfaces.webservices.client.beans.common.ObjectLookupBean;
import agorum.roi.interfaces.webservices.client.beans.login.LoginResponseBean;
import agorum.roi.interfaces.webservices.client.beans.parsexml.ParseXMLResponseBean;
import agorum.roi.interfaces.webservices.client.beans.system.TransactionResponseBean;
import agorum.roi.interfaces.webservices.client.utils.common.WsProperties;
import agorum.roi.interfaces.webservices.client.utils.filing.WsCreateObject;
import agorum.roi.interfaces.webservices.client.utils.filing.WsDownloadFile;
import agorum.roi.interfaces.webservices.client.utils.filing.WsUploadFile;
import agorum.roi.interfaces.webservices.client.utils.login.WsLogout;
import agorum.roi.interfaces.webservices.client.utils.system.WsAbortTransaction;
import agorum.roi.interfaces.webservices.client.utils.system.WsBeginTransaction;
import agorum.roi.interfaces.webservices.client.utils.test.TestBaseClass;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Date;

public class TestConvertFileToPdfOrHtml
extends TestBaseClass {
    private String sourcePath = null;
    private String destinationPath = null;
    private String newFormat = null;

    public TestConvertFileToPdfOrHtml(String[] args) {
        this.setUserName(args[0]);
        this.setPassWord(args[1]);
        this.setSourcePath(args[2]);
        this.setDestinationPath(args[3]);
        this.setNewFormat(args[4]);
        WsProperties prop = new WsProperties();
        this.setUrl(prop.getWebServiceUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void convertFile(LoginResponseBean loginResponseBean) throws Exception {
        block14: {
            WsAbortTransaction wsAbortTransaction;
            StringUtils su = new StringUtils();
            String transactionId = null;
            try {
                WsBeginTransaction wsBeginTransaction = new WsBeginTransaction(loginResponseBean, this.getUrl());
                int transactionTimeout = 30;
                wsBeginTransaction.setTransactionTimeout(transactionTimeout);
                TransactionResponseBean beginResponse = wsBeginTransaction.doWs();
                this.checkResponseError(beginResponse);
                transactionId = beginResponse.getTransactionId();
                File f = new File(this.getSourcePath());
                if (!f.exists()) {
                    throw new Exception("SourcePath not exists");
                }
                if (f.isDirectory()) {
                    throw new Exception("SourcePath is a Directory");
                }
                Long fileId = this.createFile(loginResponseBean, transactionId, f);
                WsProperties prop = new WsProperties();
                WsDownloadFile wsdf = new WsDownloadFile(loginResponseBean, prop.getDownloadUrl(), transactionId);
                wsdf.setFileId(fileId);
                wsdf.setTargetFormat(this.getNewFormat());
                InputStream inStream = wsdf.doWs();
                if (inStream != null) {
                    int read;
                    FileOutputStream fos = new FileOutputStream(this.getDestinationPath());
                    byte[] buffer = new byte[1024];
                    while ((read = inStream.read(buffer)) >= 0) {
                        fos.write(buffer, 0, read);
                    }
                    fos.close();
                    inStream.close();
                    System.err.println("File has been sucessfully downloaded");
                } else {
                    System.err.println("Error downloading file as pdf with id: " + fileId);
                }
                WsLogout wsLogout = new WsLogout(loginResponseBean, this.getUrl());
                wsLogout.doWs();
                if (transactionId != null) {
                    WsAbortTransaction wsAbortTransaction2 = new WsAbortTransaction(loginResponseBean, this.getUrl(), transactionId);
                    TransactionResponseBean responseEnd = wsAbortTransaction2.doWs();
                    transactionId = null;
                }
                if (transactionId == null) break block14;
                System.err.println("\n\n ------- Transaction ABORT ----------\n\n");
                wsAbortTransaction = new WsAbortTransaction(loginResponseBean, this.getUrl(), transactionId);
            }
            catch (Exception e) {
                System.err.println("aborted: message : " + e.getMessage());
                if (transactionId == null) break block14;
                System.err.println("\n\n ------- Transaction ABORT ----------\n\n");
                WsAbortTransaction wsAbortTransaction3 = new WsAbortTransaction(loginResponseBean, this.getUrl(), transactionId);
                TransactionResponseBean responseEnd = wsAbortTransaction3.doWs();
                transactionId = null;
            }
            catch (Throwable ta) {
                ta.printStackTrace(System.err);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    if (transactionId != null) {
                        System.err.println("\n\n ------- Transaction ABORT ----------\n\n");
                        WsAbortTransaction wsAbortTransaction4 = new WsAbortTransaction(loginResponseBean, this.getUrl(), transactionId);
                        TransactionResponseBean responseEnd = wsAbortTransaction4.doWs();
                        transactionId = null;
                    }
                }
            }
            TransactionResponseBean responseEnd = wsAbortTransaction.doWs();
            transactionId = null;
        }
    }

    private Long createFile(LoginResponseBean loginResponseBean, String transactionId, File f) throws Exception {
        WsProperties prop = new WsProperties();
        WsCreateObject wsco = new WsCreateObject(loginResponseBean, this.getUrl(), transactionId);
        ObjectLookupBean aclObject = new ObjectLookupBean();
        wsco.addAttribute("Name", f.getName());
        wsco.setClassName("FileObject");
        wsco.addAttribute("ExpirationDate", new Date());
        ParseXMLResponseBean parseXMLResponseBean = wsco.doWs();
        this.checkResponseError(parseXMLResponseBean);
        String[] fileArr = parseXMLResponseBean.getReturnValues();
        Long fileId = null;
        StringUtils su = new StringUtils();
        if (fileArr != null) {
            fileId = new Long(su.strReplace(fileArr[0], "\"", ""));
        }
        System.err.println("ID : " + fileId);
        WsUploadFile wsuf = new WsUploadFile(loginResponseBean, prop.getUploadUrl(), transactionId);
        FileInputStream fis = new FileInputStream(f);
        wsuf.setFileInputStream(fis);
        wsuf.setFileLength((int)f.length());
        wsuf.setFileId(fileId);
        fileId = wsuf.doWs();
        fis.close();
        return fileId;
    }

    public static void main(String[] args) {
        if (args.length < 5) {
            System.err.println("Usage: TestConvertFileToPdfOrHtml <UserName> <PassWord> <SourcePath(Disk-Path)> <DestinationPath(Disk-Path)> <newFormat(pdf or html)>");
        } else {
            try {
                TestConvertFileToPdfOrHtml test = new TestConvertFileToPdfOrHtml(args);
                LoginResponseBean loginResponseBean = test.runLogin(test.getUserName(), test.getPassWord(), test.getUrl());
                if (loginResponseBean.getConnected()) {
                    test.convertFile(loginResponseBean);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            System.err.println("test finished");
        }
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public String getDestinationPath() {
        return this.destinationPath;
    }

    public void setDestinationPath(String destinationPath) {
        this.destinationPath = destinationPath;
    }

    public String getNewFormat() {
        return this.newFormat;
    }

    public void setNewFormat(String newFormat) {
        this.newFormat = newFormat;
    }
}

