/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.interfaces.adminsync;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.messaging.common.MessageUtils;
import agorum.roi.interfaces.adminsync.AdminSyncInterface;
import agorum.roi.interfaces.adminsync.helper.AdminSyncHelper;
import java.util.ArrayList;
import java.util.Hashtable;

public class AdminSyncServiceCaller {
    private String adminOffset = "/agorum/roi/Administration";
    private AdminSyncHelper asHelper = new AdminSyncHelper(this.adminOffset);

    public void syncFromXml(SessionController sessionController, String xml) throws Exception {
        Class<?> syncClass = Class.forName("agorum.ngosadminsync.ejb.common.NgOsAdminSyncServiceUtils");
        AdminSyncInterface interf = (AdminSyncInterface)syncClass.newInstance();
        interf.init(this.adminOffset);
        interf.syncFromXml(sessionController, xml);
    }

    public void syncObject(SessionController sessionController, Object bean, FolderObjectClientBean parentFolder, String currentName, String oldName, boolean delete, Hashtable allSystemOptions, String methodeName) throws Exception {
        this.syncObject(sessionController, bean, parentFolder, currentName, oldName, delete, allSystemOptions, methodeName, null);
    }

    public void syncObject(SessionController sessionController, Object bean, FolderObjectClientBean parentFolder, String currentName, String oldName, boolean delete, Hashtable allSystemOptions, String methodeName, String callerId) throws Exception {
        ArrayList syncList = this.asHelper.getSyncsForObject(sessionController, bean, parentFolder, oldName);
        if (syncList != null) {
            MetaDb metaDb = null;
            try {
                metaDb = sessionController.getMetaDbInstance();
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
            int len = syncList.size();
            for (int i = 0; i < len; ++i) {
                String syncPoint = (String)syncList.get(i);
                if (callerId != null && callerId.equals("DSAdminSyncPasswordFetch||" + syncPoint)) continue;
                AdminSyncInterface interf = this.asHelper.getClassFromSyncPoint(syncPoint, metaDb);
                interf.createSyncObject(sessionController, bean, syncPoint, currentName, oldName, delete, allSystemOptions, methodeName);
            }
        }
    }

    public void syncAllObjects(SessionController sessionController, String syncPoint) throws Exception {
        try {
            MetaDb metaDb = sessionController.getMetaDbInstance();
            AdminSyncInterface interf = this.asHelper.getClassFromSyncPoint(syncPoint, metaDb);
            if (interf != null) {
                interf.syncAllObjects(sessionController, syncPoint);
            }
        }
        catch (Throwable e) {
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            e.printStackTrace(System.err);
        }
    }

    public void syncToServer(SessionController sessionController) throws Exception {
        try {
            MetaDb metaDb = sessionController.getMetaDbInstance();
            String[] allSyncs = this.asHelper.getAllSyncs(sessionController);
            if (allSyncs != null) {
                int len = allSyncs.length;
                for (int i = 0; i < len; ++i) {
                    if (allSyncs[i] == null || allSyncs[i].length() <= 0) continue;
                    AdminSyncInterface interf = this.asHelper.getClassFromSyncPoint(allSyncs[i], metaDb);
                    interf.syncToServer(sessionController, allSyncs[i]);
                    try {
                        MessageUtils mu = new MessageUtils();
                        mu.sendCloudEvent(allSyncs[i], sessionController.getLoginUserId(), "EVENT_OBJECT_ADMINSYNC", "AdminSync synced", 1L, "AdminSync: " + allSyncs[i]);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable e) {
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            e.printStackTrace(System.err);
        }
    }

    public void fetchFromServers(SessionController sessionController) throws Exception {
        try {
            MetaDb metaDb = sessionController.getMetaDbInstance();
            String[] allFetchSyncs = this.asHelper.getAllFetchSyncs(sessionController);
            if (allFetchSyncs != null) {
                int len = allFetchSyncs.length;
                for (int i = 0; i < len; ++i) {
                    if (allFetchSyncs[i] == null || allFetchSyncs[i].length() <= 0) continue;
                    AdminSyncInterface interf = this.asHelper.getClassFromSyncPoint(allFetchSyncs[i], metaDb);
                    interf.fetchFromServer(sessionController, allFetchSyncs[i]);
                }
            }
        }
        catch (Throwable e) {
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            e.printStackTrace(System.err);
        }
    }

    public void fetchFromServer(SessionController sessionController, String syncPoint) throws Exception {
        try {
            MetaDb metaDb = sessionController.getMetaDbInstance();
            AdminSyncInterface interf = this.asHelper.getClassFromSyncPoint(syncPoint, metaDb);
            if (interf != null) {
                interf.fetchFromServer(sessionController, syncPoint);
            }
        }
        catch (Throwable e) {
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            e.printStackTrace(System.err);
        }
    }

    public void fetchPassWordsFromServer(SessionController sessionController) throws Exception {
        try {
            MetaDb metaDb = sessionController.getMetaDbInstance();
            String[] allSyncs = this.asHelper.getAllSyncs(sessionController);
            if (allSyncs != null) {
                int len = allSyncs.length;
                for (int i = 0; i < len; ++i) {
                    if (allSyncs[i] == null || allSyncs[i].length() <= 0) continue;
                    AdminSyncInterface interf = this.asHelper.getClassFromSyncPoint(allSyncs[i], metaDb);
                    interf.fetchPassWordsFromServer(sessionController, allSyncs[i]);
                }
            }
        }
        catch (Throwable e) {
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            e.printStackTrace(System.err);
        }
    }

    public boolean checkPassWordValidity(SessionController sessionController, String passWord, DirectoryUserObjectClientBean user, String userName, FolderObjectClientBean parentFolder) throws Exception {
        return this.checkPassWordValidity(sessionController, passWord, user, userName, parentFolder, null);
    }

    public boolean checkPassWordValidity(SessionController sessionController, String passWord, DirectoryUserObjectClientBean user, String userName, FolderObjectClientBean parentFolder, String callerId) throws Exception {
        boolean isValid = true;
        ArrayList syncList = this.asHelper.getSyncsForObject(sessionController, user, parentFolder, null);
        if (syncList != null) {
            MetaDb metaDb = null;
            try {
                metaDb = sessionController.getMetaDbInstance();
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
            int len = syncList.size();
            for (int i = 0; i < len; ++i) {
                AdminSyncInterface interf;
                String syncPoint = (String)syncList.get(i);
                if ((callerId == null || !callerId.equals("DSAdminSyncPasswordFetch||" + syncPoint)) && !(isValid = (interf = this.asHelper.getClassFromSyncPoint(syncPoint, metaDb)).checkPassWordValidity(sessionController, syncPoint, passWord, user, userName, parentFolder))) break;
            }
        }
        return isValid;
    }

    public AdminSyncHelper getHelperClass() {
        return this.asHelper;
    }
}

