/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.virtual;

import agorum.roi.common.utils.Beans;
import agorum.roi.common.utils.TemplateUtil;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.FolderObjectClientBeanWrapper;
import agorum.roi.statistic.SmartFolderStatistic;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VirtualFolderHelper {
    public static FolderObjectClientBean determineTargetFolder(FolderObjectClientBeanWrapper virtualFolder) throws Exception {
        String targetFolderDefinition = VirtualFolderHelper.getResolvedTargetFolder(virtualFolder);
        if (targetFolderDefinition != null && !targetFolderDefinition.isEmpty()) {
            FolderObjectClientBean targetFolder = (FolderObjectClientBean)Beans.tryLookup(virtualFolder.getSessionController(), targetFolderDefinition);
            if (targetFolder != null) {
                return targetFolder;
            }
            SmartFolderStatistic.getInstance().error("Target directory \"" + targetFolderDefinition + "\" not found");
        }
        return null;
    }

    public static String getResolvedTargetFolder(FolderObjectClientBeanWrapper virtualFolder) throws Exception {
        return VirtualFolderHelper.fillTemplate(virtualFolder.getVirtualFolderDescriptionProvider().getDescription().getTargetFolder(), virtualFolder);
    }

    public static String getResolvedQuery(FolderObjectClientBeanWrapper virtualFolder) throws Exception {
        return VirtualFolderHelper.fillTemplate(virtualFolder.getVirtualFolderDescriptionProvider().getDescription().getQuery(), virtualFolder);
    }

    private static String fillTemplate(String toBeFilled, FolderObjectClientBeanWrapper virtualFolder) throws Exception {
        if (toBeFilled != null && !toBeFilled.isEmpty()) {
            Map<String, AttributeValue[]> replacementData = virtualFolder.getVirtualFolderMetadataHandler().getStructuredExtendedAttributesAll();
            for (Map.Entry<String, AttributeValue[]> entry : virtualFolder.getEntryPoint().getStructuredExtendedAttributesAll().entrySet()) {
                if (!replacementData.containsKey(entry.getKey())) {
                    replacementData.put(entry.getKey(), entry.getValue());
                    continue;
                }
                AttributeValue[] currentArray = replacementData.get(entry.getKey());
                List<AttributeValue> currentList = Arrays.asList(currentArray);
                for (AttributeValue value : entry.getValue()) {
                    if (currentList.indexOf(value) != -1) continue;
                    currentList.add(value);
                }
                replacementData.put(entry.getKey(), currentList.toArray(new AttributeValue[0]));
            }
            HashMap<String, AttributeValue> attributes = new HashMap<String, AttributeValue>();
            for (Map.Entry<String, AttributeValue[]> entry : replacementData.entrySet()) {
                AttributeValue[] value = entry.getValue();
                if (value == null || value.length <= 0) continue;
                attributes.put(entry.getKey(), value[0]);
            }
            return TemplateUtil.fillTemplate(attributes, toBeFilled);
        }
        return toBeFilled;
    }
}

