/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.messaging.common;

import agorum.roi.common.utils.Broadcast;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.EJBHomeHolder;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.QueueUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.TextIndexQueue;
import agorum.roi.ejb.common.TransactionTracker;
import agorum.roi.ejb.interfaces.home.EventAgentHome;
import agorum.roi.ejb.interfaces.remote.EventAgentRemote;
import agorum.roi.ejb.mbeans.MetadataInheritanceAttachedService;
import agorum.roi.ejb.mbeans.PathIndexService;
import agorum.roi.ejb.messaging.common.JmsHolder;
import agorum.roi.ejb.messaging.common.MessageBean;
import agorum.roi.ejb.messaging.common.MessageConnectionHolder;
import agorum.roi.ejb.messaging.common.TransactionController;
import agorum.roi.searchengine.IndexHandlerInterface;
import agorum.roi.searchengine.IndexHelper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class MessageUtils {
    public static long subScriberCounter;
    public Object syncObject = new Object();
    public Object sync = new Object();
    public static long sequenceId;
    public static long realMessages;
    public static long doubleMessages;
    public static Map<String, Subscription> subscriptions;
    private static final String RTH_CHANGES_KEY;

    public MessageConnectionHolder registerSubScriber(MessageListener listener, String topicName) throws Exception {
        return this.registerSubScriber(listener, topicName, false);
    }

    public void sendUpdatePathEvent(SuperObjectClientBean clientBean, SuperObjectClientBeanDefinition def) throws Exception {
        MessageBean mb = new MessageBean();
        mb.setObjectProperty("value", clientBean.getId());
        mb.setObjectProperty("uuid", clientBean.getUUID());
        mb.setObjectProperty("eventType", "updatePathListener");
        mb.setObjectProperty("className", clientBean.getClassName());
        this.publishToTopic(clientBean.getSessionController(), "updatePathListener", mb, true);
    }

    public void sendContentTransferEvent(SessionController sessionController) throws Exception {
        MessageBean mb = new MessageBean();
        mb.setObjectProperty("value", "ContentTransfer");
        mb.setObjectProperty("eventType", "contentTransferListener");
        this.publishToTopic(sessionController, "contentTransferListener", mb, true);
    }

    public void sendUpdateToPathEvent(SuperObjectClientBean clientBean, SuperObjectClientBeanDefinition def) throws Exception {
        MessageBean mb = new MessageBean();
        mb.setObjectProperty("value", clientBean.getId());
        mb.setObjectProperty("uuid", clientBean.getUUID());
        mb.setObjectProperty("eventType", "updateToPathListener");
        mb.setObjectProperty("className", clientBean.getClassName());
        this.publishToTopic(clientBean.getSessionController(), "updateToPathListener", mb, true);
    }

    public void sendCloudEvent(String eventObjectId, Long userId, String eventId, String eventComment, long multiplier, String additionalInfo) throws Exception {
    }

    public void sendUpdateToMetaDataInheritanceEvent(SuperObjectClientBean clientBean, SuperObjectClientBeanDefinition def) throws Exception {
        MessageBean mb = new MessageBean();
        mb.setObjectProperty("value", clientBean.getId());
        mb.setObjectProperty("eventType", "updateToMetaDataInheritanceListener");
        mb.setObjectProperty("className", clientBean.getClassName());
        this.publishToTopic(clientBean.getSessionController(), "updateToMetaDataInheritanceListener", mb, true);
    }

    public void sendCreateEvent(SuperObjectClientBean clientBean, SuperObjectClientBeanDefinition def) throws Exception {
        MessageBean mb = MessageUtils.prepare(clientBean, def);
        mb.setObjectProperty("value", def.getId());
        mb.setObjectProperty("uuid", clientBean.getUUID());
        mb.setObjectProperty("eventType", "createObjectListener");
        this.publishToTopic(clientBean.getSessionController(), "createObjectListener", mb, true);
    }

    public void sendUpdateEvent(SuperObjectClientBean clientBean, SuperObjectClientBeanDefinition def) throws Exception {
        MessageBean mb = MessageUtils.prepare(clientBean, def);
        mb.setObjectProperty("value", clientBean.getId());
        mb.setObjectProperty("uuid", clientBean.getUUID());
        mb.setObjectProperty("eventType", "updateObjectListener");
        this.publishToTopic(clientBean.getSessionController(), "updateObjectListener", mb, true);
    }

    private static MessageBean prepare(SuperObjectClientBean clientBean, SuperObjectClientBeanDefinition def) throws Exception {
        MessageBean mb = new MessageBean();
        mb.setObjectProperty("className", clientBean.getClassName());
        if (def != null) {
            if (def.getSystemOption("doNotEA") != null) {
                mb.setObjectProperty("NoEventAssistanceObject", "true");
            }
            if (def.getSystemOption("forceTimePhasedAction") != null) {
                mb.setObjectProperty("forceTimePhasedAction", "true");
            }
            if (def.getSystemOption("ForceEA") != null) {
                mb.setObjectProperty("ForceEventAssistanceObject", "true");
            }
            if (def.getSystemOption("ShowAlwaysEA") != null) {
                mb.setObjectProperty("ShowAlwaysEA", "true");
            }
            if (def.getSystemOption("NoCache") != null) {
                mb.setObjectProperty("NoCache", "true");
            }
        }
        if (clientBean.getSessionController().getDoNotEA()) {
            mb.setObjectProperty("NoEventAssistanceObject", "true");
        }
        return mb;
    }

    public void sendCustomEventAssistanceEvent(SuperObjectClientBean clientBean, List<DirectoryUserObjectClientBean> users) throws Exception {
        if (users == null || users.size() <= 0) {
            return;
        }
        StringBuilder userSequences = new StringBuilder();
        boolean first = true;
        for (DirectoryUserObjectClientBean user : users) {
            if (first) {
                first = false;
            } else {
                userSequences.append("||");
            }
            userSequences.append(user.getUserSequence());
        }
        MessageBean mb = new MessageBean();
        mb.setObjectProperty("value", clientBean.getId());
        mb.setObjectProperty("uuid", clientBean.getUUID());
        mb.setObjectProperty("eventType", "updateObjectListener");
        mb.setObjectProperty("className", clientBean.getClassName());
        mb.setObjectProperty("ForceEventAssistanceObject", "true");
        mb.setObjectProperty("eventSubType", "customEventAssistance");
        mb.setObjectProperty("users", userSequences.toString());
        this.publishToTopic(clientBean.getSessionController(), "updateObjectListener", mb, true);
    }

    public void sendMoveEvent(SuperObjectClientBean clientBean, String fromPath, String fromName, String toPath, String toName) throws Exception {
        if (clientBean == null) {
            return;
        }
        MessageBean mb = new MessageBean();
        mb.setObjectProperty("value", clientBean.getId());
        mb.setObjectProperty("uuid", clientBean.getUUID());
        mb.setObjectProperty("fromFullPath", fromPath + "/" + fromName);
        mb.setObjectProperty("toFullPath", toPath + "/" + toName);
        mb.setObjectProperty("eventType", "updateObjectListener");
        mb.setObjectProperty("className", clientBean.getClassName());
        this.publishToTopic(clientBean.getSessionController(), "updateObjectListener", mb, true);
    }

    public void sendDeleteEvent(SuperObjectClientBean clientBean) throws Exception {
        MessageBean mb = new MessageBean();
        mb.setObjectProperty("value", clientBean.getId());
        mb.setObjectProperty("uuid", clientBean.getUUID());
        mb.setObjectProperty("eventType", "deleteObjectListener");
        mb.setObjectProperty("className", clientBean.getClassName());
        this.publishToTopic(clientBean.getSessionController(), "deleteObjectListener", mb, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConnectionHolder registerSubScriber(MessageListener listener, String topicName, boolean transacted) throws Exception {
        Subscription.add(listener, topicName);
        TopicConnectionFactory factory = (TopicConnectionFactory)EJBHomeHolder.getHome("java:/ConnectionFactory");
        Topic topic = (Topic)EJBHomeHolder.getHome("topic/" + topicName);
        TopicConnection connect = factory.createTopicConnection();
        TopicSession session = connect.createTopicSession(transacted, 1);
        TopicSubscriber subscriber = session.createSubscriber(topic);
        subscriber.setMessageListener(listener);
        connect.start();
        MessageConnectionHolder msgConnectionHolder = new MessageConnectionHolder();
        msgConnectionHolder.setTopicConnection(connect);
        msgConnectionHolder.setTopicSession(session);
        msgConnectionHolder.setTopicSubscriber(subscriber);
        String jmsId = JmsHolder.addConnection(msgConnectionHolder);
        msgConnectionHolder.setJmsId(jmsId);
        Object object = this.syncObject;
        synchronized (object) {
            ++subScriberCounter;
        }
        return msgConnectionHolder;
    }

    public void unregisterSubScriber(MessageConnectionHolder msgConnectionHolder) throws Exception {
        try {
            String topicName = msgConnectionHolder.getTopicSubscriber().getTopic().getTopicName();
            MessageListener listener = msgConnectionHolder.getTopicSubscriber().getMessageListener();
            Subscription.remove(listener, topicName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TransactionController.addJmsId(msgConnectionHolder.getJmsId());
    }

    public static synchronized long getSequenceId() {
        return ++sequenceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finallyUnregisterSubScriber(MessageConnectionHolder msgConnectionHolder) throws Exception {
        try {
            msgConnectionHolder.getTopicConnection().stop();
            msgConnectionHolder.getTopicSession().close();
            msgConnectionHolder.getTopicConnection().close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            Object object = this.syncObject;
            synchronized (object) {
                --subScriberCounter;
            }
        }
    }

    public void publishToTopic(SessionController sessionController, String topicName, MessageBean value, boolean transacted) throws Exception {
        if (sessionController.isInClusterMode()) {
            return;
        }
        this.publishToTopic(topicName, value, transacted);
    }

    public void publishToTopic(String topicName, MessageBean value, boolean transacted) throws Exception {
        try (IndexHandlerInterface indexHandler = IndexHelper.getIndexHandlerDefault();){
            if (indexHandler.shouldPreIndex(topicName)) {
                indexHandler.preIndex(topicName, (Long)value.get("value"), (String)value.get("uuid"));
            }
            if ("createObjectListener".equals(topicName)) {
                TextIndexQueue.insert(0, (Long)value.get("value"), (String)value.get("uuid"));
            } else if ("deleteObjectListener".equals(topicName)) {
                TextIndexQueue.insert(0, -((Long)value.get("value")).longValue(), (String)value.get("uuid"));
            } else if ("updateObjectListener".equals(topicName)) {
                TextIndexQueue.insert(1, (Long)value.get("value"), (String)value.get("uuid"));
            } else if ("updatePathListener".equals(topicName)) {
                TextIndexQueue.insert(2, (Long)value.get("value"), (String)value.get("uuid"));
            } else {
                if ("updateToMetaDataInheritanceListener".equals(topicName)) {
                    QueueUtils.add("tometadatainheritanceindex", (Long)value.get("value"), () -> MetadataInheritanceAttachedService.wake());
                    return;
                }
                if ("updateToPathListener".equals(topicName)) {
                    QueueUtils.add("topathindex", (Long)value.get("value"), () -> PathIndexService.wake());
                    return;
                }
            }
        }
        boolean doSend = true;
        try {
            Object o = value.getObjectProperty("value");
            Object o1 = value.getObjectProperty("valueRightObject");
            if (value.getObjectProperty("ForceEventAssistanceObject") == null && value.getObjectProperty("forceTimePhasedAction") == null && o instanceof Long) {
                Long l = (Long)o;
                Long l1 = (Long)o1;
                String msgId = topicName + "_" + l + "_" + transacted;
                if (l1 != null) {
                    msgId = msgId + "_" + l1 + "_" + transacted;
                }
                if (TransactionTracker.containsMessage(msgId)) {
                    ++doubleMessages;
                    doSend = false;
                } else {
                    ++realMessages;
                    TransactionTracker.addMessage(msgId);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error in Tracking");
        }
        if (doSend) {
            EventAgentHome eventAgent = (EventAgentHome)EJBHomeHolder.getHome("ejb/EventAgent");
            EventAgentRemote remote = eventAgent.create();
            if (transacted) {
                remote.sendEvent(topicName, value, transacted);
            } else {
                remote.sendEventNotTransacted(topicName, value, transacted);
            }
            remote.remove();
            this.broadcast(value);
        }
    }

    public void broadcast(MessageBean data) throws Exception {
        String topicName = (String)data.get("eventType");
        Broadcast.pub(topicName, data);
    }

    public void publishToQueue(String queueName, Object value) throws Exception {
        QueueConnectionFactory factory = (QueueConnectionFactory)EJBHomeHolder.getHome("java:/ConnectionFactory");
        Queue queue = (Queue)EJBHomeHolder.getHome("queue/" + queueName);
        QueueConnection connect = factory.createQueueConnection();
        QueueSession session = connect.createQueueSession(false, 1);
        QueueSender sender = session.createSender(queue);
        Message msg = session.createMessage();
        msg.setObjectProperty("value", value);
        sender.send(msg);
        connect.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendThroughEJB(String topicName, MessageBean value, boolean transacted) throws Exception {
        TopicConnectionFactory factory = (TopicConnectionFactory)EJBHomeHolder.getHome("java:comp/env/jms/MyTopicConnection");
        TopicConnection topicConnection = factory.createTopicConnection();
        TopicSession topicSession = null;
        try {
            Topic topic = (Topic)EJBHomeHolder.getHome("java:comp/env/jms/" + topicName);
            topicSession = topicConnection.createTopicSession(transacted, 1);
            TopicPublisher topicPublisher = topicSession.createPublisher(topic);
            topicPublisher.setDeliveryMode(1);
            Message message = topicSession.createMessage();
            Enumeration keysEnum = value.keys();
            while (keysEnum.hasMoreElements()) {
                String key = (String)keysEnum.nextElement();
                message.setObjectProperty(key, value.getObjectProperty(key));
            }
            message.setJMSDeliveryMode(1);
            topicPublisher.publish(message);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            if (topicSession != null) {
                try {
                    topicSession.close();
                    topicSession = null;
                }
                catch (Exception exception) {}
            }
            if (topicConnection != null) {
                try {
                    topicConnection.close();
                    topicConnection = null;
                }
                catch (Exception exception) {}
            }
            factory = null;
        }
    }

    public void sendReadEvent(SessionController sessionController, ContentInterface contentInterface, boolean ignoreAccessCounterService) throws Exception {
        this.sendReadEvent(sessionController, contentInterface, ignoreAccessCounterService, sessionController.getLoginUserId());
    }

    public void sendReadEvent(SessionController sessionController, ContentInterface contentInterface, boolean ignoreAccessCounterService, Long userId) throws Exception {
        if (sessionController.isInClusterMode()) {
            return;
        }
        MessageBean mb = new MessageBean();
        mb.setObjectProperty("eventType", "updateAccessCounterListener");
        mb.setObjectProperty("value", contentInterface.getId());
        mb.setObjectProperty("user", userId);
        mb.setObjectProperty("className", ((GlobalObjectClientBean)((Object)contentInterface)).getClassName());
        mb.setObjectProperty("ignoreAccessCounterService", ignoreAccessCounterService);
        this.publishToTopic(sessionController, "updateAccessCounterListener", mb, false);
    }

    public void sendUnreadEvent(SessionController sessionController, ContentInterface contentInterface) throws Exception {
        this.sendUnreadEvent(sessionController, contentInterface, false);
    }

    public void sendUnreadEvent(SessionController sessionController, ContentInterface contentInterface, boolean ignoreAccessCounterService) throws Exception {
        this.sendUnreadEvent(sessionController, contentInterface, ignoreAccessCounterService, sessionController.getLoginUserId());
    }

    public void sendUnreadEvent(SessionController sessionController, ContentInterface contentInterface, boolean ignoreAccessCounterService, Long userId) throws Exception {
        if (sessionController.isInClusterMode()) {
            return;
        }
        MessageBean mb = new MessageBean();
        mb.setObjectProperty("eventType", "resetAccessCounterListener");
        mb.setObjectProperty("value", contentInterface.getId());
        mb.setObjectProperty("user", userId);
        mb.setObjectProperty("className", ((GlobalObjectClientBean)((Object)contentInterface)).getClassName());
        mb.setObjectProperty("ignoreAccessCounterService", ignoreAccessCounterService);
        this.publishToTopic(sessionController, "updateAccessCounterListener", mb, true);
    }

    public void checkMessageObject(Message msg, SessionController sessionController) throws Exception {
    }

    static {
        subscriptions = new ConcurrentHashMap<String, Subscription>();
        RTH_CHANGES_KEY = MessageUtils.class.getName();
    }

    public static class Subscription {
        public final String key;
        public final String stack;

        private Subscription(String key, String stack) {
            this.key = key;
            this.stack = stack;
        }

        public static void add(MessageListener listener, String topicName) {
            String key = Subscription.getKey(listener, topicName);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            new Throwable().printStackTrace(pw);
            String stack = sw.toString();
            subscriptions.put(key, new Subscription(key, stack));
        }

        public static void remove(MessageListener listener, String topicName) {
            subscriptions.remove(Subscription.getKey(listener, topicName));
        }

        private static String getKey(MessageListener listener, String topicName) {
            return listener.toString() + "_" + topicName;
        }
    }
}

