/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.mbeans;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.cron.SystemTimer;
import agorum.commons.cron.Trace;
import agorum.commons.logging.AgorumCoreStartDescLogger;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemObjectReference;
import agorum.roi.common.Startup;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.OpenFileHelper;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.mbeans.IntMsgBean;
import agorum.roi.ejb.mbeans.TimePhasedActionService;
import agorum.roi.ejb.mbeans.TimePhasedActionTimerServiceMBean;
import agorum.roi.statistic.timephasedactions.TimePhasedActionStatistic;
import agorum.roi.timephasedaction.common.TimePhasedActionUtils;
import java.util.Date;

public class TimePhasedActionTimerService
implements TimePhasedActionTimerServiceMBean {
    private SystemTimer timer = null;
    private SessionController gSessionController = null;
    private boolean isStarted;
    private TimePhasedActionStatistic stat;

    @Override
    public void start() {
        Startup.whenReady(() -> {
            new AgorumCoreStartDescLogger().writeDescToFile("Starting timephased action timer service...\n\n", "");
            try {
                this.stat = TimePhasedActionStatistic.getInstance();
                this.timer = SystemTimer.ofPeriod((long)1000L).name("TimePhasedActionTimerService").call((Runnable)new WorkerThread());
            }
            catch (Exception ex) {
                if (this.stat != null) {
                    this.stat.error(ex, "Error starting TimePhasedActionTimerService");
                }
                ex.printStackTrace(System.err);
            }
        });
    }

    @Override
    public void stop() {
        this.timer.cancel();
    }

    private synchronized boolean isStarted() {
        if (this.isStarted) {
            return true;
        }
        this.isStarted = true;
        return false;
    }

    private void connect() throws Exception {
        if (this.gSessionController == null) {
            try {
                RoiProperties rp = new RoiProperties();
                CredentialObject credential = new CredentialObject();
                credential.setUserName(rp.getRoiSystemUser());
                credential.setAuthInterface(new ServiceAuthInterface());
                credential.setModulInfo("TimePhasedActionService");
                this.gSessionController = SessionController.connect(credential);
            }
            catch (Exception e) {
                this.gSessionController = null;
            }
        } else {
            this.gSessionController.reconnectIfNeeded();
        }
    }

    public class WorkerThread
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try (Trace.Auto trace = Trace.auto((String)"Time phased action timer service");){
                Object o = null;
                if (TimePhasedActionTimerService.this.isStarted()) return;
                trace.starting();
                TimePhasedActionTimerService.this.stat.setServiceStatus(Statistic.ServiceStatus.RUNNING);
                try {
                    while ((o = TimePhasedActionService.queueing(null)) != null) {
                        trace.working("Invoking time phased action");
                        if (o instanceof IntMsgBean) {
                            TimePhasedActionTimerService.this.stat.count("TimePhasedAction Invocations", 1L);
                            IntMsgBean imsg = (IntMsgBean)o;
                            try {
                                Long id;
                                trace.working("Connecting");
                                TimePhasedActionTimerService.this.connect();
                                String eventType = imsg.getEventType();
                                String ftpa = imsg.getForceTS();
                                if (ftpa == null && (eventType == null || !eventType.equals("addRelationListener")) || (id = imsg.getObjectId()) == null) continue;
                                GlobalObjectClientBean gocb = null;
                                try {
                                    gocb = TimePhasedActionTimerService.this.gSessionController.getGlobalObjectById(id);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (gocb == null) continue;
                                TimePhasedActionUtils tau = new TimePhasedActionUtils();
                                long age = System.currentTimeMillis() - gocb.getUpdateDate().getTime();
                                if (gocb.getTimePhasedAction() == null || gocb.getTimePhasedActionDate().getTime() > new Date().getTime() || gocb.getTimePhasedActionDate().getTime() <= 0L) continue;
                                if (!(gocb.isLocked() || gocb.isLockedForSession() || OpenFileHelper.randomFileHash.containsKey("" + gocb.getId()) || age <= 10000L)) {
                                    String taa = gocb.getTimePhasedAction();
                                    boolean runOnEvents = false;
                                    try {
                                        MetaDb metaDb = TimePhasedActionTimerService.this.gSessionController.getMetaDbInstance();
                                        runOnEvents = Boolean.parseBoolean(metaDb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/timephasedaction/control/" + taa + "/RunOnEvents")[0]);
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    if (!runOnEvents) continue;
                                    trace.working("Running time phased action");
                                    tau.runAction(TimePhasedActionTimerService.this.gSessionController, gocb);
                                    continue;
                                }
                                if (age > 10000L && TimePhasedActionTimerService.this.stat.logInfo()) {
                                    TimePhasedActionTimerService.this.stat.info().object((SystemObjectReference)gocb).send("---- TimephasedAction deferred, Object is locked: " + gocb.getId() + ", " + gocb.getName());
                                }
                                trace.working("Rescheduling time phased action");
                                imsg.setQueueTime(System.currentTimeMillis());
                                TimePhasedActionService.reAdd(imsg);
                                continue;
                            }
                            catch (Exception jmsE) {
                                trace.failed();
                                TimePhasedActionTimerService.this.stat.error(jmsE, "Error in worker thread");
                                continue;
                            }
                        }
                        trace.waiting("Sleeping");
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    trace.ended();
                    return;
                }
                finally {
                    TimePhasedActionTimerService.this.isStarted = false;
                    TimePhasedActionTimerService.this.stat.setServiceStatus(Statistic.ServiceStatus.STOPPED);
                }
            }
        }
    }
}

