/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.mbeans;

import agorum.commons.logging.AgorumCoreStartDescLogger;
import agorum.commons.server.ServiceUtils;
import agorum.commons.statistic.Statistic;
import agorum.roi.ejb.common.JMSEventController;
import agorum.roi.ejb.common.JMSEventListenerBean;
import agorum.roi.ejb.common.JMSEventListenerInterface;
import agorum.roi.ejb.mbeans.IntMsgBean;
import agorum.roi.ejb.mbeans.TimePhasedActionServiceMBean;
import agorum.roi.ejb.messaging.common.MessageConnectionHolder;
import agorum.roi.ejb.messaging.common.MessageUtils;
import agorum.roi.statistic.timephasedactions.TimePhasedActionStatistic;
import agorum.roi.statistic.timephasedactions.TimePhasedActionStatistics;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jms.Message;
import javax.jms.MessageListener;

public class TimePhasedActionService
implements TimePhasedActionServiceMBean,
MessageListener,
JMSEventListenerInterface {
    private static List<IntMsgBean> queue = new ArrayList<IntMsgBean>();
    private static JMSEventListenerBean jmsBean = null;
    private static JMSEventController eventController = null;
    private static Set<String> messages = null;
    private TimePhasedActionStatistic stat;
    private List<MessageConnectionHolder> messageConnectionHolders = new ArrayList<MessageConnectionHolder>();

    @Override
    public void start() {
        AgorumCoreStartDescLogger startLogger = new AgorumCoreStartDescLogger();
        startLogger.writeDescToFile("Starting timephasedaction service...\n\n", "");
        TimePhasedActionStatistics.getInstance();
        this.stat = TimePhasedActionStatistic.getInstance();
        final TimePhasedActionService jmsEventListener = this;
        ServiceUtils.whenAutoUpdateFinished((Runnable)new Runnable(){

            @Override
            public void run() {
                TimePhasedActionService.this.stat.debug("TimePhasedActionService: Service is started");
                try {
                    messages = new HashSet();
                    TimePhasedActionService.this.connectEvents();
                    TimePhasedActionService.this.stat.setServiceStatus(Statistic.ServiceStatus.RUNNING);
                    jmsBean = new JMSEventListenerBean();
                    jmsBean.setId("TimePhasedActionService_" + jmsEventListener.hashCode());
                    jmsBean.setJmsEventListener(jmsEventListener);
                    eventController = JMSEventController.getInstance();
                    eventController.registerListener(jmsBean);
                }
                catch (Exception e) {
                    TimePhasedActionService.this.stat.error(e, "Error while starting service");
                }
            }
        });
    }

    @Override
    public void stop() {
        this.stat.setServiceStatus(Statistic.ServiceStatus.STOPPED);
        this.disconnectEvents();
        jmsBean.setRemoveEvent(true);
    }

    private void connectEvents() {
        try {
            MessageUtils messageUtils = new MessageUtils();
            this.messageConnectionHolders.add(messageUtils.registerSubScriber(this, "updateObjectListener"));
            this.messageConnectionHolders.add(messageUtils.registerSubScriber(this, "addRelationListener"));
        }
        catch (Exception e) {
            this.stat.error(e, "Error connecting events");
        }
    }

    private void disconnectEvents() {
        MessageUtils mu = new MessageUtils();
        for (MessageConnectionHolder messageConnectionHolder : this.messageConnectionHolders) {
            try {
                mu.unregisterSubScriber(messageConnectionHolder);
            }
            catch (Exception e) {
                this.stat.error(e, "Error unregistering subscriber");
            }
        }
        this.messageConnectionHolders.clear();
    }

    @Override
    public void reconnectEvent() {
        this.disconnectEvents();
        this.connectEvents();
    }

    @Override
    public void sendCheckEvent() {
        eventController.sendMyEvent(jmsBean, "updateObjectListener");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object queueing(Message msg) {
        List<IntMsgBean> list = queue;
        synchronized (list) {
            if (msg != null) {
                IntMsgBean mb;
                if (!eventController.checkMyEvent(jmsBean, msg) && !messages.contains((mb = new IntMsgBean(msg)).getKey())) {
                    try {
                        mb.setQueueTime(System.currentTimeMillis());
                        messages.add(mb.getKey());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    queue.add(mb);
                }
                return null;
            }
            IntMsgBean nextMessage = null;
            if (queue.size() > 0) {
                nextMessage = queue.get(0);
                long time = nextMessage.getQueueTime();
                if (System.currentTimeMillis() - time > 2000L) {
                    messages.remove(nextMessage.getKey());
                    queue.remove(0);
                } else {
                    return "wait";
                }
            }
            return nextMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reAdd(IntMsgBean msg) {
        List<IntMsgBean> list = queue;
        synchronized (list) {
            queue.add(msg);
        }
    }

    public void onMessage(Message msg) {
        TimePhasedActionService.queueing(msg);
    }
}

