/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.mbeans;

import agorum.commons.cron.SystemTimer;
import agorum.commons.cron.Trace;
import agorum.commons.logging.AgorumCoreStartDescLogger;
import agorum.commons.logging.Log;
import agorum.commons.server.ServiceUtils;
import agorum.commons.statistic.SystemObjectReference;
import agorum.commons.statistic.SystemStatistic;
import agorum.commons.tuple.Pair;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SessionInfoObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.common.LoginLogoutHandler;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.ejb.mbeans.SessionUnLockServiceMBean;
import agorum.roi.statistic.SessionControllerStatistic;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SessionUnLockService
implements SessionUnLockServiceMBean {
    private static final SystemStatistic stat = SessionControllerStatistic.getInstance();
    private SessionController sessionController;
    private boolean isRunning = false;
    protected boolean listenActive = true;
    private static final Queue<Pair<Long, Runnable>> queue = new ConcurrentLinkedQueue<Pair<Long, Runnable>>();

    public static void unlock(long sessionId, Runnable cleanup) {
        queue.add((Pair<Long, Runnable>)new Pair((Object)sessionId, (Object)cleanup));
    }

    @Override
    public void start() {
        stat.info("Starting Session UnLock Service");
        AgorumCoreStartDescLogger startLogger = new AgorumCoreStartDescLogger();
        startLogger.writeDescToFile("Starting session unlock service...\n\n", "");
        ServiceUtils.whenStarted(() -> {
            Throwable throwable;
            Transaction t;
            stat.info("SessionUnLockService: Server is started");
            try {
                t = new Transaction();
                throwable = null;
                try {
                    this.connect();
                    t.commit();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (t != null) {
                        if (throwable != null) {
                            try {
                                t.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            t.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                Log.error((Throwable)e);
                return;
            }
            new SocketThread().start();
            SystemTimer.ofPeriod((long)10000L).call(this::unlock);
            try {
                t = new Transaction();
                throwable = null;
                try {
                    stat.info("Unlocking all session locked objects");
                    this.unLockGlobalObjects(null, 4);
                    this.unLockGlobalObjects(null, 8);
                    t.commit();
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (t != null) {
                        if (throwable != null) {
                            try {
                                t.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            t.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                stat.error((Throwable)e);
            }
            try {
                t = new Transaction();
                throwable = null;
                try {
                    stat.info("set all SessionInfoObject to inactive start");
                    this.setSessionInfoObjectInActive(this.sessionController, new Date(System.currentTimeMillis() - 120000L));
                    stat.info("set all SessionInfoObject to inactive end");
                    t.commit();
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (t != null) {
                        if (throwable != null) {
                            try {
                                t.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            t.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                Log.warning((Throwable)e);
            }
        });
    }

    @Override
    public void stop() {
        stat.info("Stopping Session UnLock Service");
        try (Socket socket = new Socket("localhost", new RoiProperties().getSessionUnlockPort());){
            OutputStream os = socket.getOutputStream();
            os.write("finish\n".getBytes());
            os.close();
        }
        catch (Exception e) {
            stat.error((Throwable)e);
        }
    }

    private void setSessionNotActive(Long sessionId) throws Exception {
        SessionInfoObjectClientBean sessionInfo = this.sessionController.getSessionInfoObject(sessionId);
        if (sessionInfo != null) {
            sessionInfo.setSiActive(false);
        }
    }

    private void unLockGlobalObjects(Long sessionId, int lockState) throws Exception {
        SuperObjectClientBean[] soArr = null;
        soArr = sessionId == null ? this.sessionController.getSuperObjectByAttribute(this.sessionController, GlobalObjectClientBean.LOCKSTATE_ATTRIBUTE, new Integer(lockState), false, this.sessionController.getClassObject(GlobalObjectClientBean.CLASS_NAME)) : this.sessionController.getSuperObjectByAttribute(this.sessionController, GlobalObjectClientBean.LOCKEDFOR_ATTRIBUTE, sessionId, false, this.sessionController.getClassObject(GlobalObjectClientBean.CLASS_NAME));
        if (soArr != null) {
            int len = soArr.length;
            for (int i = 0; i < len; ++i) {
                try {
                    GlobalObjectClientBean globalObject = (GlobalObjectClientBean)soArr[i];
                    stat.debug().object((SystemObjectReference)globalObject).send("Unlocking");
                    globalObject.unlock();
                    continue;
                }
                catch (Exception e) {
                    stat.error((Throwable)e);
                }
            }
        }
    }

    private void connect() throws Exception {
        this.sessionController = SessionControllerAdmin.getService(SessionUnLockService.class);
    }

    private void setSessionInfoObjectInActive(SessionController sessionController, Date maxDate) throws Exception {
        SuperObjectClientBean[] allInfoObjects = sessionController.getSuperObjectByAttributes(sessionController, sessionController.getClassObject(SessionInfoObjectClientBean.CLASS_NAME), new String[]{"SIACTIVE", "SILOGINDATE"}, new Object[]{Boolean.TRUE, maxDate}, new int[]{0, 1}, new boolean[]{false, false}, new int[]{1, 1}, null, null);
        if (allInfoObjects != null) {
            int len = allInfoObjects.length;
            for (int i = 0; i < len; ++i) {
                if (allInfoObjects[i] == null) continue;
                SessionInfoObjectClientBean sessionInfo = (SessionInfoObjectClientBean)allInfoObjects[i];
                sessionInfo.setSiActive(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unlock() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        try (Trace.Auto trace = Trace.auto((String)"Session unlock service unlock thread");){
            Pair<Long, Runnable> pair;
            while ((pair = queue.poll()) != null) {
                Long sessionId = (Long)pair.getFirst();
                Runnable cleanup = (Runnable)pair.getSecond();
                if (cleanup != null) {
                    try {
                        cleanup.run();
                    }
                    catch (Exception e) {
                        stat.error((Throwable)e);
                    }
                }
                try {
                    Transaction t = new Transaction();
                    Throwable throwable = null;
                    try {
                        stat.debug("Unlocking all objects for sessionId: " + sessionId);
                        this.connect();
                        try {
                            for (LoginLogoutHandler plh : SessionController.getLoginLogoutHandler(this.sessionController)) {
                                if (plh == null) continue;
                                try {
                                    plh.preLogout(this.sessionController, this.sessionController.getSessionInfoObject(sessionId));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.unLockGlobalObjects(new Long(sessionId), 4);
                        stat.debug("Unlocked all objects for sessionId: " + sessionId);
                        this.setSessionNotActive(new Long(sessionId));
                        t.commit();
                        stat.debug("Finished unlocking sessionId: " + sessionId);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (t == null) continue;
                        if (throwable != null) {
                            try {
                                t.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        t.close();
                    }
                }
                catch (Throwable e) {
                    stat.error(e);
                }
            }
            trace.ended();
            return;
        }
        finally {
            this.isRunning = false;
        }
    }

    public class EventThread
    extends Thread {
        private final Socket socket;

        public EventThread(Socket s) {
            this.socket = s;
        }

        @Override
        public void run() {
            try (Trace.Auto trace = Trace.auto((String)"Session unlock service event thread");){
                try {
                    trace.working("Reading input stream");
                    InputStream inputStream = this.socket.getInputStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                    String sId = br.readLine();
                    stat.debug("SessionUnLockService: read sessionId: " + sId);
                    if (sId.equals("finish")) {
                        SessionUnLockService.this.listenActive = false;
                    } else {
                        trace.working("Executing message");
                        queue.add(new Pair((Object)new Long(sId), null));
                    }
                    trace.working("Closing stream and socket");
                    br.close();
                    this.socket.close();
                    trace.ended();
                }
                catch (Exception e) {
                    trace.failed();
                    stat.error((Throwable)e);
                }
            }
        }
    }

    public class SocketThread
    extends Thread {
        @Override
        public void run() {
            try (Trace.Auto trace = Trace.auto((String)"Session unlock service socket thread");){
                try {
                    trace.working("Creating server socket");
                    InetAddress inetAdr = InetAddress.getByName("localhost");
                    try (ServerSocket ss = new ServerSocket(new RoiProperties().getSessionUnlockPort(), 0, inetAdr);){
                        while (SessionUnLockService.this.listenActive) {
                            trace.waiting("Waiting for incoming connection");
                            Socket s = ss.accept();
                            stat.debug("SessionUnLockService: got connection");
                            try {
                                s.setTcpNoDelay(true);
                            }
                            catch (Exception e) {
                                stat.error((Throwable)e);
                            }
                            stat.debug("Starting event thread");
                            new EventThread(s).start();
                        }
                        trace.ended();
                    }
                }
                catch (Exception e) {
                    trace.failed();
                    stat.error((Throwable)e);
                }
            }
        }
    }
}

