/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.mbeans;

import agorum.commons.cron.Trace;
import agorum.commons.server.ServiceUtils;
import agorum.commons.statistic.Statistic;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientCachedBean;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.QueueUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.ejb.common.TransactionAmount;
import agorum.roi.ejb.messaging.common.MessageUtils;
import agorum.roi.statistic.searchengine.IndexStatistic;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Set;

public class PathIndexService {
    private static final String STICKY_WARNING_NO_TO_PATH_INDEX_PROGRESS = "STICKY_WARNING_NO_PATH_INDEX_PROGRESS";
    private static final IndexStatistic stat = IndexStatistic.getInstance();
    private static final Thread thread = new Thread(() -> {
        Trace.Auto trace = Trace.auto((String)"topathindex service");
        Throwable throwable = null;
        try {
            try {
                while (true) {
                    try {
                        while (true) {
                            trace.waiting("Sleeping");
                            PathIndexService.sleep(10000L);
                            trace.working("Working");
                            PathIndexService.work(trace);
                        }
                    }
                    catch (Exception e) {
                        trace.failed();
                        stat.error(e);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (trace != null) {
                if (throwable != null) {
                    try {
                        trace.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    trace.close();
                }
            }
            throw throwable3;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sleep(long timeout) throws InterruptedException {
        Thread thread = PathIndexService.thread;
        synchronized (thread) {
            PathIndexService.thread.wait(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wake() {
        Thread thread = PathIndexService.thread;
        synchronized (thread) {
            PathIndexService.thread.notifyAll();
        }
    }

    private static void work(Trace.Auto trace) {
        try {
            if (SessionController.getImportMode()) {
                return;
            }
            trace.starting();
            stat.debug().send("work");
            SessionController sc = SessionControllerAdmin.getService(PathIndexService.class);
            boolean hasMore = false;
            do {
                Throwable throwable;
                Connection conn4;
                Throwable throwable2;
                long minSortId;
                long id;
                block130: {
                    sc.reconnectIfNeeded();
                    stat.setServiceStatus(Statistic.ServiceStatus.RUNNING);
                    trace.working("Counting tables");
                    try (Connection conn2 = new ConnectionUtils(sc).getConnection();){
                        long queueSize = QueueUtils.count("topathindex");
                        stat.measure("Index queue size: To Path Index", queueSize);
                    }
                    id = -1L;
                    minSortId = -1L;
                    throwable2 = null;
                    try (Connection conn3 = new ConnectionUtils(sc).getConnection();){
                        String minSelect = "select min(SORTID) from topathindex";
                        try (PreparedStatement ps = conn3.prepareStatement(minSelect);
                             ResultSet rs = ps.executeQuery();){
                            if (rs != null && rs.next()) {
                                minSortId = rs.getLong(1);
                            }
                        }
                        if (minSortId < 0L) break block130;
                        String select = "select ID,SORTID from topathindex where SORTID = ?";
                        try (PreparedStatement ps = conn3.prepareStatement(select);){
                            ps.setLong(1, minSortId);
                            try (ResultSet rs = ps.executeQuery();){
                                if (rs != null && rs.next()) {
                                    id = rs.getLong(1);
                                }
                            }
                        }
                    }
                    catch (Throwable minSelect) {
                        throwable2 = minSelect;
                        throw minSelect;
                    }
                }
                hasMore = false;
                if (id <= 0L) continue;
                throwable2 = null;
                try (Transaction t = new Transaction();){
                    conn4 = new ConnectionUtils(sc).getConnection();
                    throwable = null;
                    try {
                        QueueUtils.clearDuplicates(conn4, "topathindex", id, minSortId);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (conn4 != null) {
                            if (throwable != null) {
                                try {
                                    conn4.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                conn4.close();
                            }
                        }
                    }
                    t.commit();
                }
                catch (Throwable conn4) {
                    throwable2 = conn4;
                    throw conn4;
                }
                stat.debug().objectId(Long.valueOf(id)).send("handling object");
                hasMore = true;
                try {
                    PathIndexService.pathWalker(sc, id);
                }
                catch (Exception e) {
                    stat.error().detail((Object)"An error has occurred in PathIndexService.").objectId(Long.valueOf(id)).exception((Throwable)e).send("ToPathIndex queue not progressing");
                }
                t = new Transaction();
                throwable2 = null;
                try {
                    conn4 = new ConnectionUtils(sc).getConnection();
                    throwable = null;
                    try {
                        stat.debug().objectId(Long.valueOf(id)).send("object finished, remove from queue: sortId: " + minSortId);
                        QueueUtils.remove(conn4, "topathindex", id, minSortId);
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (conn4 != null) {
                            if (throwable != null) {
                                try {
                                    conn4.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                conn4.close();
                            }
                        }
                    }
                    t.commit();
                }
                catch (Throwable throwable7) {
                    throwable2 = throwable7;
                    throw throwable7;
                }
                finally {
                    if (t != null) {
                        if (throwable2 != null) {
                            try {
                                t.close();
                            }
                            catch (Throwable throwable8) {
                                throwable2.addSuppressed(throwable8);
                            }
                        } else {
                            t.close();
                        }
                    }
                }
            } while (hasMore);
            stat.setServiceStatus(Statistic.ServiceStatus.STOPPED);
            stat.clearStickyLogEntry(STICKY_WARNING_NO_TO_PATH_INDEX_PROGRESS);
        }
        catch (Throwable e) {
            stat.error().detail((Object)"An error has occurred in PathIndexService that prevented the path inheritance queue from being processed.").exception(e).sticky(STICKY_WARNING_NO_TO_PATH_INDEX_PROGRESS).send("ToPathIndex queue not progressing");
        }
    }

    private static void pathWalker(SessionController sc, long id) throws Exception {
        stat.debug().objectId(Long.valueOf(id)).send("PathIndex: Begin PathWalk");
        GlobalObjectClientBean obj = null;
        try (Transaction t = new Transaction(-1);){
            TransactionAmount tHelper = new TransactionAmount(t, 100L);
            try {
                obj = sc.getGlobalObjectById(new Long(id));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (obj != null) {
                PathIndexService.pathWalkerRec(tHelper, obj, new HashSet<Long>());
            }
            t.commit();
        }
        stat.debug().objectId(Long.valueOf(id)).send("PathIndex: End PathWalk");
    }

    private static void pathWalkerRec(TransactionAmount tHelper, GlobalObjectClientBean gocb, Set<Long> ids) throws Exception {
        SuperObjectClientCachedBean.invalidateCachedObject(gocb.getId());
        MessageUtils mu = new MessageUtils();
        mu.sendUpdatePathEvent(gocb, null);
        tHelper.bulkedCommit();
        if (gocb instanceof FolderObjectClientBean) {
            for (SuperObjectClientBean superObjectClientBean : ((FolderObjectClientBean)gocb).items()) {
                if (!ids.add(superObjectClientBean.getId())) continue;
                PathIndexService.pathWalkerRec(tHelper, (GlobalObjectClientBean)superObjectClientBean, ids);
            }
        }
        for (SuperObjectClientBean superObjectClientBean : gocb.getIndexSubObjects()) {
            if (!(superObjectClientBean instanceof GlobalObjectClientBean) || superObjectClientBean.equals(gocb) || !ids.add(superObjectClientBean.getId())) continue;
            PathIndexService.pathWalkerRec(tHelper, (GlobalObjectClientBean)superObjectClientBean, ids);
        }
    }

    static {
        stat.setServiceStatus(Statistic.ServiceStatus.NOT_STARTED_YET);
        ServiceUtils.whenAutoUpdateFinished(thread::start);
    }
}

