/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.mbeans;

import agorum.commons.logging.AgorumCoreStartDescLogger;
import agorum.commons.server.ServiceUtils;
import agorum.roi.ejb.client.beans.FolderRelationObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.GenericMultiQueueBean;
import agorum.roi.ejb.common.GenericMultiQueueHelper;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.ejb.mbeans.PathDateServiceMBean;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PathDateService
implements PathDateServiceMBean,
Runnable {
    private static final String METADB_BASE = "MAIN_MODULE_MANAGEMENT/roi/control/pathdate/";
    private SessionController sessionController = null;
    public static String QUEUE_IDENT = "PathDateService";
    private boolean running = true;

    @Override
    public void start() {
        System.out.println("---------- Starting Path Date Service -------------");
        AgorumCoreStartDescLogger startLogger = new AgorumCoreStartDescLogger();
        startLogger.writeDescToFile("Starting path date service...\n\n", "");
        final PathDateService self = this;
        ServiceUtils.whenAutoUpdateFinished((Runnable)new Runnable(){

            @Override
            public void run() {
                new Thread(self).start();
            }
        });
    }

    @Override
    public void stop() {
        System.out.println("---------- Stopping Path Date Service -------------");
        this.running = false;
    }

    @Override
    public void run() {
        System.out.println("PathDateService: Service is started");
        this.doJob();
    }

    public void doJob() {
        try {
            this.connect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        block6: while (this.running) {
            try {
                this.connect();
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (SessionController.getImportMode() || !PathDateService.isActive(this.sessionController)) continue;
            try {
                boolean hasMore = true;
                block7: while (hasMore && !SessionController.getImportMode()) {
                    this.connect();
                    GenericMultiQueueHelper queue = new GenericMultiQueueHelper();
                    List<GenericMultiQueueBean> entries = queue.getQueueEntries(null, QUEUE_IDENT, 500L);
                    Date date = new Date();
                    HashSet<Long> done = new HashSet<Long>();
                    if (entries != null && entries.size() > 0) {
                        if (SessionController.getImportMode()) continue block6;
                        for (GenericMultiQueueBean entry : entries) {
                            if (SessionController.getImportMode()) continue block7;
                            this.pathWalker(entry.id, date, done);
                            this.connect();
                            queue.deleteQueueEntry(entry.id, entry.sortId, QUEUE_IDENT);
                        }
                        continue;
                    }
                    hasMore = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isActive(SessionController sc) {
        return MetaDbSuperCache.isTrue(sc, "MAIN_MODULE_MANAGEMENT/roi/control/pathdate/Active");
    }

    private void pathWalker(long id, Date date, Set<Long> done) throws Exception {
        try {
            if (done.contains(id)) {
                return;
            }
            GlobalObjectClientBean startObject = null;
            try {
                startObject = this.sessionController.getGlobalObjectById(new Long(id));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (startObject != null) {
                this.pathWalkerRec(startObject, done, date);
            } else {
                done.add(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pathWalkerRec(GlobalObjectClientBean object, Set<Long> ids, Date date) throws Exception {
        Long id = object.getId();
        if (!ids.contains(id)) {
            ids.add(id);
            RelationObjectClientBean[] leftRelations = object.getLeftwardRelations(FolderRelationObjectClientBean.CLASS_NAME);
            if (leftRelations != null) {
                for (RelationObjectClientBean relation : leftRelations) {
                    object.getSessionController().setAuditEnable(false);
                    FolderRelationObjectClientBean folderRel = (FolderRelationObjectClientBean)relation;
                    try (Transaction t = new Transaction();){
                        folderRel.setSubChangeDate(date);
                        t.commit();
                    }
                    finally {
                        object.getSessionController().setAuditEnable(true);
                    }
                    GlobalObjectClientBean parentObj = null;
                    try {
                        parentObj = folderRel.getLeftObject();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (parentObj == null) continue;
                    this.pathWalkerRec(parentObj, ids, date);
                }
            }
        }
    }

    private void connect() throws Exception {
        if (this.sessionController == null) {
            try {
                RoiProperties rp = new RoiProperties();
                CredentialObject credential = new CredentialObject();
                credential.setUserName(rp.getRoiSystemUser());
                credential.setModulInfo("PathDateService");
                credential.setAuthInterface(new ServiceAuthInterface());
                this.sessionController = SessionController.connect(credential);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        } else {
            this.sessionController.reconnectIfNeeded();
        }
    }

    public static void addToPathDateQueue(GlobalObjectClientBean obj) throws Exception {
        if (!obj.getSessionController().isInClusterMode() && PathDateService.isActive(obj.getSessionController())) {
            GenericMultiQueueHelper queue = new GenericMultiQueueHelper();
            queue.createQueueEntry(obj.getId(), QUEUE_IDENT);
        }
    }
}

