/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.mbeans;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.logging.AgorumCoreStartDescLogger;
import agorum.commons.server.ServiceUtils;
import agorum.roi.ejb.client.beans.SuperObjectClientCachedBean;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.CryptKeyAuthInterface;
import agorum.roi.ejb.common.CryptKeyController;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.mbeans.MetaDbWarmupServiceMBean;
import agorum.roi.metadb.common.MetaDbUtils;

public class MetaDbWarmupService
implements MetaDbWarmupServiceMBean,
CryptKeyAuthInterface {
    protected boolean listenActive = true;
    private SessionController sessionController = null;
    private long itemCount = 0L;
    private transient boolean privilegedForCrypting = false;

    @Override
    public void start() {
        System.err.println("---------- Starting MetaDb Warmup Service -----------");
        AgorumCoreStartDescLogger startLogger = new AgorumCoreStartDescLogger();
        startLogger.writeDescToFile("Starting metadb warmup service...\n\n", "");
        ServiceUtils.whenAutoUpdateFinished((Runnable)new Runnable(){

            @Override
            public void run() {
                System.err.println("MetaDbWarmupService: Service is started");
                try {
                    MetaDbWarmupService.this.connect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (MetaDbWarmupService.this.sessionController != null) {
                    try {
                        MetaDbWarmupService.this.warmup();
                        MetaDbWarmupService.this.sessionController.disconnect();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        });
    }

    @Override
    public void stop() {
        System.err.println("---------- Stopping MetaDb Warmup Service -----------");
    }

    private void connect() throws Exception {
        if (this.sessionController == null) {
            System.err.println("Not connected, so reconnect...");
            try {
                RoiProperties rp = new RoiProperties();
                CredentialObject credential = new CredentialObject();
                credential.setUserName(rp.getRoiSystemUser());
                credential.setAuthInterface(new ServiceAuthInterface());
                credential.setModulInfo("MetaDbWarmupService");
                this.sessionController = SessionController.connect(credential);
            }
            catch (Exception e) {
                this.sessionController = null;
            }
        } else {
            this.sessionController.reconnectIfNeeded();
        }
    }

    private void warmup() throws Throwable {
        MetaDb mdb = this.sessionController.getMetaDbInstance();
        try {
            CryptKeyController cryptKeyController = new CryptKeyController();
            this.privilegedForCrypting = true;
            cryptKeyController.createCryptKeyPair("metadb", this, this.sessionController);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            this.privilegedForCrypting = false;
        }
        System.out.println("Setting superobject cache size...");
        SuperObjectClientCachedBean.loadCachedSize();
        String doWarmup = "false";
        try {
            doWarmup = mdb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/metadb/control/PerformMetaDbWarmup")[0];
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (doWarmup.equalsIgnoreCase("true")) {
            MetaDbUtils mdbu = new MetaDbUtils(this.sessionController);
            long time = System.currentTimeMillis();
            System.err.println("Warmup finished (" + this.itemCount + " Objects) in: " + (System.currentTimeMillis() - time) + " ms");
        } else {
            System.err.println("MetaDb Warmup is disabled");
        }
    }

    @Override
    public boolean isPrivilegedForCrypting() {
        return this.privilegedForCrypting;
    }
}

