/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.mbeans;

import agorum.commons.cron.SystemTimer;
import agorum.commons.logging.AgorumCoreStartDescLogger;
import agorum.commons.server.ServiceUtils;
import agorum.roi.ejb.agents.mail.SendMail;
import agorum.roi.ejb.client.beans.MailObjectClientBean;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.JMSEventController;
import agorum.roi.ejb.common.JMSEventListenerBean;
import agorum.roi.ejb.common.JMSEventListenerInterface;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.mbeans.MailServiceMBean;
import agorum.roi.ejb.messaging.common.MessageConnectionHolder;
import agorum.roi.ejb.messaging.common.MessageUtils;
import java.util.Vector;
import javax.jms.Message;
import javax.jms.MessageListener;

public class MailService
implements MailServiceMBean,
MessageListener,
JMSEventListenerInterface {
    private boolean isServiceStarted = false;
    private static MailService instance = null;
    private boolean isStarted = false;
    private Vector messageConnectionHolders = new Vector();
    private SessionController sessionController = null;
    private Vector queue = new Vector();
    public static Object syncMail = new Object();
    private JMSEventListenerBean jmsBean = null;
    private JMSEventController eventController = null;
    public static boolean killTest = false;
    private long mailCounter = 0L;
    private SystemTimer timer;

    @Override
    public void start() {
        System.err.println("---------- Starting Mail Service -------------");
        this.getInstance();
        AgorumCoreStartDescLogger startLogger = new AgorumCoreStartDescLogger();
        startLogger.writeDescToFile("Starting mail service...\n\n", "");
        final MailService jmsEventListener = this;
        ServiceUtils.whenAutoUpdateFinished((Runnable)new Runnable(){

            @Override
            public void run() {
                System.err.println("MailService: Service is started");
                MailService.this.isServiceStarted = true;
                try {
                    MailService.this.connectEvents();
                    MailService.this.jmsBean = new JMSEventListenerBean();
                    MailService.this.jmsBean.setId("MailService_" + jmsEventListener.hashCode());
                    MailService.this.jmsBean.setJmsEventListener(jmsEventListener);
                    MailService.this.eventController = JMSEventController.getInstance();
                    MailService.this.eventController.registerListener(MailService.this.jmsBean);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void stop() {
        System.err.println("---------- Stopping Mail Service -------------");
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.disconnectEvents();
        this.jmsBean.setRemoveEvent(true);
    }

    private void connect() throws Exception {
        if (this.sessionController == null) {
            System.err.println("Not connected, so reconnect...");
            try {
                RoiProperties rp = new RoiProperties();
                CredentialObject credential = new CredentialObject();
                credential.setUserName(rp.getRoiSystemUser());
                credential.setAuthInterface(new ServiceAuthInterface());
                credential.setModulInfo("MailService");
                this.sessionController = SessionController.connect(credential);
            }
            catch (Exception e) {
                this.sessionController = null;
            }
        } else {
            this.sessionController.reconnectIfNeeded();
        }
    }

    private void connectEvents() {
        try {
            MessageUtils messageUtils = new MessageUtils();
            try {
                this.messageConnectionHolders.addElement(messageUtils.registerSubScriber(this, "createObjectListener"));
                this.messageConnectionHolders.addElement(messageUtils.registerSubScriber(this, "updateObjectListener"));
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void disconnectEvents() {
        int len = this.messageConnectionHolders.size();
        MessageUtils mu = new MessageUtils();
        for (int i = 0; i < len; ++i) {
            try {
                MessageConnectionHolder messageConnectionHolder = (MessageConnectionHolder)this.messageConnectionHolders.elementAt(i);
                mu.unregisterSubScriber(messageConnectionHolder);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.messageConnectionHolders.clear();
    }

    @Override
    public void reconnectEvent() {
        this.disconnectEvents();
        this.connectEvents();
    }

    @Override
    public void sendCheckEvent() {
        this.eventController.sendMyEvent(this.jmsBean, "createObjectListener");
    }

    private synchronized String queueing(String msg) {
        if (msg != null) {
            this.queue.addElement(msg);
            return null;
        }
        String nextMessage = null;
        if (this.queue.size() > 0) {
            nextMessage = (String)this.queue.elementAt(0);
            this.queue.removeElementAt(0);
        }
        return nextMessage;
    }

    private synchronized boolean isStarted() {
        if (this.isStarted) {
            return true;
        }
        this.isStarted = true;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        if (killTest) {
            System.err.println(" <<<<<<<<<<< Making a kill Test >>>>>>>>>>>");
            this.disconnectEvents();
            return;
        }
        if (!this.eventController.checkMyEvent(this.jmsBean, message)) {
            String className = null;
            try {
                className = (String)message.getObjectProperty("className");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            if (className != null && className.equalsIgnoreCase(MailObjectClientBean.CLASS_NAME)) {
                this.queueing("");
                if (!this.isStarted()) {
                    try {
                        while (this.queueing(null) != null) {
                            try {
                                this.sendMail();
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.err);
                            }
                        }
                    }
                    finally {
                        this.isStarted = false;
                    }
                }
            }
        }
    }

    public void sendMail() {
        this.getInstance();
        instance.sendMailInternal();
    }

    private void sendMailDeferred() {
        if (MailService.instance.isServiceStarted && this.mailCounter > 0L) {
            this.mailCounter = 0L;
            try {
                this.connect();
                System.err.println("Sending Mails....");
                SendMail sm = new SendMail(this.sessionController);
                sm.sendAllMails(sm.getAllMailObjects());
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMailInternal() {
        ++this.mailCounter;
        Object object = syncMail;
        synchronized (object) {
            if (this.timer == null) {
                this.timer = SystemTimer.ofPeriod((long)1000L).name("MailService Timer").call(new Runnable(){

                    @Override
                    public void run() {
                        MailService.this.sendMailDeferred();
                    }
                });
            }
        }
    }

    private MailService getInstance() {
        if (instance == null) {
            instance = this;
        }
        return instance;
    }
}

