/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.mbeans;

import agorum.commons.cron.SystemTimer;
import agorum.commons.logging.AgorumCoreStartDescLogger;
import agorum.commons.server.ServiceUtils;
import agorum.roi.ejb.common.AccessCounterUtils;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.JMSEventController;
import agorum.roi.ejb.common.JMSEventListenerBean;
import agorum.roi.ejb.common.JMSEventListenerInterface;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.mbeans.AccessCounterServiceMBean;
import agorum.roi.ejb.messaging.common.MessageConnectionHolder;
import agorum.roi.ejb.messaging.common.MessageUtils;
import java.util.Vector;
import javax.jms.Message;
import javax.jms.MessageListener;

public class AccessCounterService
implements AccessCounterServiceMBean,
MessageListener,
JMSEventListenerInterface {
    private Vector messageConnectionHolders = new Vector();
    private boolean isStarted = false;
    private Vector queue = new Vector();
    private SystemTimer timer = null;
    private int amount = 0;
    private int idleTimer = 2000;
    private int amountToCollect = 1000;
    private SessionController sessionController = null;
    private Vector msgVector = new Vector();
    private JMSEventListenerBean jmsBean = null;
    private JMSEventController eventController = null;
    public static boolean killTest = false;
    public boolean isInUpdate = false;
    public Object syncObj = new Object();

    @Override
    public void start() {
        System.err.println("---------- Starting AccessCounter Service -------------");
        AgorumCoreStartDescLogger startLogger = new AgorumCoreStartDescLogger();
        startLogger.writeDescToFile("Starting accesscounter service...\n\n", "");
        final AccessCounterService jmsEventListener = this;
        ServiceUtils.whenStarted((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    AccessCounterService.this.connectEvents();
                    AccessCounterService.this.jmsBean = new JMSEventListenerBean();
                    AccessCounterService.this.jmsBean.setId("AccessCounterService_" + jmsEventListener.hashCode());
                    AccessCounterService.this.jmsBean.setJmsEventListener(jmsEventListener);
                    AccessCounterService.this.eventController = JMSEventController.getInstance();
                    AccessCounterService.this.eventController.registerListener(AccessCounterService.this.jmsBean);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void stop() {
        System.err.println("---------- Stopping AccessCounter Service  -------------");
        this.disconnectEvents();
        this.jmsBean.setRemoveEvent(true);
    }

    private void connectEvents() {
        try {
            MessageUtils messageUtils = new MessageUtils();
            this.messageConnectionHolders.addElement(messageUtils.registerSubScriber(this, "updateAccessCounterListener"));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void disconnectEvents() {
        int len = this.messageConnectionHolders.size();
        MessageUtils mu = new MessageUtils();
        for (int i = 0; i < len; ++i) {
            try {
                MessageConnectionHolder messageConnectionHolder = (MessageConnectionHolder)this.messageConnectionHolders.elementAt(i);
                mu.unregisterSubScriber(messageConnectionHolder);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.messageConnectionHolders.clear();
    }

    @Override
    public void reconnectEvent() {
        this.disconnectEvents();
        this.connectEvents();
    }

    @Override
    public void sendCheckEvent() {
        this.eventController.sendMyEvent(this.jmsBean, "updateAccessCounterListener");
    }

    private synchronized boolean isStarted() {
        if (this.isStarted) {
            return true;
        }
        this.isStarted = true;
        return false;
    }

    private synchronized Message queueing(Message msg) {
        if (msg != null) {
            if (!this.eventController.checkMyEvent(this.jmsBean, msg)) {
                this.queue.addElement(msg);
            }
            return null;
        }
        Message nextMessage = null;
        if (this.queue.size() > 0) {
            nextMessage = (Message)this.queue.elementAt(0);
            this.queue.removeElementAt(0);
            try {
                this.connect();
                MessageUtils mu = new MessageUtils();
                mu.checkMessageObject(nextMessage, this.sessionController);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nextMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        if (SessionController.getImportMode()) {
            return;
        }
        if (killTest) {
            System.err.println(" <<<<<<<<<<< Making a kill Test >>>>>>>>>>>");
            this.disconnectEvents();
            return;
        }
        this.queueing(msg);
        if (!this.isStarted()) {
            while ((msg = this.queueing(null)) != null) {
                ++this.amount;
                try {
                    Vector vector = this.msgVector;
                    synchronized (vector) {
                        this.msgVector.addElement(msg);
                    }
                    if (this.amount > this.amountToCollect) {
                        if (this.timer != null) {
                            this.timer.cancel();
                        }
                        this.amount = 0;
                        if (this.isInUpdate) continue;
                        this.updateAccessCounter();
                        continue;
                    }
                    if (this.isInUpdate) continue;
                    if (this.timer != null) {
                        this.timer.cancel();
                    }
                    this.timer = SystemTimer.ofDelay((long)this.idleTimer).name("AccessCounterTimer").call((Runnable)new AccessCounterTimerTask());
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
            this.isStarted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAccessCounter() throws Exception {
        if (this.isInUpdate) {
            return;
        }
        Object object = this.syncObj;
        synchronized (object) {
            this.isInUpdate = true;
            try {
                RoiTransactionHandler rth = null;
                this.connect();
                AccessCounterUtils acu = new AccessCounterUtils(this.sessionController);
                Vector msgVectorClone = null;
                Vector vector = this.msgVector;
                synchronized (vector) {
                    msgVectorClone = (Vector)this.msgVector.clone();
                    this.msgVector.removeAllElements();
                }
                int len = msgVectorClone.size();
                for (int i = 0; i < len; ++i) {
                    this.connect();
                    rth = new RoiTransactionHandler();
                    rth.begin();
                    try {
                        Message msg = (Message)msgVectorClone.elementAt(0);
                        msgVectorClone.removeElementAt(0);
                        boolean ignore = (Boolean)msg.getObjectProperty("ignoreAccessCounterService");
                        if (!ignore) {
                            String eventType = (String)msg.getObjectProperty("eventType");
                            Long userId = (Long)msg.getObjectProperty("user");
                            Long id = (Long)msg.getObjectProperty("value");
                            if (eventType.equals("updateAccessCounterListener")) {
                                ContentInterface contentObject = (ContentInterface)((Object)this.sessionController.getGlobalObjectById(id));
                                acu.setAccessCounter(contentObject, userId);
                            } else if (eventType.equals("resetAccessCounterListener")) {
                                acu.resetUserAccessCounter(id, userId);
                            }
                        }
                        rth.end();
                        rth = null;
                        continue;
                    }
                    finally {
                        if (rth != null) {
                            rth.abort();
                        }
                    }
                }
            }
            finally {
                Vector vector = this.msgVector;
                synchronized (vector) {
                    if (this.msgVector.size() > 0) {
                        if (this.timer != null) {
                            this.timer.cancel();
                        }
                        this.timer = SystemTimer.ofDelay((long)this.idleTimer).name("AccessCounterTimer").call((Runnable)new AccessCounterTimerTask());
                    }
                }
                this.isInUpdate = false;
            }
        }
    }

    private void connect() throws Exception {
        if (this.sessionController == null) {
            try {
                RoiProperties rp = new RoiProperties();
                CredentialObject credential = new CredentialObject();
                credential.setUserName(rp.getRoiSystemUser());
                credential.setAuthInterface(new ServiceAuthInterface());
                credential.setModulInfo("AccessCounterService");
                this.sessionController = SessionController.connect(credential);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        } else {
            this.sessionController.reconnectIfNeeded();
        }
    }

    private class AccessCounterTimerTask
    implements Runnable {
        private AccessCounterTimerTask() {
        }

        @Override
        public void run() {
            AccessCounterService.this.amount = 0;
            try {
                AccessCounterService.this.updateAccessCounter();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (AccessCounterService.this.timer != null) {
                AccessCounterService.this.timer.cancel();
            }
            AccessCounterService.this.timer = SystemTimer.ofDelay((long)AccessCounterService.this.idleTimer).name("AccessCounterTimer").call((Runnable)new AccessCounterTimerTask());
        }
    }
}

