/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.database.mssql;

import agorum.commons.string.StringUtils;
import agorum.roi.ejb.client.beans.AttributeObjectClientBean;
import agorum.roi.ejb.common.ContentTransferBean;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.database.common.BaseDatabaseImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class MSSqlDatabaseImpl
extends BaseDatabaseImpl {
    @Override
    public String limit(String query, int count) {
        return query.replace("select", "select top " + count);
    }

    @Override
    public String getDBName() {
        return "mssql";
    }

    @Override
    public int getDbInterfaceKey() {
        return 1;
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public String getCreateTableBeginStatement(String tableName) throws Exception {
        return "CREATE TABLE " + tableName + " (ID BIGINT NOT NULL";
    }

    @Override
    public String getTableAttribute(String datatype, AttributeObjectClientBean attrObject) throws Exception {
        int dataLen;
        String createTableStmt = "";
        if (datatype.equals("STRING")) {
            dataLen = attrObject.getDataLength();
            createTableStmt = createTableStmt + attrObject.getDataBaseObjectName() + " NVARCHAR (" + dataLen + ")";
        }
        if (datatype.equals("CISTRING")) {
            dataLen = attrObject.getDataLength();
            createTableStmt = createTableStmt + attrObject.getDataBaseObjectName() + " NVARCHAR (" + dataLen + ")";
        } else if (datatype.equals("LONGTEXT")) {
            createTableStmt = createTableStmt + attrObject.getDataBaseObjectName() + " NTEXT";
        } else if (datatype.equals("LONG")) {
            createTableStmt = createTableStmt + attrObject.getDataBaseObjectName() + " BIGINT";
        } else if (datatype.equals("BOOLEAN")) {
            createTableStmt = createTableStmt + attrObject.getDataBaseObjectName() + " INT";
        } else if (datatype.equals("INTEGER")) {
            dataLen = attrObject.getDataLength();
            createTableStmt = createTableStmt + attrObject.getDataBaseObjectName() + " INT";
        } else if (datatype.equals("DOUBLE")) {
            createTableStmt = createTableStmt + attrObject.getDataBaseObjectName() + " FLOAT";
        } else if (datatype.equals("DATABASEOBJECT")) {
            createTableStmt = createTableStmt + attrObject.getDataBaseObjectName() + " BIGINT";
        } else if (datatype.equals("GLOBALOBJECT")) {
            createTableStmt = createTableStmt + attrObject.getDataBaseObjectName() + " BIGINT";
        } else if (datatype.equals("INTERNALOBJECT")) {
            createTableStmt = createTableStmt + attrObject.getDataBaseObjectName() + " BIGINT";
        } else if (datatype.equals("DATE")) {
            createTableStmt = createTableStmt + attrObject.getDataBaseObjectName() + " BIGINT";
        } else if (datatype.equals("DIRECTORYOBJECT")) {
            dataLen = attrObject.getDataLength();
            createTableStmt = createTableStmt + attrObject.getDataBaseObjectName() + " BIGINT";
        } else if (datatype.equals("BOOLEAN_ARRAY")) {
            createTableStmt = createTableStmt + attrObject.getDataBaseObjectName() + " INT";
        } else if (datatype.equals("DATE_ARRAY")) {
            createTableStmt = createTableStmt + attrObject.getDataBaseObjectName() + " INT";
        } else if (datatype.equals("INTEGER_ARRAY")) {
            createTableStmt = createTableStmt + attrObject.getDataBaseObjectName() + " INT";
        } else if (datatype.equals("LONG_ARRAY")) {
            createTableStmt = createTableStmt + attrObject.getDataBaseObjectName() + " INT";
        } else if (datatype.equals("DOUBLE_ARRAY")) {
            createTableStmt = createTableStmt + attrObject.getDataBaseObjectName() + " INT";
        } else if (datatype.equals("STRING_ARRAY")) {
            createTableStmt = createTableStmt + attrObject.getDataBaseObjectName() + " INT";
        } else if (datatype.equals("GLOBALOBJECT_ARRAY")) {
            createTableStmt = createTableStmt + attrObject.getDataBaseObjectName() + " INT";
        } else if (datatype.equals("INTERNALOBJECT_ARRAY")) {
            createTableStmt = createTableStmt + attrObject.getDataBaseObjectName() + " INT";
        } else if (datatype.equals("DATABASEOBJECT_ARRAY")) {
            createTableStmt = createTableStmt + attrObject.getDataBaseObjectName() + " INT";
        } else if (datatype.equals("DIRECTORYOBJECT_ARRAY")) {
            createTableStmt = createTableStmt + attrObject.getDataBaseObjectName() + " INT";
        }
        return createTableStmt;
    }

    @Override
    public String getPrimaryKeyStatement(String tableName) throws Exception {
        return " alter table " + tableName + " add primary key (id)";
    }

    @Override
    public String getCreateIndexStatement(String tableName, String indexName, String indexColumns, boolean unique) throws Exception {
        return "CREATE " + (unique ? "UNIQUE" : "") + " INDEX " + indexName + " ON " + tableName + "(" + indexColumns + ")";
    }

    @Override
    public String getAlterTableAddColumn(String tableNaem, AttributeObjectClientBean attrObject) throws Exception {
        return "alter TABLE " + tableNaem + " add (" + this.getTableAttribute(attrObject.getDataType(), attrObject) + ")";
    }

    @Override
    public String getAvBooleanArrayTableName() {
        return "AVBOOLEANARRAY";
    }

    @Override
    public String getAvDatabaseObjectArrayTableName() {
        return "AVDATABASEOBJECTARRAY";
    }

    @Override
    public String getAvDateArrayTableName() {
        return "AVDATEARRAY";
    }

    @Override
    public String getAvDirectoryObjectArrayTableName() {
        return "AVDIRECTORYOBJECTARRAY";
    }

    @Override
    public String getAvDoubleArrayTableName() {
        return "AVDOUBLEARRAY";
    }

    @Override
    public String getAvGlobalobjectArrayTableName() {
        return "AVGLOBALOBJECTARRAY";
    }

    @Override
    public String getAvIntegerArrayTableName() {
        return "AVINTEGERARRAY";
    }

    @Override
    public String getAvInternalObjectArrayTableName() {
        return "AVINTERNALOBJECTARRAY";
    }

    @Override
    public String getAvLongArrayTableName() {
        return "AVLONGARRAY";
    }

    @Override
    public String getAvStringArrayTableName() {
        return "AVSTRINGARRAY";
    }

    @Override
    public String getAVValueDatabaseName() {
        return "VALUE";
    }

    @Override
    public String getAVObjectIdDatabaseName() {
        return "OBJECTID";
    }

    @Override
    public String getAVAttributeIdDatabaseName() {
        return "ATTRIBUTEID";
    }

    @Override
    public String getAVSequenceDatabaseName() {
        return "SEQUENCE";
    }

    @Override
    public String getObjectAccessSelect() {
        return "select count(*) from GLOBALOBJECT go , ACLUSERTABLE au , ACLOBJECTTABLE aot where (aot.ACLID=au.ACLID and aot.OBJECTID = go.ID and ((go.OWNER=? and au.USERID=0) or (go.OWNER != ? and au.USERID=999 and (select count(ACLID) from ACLUSERREVOKE where ACLID=aot.ACLID and USERID=?)=0) or (go.OWNER != ? and (au.USERID=?))) and au.ACLID = ? and go.ID = ?)";
    }

    @Override
    public String getObjectAccessSelectAclId() {
        return "select ACLID from ACLUSERTABLE au where (au.USERID=999 and (select count(ACLID) from ACLUSERREVOKE where ACLID=au.ACLID and USERID=?)=0) or USERID=? group by ACLID";
    }

    @Override
    public String getEAStatement1() {
        return "delete from EVENTASSISTANCE where VALUE=0 or CREATEDATE < ?";
    }

    @Override
    public String getEAStatement3() {
        return "select * from EVENTASSISTANCE where ID=? and SUBID=?";
    }

    @Override
    public String getEAStatement4() {
        return "update EVENTASSISTANCE set VALUE=(VALUE & ~(?)),CUSTOMVALUE=(CUSTOMVALUE & ~(?)) where SUBID=? and ID=?";
    }

    @Override
    public String getEAStatement5() {
        return "select * from EVENTASSISTANCE where SUBID=?";
    }

    @Override
    public String getEAStatement6() {
        return "update EVENTASSISTANCE set VALUE=(VALUE & ~(?)),CUSTOMVALUE=(CUSTOMVALUE & ~(?)) where SUBID=?";
    }

    @Override
    public String getEAStatement7() {
        return "delete from EVENTASSISTANCE where ID=?";
    }

    @Override
    public String getEAStatement8() {
        return "insert into EVENTASSISTANCE (ID,SUBID,VALUE,CUSTOMVALUE,CREATEDATE,TYPE,CLASSNAME) values (?,?,?,?,?,?,?)";
    }

    @Override
    public String getEAStatement9() {
        return "select SUBID from EVENTASSISTANCE where ID=?";
    }

    @Override
    public String getEAStatement10() {
        return "update EVENTASSISTANCE set VALUE=(CUSTOMVALUE | ?),CREATEDATE=?,TYPE=? where ID=? and SUBID=?";
    }

    @Override
    public String getEAStatement11() {
        return "update EVENTASSISTANCE set VALUE=(VALUE | ?),CUSTOMVALUE=(CUSTOMVALUE | ?),CREATEDATE=?,TYPE=? where ID=? and SUBID=?";
    }

    @Override
    public String getIndexStatement4() {
        return "insert into INDEX_SEQUENCE_T (SEQUENCE_IDENT,SEQUENCE_ID) values ('ROI_SEQUENCE',1000)";
    }

    @Override
    public String getIndexStatement5() {
        return "select ID, LENGTH, BLOCKSIZE from INDEX_DOCUMENT_T where NAME=? and DIRECTORY_NAME=?";
    }

    @Override
    public String getIndexStatement6() {
        return "select SEQUENCE_ID from INDEX_SEQUENCE_T where SEQUENCE_IDENT='ROI_SEQUENCE'";
    }

    @Override
    public String getIndexStatement7() {
        return "update INDEX_SEQUENCE_T set SEQUENCE_ID=? where SEQUENCE_IDENT='ROI_SEQUENCE'";
    }

    @Override
    public String getIndexStatement8() {
        return "insert into INDEX_DOCUMENT_T (ID, NAME, DIRECTORY_NAME, LENGTH,BLOCKSIZE) values (?,?,?,?,?)";
    }

    @Override
    public String getIndexStatement9() {
        return "select ID from INDEX_DOCUMENT_T where NAME=? and DIRECTORY_NAME=?";
    }

    @Override
    public String getIndexStatement10() {
        return "delete from INDEX_CONTENT_T where DOCID=?";
    }

    @Override
    public String getIndexStatement11() {
        return "delete from INDEX_DOCUMENT_T where ID=?";
    }

    @Override
    public String getIndexStatement12() {
        return "select NAME from INDEX_DOCUMENT_T where DIRECTORY_NAME=?";
    }

    @Override
    public String getIndexStatement12InitReadOnly() {
        return "select NAME,ID,LENGTH,BLOCKSIZE from INDEX_DOCUMENT_T where DIRECTORY_NAME=?";
    }

    @Override
    public String getIndexStatement13() {
        return "select NAME from INDEX_DOCUMENT_T where NAME=? and DIRECTORY_NAME=?";
    }

    @Override
    public String getIndexStatement14() {
        return "select LASTMODIFIED from INDEX_DOCUMENT_T where NAME=? and DIRECTORY_NAME=?";
    }

    @Override
    public String getIndexStatement15() {
        return "update INDEX_DOCUMENT_T set LASTMODIFIED=? where NAME=? and DIRECTORY_NAME=?";
    }

    @Override
    public String getIndexStatement16() {
        return "update INDEX_DOCUMENT_T set NAME=? where NAME=? and DIRECTORY_NAME=?";
    }

    @Override
    public String getIndexStatement18() {
        return "update INDEX_DOCUMENT_T set LENGTH = ?, LASTMODIFIED = ? where ID = ?";
    }

    @Override
    public String getIndexStatement19() {
        return "select count(*) from INDEX_DOCUMENT_T where DIRECTORY_NAME=?";
    }

    @Override
    public String getIndexStatement21() {
        return "delete from INDEX_DOCUMENT_T where NAME=? and DIRECTORY_NAME = ?";
    }

    @Override
    public String getIndexStatement22() {
        return "select ID,BLOCKSIZE from index_document_t order by id";
    }

    @Override
    public String getIndexStatement23() {
        return "select count(*) from index_content_t where docid=?";
    }

    @Override
    public String getIndexStatement24() {
        return "select CONTENT from index_content_t where id=? and docid=?";
    }

    @Override
    public String getIndexStatement25() {
        return "update index_document_t set length=? where id=?";
    }

    @Override
    public String getSyncStatement1() {
        return "insert into TOSYNC (SYNCID,LEFTID,RIGHTID,OPERATION) values (?,?,?,?)";
    }

    @Override
    public String getSyncStatement2() {
        return "update TOSYNC set OPERATION=? where SYNCID=? and LEFTID=? and RIGHTID=?";
    }

    @Override
    public String getSyncStatement3() {
        return "delete from TOSYNC where SYNCID=? and LEFTID=? and RIGHTID=?";
    }

    @Override
    public String getSyncStatement4() {
        return "select OPERATION from TOSYNC where SYNCID=? and LEFTID=? and RIGHTID=?";
    }

    @Override
    public PreparedStatement getSyncStatement5(Connection conn, long syncId, long lastId, int maxRows) throws SQLException {
        PreparedStatement pstmt = conn.prepareStatement("select TOP (?) T.SORTID,T.LEFTID,T.RIGHTID,T.OPERATION,S.REMOTEID from TOSYNC as T join RELATIONOBJECT as R on T.LEFTID=R.LEFTOBJECT and T.SYNCID=R.RIGHTOBJECT join AGORUMCORESYNCSETTINGSRELATION as S on S.ID=R.ID where T.SYNCID=? and T.SORTID>? order by T.SORTID asc");
        pstmt.setInt(1, maxRows);
        pstmt.setLong(2, syncId);
        pstmt.setLong(3, lastId);
        return pstmt;
    }

    @Override
    public PreparedStatement getSyncStatement6(Connection conn, long syncId, long lastId, int maxRows) throws SQLException {
        PreparedStatement pstmt = conn.prepareStatement("select TOP (?) S.ID,G.ID,S.REMOTEID from GLOBALOBJECT as G join RELATIONOBJECT as R on G.ID=R.LEFTOBJECT join AGORUMCORESYNCSETTINGSRELATION as S on R.ID=S.ID where G.UPDATEDATE>S.LASTSYNCDATE and G.LOCKSTATE=? and RIGHTOBJECT=? and S.ID>? order by S.ID asc");
        pstmt.setInt(1, maxRows);
        pstmt.setInt(2, 0);
        pstmt.setLong(3, syncId);
        pstmt.setLong(4, lastId);
        return pstmt;
    }

    @Override
    public void indexDBOutputStreamUpdateContent(Connection conn, byte[] internBuffer, long endPointer, long id, long contentId) throws IOException {
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("update INDEX_CONTENT_T set CONTENT = ? where DOCID = ? and ID = ?");
            ByteArrayInputStream bais = new ByteArrayInputStream(internBuffer, 0, (int)endPointer);
            pstmt.setBinaryStream(1, (InputStream)bais, (int)endPointer);
            pstmt.setLong(2, id);
            pstmt.setLong(3, contentId);
            pstmt.executeUpdate();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            throw new IOException("Fehler in IndexDBOutputStream.writeBuffer");
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void indexDBOutputStreamInsertContent(Connection conn, byte[] internBuffer, long endPointer, long seqId, long id) throws IOException {
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("insert into INDEX_CONTENT_T (ID, DOCID, CONTENT) values (?,?,?)");
            ByteArrayInputStream bais = new ByteArrayInputStream(internBuffer, 0, (int)endPointer);
            pstmt.setLong(1, seqId);
            pstmt.setLong(2, id);
            pstmt.setBinaryStream(3, (InputStream)bais, (int)endPointer);
            pstmt.executeUpdate();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
            throw new IOException("Fehler in IndexDBOutputStream.writeBuffer");
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contentEJBMoveOrCopyContent(Connection conn, Long sourceDocId, Long destinationDocId, boolean isMove, String sourceTableName, String destinationTableName) throws Exception {
        Statement pstmt = null;
        PreparedStatement pstmtSo = null;
        PreparedStatement pstmtDe = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement("select id from " + sourceTableName + " where docid=?");
            pstmt.setLong(1, sourceDocId);
            rs = pstmt.executeQuery();
            if (rs != null) {
                pstmtSo = conn.prepareStatement("select content from " + sourceTableName + " where docid=? and id=?");
                pstmtSo.setLong(1, sourceDocId);
                pstmtDe = conn.prepareStatement("select count(*) from " + destinationTableName + " where docid=?");
                pstmtDe.setLong(1, destinationDocId);
                ResultSet rs1 = pstmtDe.executeQuery();
                rs1.next();
                int count = rs1.getInt(1);
                rs1.close();
                rs1 = null;
                if (count > 0) {
                    pstmtDe.close();
                    pstmtDe = null;
                    pstmtDe = conn.prepareStatement("delete from " + destinationTableName + " where docid=?");
                    pstmtDe.setLong(1, destinationDocId);
                    pstmtDe.execute();
                }
                pstmtDe.close();
                pstmtDe = null;
                pstmtDe = conn.prepareStatement("insert into " + destinationTableName + " (ID, DOCID, CONTENT) values (?, ?, ?)");
                pstmtDe.setLong(2, destinationDocId);
                boolean delete = false;
                while (rs.next()) {
                    if (isMove) {
                        delete = true;
                    }
                    long id = rs.getLong(1);
                    pstmtSo.setLong(2, id);
                    ResultSet rsSo = pstmtSo.executeQuery();
                    rsSo.next();
                    byte[] buffer = rsSo.getBytes(1);
                    int len = buffer.length;
                    rsSo.close();
                    rsSo = null;
                    pstmtDe.setLong(1, id);
                    ByteArrayInputStream bais = new ByteArrayInputStream(buffer, 0, len);
                    pstmtDe.setBinaryStream(3, (InputStream)bais, len);
                    pstmtDe.execute();
                }
                pstmtSo.close();
                pstmtSo = null;
                pstmtDe.close();
                pstmtDe = null;
                if (delete) {
                    pstmtSo = conn.prepareStatement("delete from " + sourceTableName + " where docid=?");
                    pstmtSo.setLong(1, sourceDocId);
                    pstmtSo.execute();
                    pstmtSo.close();
                    pstmtSo = null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                rs.close();
                rs = null;
            }
            catch (Exception exception) {}
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contentEJBMoveContent(Connection conn, String tableName, long id, Long docId, byte[] buffer, int len) throws Exception {
        Statement pstmtDe = null;
        try {
            pstmtDe = conn.prepareStatement("insert into " + tableName + " (ID, DOCID, CONTENT) values (?, ?,?)");
            pstmtDe.setLong(1, id);
            pstmtDe.setLong(2, docId);
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer, 0, len);
            pstmtDe.setBinaryStream(3, bais, len);
            pstmtDe.execute();
            pstmtDe.close();
            pstmtDe = null;
        }
        finally {
            try {
                if (pstmtDe != null) {
                    pstmtDe.close();
                    pstmtDe = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contentEJBTransferContent(Connection conn, String tableName, long blockNumber, Long id, ContentTransferBean ctb) throws Exception {
        Statement pstmt = null;
        try {
            pstmt = conn.prepareStatement("insert into " + tableName + " (ID, DOCID, CONTENT) values (?, ?,?)");
            pstmt.setLong(1, blockNumber);
            pstmt.setLong(2, id);
            ByteArrayInputStream bais = new ByteArrayInputStream(ctb.getBuffer(), 0, ctb.getBufferLength());
            pstmt.setBinaryStream(3, bais, ctb.getBufferLength());
            pstmt.execute();
            bais = null;
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contentEJBTransferContentUpdate(Connection conn, String tableName, boolean update, long blockNumber, Long id, ContentTransferBean ctb) throws Exception {
        Statement pstmt = null;
        try {
            if (!update) {
                String statement = "insert into " + tableName + " (ID, DOCID, CONTENT) values (?, ?,?)";
                pstmt = conn.prepareStatement(statement);
                pstmt.setLong(1, blockNumber);
                pstmt.setLong(2, id);
                ByteArrayInputStream bais = new ByteArrayInputStream(ctb.getBuffer(), 0, ctb.getBufferLength());
                pstmt.setBinaryStream(3, bais, ctb.getBufferLength());
            } else {
                String statement = "update " + tableName + " set CONTENT=? where DOCID = ? and ID = ?";
                pstmt = conn.prepareStatement(statement);
                long amount = ctb.getBufferLength();
                ByteArrayInputStream bais = new ByteArrayInputStream(ctb.getBuffer(), 0, (int)amount);
                pstmt.setBinaryStream(1, bais, (int)amount);
                pstmt.setLong(2, id);
                pstmt.setLong(3, blockNumber);
            }
            pstmt.execute();
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public long getDbSize(Connection conn) throws Exception {
        Object pstmt = null;
        long totalBytes = 0L;
        return totalBytes;
    }

    @Override
    public String replaceWildCards(String s) throws Exception {
        String sNew = s;
        if (sNew != null && sNew.indexOf("%") >= 0) {
            StringUtils su = new StringUtils();
            sNew = su.strReplace(sNew, "\\%", "_xx_xx__xx__________B S P____________xx");
            sNew = su.strReplace(sNew, "%", "%%");
            sNew = su.strReplace(sNew, "_xx_xx__xx__________B S P____________xx", "\\%");
        }
        return sNew;
    }

    @Override
    public String escapeWildCards(String value, int qualifier, boolean caseInsensitive) throws Exception {
        return value;
    }

    @Override
    public String[] getLower(String tablename, String attributename) throws Exception {
        boolean returnLower = true;
        if (tablename != null && attributename != null && tablename.equalsIgnoreCase("GlobalObject") && attributename.equalsIgnoreCase("Name")) {
            returnLower = false;
        }
        String[] lower = new String[2];
        if (returnLower) {
            lower[0] = "lower(";
            lower[1] = ")";
        } else {
            lower[0] = "";
            lower[1] = "";
        }
        return lower;
    }

    @Override
    public String getCryptKeyStatementInsertKeys() {
        return "insert into CRYPTKEYS (IDENT,PUBLICKEY,PRIVATEKEY) values (?,?,?)";
    }

    @Override
    public String getCryptKeyStatementDeleteKeys() {
        return "delete from CRYPTKEYS where IDENT=?";
    }

    @Override
    public String getCryptKeyStatementSelectPublicKey() {
        return "select PUBLICKEY from CRYPTKEYS where IDENT=?";
    }

    @Override
    public String getCryptKeyStatementSelectPrivatKey() {
        return "select PRIVATEKEY from CRYPTKEYS where IDENT=?";
    }

    @Override
    public String getCryptKeyClassesStatementRegisterClass() {
        return "insert into CRYPTKEYCLASSES (IDENT,CLASS) values (?,?)";
    }

    @Override
    public String getCryptKeyClassesStatementUnregisterClass() {
        return "delete from CRYPTKEYCLASSES where IDENT=? and CLASS=?";
    }

    @Override
    public String getCryptKeyClassesStatementSelectClass() {
        return "select CLASS from CRYPTKEYCLASSES where IDENT=?";
    }

    @Override
    public String getCryptKeyClassesStatementEntryExists() {
        return "select CLASS from CRYPTKEYCLASSES where IDENT=? and CLASS=?";
    }

    @Override
    public String getImapMailboxAllMails(int amountOfClassIds, Long selectFromDate, boolean isAdmin) {
        StringBuffer classIds = new StringBuffer();
        String clause = null;
        for (int i = 0; i < amountOfClassIds; ++i) {
            if (clause != null) {
                classIds.append(clause);
            } else {
                clause = " OR ";
            }
            classIds.append("roi_0.CLASSID=?");
        }
        StringBuffer selectStmt = new StringBuffer();
        selectStmt.append("(select ");
        selectStmt.append("roi_1.id AS uidac, ");
        selectStmt.append("roi_1.sortsequence, ");
        selectStmt.append("roi_0.id, ");
        selectStmt.append("roi_0.CREATEDATE, ");
        selectStmt.append("roi_3.rfc822date, ");
        selectStmt.append("roi_3.deleted, ");
        selectStmt.append("roi_3.answered, ");
        selectStmt.append("roi_3.flagged, ");
        selectStmt.append("1 AS seen, ");
        selectStmt.append("roi_3.draft, ");
        selectStmt.append("roi_3.recent ");
        selectStmt.append("from ");
        selectStmt.append("GLOBALOBJECT roi_0, ");
        selectStmt.append("RELATIONOBJECT roi_1, ");
        selectStmt.append("INTERNALOBJECT io, ");
        selectStmt.append("FOLDERRELATIONOBJECT roi_2, ");
        selectStmt.append("MAILOBJECT roi_3");
        if (!isAdmin) {
            selectStmt.append(", ACLUSERTABLE roi_au, ");
            selectStmt.append("ACLOBJECTTABLE roi_aot");
        }
        selectStmt.append(" where ");
        selectStmt.append("roi_1.ID=io.ID and ");
        selectStmt.append("roi_1.LEFTOBJECT=? and ");
        if (selectFromDate != null) {
            selectStmt.append("roi_0.CREATEDATE>=? and ");
        }
        selectStmt.append("(roi_0.DELETOR=0 or roi_0.DELETOR=?) ");
        selectStmt.append("and ");
        selectStmt.append("((");
        selectStmt.append(classIds);
        selectStmt.append(") AND roi_2.ID=roi_1.ID AND roi_1.RIGHTOBJECT=roi_0.ID AND roi_0.id=roi_3.id) ");
        if (!isAdmin) {
            selectStmt.append("and ");
            selectStmt.append("(roi_aot.ACLID=roi_au.ACLID and roi_aot.OBJECTID=roi_0.ID ");
            selectStmt.append("and ");
            selectStmt.append("( ");
            selectStmt.append("(roi_0.OWNER=? and roi_au.USERID=0) ");
            selectStmt.append("or ");
            selectStmt.append("(roi_0.OWNER!=? and roi_au.USERID=999 and (select count(ACLID) from acluserrevoke where ACLID=roi_aot.ACLID and USERID=?)=0) ");
            selectStmt.append("or ");
            selectStmt.append("(roi_0.OWNER!=? and (roi_au.USERID=?)))) ");
        }
        selectStmt.append("and ");
        selectStmt.append("EXISTS (select fdo.id from ");
        selectStmt.append("FOLDERDOCUMENTOBJECT fdo, ACCESSCOUNTERUSEROBJECT acuo1 ");
        selectStmt.append("where ");
        selectStmt.append("roi_0.id=fdo.id and acuo1.ACCESSUSER=? AND acuo1.referenceobject=fdo.id ");
        selectStmt.append("and acuo1.lastaccessdate>fdo.LASTCONTENTMODIFYDATE)");
        selectStmt.append(") ");
        selectStmt.append("UNION ");
        selectStmt.append("(select ");
        selectStmt.append("roi_1.id AS uidac, ");
        selectStmt.append("roi_1.sortsequence, ");
        selectStmt.append("roi_0.id, ");
        selectStmt.append("roi_0.CREATEDATE, ");
        selectStmt.append("roi_3.rfc822date, ");
        selectStmt.append("roi_3.deleted, ");
        selectStmt.append("roi_3.answered, ");
        selectStmt.append("roi_3.flagged, ");
        selectStmt.append("0 AS seen, ");
        selectStmt.append("roi_3.draft, ");
        selectStmt.append("roi_3.recent ");
        selectStmt.append("from ");
        selectStmt.append("GLOBALOBJECT roi_0, ");
        selectStmt.append("RELATIONOBJECT roi_1, ");
        selectStmt.append("INTERNALOBJECT io, ");
        selectStmt.append("FOLDERRELATIONOBJECT roi_2, ");
        selectStmt.append("MAILOBJECT roi_3");
        if (!isAdmin) {
            selectStmt.append(", ACLUSERTABLE roi_au, ");
            selectStmt.append("ACLOBJECTTABLE roi_aot");
        }
        selectStmt.append(" where ");
        selectStmt.append("roi_1.ID=io.ID and ");
        selectStmt.append("roi_1.LEFTOBJECT=? and ");
        if (selectFromDate != null) {
            selectStmt.append("io.CREATEDATE>=? and ");
        }
        selectStmt.append("(roi_0.DELETOR=0 or roi_0.DELETOR=?) ");
        selectStmt.append("and ");
        selectStmt.append("((");
        selectStmt.append(classIds);
        selectStmt.append(") AND roi_2.ID=roi_1.ID AND roi_1.RIGHTOBJECT=roi_0.ID AND roi_0.id=roi_3.id) ");
        if (!isAdmin) {
            selectStmt.append("and ");
            selectStmt.append("(roi_aot.ACLID=roi_au.ACLID and roi_aot.OBJECTID=roi_0.ID ");
            selectStmt.append("and ");
            selectStmt.append("( ");
            selectStmt.append("(roi_0.OWNER=? and roi_au.USERID=0) ");
            selectStmt.append("or ");
            selectStmt.append("(roi_0.OWNER!=? and roi_au.USERID=999 and (select count(ACLID) from acluserrevoke where ACLID=roi_aot.ACLID and USERID=?)=0) ");
            selectStmt.append("or ");
            selectStmt.append("(roi_0.OWNER!=? and (roi_au.USERID=?)))) ");
        }
        selectStmt.append("and ");
        selectStmt.append("NOT EXISTS (select fdo.id from ");
        selectStmt.append("FOLDERDOCUMENTOBJECT fdo, ACCESSCOUNTERUSEROBJECT acuo1 ");
        selectStmt.append("where ");
        selectStmt.append("roi_0.id=fdo.id and acuo1.ACCESSUSER=? AND acuo1.referenceobject=fdo.id ");
        selectStmt.append("and acuo1.lastaccessdate>fdo.LASTCONTENTMODIFYDATE)) ");
        selectStmt.append("order by uidac desc");
        return selectStmt.toString();
    }

    @Override
    public String getCredentialManagerSelect() {
        return "select count(*) from ROICREDENTIALMANAGER where DISTINGUISHEDNAME = ? and (PASSWORD = ?)";
    }

    @Override
    public String getQualifierStatement(int qual, boolean isCI) {
        return this.getQualifierStatement(qual, isCI, null);
    }

    @Override
    public String getQualifierStatement(int qual, boolean isCI, String attrValue) {
        String retQual = null;
        if (qual == 0) {
            retQual = "= ?";
        } else if (qual == 1) {
            retQual = "< ?";
        } else if (qual == 2) {
            retQual = "<= ?";
        }
        if (qual == 3) {
            retQual = "> ?";
        } else if (qual == 4) {
            retQual = ">= ?";
        } else if (qual == 5) {
            retQual = "!= ?";
        } else if (qual == 6) {
            retQual = " IS NULL ";
        } else if (qual == 7) {
            retQual = " IS NOT NULL ";
        } else if (qual == 8) {
            retQual = " like ?";
        } else if (qual == 9) {
            retQual = " not like ?";
        } else if (qual == 10) {
            retQual = " in (" + attrValue + ") ";
        } else if (qual == 11) {
            retQual = " not in (" + attrValue + ") ";
        }
        return retQual;
    }

    @Override
    public String getDistinctByGroupBy() {
        return "";
    }

    @Override
    public String getDistinct() {
        return "";
    }

    @Override
    public byte[] getBlob(ResultSet rs) throws SQLException {
        Blob blob = rs.getBlob(1);
        int len = (int)blob.length();
        return blob.getBytes(1L, len);
    }

    public void deleteTables(Connection conn, String delTables, String delTablesFrom, String delWhere, ArrayList delTableAL, Long id) throws SQLException {
        if (delTableAL != null) {
            int len = delTableAL.size();
            for (int i = 0; i < len; ++i) {
                String table = (String)delTableAL.get(i);
                String stmt = "delete from " + table + " where id=?";
                PreparedStatement pstmtDel = conn.prepareStatement(stmt);
                pstmtDel.setLong(1, id);
                pstmtDel.execute();
                pstmtDel.close();
                pstmtDel = null;
            }
        }
    }

    @Override
    public String buildConcat(String[] elements) {
        String retS = "";
        String colon = "";
        if (elements != null) {
            int len = elements.length;
            for (int i = 0; i < len; ++i) {
                retS = retS + colon + elements[i];
                colon = "+";
            }
        }
        return retS;
    }

    @Override
    public String buildConcatIf(String[] elements, boolean[] withIf) {
        String retS = "";
        String colon = "";
        if (elements != null) {
            int len = elements.length;
            for (int i = 0; i < len; ++i) {
                retS = !withIf[i] ? retS + colon + elements[i] : retS + colon + "case when len(" + elements[i] + ") > 0 then " + elements[i] + " else '' end";
                colon = "+";
            }
        }
        return retS;
    }

    @Override
    public String buildCIWhere(String field, String value) {
        return field + " like " + value;
    }

    @Override
    public String buildIf(String stmt, String trueValue, String falseValue) {
        return "case when " + stmt + " then " + trueValue + " else " + falseValue + " end";
    }

    @Override
    public String buildLength(String field) {
        return "len(" + field + ")";
    }

    @Override
    public String getTextComparator() {
        return " like ";
    }

    @Override
    public String castLongToString(String s) {
        return "cast(" + s + " as varchar)";
    }

    @Override
    public PreparedStatement getGenericMultiQueueSelect(Connection conn, Long id, String ident, long maxAmount, long minSortId) throws SQLException {
        String select = null;
        String rownum = "";
        if (maxAmount > 0L) {
            rownum = " TOP (?) ";
        }
        select = id == null ? "select " + rownum + " id, sortid, ident, data from genericmultiqueue where ident=? and sortid >= ? order by sortid asc" : "select " + rownum + " id, sortid, ident, data from genericmultiqueue where id=? and ident=? and sortid >= ? order by sortid asc";
        int num = 1;
        PreparedStatement pstmt = conn.prepareStatement(select);
        if (id == null) {
            if (maxAmount > 0L) {
                pstmt.setLong(num++, maxAmount);
            }
            pstmt.setString(num++, ident);
        } else {
            if (maxAmount > 0L) {
                pstmt.setLong(num++, maxAmount);
            }
            pstmt.setLong(num++, id);
            pstmt.setString(num++, ident);
        }
        pstmt.setLong(num++, minSortId);
        return pstmt;
    }

    @Override
    public boolean tableExists(Connection connection, String tableName) throws SQLException {
        DatabaseMetaData meta = connection.getMetaData();
        try (ResultSet rSet = meta.getTables(null, null, tableName, null);){
            if (rSet.next()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public String limitQuery(String columns, String tables, String clauses, String order, long limit) {
        StringBuilder query = new StringBuilder("select top(");
        query.append(limit);
        query.append(") ");
        query.append(columns);
        query.append(" from ");
        query.append(tables);
        if (clauses != null) {
            query.append(" where ");
            query.append(clauses);
        }
        if (order != null) {
            query.append(" order by ");
            query.append(order);
        }
        return query.toString();
    }
}

