/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.utils.ReloadablePropertyResourceBundle;
import java.util.MissingResourceException;

public class TransactionProperties {
    private static ReloadablePropertyResourceBundle property = null;
    private static long lastLoadTime = 0L;
    private static final long timerOffset = 20000L;

    private static void init() {
        long currentTime = System.currentTimeMillis();
        if (lastLoadTime < currentTime) {
            lastLoadTime = currentTime + 20000L;
            try {
                property = (ReloadablePropertyResourceBundle)ReloadablePropertyResourceBundle.getResourceBundle((String)"agorum.roi.properties.Transaction");
            }
            catch (Exception e) {
                property = null;
            }
        }
    }

    public static int getDefaultTransactionTimeout() {
        return TransactionProperties.getValueWithDefault("agorum.roi.system.transaction.DefaultTransactionTimeout", 3600);
    }

    public static int getAutoupdateTransactionTimeout() {
        return TransactionProperties.getValueWithDefault("agorum.roi.system.transaction.AutoupdateTransactionTimeout", 0);
    }

    public static int getBuildIndexTransactionTimeout() {
        return TransactionProperties.getValueWithDefault("agorum.roi.system.transaction.BuildIndexTransactionTimeout", 0);
    }

    public static int getBuildPreviewTransactionTimeout() {
        return TransactionProperties.getValueWithDefault("agorum.roi.system.transaction.BuildPreviewTransactionTimeout", 0);
    }

    public static int getFTPTransactionTimeout() {
        return TransactionProperties.getValueWithDefault("agorum.roi.system.transaction.FTPTransactionTimeout", 0);
    }

    public static int getWebDAVTransactionTimeout() {
        return TransactionProperties.getValueWithDefault("agorum.roi.system.transaction.WebDAVTransactionTimeout", 0);
    }

    public static int getIMAPTransactionTimeout() {
        return TransactionProperties.getValueWithDefault("agorum.roi.system.transaction.IMAPTransactionTimeout", 300);
    }

    public static int getSyncTransactionTimeout() {
        return TransactionProperties.getValueWithDefault("agorum.roi.system.transaction.SyncTransactionTimeout", 21600);
    }

    public static int getAdminSyncTransactionTimeout() {
        return TransactionProperties.getValueWithDefault("agorum.roi.system.transaction.AdminSyncTransactionTimeout", 0);
    }

    public static int getDeleteTransactionTimeout() {
        return TransactionProperties.getValueWithDefault("agorum.roi.system.transaction.DeleteTransactionTimeout", 0);
    }

    public static int getTimePhasedActionTransactionTimeout() {
        return TransactionProperties.getValueWithDefault("agorum.roi.system.transaction.TimePhasedActionTransactionTimeout", 0);
    }

    public static int getWorkflowTransactionTimeout() {
        return TransactionProperties.getValueWithDefault("agorum.roi.system.transaction.WorkflowTransactionTimeout", 0);
    }

    private static int getValueWithDefault(String key, int def) {
        TransactionProperties.init();
        if (property == null) {
            return def;
        }
        try {
            return Integer.parseInt(property.getString(key));
        }
        catch (MissingResourceException e) {
            return def;
        }
    }
}

