/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SessionControllerAdmin {
    private static final String KEEPALIVE_TIME_KEY = "__SCA_KeepAlive";
    private static final long KEEPALIVE_THRESHOLD = 30000L;
    private static final Map<String, SessionController> sessionControllers = new ConcurrentHashMap<String, SessionController>();

    public static SessionController get(String ident) {
        return SessionControllerAdmin.getSessionControllerAdmin(null, ident);
    }

    public static SessionController get(Class<?> clazz) {
        return SessionControllerAdmin.getSessionControllerAdmin(null, clazz.getName());
    }

    public static SessionController get(Object object) {
        return SessionControllerAdmin.getSessionControllerAdmin(null, object.getClass().getName());
    }

    public static SessionController getService(String ident) {
        return SessionControllerAdmin.get(ident).makeService().noExpiration();
    }

    public static SessionController getService(Class<?> clazz) {
        return SessionControllerAdmin.get(clazz).makeService().noExpiration();
    }

    public static SessionController getService(Object object) {
        return SessionControllerAdmin.get(object).makeService().noExpiration();
    }

    public static SessionController getSessionControllerAdmin(String ident) {
        return SessionControllerAdmin.getSessionControllerAdmin(null, ident);
    }

    public static SessionController getSessionControllerAdmin(SessionController sessionController, String ident) {
        if (sessionController != null && sessionController.isMainAdmin()) {
            try {
                sessionController.reconnectIfNeeded();
                return sessionController;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            return SessionControllerAdmin.lookup(ident);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not get administrative session", e);
        }
    }

    private static SessionController lookup(String ident) throws Exception {
        Long keepaliveTime;
        SessionController sessionController = sessionControllers.get(ident);
        if (sessionController == null) {
            sessionController = SessionControllerAdmin.connect(ident);
        }
        if ((keepaliveTime = (Long)sessionController.get(KEEPALIVE_TIME_KEY)) == null || keepaliveTime < System.currentTimeMillis()) {
            sessionController.reconnectIfNeeded();
            sessionController.put(KEEPALIVE_TIME_KEY, System.currentTimeMillis() + 30000L);
        }
        return sessionController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SessionController connect(String ident) throws Exception {
        Map<String, SessionController> map = sessionControllers;
        synchronized (map) {
            SessionController sessionController = sessionControllers.get(ident);
            if (sessionController == null) {
                CredentialObject credential = new CredentialObject();
                credential.setUserName(new RoiProperties().getRoiSystemUser());
                credential.setAuthInterface(new ServiceAuthInterface());
                credential.setModulInfo(ident);
                sessionController = SessionController.connect(credential);
                sessionControllers.put(ident, sessionController);
                sessionController.put(KEEPALIVE_TIME_KEY, System.currentTimeMillis() + 30000L);
            }
            return sessionController;
        }
    }
}

