/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.agceptit.metadb.client.common.MetaDbException;
import agorum.roi.ejb.common.NetworkAccessSettingsBean;
import agorum.roi.ejb.common.SessionController;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;

public class NetworkAccessControllerUtils {
    private SessionController sessionController = null;
    private HttpServletRequest request = null;
    private int[] ip = null;
    private String mdbNetworkAccessBasePath = "MAIN_MODULE_MANAGEMENT/roi/control/accesscontrol";

    public NetworkAccessControllerUtils(SessionController sessionController, HttpServletRequest request) {
        this.sessionController = sessionController;
        this.request = request;
        this.ip = this.getIpFromString(sessionController.getCredential().getIp());
    }

    public NetworkAccessControllerUtils(String ip) {
        this.ip = this.getIpFromString(ip);
    }

    public void handleNetworkAccessSettings() throws Exception {
        ArrayList nasBeans = this.getMetaDbSettings();
        if (nasBeans != null) {
            int len = nasBeans.size();
            for (int i = 0; i < len; ++i) {
                NetworkAccessSettingsBean settingsBean = (NetworkAccessSettingsBean)nasBeans.get(i);
                if (!this.checkNetwork(settingsBean)) continue;
                String moduleInfo = this.sessionController.getCredential().getModulInfo();
                boolean isValid = true;
                if (moduleInfo != null && !settingsBean.getIncludedProtocols().containsKey(moduleInfo.toUpperCase()) && !settingsBean.getIncludedProtocols().containsKey("ALL")) {
                    isValid = false;
                }
                if (!isValid) continue;
                this.applySettings(settingsBean);
                break;
            }
        }
    }

    private boolean checkNetwork(NetworkAccessSettingsBean settingsBean) {
        boolean valid = true;
        if (this.ip != null) {
            for (int i = 0; i < 4; ++i) {
                if ((this.ip[i] & settingsBean.getNetmask()[i]) == settingsBean.getNetwork()[i]) continue;
                valid = false;
                break;
            }
            valid ^= !settingsBean.getInclude();
        }
        return valid;
    }

    private void applySettings(NetworkAccessSettingsBean settingsBean) {
        this.sessionController.setReadOnlyMode(settingsBean.getReadOnlyMode());
        this.sessionController.setNetworkAccessSettings(settingsBean.getNetworkAccessSettings());
    }

    private ArrayList getMetaDbSettings() throws Exception {
        ArrayList<NetworkAccessSettingsBean> nasBeans;
        block14: {
            nasBeans = null;
            try {
                MetaDb metaDb = this.sessionController.getMetaDbInstance();
                String[] settingBundles = metaDb.listSimplePropertyBundle(this.mdbNetworkAccessBasePath);
                if (settingBundles == null) break block14;
                int settingsLen = settingBundles.length;
                nasBeans = new ArrayList<NetworkAccessSettingsBean>();
                for (int i = 0; i < settingsLen; ++i) {
                    String path = this.mdbNetworkAccessBasePath + "/" + settingBundles[i];
                    NetworkAccessSettingsBean settingsBean = new NetworkAccessSettingsBean();
                    settingsBean.setNetworkAccessControllerName(settingBundles[i]);
                    boolean active = false;
                    try {
                        active = Boolean.parseBoolean(metaDb.getSimplePropertyValue(path + "/Active")[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!active) continue;
                    settingsBean.setActive(active);
                    settingsBean.setInclude(Boolean.parseBoolean(metaDb.getSimplePropertyValue(path + "/Include")[0]));
                    settingsBean.setNetmask(this.getIpFromString(metaDb.getSimplePropertyValue(path + "/Netmask")[0]));
                    settingsBean.setNetwork(this.getIpFromString(metaDb.getSimplePropertyValue(path + "/Network")[0]));
                    try {
                        settingsBean.setReadOnlyMode(Boolean.parseBoolean(metaDb.getSimplePropertyValue(path + "/ReadOnlyMode")[0]));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        settingsBean.setNetworkAccessSettings(metaDb.getParameterHash(path));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    Hashtable<String, String> includedProtocols = new Hashtable<String, String>();
                    try {
                        String[] incProts = metaDb.getSimplePropertyValue(path + "/IncludedProtocols");
                        if (incProts != null) {
                            int len = incProts.length;
                            for (int i1 = 0; i1 < len; ++i1) {
                                includedProtocols.put(incProts[i1].toUpperCase(), "true");
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (includedProtocols.size() == 0) {
                        includedProtocols.put("ALL", "true");
                    }
                    settingsBean.setIncludedProtocols(includedProtocols);
                    nasBeans.add(settingsBean);
                }
            }
            catch (MetaDbException e) {
                e.printStackTrace(System.err);
            }
        }
        return nasBeans;
    }

    public void test() {
        NetworkAccessSettingsBean settingsBean = new NetworkAccessSettingsBean();
        settingsBean.setActive(true);
        settingsBean.setInclude(true);
        settingsBean.setNetmask(this.getIpFromString("255.255.255.255"));
        settingsBean.setNetworkAccessControllerName("Test");
        settingsBean.setReadOnlyMode(true);
        settingsBean.setNetwork(this.getIpFromString("62.2.139.140"));
        this.checkNetwork(settingsBean);
    }

    private int[] getIpFromString(String ip) {
        int[] ipBytes = null;
        if (ip != null) {
            if (ip.indexOf(":") != -1) {
                ipBytes = new int[]{255, 255, 255, 255};
            } else {
                String[] ipParts = ip.split("\\.", 4);
                ipBytes = new int[4];
                for (int i = 0; i < 4; ++i) {
                    ipBytes[i] = new Integer(ipParts[i]);
                }
            }
        }
        return ipBytes;
    }

    public static void main(String[] args) {
        NetworkAccessControllerUtils na = new NetworkAccessControllerUtils("62.2.139.140");
        na.test();
    }
}

