/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.RoiTransactionHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class GenericQueueHelper {
    public static void createQueueEntry(Long id, String ident) throws Exception {
        ConnectionUtils cu = new ConnectionUtils(null);
        try (RoiTransactionHandler rth = new RoiTransactionHandler();){
            block62: {
                rth.begin(true);
                try (Connection conn = cu.getConnection();){
                    String select = "select * from genericqueue where ID = ? and ident=?";
                    try (PreparedStatement psel = conn.prepareStatement(select);){
                        psel.setLong(1, id);
                        psel.setString(2, ident);
                        try (ResultSet rs = psel.executeQuery();){
                            if (rs.next()) break block62;
                            String insert = "insert into genericqueue (ID, ident) values (?, ?)";
                            try (PreparedStatement ps = conn.prepareStatement(insert);){
                                ps.setLong(1, id);
                                ps.setString(2, ident);
                                ps.execute();
                            }
                        }
                    }
                }
            }
            rth.end();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static List<Long> getQueueEntries(Long id, String ident) throws Exception {
        ConnectionUtils cu = new ConnectionUtils(null);
        ArrayList<Long> result = new ArrayList<Long>();
        String select = null;
        select = id == null ? "select id from genericqueue where ident=? order by sortid asc" : "select id from genericqueue where ID = ? and ident=? order by sortid asc";
        try (RoiTransactionHandler rth = new RoiTransactionHandler();){
            rth.begin(true);
            try (Connection conn = cu.getConnection();
                 PreparedStatement psel = conn.prepareStatement(select);){
                if (id == null) {
                    psel.setString(1, ident);
                } else {
                    psel.setLong(1, id);
                    psel.setString(2, ident);
                }
                try (ResultSet rs = psel.executeQuery();){
                    while (rs.next()) {
                        Long resId = rs.getLong(1);
                        result.add(resId);
                    }
                }
            }
            rth.end();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteQueueEntry(Long id, String ident) throws Exception {
        ConnectionUtils cu = new ConnectionUtils(null);
        try (RoiTransactionHandler rth = new RoiTransactionHandler();
             Connection conn = cu.getConnection();){
            rth.begin(true);
            try (PreparedStatement ps = conn.prepareStatement("select sortid from genericqueue where id=? and ident=?");){
                ps.setLong(1, id);
                ps.setString(2, ident);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        PreparedStatement psDel;
                        block58: {
                            long sortId = rs.getLong(1);
                            psDel = conn.prepareStatement("delete from genericqueue where ID=? and ident=? and sortid=?");
                            Throwable throwable = null;
                            try {
                                psDel.setLong(1, id);
                                psDel.setString(2, ident);
                                psDel.setLong(3, sortId);
                                psDel.execute();
                                if (psDel == null) continue;
                                if (throwable == null) break block58;
                            }
                            catch (Throwable throwable2) {
                                try {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    if (psDel == null) throw throwable3;
                                    if (throwable == null) {
                                        psDel.close();
                                        throw throwable3;
                                    }
                                    try {
                                        psDel.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                            }
                            try {
                                psDel.close();
                                continue;
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                                continue;
                            }
                        }
                        psDel.close();
                    }
                }
            }
            rth.end();
            return;
        }
    }
}

