/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.client.beans.AccessControlEntryObjectClientBean;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.FolderTreeAccessStructureBean;
import agorum.roi.ejb.common.FolderTreeAccessStructureProtocolBean;
import agorum.roi.ejb.common.FolderTreeDObjectAccessStructureBean;
import agorum.roi.ejb.common.FolderTreeDObjectAccessStructureProtocolBean;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import java.util.ArrayList;
import java.util.Hashtable;

public class FolderTreeAccessStructure {
    private SessionController sessionController = null;
    private Hashtable folderHash = null;
    private Hashtable processedHash = null;
    private ArrayList resultList = null;

    public FolderTreeAccessStructure(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public void findNonGrantedFolderTrees(FolderObjectClientBean startFolder) throws Exception {
        this.folderHash = new Hashtable();
        FolderTreeAccessStructureBean rootBean = new FolderTreeAccessStructureBean();
        rootBean.setAcl(startFolder.getAcl());
        rootBean.setObject(startFolder);
        this.folderHash.put(startFolder.getId(), rootBean);
        this.buildUpFolderTreeStructure(startFolder, rootBean, 0);
        this.resultList = new ArrayList();
        this.scanAccessStructure(rootBean, this.resultList);
    }

    public void getDObjectAccessStructure(FolderObjectClientBean startFolder, DirectoryObjectClientBean dObject) throws Exception {
        this.folderHash = new Hashtable();
        this.processedHash = new Hashtable();
        FolderTreeDObjectAccessStructureBean rootBean = new FolderTreeDObjectAccessStructureBean();
        rootBean.setAcl(startFolder.getAcl());
        rootBean.setObject(startFolder);
        rootBean.setDepth(0);
        rootBean.setVisible(true);
        this.folderHash.put(startFolder.getId(), rootBean);
        this.buildUpFolderTreeDObjectStructure(startFolder, rootBean, dObject, 1, startFolder.getAcl().getId());
        this.resultList = new ArrayList();
        this.buildDObjectResultList(rootBean, this.resultList, dObject, 0L);
    }

    public void printProtocol() {
        System.err.println("Protocol: ");
        int len = this.resultList.size();
        for (int i = 0; i < len; ++i) {
            FolderTreeAccessStructureProtocolBean protocolBean = (FolderTreeAccessStructureProtocolBean)this.resultList.get(i);
            System.err.println("Add grantee \"" + protocolBean.getGrantee() + " (" + protocolBean.getType() + ")\" to the ACL \"" + protocolBean.getAcl() + "\" in path \"" + protocolBean.getPath() + "\". Origin from ACL \"" + protocolBean.getOriginAcl() + "\" in path \"" + protocolBean.getOriginPath() + "\"");
            System.err.println("");
        }
    }

    public void printDObjectProtocol() {
        System.err.println("Protocol: ");
        int len = this.resultList.size();
        for (int i = 0; i < len; ++i) {
            FolderTreeDObjectAccessStructureProtocolBean protocolBean = (FolderTreeDObjectAccessStructureProtocolBean)this.resultList.get(i);
            int depth = protocolBean.getDepth();
            String inset = "";
            for (int d = 0; d < depth; ++d) {
                inset = inset + "  ";
            }
            System.err.print(inset + "" + protocolBean.getName());
            if (protocolBean.getAcl() != null) {
                System.err.print(", " + protocolBean.getAcl());
            }
            if (protocolBean.getAccessLevel() == 0L) {
                System.err.print(", none");
            } else if (protocolBean.getAccessLevel() == 1L) {
                System.err.print(", read");
            } else if (protocolBean.getAccessLevel() == 2L) {
                System.err.print(", proteced");
            } else if (protocolBean.getAccessLevel() == 3L) {
                System.err.print(", write");
            } else if (protocolBean.getAccessLevel() == 4L) {
                System.err.print(", all");
            }
            System.err.println("");
        }
    }

    private void scanAccessStructure(FolderTreeAccessStructureBean bean, ArrayList resultList) throws Exception {
        ArrayList childs = bean.getChilds();
        if (childs != null) {
            int len = childs.size();
            for (int i = 0; i < len; ++i) {
                FolderTreeAccessStructureBean child = (FolderTreeAccessStructureBean)childs.get(i);
                AccessControlListObjectClientBean acl = child.getAcl();
                AccessControlEntryObjectClientBean[] aces = acl.getAccessControlEntries();
                if (aces != null) {
                    int lenA = aces.length;
                    for (int a = 0; a < lenA; ++a) {
                        if (!aces[a].getGranted()) continue;
                        DirectoryObjectClientBean grantee = aces[a].getGrantee();
                        this.checkRootContact(child, grantee, resultList, acl, child.getObject());
                    }
                }
                this.scanAccessStructure(child, resultList);
            }
        }
    }

    private void checkRootContact(FolderTreeAccessStructureBean child, DirectoryObjectClientBean grantee, ArrayList resultList, AccessControlListObjectClientBean originAcl, GlobalObjectClientBean originObject) throws Exception {
        if (!child.getObject().checkEffectiveAccess(grantee, 4L)) {
            FolderTreeAccessStructureProtocolBean protocolBean = new FolderTreeAccessStructureProtocolBean();
            protocolBean.setGrantee(grantee.getName());
            protocolBean.setGranteeId(grantee.getId());
            protocolBean.setType(grantee instanceof DirectoryUserObjectClientBean ? "user" : "group");
            protocolBean.setAcl(child.getAcl().getName());
            protocolBean.setAclId(child.getAcl().getId());
            protocolBean.setPath(child.getObject().getAnyFolderPath());
            protocolBean.setPathId(child.getObject().getId());
            protocolBean.setOriginAcl(originAcl.getName());
            protocolBean.setOriginAclId(originAcl.getId());
            protocolBean.setOriginPath(originObject.getAnyFolderPath());
            protocolBean.setOriginPathId(originObject.getId());
            resultList.add(protocolBean);
        }
        if (child.getParents() != null) {
            int len = child.getParents().size();
            for (int i = 0; i < len; ++i) {
                FolderTreeAccessStructureBean parentBean = (FolderTreeAccessStructureBean)child.getParents().get(i);
                this.checkRootContact(parentBean, grantee, resultList, originAcl, originObject);
            }
        }
    }

    private void buildUpFolderTreeStructure(FolderObjectClientBean folder, FolderTreeAccessStructureBean parentBean, int depth) throws Exception {
        String inset = "";
        for (int i = 0; i < depth; ++i) {
            inset = inset + "  ";
        }
        long actualAclId = parentBean.getAcl().getId();
        GlobalObjectClientBean[] subItems = folder.getItems();
        if (subItems != null) {
            int len = subItems.length;
            for (int i = 0; i < len; ++i) {
                if (subItems[i].getAcl().getId() != actualAclId) {
                    FolderTreeAccessStructureBean newBean = null;
                    if (this.folderHash.containsKey(subItems[i].getId())) {
                        newBean = (FolderTreeAccessStructureBean)this.folderHash.get(subItems[i].getId());
                    } else {
                        newBean = new FolderTreeAccessStructureBean();
                        newBean.setAcl(subItems[i].getAcl());
                        newBean.setObject(subItems[i]);
                        this.folderHash.put(subItems[i].getId(), newBean);
                    }
                    ArrayList<FolderTreeAccessStructureBean> parentList = newBean.getParents();
                    if (parentList == null) {
                        parentList = new ArrayList<FolderTreeAccessStructureBean>();
                        newBean.setParents(parentList);
                    }
                    parentList.add(parentBean);
                    ArrayList<FolderTreeAccessStructureBean> childs = parentBean.getChilds();
                    if (childs == null) {
                        childs = new ArrayList<FolderTreeAccessStructureBean>();
                        parentBean.setChilds(childs);
                    }
                    childs.add(newBean);
                    System.err.println(inset + "Processing Folder: ");
                    System.err.println(inset + "  FullPath: " + subItems[i].getAnyFolderPath());
                    System.err.println(inset + "  ACL:      " + subItems[i].getAcl().getName());
                    System.err.println("");
                    if (!subItems[i].getIsFolder()) continue;
                    this.buildUpFolderTreeStructure((FolderObjectClientBean)subItems[i], newBean, depth + 1);
                    continue;
                }
                if (!subItems[i].getIsFolder()) continue;
                this.buildUpFolderTreeStructure((FolderObjectClientBean)subItems[i], parentBean, depth);
            }
        }
    }

    private void buildUpFolderTreeDObjectStructure(FolderObjectClientBean folder, FolderTreeDObjectAccessStructureBean parentBean, DirectoryObjectClientBean dObject, int depth, long actualAclId) throws Exception {
        String inset = "";
        for (int i = 0; i < depth; ++i) {
            inset = inset + "  ";
        }
        GlobalObjectClientBean[] subItems = folder.getItems();
        if (subItems != null) {
            int len = subItems.length;
            for (int i = 0; i < len; ++i) {
                if (!subItems[i].getIsFolder()) continue;
                FolderTreeDObjectAccessStructureBean newBean = null;
                if (this.folderHash.containsKey(subItems[i].getId())) {
                    newBean = (FolderTreeDObjectAccessStructureBean)this.folderHash.get(subItems[i].getId());
                } else {
                    newBean = new FolderTreeDObjectAccessStructureBean();
                    newBean.setObject(subItems[i]);
                    this.folderHash.put(subItems[i].getId(), newBean);
                }
                ArrayList<FolderTreeDObjectAccessStructureBean> parentList = newBean.getParents();
                if (parentList == null) {
                    parentList = new ArrayList<FolderTreeDObjectAccessStructureBean>();
                    newBean.setParents(parentList);
                }
                parentList.add(parentBean);
                ArrayList<FolderTreeDObjectAccessStructureBean> childs = parentBean.getChilds();
                if (childs == null) {
                    childs = new ArrayList<FolderTreeDObjectAccessStructureBean>();
                    parentBean.setChilds(childs);
                }
                boolean dontAdd = false;
                int lenC = childs.size();
                for (int c = 0; c < lenC; ++c) {
                    FolderTreeDObjectAccessStructureBean oneChild = (FolderTreeDObjectAccessStructureBean)childs.get(c);
                    if (oneChild.getObject().getId().longValue() != newBean.getObject().getId().longValue()) continue;
                    dontAdd = true;
                    break;
                }
                if (!dontAdd) {
                    childs.add(newBean);
                }
                newBean.setDepth(depth);
                if (subItems[i].getAcl().getId() != actualAclId) {
                    newBean.setAcl(subItems[i].getAcl());
                    System.err.println(inset + "Processing Folder: ");
                    System.err.println(inset + "  FullPath: " + subItems[i].getAnyFolderPath());
                    System.err.println(inset + "  ACL:      " + subItems[i].getAcl().getName());
                    System.err.println("");
                    this.changeParentState(newBean, true);
                }
                if (!subItems[i].getIsFolder()) continue;
                long newActualAclId = subItems[i].getAcl().getId();
                this.buildUpFolderTreeDObjectStructure((FolderObjectClientBean)subItems[i], newBean, dObject, depth + 1, newActualAclId);
            }
        }
    }

    private void changeParentState(FolderTreeDObjectAccessStructureBean newBean, boolean visibility) throws Exception {
        newBean.setVisible(true);
        ArrayList al = newBean.getParents();
        if (al != null) {
            int len = al.size();
            for (int i = 0; i < len; ++i) {
                FolderTreeDObjectAccessStructureBean pBean = (FolderTreeDObjectAccessStructureBean)al.get(i);
                pBean.setVisible(visibility);
                this.changeParentState(pBean, visibility);
            }
        }
    }

    private void buildDObjectResultList(FolderTreeDObjectAccessStructureBean bean, ArrayList resultList, DirectoryObjectClientBean dObject, long accessLevel) throws Exception {
        if (bean.getVisible() && bean.getObject() instanceof FolderObjectClientBean) {
            FolderTreeDObjectAccessStructureProtocolBean protBean = new FolderTreeDObjectAccessStructureProtocolBean();
            if (bean.getAcl() != null) {
                protBean.setAcl(bean.getAcl().getName());
                protBean.setAclId(bean.getAcl().getId());
            }
            accessLevel = 0L;
            if (bean.getObject().checkEffectiveAccess(dObject, 16L)) {
                accessLevel = 4L;
            } else if (bean.getObject().checkEffectiveAccess(dObject, 8L)) {
                accessLevel = 3L;
            } else if (bean.getObject().checkEffectiveAccess(dObject, 16384L)) {
                accessLevel = 2L;
            } else if (bean.getObject().checkEffectiveAccess(dObject, 1L)) {
                accessLevel = 1L;
            }
            protBean.setAccessLevel(accessLevel);
            protBean.setFolderObject((FolderObjectClientBean)bean.getObject());
            protBean.setName(bean.getObject().getName());
            protBean.setDepth(bean.getDepth());
            resultList.add(protBean);
            ArrayList al = bean.getChilds();
            if (al != null) {
                int len = al.size();
                for (int i = 0; i < len; ++i) {
                    FolderTreeDObjectAccessStructureBean pBean = (FolderTreeDObjectAccessStructureBean)al.get(i);
                    this.buildDObjectResultList(pBean, resultList, dObject, accessLevel);
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            RoiProperties rp = new RoiProperties();
            CredentialObject credential = new CredentialObject();
            credential.setUserName(rp.getRoiSystemUser());
            credential.setAuthInterface(new ServiceAuthInterface());
            credential.setModulInfo("FolderTreeAccessStructure");
            SessionController sessionController = SessionController.connect(credential);
            FolderTreeAccessStructure ts = new FolderTreeAccessStructure(sessionController);
            FolderObjectClientBean startFolder = (FolderObjectClientBean)sessionController.findGlobalObjectByPath("/agorum/roi/Files/Allgemeiner Testordner/Objekte");
            DirectoryUserObjectClientBean dObject = sessionController.getUserByName("d4wdemo_en");
            ts.getDObjectAccessStructure(startFolder, dObject);
            ts.printDObjectProtocol();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        System.err.println("Ende of Test-Program");
    }

    public ArrayList getResultList() {
        return this.resultList;
    }
}

