/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.cache.GenericCache;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class FolderPathUtil {
    private static final PathNode BLOCK_NODE = new PathNode(null, "", null);

    private static GenericCache getCache(Long sessionId, String rootId) {
        return GenericCache.getInstance((Object)(sessionId + "_" + rootId + "_GetFolderPathObjects"), (int)100000, (int)1000, (int)500);
    }

    private static PathNode getPathNode(GlobalObjectClientBean obj, String rootId, GenericCache cache) throws Exception {
        String id = obj.getID();
        PathNode result = (PathNode)cache.get((Object)id);
        if (result == BLOCK_NODE) {
            return null;
        }
        if (result != null) {
            return result;
        }
        if (id.equals(rootId)) {
            return new PathNode(null, id, obj);
        }
        FolderObjectClientBean[] parents = obj.getParents();
        if (parents == null) {
            cache.put((Object)id, (Object)BLOCK_NODE);
            return null;
        }
        ArrayList<PathNode> parentNodes = new ArrayList<PathNode>(parents.length);
        for (FolderObjectClientBean parent : parents) {
            PathNode parentNode = FolderPathUtil.getPathNode(parent, rootId, cache);
            if (parentNode == null) continue;
            parentNodes.add(parentNode);
        }
        if (parentNodes.size() <= 0) {
            cache.put((Object)id, (Object)BLOCK_NODE);
            return null;
        }
        result = new PathNode(parentNodes, id, obj);
        cache.put((Object)id, (Object)result);
        return result;
    }

    private static <T> ArrayList<T> reverse(ArrayList<T> toReverse) {
        int len = toReverse.size();
        ArrayList<T> result = new ArrayList<T>(len);
        for (int i = 0; i < len; ++i) {
            result.add(toReverse.get(len - i - 1));
        }
        return result;
    }

    private static void build(PathNode pathNode, String startId, boolean saveThisPath, ArrayList<GlobalObjectClientBean> currentPath, Set<String> handled, Map<String, List<GlobalObjectClientBean>> result) throws Exception {
        if (pathNode == null) {
            return;
        }
        if (handled.contains(pathNode.id)) {
            return;
        }
        if (pathNode.id.equals(startId)) {
            saveThisPath = true;
        }
        currentPath.add((GlobalObjectClientBean)pathNode.obj);
        handled.add(pathNode.id);
        List<PathNode> parentNodes = pathNode.parentNodes;
        if (parentNodes == null) {
            if (saveThisPath) {
                String path;
                int len = (currentPath = FolderPathUtil.reverse(currentPath)).size();
                if (len > 1) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 1; i < len; ++i) {
                        sb.append("/");
                        sb.append(((GlobalObjectClientBean)currentPath.get(i)).getName());
                    }
                    path = sb.toString();
                } else {
                    path = "/";
                }
                result.put(path, currentPath);
            }
        } else {
            int len = parentNodes.size();
            for (int i = 0; i < len; ++i) {
                Set<String> clonedHandled;
                ArrayList clonedPath;
                if (i < len - 1) {
                    clonedPath = (ArrayList)currentPath.clone();
                    clonedHandled = new HashSet<String>(handled);
                } else {
                    clonedPath = currentPath;
                    clonedHandled = handled;
                }
                FolderPathUtil.build(parentNodes.get(i), startId, saveThisPath, clonedPath, clonedHandled, result);
            }
        }
    }

    private static <T> Vector<T> reverse(Vector<T> toReverse) {
        int len = toReverse.size();
        Vector<T> result = new Vector<T>(len);
        for (int i = 0; i < len; ++i) {
            result.add(toReverse.get(len - i - 1));
        }
        return result;
    }

    private static void buildLegacy(PathNode pathNode, String startId, boolean saveThisPath, Vector<GlobalObjectClientBean> currentPath, Set<String> handled, Hashtable<String, Vector<GlobalObjectClientBean>> result) throws Exception {
        if (pathNode == null) {
            return;
        }
        if (handled.contains(pathNode.id)) {
            return;
        }
        if (pathNode.id.equals(startId)) {
            saveThisPath = true;
        }
        currentPath.add((GlobalObjectClientBean)pathNode.obj);
        handled.add(pathNode.id);
        List<PathNode> parentNodes = pathNode.parentNodes;
        if (parentNodes == null) {
            if (saveThisPath) {
                String path;
                int len = (currentPath = FolderPathUtil.reverse(currentPath)).size();
                if (len > 1) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 1; i < len; ++i) {
                        sb.append("/");
                        sb.append(((GlobalObjectClientBean)currentPath.get(i)).getName());
                    }
                    path = sb.toString();
                } else {
                    path = "/";
                }
                result.put(path, currentPath);
            }
        } else {
            int len = parentNodes.size();
            for (int i = 0; i < len; ++i) {
                Set<String> clonedHandled;
                Vector clonedPath;
                if (i < len - 1) {
                    clonedPath = (Vector)currentPath.clone();
                    clonedHandled = new HashSet<String>(handled);
                } else {
                    clonedPath = currentPath;
                    clonedHandled = handled;
                }
                FolderPathUtil.buildLegacy(parentNodes.get(i), startId, saveThisPath, clonedPath, clonedHandled, result);
            }
        }
    }

    public static Map<String, List<GlobalObjectClientBean>> get(GlobalObjectClientBean obj) throws Exception {
        FolderObjectClientBean rootFolder = obj.getSessionController().getRootFolder();
        Long rootId = rootFolder.getId();
        return FolderPathUtil.get(obj, rootId, rootId);
    }

    public static Map<String, List<GlobalObjectClientBean>> get(GlobalObjectClientBean obj, long startId) throws Exception {
        FolderObjectClientBean rootFolder = obj.getSessionController().getRootFolder();
        Long rootId = rootFolder.getId();
        return FolderPathUtil.get(obj, startId, rootId);
    }

    public static Map<String, List<GlobalObjectClientBean>> get(GlobalObjectClientBean obj, long startId, long rootId) throws Exception {
        String startIdString = String.valueOf(startId);
        String rootIdString = String.valueOf(rootId);
        return FolderPathUtil.get(obj, startIdString, rootIdString);
    }

    public static Map<String, List<GlobalObjectClientBean>> get(GlobalObjectClientBean obj, String startId, String rootId) throws Exception {
        LinkedHashMap<String, List<GlobalObjectClientBean>> result = new LinkedHashMap<String, List<GlobalObjectClientBean>>();
        FolderPathUtil.build(FolderPathUtil.getPathNode(obj, rootId, FolderPathUtil.getCache(obj.getSessionController().getSessionId(), rootId)), startId, false, new ArrayList<GlobalObjectClientBean>(), new HashSet<String>(), result);
        return result;
    }

    public static Hashtable<String, Vector<GlobalObjectClientBean>> getLegacy(GlobalObjectClientBean obj, String startId, String rootId) throws Exception {
        Hashtable<String, Vector<GlobalObjectClientBean>> result = new Hashtable<String, Vector<GlobalObjectClientBean>>();
        FolderPathUtil.buildLegacy(FolderPathUtil.getPathNode(obj, rootId, FolderPathUtil.getCache(obj.getSessionController().getSessionId(), rootId)), startId, false, new Vector<GlobalObjectClientBean>(), new HashSet<String>(), result);
        return result;
    }

    public static void invalidate(Long sessionId) {
        FolderPathUtil.invalidate(sessionId, "9999");
    }

    public static void invalidate(Long sessionId, String rootId) {
        FolderPathUtil.getCache(sessionId, rootId).invalidateCache();
    }

    private static class PathNode {
        public final List<PathNode> parentNodes;
        public final String id;
        public final GlobalObjectClientBean obj;

        public PathNode(List<PathNode> parentNodes, String id, GlobalObjectClientBean obj) {
            this.parentNodes = parentNodes;
            this.id = id;
            this.obj = obj;
        }
    }
}

